/*
 * Decompiled with CFR 0.152.
 */
package com.valentinilk.shimmer;

import androidx.compose.animation.core.Animatable;
import androidx.compose.animation.core.AnimatableKt;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.valentinilk.shimmer.ShimmerArea;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001dH\u0080@\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0012\u0010!\u001a\u00020\u001d*\u00020\"2\u0006\u0010#\u001a\u00020$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/valentinilk/shimmer/ShimmerEffect;", "", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "rotation", "shaderColors", "", "Landroidx/compose/ui/graphics/Color;", "shaderColorStops", "shimmerWidth", "<init>", "(Landroidx/compose/animation/core/AnimationSpec;IFLjava/util/List;Ljava/util/List;FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "I", "animatedState", "Landroidx/compose/animation/core/Animatable;", "Landroidx/compose/animation/core/AnimationVector1D;", "transformationMatrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "gradientFrom", "Landroidx/compose/ui/geometry/Offset;", "J", "gradientTo", "paint", "Landroidx/compose/ui/graphics/Paint;", "startAnimation", "", "startAnimation$shimmer", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "emptyPaint", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "shimmerArea", "Lcom/valentinilk/shimmer/ShimmerArea;", "equals", "", "other", "hashCode", "", "shimmer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nShimmerEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShimmerEffect.kt\ncom/valentinilk/shimmer/ShimmerEffect\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 6 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 7 Canvas.kt\nandroidx/compose/ui/graphics/CanvasKt\n*L\n1#1,128:1\n30#2:129\n53#3,3:130\n60#3:135\n60#3:138\n70#3:141\n60#3:143\n70#3:146\n150#4:133\n65#4:134\n65#4:137\n69#4:140\n65#4:142\n69#4:145\n22#5:136\n22#5:139\n22#5:144\n233#6:147\n95#7,7:148\n*S KotlinDebug\n*F\n+ 1 ShimmerEffect.kt\ncom/valentinilk/shimmer/ShimmerEffect\n*L\n52#1:129\n52#1:130,3\n73#1:135\n77#1:138\n77#1:141\n79#1:143\n79#1:146\n53#1:133\n73#1:134\n77#1:137\n77#1:140\n79#1:142\n79#1:145\n73#1:136\n77#1:139\n79#1:144\n91#1:147\n92#1:148,7\n*E\n"})
public final class ShimmerEffect {
    @NotNull
    private final AnimationSpec<Float> animationSpec;
    private final int blendMode;
    private final float rotation;
    @NotNull
    private final List<Color> shaderColors;
    @Nullable
    private final List<Float> shaderColorStops;
    private final float shimmerWidth;
    @NotNull
    private final Animatable<Float, AnimationVector1D> animatedState;
    @NotNull
    private final float[] transformationMatrix;
    private final long gradientFrom;
    private final long gradientTo;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint emptyPaint;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private ShimmerEffect(AnimationSpec<Float> animationSpec, int blendMode, float rotation, List<Color> shaderColors, List<Float> shaderColorStops, float shimmerWidth) {
        void $this$paint_u24lambda_u240;
        Paint paint;
        void x$iv;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(shaderColors, (String)"shaderColors");
        this.animationSpec = animationSpec;
        this.blendMode = blendMode;
        this.rotation = rotation;
        this.shaderColors = shaderColors;
        this.shaderColorStops = shaderColorStops;
        this.shimmerWidth = shimmerWidth;
        this.animatedState = AnimatableKt.Animatable$default((float)0.0f, (float)0.0f, (int)2, null);
        this.transformationMatrix = Matrix.constructor-impl$default(null, (int)1, null);
        float f = -this.shimmerWidth / (float)2;
        float y$iv22 = 0.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv22);
        long arg0$iv = this.gradientFrom = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        boolean bl = false;
        this.gradientTo = Offset.constructor-impl((long)(arg0$iv ^ 0x8000000080000000L));
        Paint y$iv22 = paint = SkiaBackedPaint_skikoKt.Paint();
        ShimmerEffect shimmerEffect = this;
        boolean bl2 = false;
        $this$paint_u24lambda_u240.setAntiAlias(true);
        $this$paint_u24lambda_u240.setStyle-k9PVt8s(PaintingStyle.Companion.getFill-TiuSbCo());
        $this$paint_u24lambda_u240.setBlendMode-s9anfk8(this.blendMode);
        shimmerEffect.paint = paint;
        this.emptyPaint = SkiaBackedPaint_skikoKt.Paint();
    }

    @Nullable
    public final Object startAnimation$shimmer(@NotNull Continuation<? super Unit> $completion) {
        Object object = Animatable.animateTo$default(this.animatedState, (Object)Boxing.boxFloat((float)1.0f), this.animationSpec, null, null, $completion, (int)12, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void draw(@NotNull ContentDrawScope $this$draw, @NotNull ShimmerArea shimmerArea) {
        void $this$withSaveLayer$iv;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shimmerArea, (String)"shimmerArea");
        ShimmerArea $this$draw_u24lambda_u244 = shimmerArea;
        boolean bl = false;
        if ($this$draw_u24lambda_u244.getShimmerBounds().isEmpty() || $this$draw_u24lambda_u244.getViewBounds().isEmpty()) {
            return;
        }
        float progress = ((Number)this.animatedState.getValue()).floatValue();
        long arg0$iv = $this$draw_u24lambda_u244.getPivotPoint-F1C5BW0();
        boolean bl2 = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv22 = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float traversal = -$this$draw_u24lambda_u244.getTranslationDistance() / (float)2 + $this$draw_u24lambda_u244.getTranslationDistance() * progress + Float.intBitsToFloat(bits$iv$iv$iv22);
        float[] $this$draw_u24lambda_u244_u24lambda_u241 = fArray = this.transformationMatrix;
        boolean bl3 = false;
        Matrix.reset-impl((float[])$this$draw_u24lambda_u244_u24lambda_u241);
        long arg0$iv2 = $this$draw_u24lambda_u244.getPivotPoint-F1C5BW0();
        $i$f$getX-impl = false;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackFloat12 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv2 >> 32);
        boolean $i$f$floatFromBits2 = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv2 = $this$draw_u24lambda_u244.getPivotPoint-F1C5BW0();
        boolean bl4 = false;
        value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        $i$f$floatFromBits2 = false;
        Matrix.translate-impl((float[])$this$draw_u24lambda_u244_u24lambda_u241, (float)f, (float)Float.intBitsToFloat(bits$iv$iv$iv), (float)0.0f);
        Matrix.rotateZ-impl((float[])$this$draw_u24lambda_u244_u24lambda_u241, (float)this.rotation);
        arg0$iv2 = $this$draw_u24lambda_u244.getPivotPoint-F1C5BW0();
        $i$f$getX-impl = false;
        value$iv$iv2 = arg0$iv2;
        $i$f$unpackFloat12 = false;
        bits$iv$iv$iv = (int)(value$iv$iv2 >> 32);
        $i$f$floatFromBits2 = false;
        float f2 = -Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv2 = $this$draw_u24lambda_u244.getPivotPoint-F1C5BW0();
        bl4 = false;
        value$iv$iv2 = arg0$iv2;
        $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        $i$f$floatFromBits2 = false;
        Matrix.translate-impl((float[])$this$draw_u24lambda_u244_u24lambda_u241, (float)f2, (float)(-Float.intBitsToFloat(bits$iv$iv$iv)), (float)0.0f);
        Matrix.translate-impl((float[])$this$draw_u24lambda_u244_u24lambda_u241, (float)traversal, (float)0.0f, (float)0.0f);
        this.paint.setShader(ShaderKt.LinearGradientShader-VjE6UOU$default((long)Matrix.map-MK-Hz9U((float[])this.transformationMatrix, (long)this.gradientFrom), (long)Matrix.map-MK-Hz9U((float[])this.transformationMatrix, (long)this.gradientTo), this.shaderColors, this.shaderColorStops, (int)0, (int)16, null));
        Rect drawArea = SizeKt.toRect-uvyYCjk((long)$this$draw.getSize-NH-jbRc());
        DrawScope $this$drawIntoCanvas$iv = (DrawScope)$this$draw;
        boolean $i$f$drawIntoCanvas = false;
        Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl5 = false;
        Canvas $i$f$getY-impl2 = canvas;
        Paint bits$iv$iv$iv22 = this.emptyPaint;
        boolean $i$f$withSaveLayer = false;
        try {
            void paint$iv;
            $this$withSaveLayer$iv.saveLayer(drawArea, (Paint)paint$iv);
            boolean bl6 = false;
            $this$draw.drawContent();
            canvas.drawRect(drawArea, this.paint);
        }
        finally {
            $this$withSaveLayer$iv.restore();
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ShimmerEffect cfr_ignored_0 = (ShimmerEffect)other;
        if (!Intrinsics.areEqual(this.animationSpec, ((ShimmerEffect)other).animationSpec)) {
            return false;
        }
        if (!BlendMode.equals-impl0((int)this.blendMode, (int)((ShimmerEffect)other).blendMode)) {
            return false;
        }
        if (!(this.rotation == ((ShimmerEffect)other).rotation)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.shaderColors, ((ShimmerEffect)other).shaderColors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.shaderColorStops, ((ShimmerEffect)other).shaderColorStops)) {
            return false;
        }
        return this.shimmerWidth == ((ShimmerEffect)other).shimmerWidth;
    }

    public int hashCode() {
        int result = this.animationSpec.hashCode();
        result = 31 * result + BlendMode.hashCode-impl((int)this.blendMode);
        result = 31 * result + Float.hashCode(this.rotation);
        result = 31 * result + ((Object)this.shaderColors).hashCode();
        List<Float> list = this.shaderColorStops;
        result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
        result = 31 * result + Float.hashCode(this.shimmerWidth);
        return result;
    }

    public /* synthetic */ ShimmerEffect(AnimationSpec animationSpec, int blendMode, float rotation, List shaderColors, List shaderColorStops, float shimmerWidth, DefaultConstructorMarker $constructor_marker) {
        this((AnimationSpec<Float>)animationSpec, blendMode, rotation, shaderColors, shaderColorStops, shimmerWidth);
    }
}

