in vec3 a_position;

uniform mat4 u_matrix_mvp;
uniform mat4 u_matrix_model;
uniform mat4 u_matrix_view;
uniform mat4 u_matrix_projection;

uniform vec4 u_color_min;
uniform vec4 u_color_max;

uniform float u_value_min;
uniform float u_value_max;

out vec4 color;

// robust util to map value
float map(float v, float in_min, float in_max, float out_min, float out_max) {
    // normalisation in range[in_min,in_max]
    float norm = 0.0;
    if (in_min < in_max) {
        norm = min(in_max, max(in_min, v)) - in_min;
        norm /= (in_max - in_min);
    } else if (in_min > in_max) {
        norm = min(in_min, max(in_max, v)) - in_max;
        norm /= (in_min - in_max);
        norm = 1.0 - norm;
    }
    // mapping in range [out_min,out_max]
    float result = norm * (out_max - out_min) + out_min;
    float mmin = out_min;
    float mmax = out_max;
    if (out_min > out_max) {
        mmin = out_max;
        mmax = out_min;
        result = (1. - norm) * (out_min - out_max) + out_max;
    }
    // clamping value
    return min(mmax, max(mmin, result));
}

void main() {
    gl_Position = vec4(a_position, 1.0) * u_matrix_mvp;

    float t = map(abs(a_position.y), u_value_min, u_value_max, 0.0, 1.0);
    color = mix(u_color_min, u_color_max, t);
}
