/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.material3.internal.LegacyCalendarModelImpl;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0013J*\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0013J8\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0013J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020!R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR#\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Landroidx/compose/material3/internal/PlatformDateFormat;", "", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "<init>", "(Ljava/util/Locale;)V", "delegate", "Landroidx/compose/material3/internal/LegacyCalendarModelImpl;", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "cache", "", "formatWithSkeleton", "skeleton", "parse", "Landroidx/compose/material3/internal/CalendarDate;", "date", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "weekdayNames", "", "Lkotlin/Pair;", "getWeekdayNames", "()Ljava/util/List;", "is24HourFormat", "", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformDateFormat.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformDateFormat.desktop.kt\nandroidx/compose/material3/internal/PlatformDateFormat\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,118:1\n11228#2:119\n11563#2,3:120\n*S KotlinDebug\n*F\n+ 1 PlatformDateFormat.desktop.kt\nandroidx/compose/material3/internal/PlatformDateFormat\n*L\n95#1:119\n95#1:120,3\n*E\n"})
public final class PlatformDateFormat {
    @NotNull
    private final Locale locale;
    @NotNull
    private final LegacyCalendarModelImpl delegate;
    public static final int $stable = 8;

    public PlatformDateFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = locale;
        this.delegate = new LegacyCalendarModelImpl(this.locale);
    }

    public final int getFirstDayOfWeek() {
        return this.delegate.getFirstDayOfWeek();
    }

    @NotNull
    public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Map<String, Object> cache) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        return this.delegate.formatWithPattern(utcTimeMillis, pattern, this.locale);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String formatWithSkeleton(long utcTimeMillis, @NotNull String skeleton, @NotNull Map<String, Object> cache) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)skeleton, (String)"skeleton");
                Intrinsics.checkNotNullParameter(cache, (String)"cache");
                var6_4 = skeleton;
                switch (var6_4.hashCode()) {
                    case -1097329781: {
                        if (var6_4.equals("yMMMMEEEEd")) break;
                        ** break;
                    }
                    case 114116409: {
                        if (!var6_4.equals("yMMMM")) {
                            ** break;
                        }
                        break block6;
                    }
                    case 114116432: {
                        if (!var6_4.equals("yMMMd")) ** break;
                        v0 = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).localizedBy(this.locale).format(Instant.ofEpochMilli(utcTimeMillis).atOffset(ZoneOffset.UTC));
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"format(...)");
                        return v0;
                    }
                }
                v1 = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).localizedBy(this.locale).format(Instant.ofEpochMilli(utcTimeMillis).atOffset(ZoneOffset.UTC));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(...)");
                return v1;
            }
            v2 = "LLLL yyyy";
            break block7;
lbl23:
            // 4 sources

            v2 = skeleton;
        }
        pattern = v2;
        return this.formatWithPattern(utcTimeMillis, pattern, cache);
    }

    @Nullable
    public final CalendarDate parse(@NotNull String date, @NotNull String pattern, @NotNull Locale locale, @NotNull Map<String, Object> cache) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        return this.delegate.parse(date, pattern, locale);
    }

    @NotNull
    public final DateInputFormat getDateInputFormat() {
        return this.delegate.getDateInputFormat(this.locale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, String>> getWeekdayNames() {
        void $this$mapTo$iv$iv;
        DayOfWeek[] $this$map$iv = DayOfWeek.values();
        boolean $i$f$map = false;
        DayOfWeek[] dayOfWeekArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getDisplayName(TextStyle.FULL, this.locale), (Object)it.getDisplayName(TextStyle.NARROW, this.locale)));
        }
        return (List)destination$iv$iv;
    }

    public final boolean is24HourFormat() {
        DateFormat dateFormat = DateFormat.getTimeInstance(1, this.locale);
        if (!(dateFormat instanceof SimpleDateFormat)) {
            return false;
        }
        String string = ((SimpleDateFormat)dateFormat).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPattern(...)");
        return StringsKt.contains$default((CharSequence)string, (char)'H', (boolean)false, (int)2, null);
    }
}

