/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarModelKt;
import androidx.compose.material3.internal.CalendarMonth;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 12\u00020\u0001:\u00011B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\fH\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\fH\u0016J$\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00122\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J&\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00122\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0002J\f\u0010.\u001a\u00020-*\u00020\u001bH\u0002J\u0014\u0010.\u001a\u00020-*\u00020\b2\u0006\u0010/\u001a\u000200H\u0002R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00062"}, d2={"Landroidx/compose/material3/internal/LegacyCalendarModelImpl;", "Landroidx/compose/material3/internal/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "<init>", "(Ljava/util/Locale;)V", "today", "Landroidx/compose/material3/internal/CalendarDate;", "getToday", "()Landroidx/compose/material3/internal/CalendarDate;", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "getCanonicalDate", "timeInMillis", "", "getMonth", "Landroidx/compose/material3/internal/CalendarMonth;", "date", "year", "month", "getDayOfWeek", "plusMonths", "from", "addedMonthsCount", "minusMonths", "subtractedMonthsCount", "formatWithPattern", "utcTimeMillis", "pattern", "parse", "toString", "dayInISO8601", "day", "firstDayCalendar", "Ljava/util/Calendar;", "toCalendar", "timeZone", "Ljava/util/TimeZone;", "Companion", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,241:1\n71#2,5:242\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl\n*L\n61#1:242,5\n*E\n"})
public final class LegacyCalendarModelImpl
extends CalendarModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int firstDayOfWeek;
    @NotNull
    private final List<Pair<String, String>> weekdayNames;
    public static final int $stable = 8;
    @NotNull
    private static final TimeZone utcTimeZone;

    /*
     * WARNING - void declaration
     */
    public LegacyCalendarModelImpl(@NotNull Locale locale) {
        void $this$weekdayNames_u24lambda_u241;
        List list;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(locale);
        this.firstDayOfWeek = this.dayInISO8601(Calendar.getInstance(locale).getFirstDayOfWeek());
        List list2 = list = CollectionsKt.createListBuilder();
        LegacyCalendarModelImpl legacyCalendarModelImpl = this;
        boolean bl = false;
        Object[] weekdays = new DateFormatSymbols(locale).getWeekdays();
        String[] shortWeekdays = new DateFormatSymbols(locale).getShortWeekdays();
        Intrinsics.checkNotNull((Object)weekdays);
        List $this$fastForEachIndexed$iv = ArraysKt.drop((Object[])weekdays, (int)2);
        boolean $i$f$fastForEachIndexed = false;
        int index$iv = 0;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        while (index$iv < n) {
            void day;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            String string = (String)item$iv;
            int index = index$iv++;
            boolean bl2 = false;
            $this$weekdayNames_u24lambda_u241.add(new Pair((Object)day, (Object)shortWeekdays[index + 2]));
        }
        $this$weekdayNames_u24lambda_u241.add(new Pair(weekdays[1], (Object)shortWeekdays[1]));
        legacyCalendarModelImpl.weekdayNames = CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public CalendarDate getToday() {
        Calendar systemCalendar = Calendar.getInstance();
        systemCalendar.set(11, 0);
        systemCalendar.set(12, 0);
        systemCalendar.set(13, 0);
        systemCalendar.set(14, 0);
        int utcOffset = systemCalendar.get(15) + systemCalendar.get(16);
        return new CalendarDate(systemCalendar.get(1), systemCalendar.get(2) + 1, systemCalendar.get(5), systemCalendar.getTimeInMillis() + (long)utcOffset);
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.weekdayNames;
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        Intrinsics.checkNotNull((Object)dateFormat, (String)"null cannot be cast to non-null type java.text.SimpleDateFormat");
        String string = ((SimpleDateFormat)dateFormat).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPattern(...)");
        return CalendarModelKt.datePatternAsInputFormat(string);
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis(timeInMillis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.getTimeInMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.setTimeInMillis(timeInMillis);
        firstDayCalendar.set(5, 1);
        firstDayCalendar.set(11, 0);
        firstDayCalendar.set(12, 0);
        firstDayCalendar.set(13, 0);
        firstDayCalendar.set(14, 0);
        Intrinsics.checkNotNull((Object)firstDayCalendar);
        return this.getMonth(firstDayCalendar);
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getMonth(date.getYear(), date.getMonth());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.clear();
        firstDayCalendar.set(1, year);
        firstDayCalendar.set(2, month - 1);
        firstDayCalendar.set(5, 1);
        Intrinsics.checkNotNull((Object)firstDayCalendar);
        return this.getMonth(firstDayCalendar);
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault(...)");
        return this.dayInISO8601(this.toCalendar(date, timeZone).get(7));
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (addedMonthsCount <= 0) {
            return from;
        }
        Calendar laterMonth = this.toCalendar(from);
        laterMonth.add(2, addedMonthsCount);
        return this.getMonth(laterMonth);
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (subtractedMonthsCount <= 0) {
            return from;
        }
        Calendar earlierMonth = this.toCalendar(from);
        earlierMonth.add(2, -subtractedMonthsCount);
        return this.getMonth(earlierMonth);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return Companion.formatWithPattern(utcTimeMillis, pattern, locale, this.getFormatterCache$material3());
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern, @NotNull Locale locale) {
        CalendarDate calendarDate;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(utcTimeZone);
        dateFormat.setLenient(false);
        try {
            Date date2 = dateFormat.parse(date);
            if (date2 == null) {
                return null;
            }
            Date parsedDate = date2;
            Calendar calendar = Calendar.getInstance(utcTimeZone);
            calendar.setTime(parsedDate);
            calendarDate = new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.getTimeInMillis());
        }
        catch (ParseException pe) {
            calendarDate = null;
        }
        return calendarDate;
    }

    @NotNull
    public String toString() {
        return "LegacyCalendarModel";
    }

    private final int dayInISO8601(int day) {
        int shiftedDay = (day + 6) % 7;
        if (shiftedDay == 0) {
            return 7;
        }
        return shiftedDay;
    }

    private final CalendarMonth getMonth(Calendar firstDayCalendar) {
        int difference = this.dayInISO8601(firstDayCalendar.get(7)) - this.getFirstDayOfWeek();
        int daysFromStartOfWeekToFirstOfMonth = difference < 0 ? difference + 7 : difference;
        return new CalendarMonth(firstDayCalendar.get(1), firstDayCalendar.get(2) + 1, firstDayCalendar.getActualMaximum(5), daysFromStartOfWeekToFirstOfMonth, firstDayCalendar.getTimeInMillis());
    }

    private final Calendar toCalendar(CalendarMonth $this$toCalendar) {
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis($this$toCalendar.getStartUtcTimeMillis());
        Intrinsics.checkNotNull((Object)calendar);
        return calendar;
    }

    private final Calendar toCalendar(CalendarDate $this$toCalendar, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(1, $this$toCalendar.getYear());
        calendar.set(2, $this$toCalendar.getMonth() - 1);
        calendar.set(5, $this$toCalendar.getDayOfMonth());
        Intrinsics.checkNotNull((Object)calendar);
        return calendar;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(...)");
        utcTimeZone = timeZone;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rJ0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rH\u0002R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Landroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion;", "", "<init>", "()V", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "cache", "", "utcTimeZone", "Ljava/util/TimeZone;", "getUtcTimeZone$material3", "()Ljava/util/TimeZone;", "getCachedSimpleDateFormat", "Ljava/text/SimpleDateFormat;", "material3"})
    @SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,241:1\n384#2,7:242\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion\n*L\n192#1:242,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale, @NotNull Map<String, Object> cache) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter(cache, (String)"cache");
            SimpleDateFormat dateFormat = this.getCachedSimpleDateFormat(pattern, locale, cache);
            Calendar calendar = Calendar.getInstance(this.getUtcTimeZone$material3());
            calendar.setTimeInMillis(utcTimeMillis);
            String string = dateFormat.format(calendar.getTimeInMillis());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final TimeZone getUtcTimeZone$material3() {
            return utcTimeZone;
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleDateFormat getCachedSimpleDateFormat(String pattern, Locale locale, Map<String, Object> cache) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, Object> map2 = cache;
            String key$iv = pattern + locale.toLanguageTag();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, locale);
                dateFormat.setTimeZone(Companion.getUtcTimeZone$material3());
                SimpleDateFormat answer$iv = dateFormat;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (SimpleDateFormat)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

