/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarMonth;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.material3.internal.KotlinxDatetimeCalendarModelKt;
import androidx.compose.material3.internal.PlatformDateFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\nH\u0016J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u000eH\u0016J\u0018\u0010*\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u000eH\u0016J)\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00142\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016\u00a2\u0006\u0002\u0010/J+\u00100\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016\u00a2\u0006\u0002\u00101J\u0014\u00102\u001a\u00020\"*\u0002032\u0006\u00104\u001a\u00020\u0018H\u0002J\f\u00105\u001a\u00020\u000e*\u000206H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00067"}, d2={"Landroidx/compose/material3/internal/KotlinxDatetimeCalendarModel;", "Landroidx/compose/material3/internal/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "<init>", "(Ljava/util/Locale;)V", "platformDateFormat", "Landroidx/compose/material3/internal/PlatformDateFormat;", "today", "Landroidx/compose/material3/internal/CalendarDate;", "getToday", "()Landroidx/compose/material3/internal/CalendarDate;", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "systemTZ", "Lkotlinx/datetime/TimeZone;", "getSystemTZ", "()Lkotlinx/datetime/TimeZone;", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "(Ljava/util/Locale;)Landroidx/compose/material3/internal/DateInputFormat;", "getCanonicalDate", "timeInMillis", "", "getMonth", "Landroidx/compose/material3/internal/CalendarMonth;", "date", "year", "month", "getDayOfWeek", "plusMonths", "from", "addedMonthsCount", "minusMonths", "subtractedMonthsCount", "formatWithPattern", "utcTimeMillis", "pattern", "(JLjava/lang/String;Ljava/util/Locale;)Ljava/lang/String;", "parse", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;)Landroidx/compose/material3/internal/CalendarDate;", "toCalendarMonth", "Lkotlin/time/Instant;", "timeZone", "daysFromStartOfWeekToFirstOfMonth", "Lkotlinx/datetime/LocalDate;", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nKotlinxDatetimeCalendarModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxDatetimeCalendarModel.kt\nandroidx/compose/material3/internal/KotlinxDatetimeCalendarModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class KotlinxDatetimeCalendarModel
extends CalendarModel {
    @NotNull
    private final PlatformDateFormat platformDateFormat;
    public static final int $stable = 8;

    public KotlinxDatetimeCalendarModel(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(locale);
        this.platformDateFormat = new PlatformDateFormat(locale);
    }

    @Override
    @NotNull
    public CalendarDate getToday() {
        LocalDateTime localDate = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)this.getSystemTZ());
        return new CalendarDate(localDate.getYear(), localDate.getMonthNumber(), localDate.getDayOfMonth(), TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime((LocalDate)localDate.getDate(), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null).toEpochMilliseconds());
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.platformDateFormat.getFirstDayOfWeek();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.platformDateFormat.getWeekdayNames();
    }

    private final TimeZone getSystemTZ() {
        return TimeZone.Companion.currentSystemDefault();
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.platformDateFormat.getDateInputFormat();
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        return KotlinxDatetimeCalendarModelKt.toCalendarDate(TimeZoneKt.atStartOfDayIn$default((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(timeInMillis), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        return this.toCalendarMonth(Instant.Companion.fromEpochMilliseconds(timeInMillis), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getMonth(date.getUtcTimeMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Instant instant = TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime((LocalDate)new LocalDate(year, month, 1), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null);
        return this.getMonth(instant.toEpochMilliseconds());
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return DayOfWeekKt.getIsoDayNumber((DayOfWeek)new LocalDate(date.getYear(), date.getMonth(), date.getDayOfMonth()).getDayOfWeek());
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.toCalendarMonth(TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime((LocalDate)LocalDateJvmKt.plus((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(from.getStartUtcTimeMillis()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate(), (DatePeriod)new DatePeriod(0, addedMonthsCount, 0, 5, null)), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.plusMonths(from, -subtractedMonthsCount);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.platformDateFormat.formatWithPattern(utcTimeMillis, pattern, this.getFormatterCache$material3());
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.platformDateFormat.parse(date, pattern, locale, this.getFormatterCache$material3());
    }

    private final CalendarMonth toCalendarMonth(Instant $this$toCalendarMonth, TimeZone timeZone) {
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((Instant)$this$toCalendarMonth, (TimeZone)timeZone);
        LocalDate monthStart = new LocalDate(dateTime.getYear(), dateTime.getMonth(), 1);
        return new CalendarMonth(dateTime.getYear(), dateTime.getMonthNumber(), KotlinxDatetimeCalendarModelKt.access$numberOfDays(dateTime.getMonth(), KotlinxDatetimeCalendarModelKt.access$isLeapYear(dateTime.getYear())), this.daysFromStartOfWeekToFirstOfMonth(monthStart), TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime((LocalDate)monthStart, (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null).toEpochMilliseconds());
    }

    private final int daysFromStartOfWeekToFirstOfMonth(LocalDate $this$daysFromStartOfWeekToFirstOfMonth) {
        int it = DayOfWeekKt.getIsoDayNumber((DayOfWeek)$this$daysFromStartOfWeekToFirstOfMonth.getDayOfWeek()) - this.getFirstDayOfWeek();
        boolean bl = false;
        return it >= 0 ? it : 7 + it;
    }
}

