/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.material3.carousel.Arrangement;
import androidx.compose.material3.carousel.CarouselAlignment;
import androidx.compose.material3.carousel.CarouselDefaults;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aD\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0000\u001a(\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0000\u001aU\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a0\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a0\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002\u00a8\u0006\u001d"}, d2={"multiBrowseKeylineList", "Landroidx/compose/material3/carousel/KeylineList;", "density", "Landroidx/compose/ui/unit/Density;", "carouselMainAxisSize", "", "preferredItemSize", "itemSpacing", "itemCount", "", "minSmallItemSize", "maxSmallItemSize", "uncontainedKeylineList", "itemSize", "heroKeylineList", "maxItemSize", "isCentered", "", "(Landroidx/compose/ui/unit/Density;FLjava/lang/Float;FIZFF)Landroidx/compose/material3/carousel/KeylineList;", "createLeftAlignedKeylineList", "leftAnchorSize", "rightAnchorSize", "arrangement", "Landroidx/compose/material3/carousel/Arrangement;", "createCenterAlignedKeylineList", "calculateMediumChildSize", "minimumMediumSize", "largeItemSize", "remainingSpace", "material3"})
@SourceDebugExtension(value={"SMAP\nKeylines.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keylines.kt\nandroidx/compose/material3/carousel/KeylinesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1#2:361\n*E\n"})
public final class KeylinesKt {
    @NotNull
    public static final KeylineList multiBrowseKeylineList(@NotNull Density density, float carouselMainAxisSize, float preferredItemSize, float itemSpacing, int itemCount, float minSmallItemSize, float maxSmallItemSize) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (carouselMainAxisSize == 0.0f || preferredItemSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        int[] nArray = new int[]{1};
        int[] smallCounts = nArray;
        int[] nArray2 = new int[]{1, 0};
        int[] mediumCounts = nArray2;
        float targetLargeSize = Math.min(preferredItemSize, carouselMainAxisSize);
        float targetSmallSize = RangesKt.coerceIn((float)(targetLargeSize / 3.0f), (float)minSmallItemSize, (float)maxSmallItemSize);
        float targetMediumSize = (targetLargeSize + targetSmallSize) / 2.0f;
        if (carouselMainAxisSize < minSmallItemSize * (float)2) {
            int[] nArray3 = new int[]{0};
            smallCounts = nArray3;
        }
        float minAvailableLargeSpace = carouselMainAxisSize - targetMediumSize * (float)ArraysKt.maxOrThrow((int[])mediumCounts) - maxSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts);
        int minLargeCount = Math.max(1, (int)Math.floor(minAvailableLargeSpace / targetLargeSize));
        int maxLargeCount = (int)Math.ceil(carouselMainAxisSize / targetLargeSize);
        int n = 0;
        int n2 = maxLargeCount - minLargeCount + 1;
        int[] nArray4 = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray4[n3] = maxLargeCount - n3;
        }
        int[] largeCounts = nArray4;
        Density $this$multiBrowseKeylineList_u24lambda_u242 = density;
        boolean bl = false;
        float anchorSize = $this$multiBrowseKeylineList_u24lambda_u242.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3());
        Arrangement arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, targetSmallSize, minSmallItemSize, maxSmallItemSize, smallCounts, targetMediumSize, mediumCounts, targetLargeSize, largeCounts);
        if (arrangement != null && arrangement.itemCount() > itemCount) {
            int smallCount = arrangement.getSmallCount();
            int mediumCount = arrangement.getMediumCount();
            for (int keylineSurplus = arrangement.itemCount() - itemCount; keylineSurplus > 0; --keylineSurplus) {
                if (smallCount > 0) {
                    --smallCount;
                    continue;
                }
                if (mediumCount <= 1) continue;
                --mediumCount;
            }
            int[] nArray5 = new int[]{smallCount};
            int[] nArray6 = nArray5;
            nArray5 = new int[]{mediumCount};
            arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, targetSmallSize, minSmallItemSize, maxSmallItemSize, nArray6, targetMediumSize, nArray5, targetLargeSize, largeCounts);
        }
        if (arrangement == null) {
            return KeylineListKt.emptyKeylineList();
        }
        return KeylinesKt.createLeftAlignedKeylineList(carouselMainAxisSize, itemSpacing, anchorSize, anchorSize, arrangement);
    }

    public static /* synthetic */ KeylineList multiBrowseKeylineList$default(Density density, float f, float f2, float f3, int n, float f4, float f5, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            Density $this$multiBrowseKeylineList_u24lambda_u240 = density;
            boolean bl = false;
            f4 = $this$multiBrowseKeylineList_u24lambda_u240.toPx-0680j_4(CarouselDefaults.INSTANCE.getMinSmallItemSize-D9Ej5fM());
        }
        if ((n2 & 0x40) != 0) {
            Density $this$multiBrowseKeylineList_u24lambda_u241 = density;
            boolean bl = false;
            f5 = $this$multiBrowseKeylineList_u24lambda_u241.toPx-0680j_4(CarouselDefaults.INSTANCE.getMaxSmallItemSize-D9Ej5fM());
        }
        return KeylinesKt.multiBrowseKeylineList(density, f, f2, f3, n, f4, f5);
    }

    @NotNull
    public static final KeylineList uncontainedKeylineList(@NotNull Density density, float carouselMainAxisSize, float itemSize, float itemSpacing) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (carouselMainAxisSize == 0.0f || itemSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        float largeItemSize = Math.min(itemSize + itemSpacing, carouselMainAxisSize);
        int largeCount = Math.max(1, (int)Math.floor(carouselMainAxisSize / largeItemSize));
        float remainingSpace = carouselMainAxisSize - (float)largeCount * largeItemSize;
        int mediumCount = remainingSpace > 0.0f ? 1 : 0;
        Density $this$uncontainedKeylineList_u24lambda_u243 = density;
        boolean bl = false;
        float defaultAnchorSize = $this$uncontainedKeylineList_u24lambda_u243.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3());
        float mediumItemSize = KeylinesKt.calculateMediumChildSize(defaultAnchorSize, largeItemSize, remainingSpace);
        Arrangement arrangement = new Arrangement(0, 0.0f, 0, mediumItemSize, mediumCount, largeItemSize, largeCount);
        float xSmallSize = Math.min(defaultAnchorSize, itemSize);
        float leftAnchorSize = Math.max(xSmallSize, mediumItemSize * 0.5f);
        return KeylinesKt.createLeftAlignedKeylineList(carouselMainAxisSize, itemSpacing, leftAnchorSize, defaultAnchorSize, arrangement);
    }

    @NotNull
    public static final KeylineList heroKeylineList(@NotNull Density density, float carouselMainAxisSize, @Nullable Float maxItemSize, float itemSpacing, int itemCount, boolean isCentered, float minSmallItemSize, float maxSmallItemSize) {
        int[] nArray;
        int[] nArray2;
        boolean shouldCenter;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (carouselMainAxisSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        boolean bl = shouldCenter = isCentered && itemCount >= 3;
        if (shouldCenter) {
            nArray2 = new int[]{2};
            nArray = nArray2;
        } else {
            nArray2 = new int[]{1};
            nArray = nArray2;
        }
        int[] smallCounts = nArray;
        Float f = maxItemSize;
        float targetLargeSize = Math.min(f != null ? f.floatValue() : carouselMainAxisSize, carouselMainAxisSize);
        float targetSmallSize = RangesKt.coerceIn((float)(targetLargeSize / 3.0f), (float)minSmallItemSize, (float)maxSmallItemSize);
        float fullscreenThreshold = minSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts) + minSmallItemSize * 1.25f;
        if (carouselMainAxisSize < fullscreenThreshold) {
            int[] nArray3 = new int[]{0};
            smallCounts = nArray3;
        }
        float minAvailableLargeSpace = carouselMainAxisSize - minSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts);
        int minLargeCount = Math.max(1, (int)Math.floor(minAvailableLargeSpace / targetLargeSize));
        int maxLargeCount = (int)Math.ceil(carouselMainAxisSize / targetLargeSize);
        int n = 0;
        int n2 = maxLargeCount - minLargeCount + 1;
        int[] nArray4 = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray4[n3] = maxLargeCount - n3;
        }
        int[] largeCounts = nArray4;
        Density $this$heroKeylineList_u24lambda_u246 = density;
        boolean bl2 = false;
        float anchorSize = $this$heroKeylineList_u24lambda_u246.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3());
        int[] nArray5 = new int[]{0};
        Arrangement arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, targetSmallSize, minSmallItemSize, maxSmallItemSize, smallCounts, 0.0f, nArray5, targetLargeSize, largeCounts);
        if (arrangement == null) {
            return KeylineListKt.emptyKeylineList();
        }
        if (shouldCenter && itemCount >= arrangement.itemCount()) {
            return KeylinesKt.createCenterAlignedKeylineList(carouselMainAxisSize, itemSpacing, anchorSize, anchorSize, arrangement);
        }
        return KeylinesKt.createLeftAlignedKeylineList(carouselMainAxisSize, itemSpacing, anchorSize, anchorSize, arrangement);
    }

    public static /* synthetic */ KeylineList heroKeylineList$default(Density density, float f, Float f2, float f3, int n, boolean bl, float f4, float f5, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            Density $this$heroKeylineList_u24lambda_u244 = density;
            boolean bl2 = false;
            f4 = $this$heroKeylineList_u24lambda_u244.toPx-0680j_4(CarouselDefaults.INSTANCE.getMinSmallItemSize-D9Ej5fM());
        }
        if ((n2 & 0x80) != 0) {
            Density $this$heroKeylineList_u24lambda_u245 = density;
            boolean bl3 = false;
            f5 = $this$heroKeylineList_u24lambda_u245.toPx-0680j_4(CarouselDefaults.INSTANCE.getMaxSmallItemSize-D9Ej5fM());
        }
        return KeylinesKt.heroKeylineList(density, f, f2, f3, n, bl, f4, f5);
    }

    @NotNull
    public static final KeylineList createLeftAlignedKeylineList(float carouselMainAxisSize, float itemSpacing, float leftAnchorSize, float rightAnchorSize, @NotNull Arrangement arrangement) {
        Intrinsics.checkNotNullParameter((Object)arrangement, (String)"arrangement");
        return KeylineListKt.keylineListOf-WNYm7Xg(carouselMainAxisSize, itemSpacing, CarouselAlignment.Companion.getStart-NUL3oTo(), (Function1<? super KeylineListScope, Unit>)((Function1)arg_0 -> KeylinesKt.createLeftAlignedKeylineList$lambda$10(leftAnchorSize, arrangement, rightAnchorSize, arg_0)));
    }

    @NotNull
    public static final KeylineList createCenterAlignedKeylineList(float carouselMainAxisSize, float itemSpacing, float leftAnchorSize, float rightAnchorSize, @NotNull Arrangement arrangement) {
        Intrinsics.checkNotNullParameter((Object)arrangement, (String)"arrangement");
        return KeylineListKt.keylineListOf-WNYm7Xg(carouselMainAxisSize, itemSpacing, CarouselAlignment.Companion.getCenter-NUL3oTo(), (Function1<? super KeylineListScope, Unit>)((Function1)arg_0 -> KeylinesKt.createCenterAlignedKeylineList$lambda$16(leftAnchorSize, arrangement, rightAnchorSize, arg_0)));
    }

    private static final float calculateMediumChildSize(float minimumMediumSize, float largeItemSize, float remainingSpace) {
        float largeItemThreshold;
        float mediumItemSize = minimumMediumSize;
        float sizeWithThirdCutOff = remainingSpace * 1.5f;
        if ((mediumItemSize = Math.max(sizeWithThirdCutOff, mediumItemSize)) > (largeItemThreshold = largeItemSize * 0.85f)) {
            float sizeWithFifthCutOff = remainingSpace * 1.2f;
            mediumItemSize = Math.min(Math.max(largeItemThreshold, sizeWithFifthCutOff), largeItemSize);
        }
        return mediumItemSize;
    }

    private static final Unit createLeftAlignedKeylineList$lambda$10(float $leftAnchorSize, Arrangement $arrangement, float $rightAnchorSize, KeylineListScope $this$keylineListOf) {
        int it;
        Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
        $this$keylineListOf.add($leftAnchorSize, true);
        int n = $arrangement.getLargeCount();
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getLargeSize(), false, 2, null);
        }
        n = $arrangement.getMediumCount();
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getMediumSize(), false, 2, null);
        }
        n = $arrangement.getSmallCount();
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getSmallSize(), false, 2, null);
        }
        $this$keylineListOf.add($rightAnchorSize, true);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterAlignedKeylineList$lambda$16(float $leftAnchorSize, Arrangement $arrangement, float $rightAnchorSize, KeylineListScope $this$keylineListOf) {
        int it;
        Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
        $this$keylineListOf.add($leftAnchorSize, true);
        int n = $arrangement.getSmallCount() / 2;
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getSmallSize(), false, 2, null);
        }
        n = $arrangement.getMediumCount() / 2;
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getMediumSize(), false, 2, null);
        }
        n = $arrangement.getLargeCount();
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getLargeSize(), false, 2, null);
        }
        n = $arrangement.getMediumCount() / 2;
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getMediumSize(), false, 2, null);
        }
        n = $arrangement.getSmallCount() / 2;
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            KeylineListScope.add$default($this$keylineListOf, $arrangement.getSmallSize(), false, 2, null);
        }
        $this$keylineListOf.add($rightAnchorSize, true);
        return Unit.INSTANCE;
    }
}

