/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.material3.carousel.CarouselPageSize;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.Strategy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"getSnapPositionOffset", "", "strategy", "Landroidx/compose/material3/carousel/Strategy;", "itemIndex", "itemCount", "KeylineSnapPosition", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "pageSize", "Landroidx/compose/material3/carousel/CarouselPageSize;", "material3"})
public final class KeylineSnapPositionKt {
    public static final int getSnapPositionOffset(@NotNull Strategy strategy, int itemIndex, int itemCount) {
        int lastItemIndex;
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        if (!strategy.isValid()) {
            return 0;
        }
        int offset2 = MathKt.roundToInt((float)(strategy.getDefaultKeylines().getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        if (itemIndex <= CollectionsKt.getLastIndex(strategy.getStartKeylineSteps())) {
            int stepIndex = RangesKt.coerceIn((int)(CollectionsKt.getLastIndex(strategy.getStartKeylineSteps()) - itemIndex), (int)0, (int)CollectionsKt.getLastIndex(strategy.getStartKeylineSteps()));
            KeylineList startKeylines = strategy.getStartKeylineSteps().get(stepIndex);
            offset2 = MathKt.roundToInt((float)(startKeylines.getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        }
        if (itemIndex >= (lastItemIndex = itemCount - 1) - CollectionsKt.getLastIndex(strategy.getEndKeylineSteps()) && itemCount > strategy.getDefaultKeylines().getFocalCount()) {
            int stepIndex = RangesKt.coerceIn((int)(CollectionsKt.getLastIndex(strategy.getEndKeylineSteps()) - (lastItemIndex - itemIndex)), (int)0, (int)CollectionsKt.getLastIndex(strategy.getEndKeylineSteps()));
            KeylineList endKeylines = strategy.getEndKeylineSteps().get(stepIndex);
            offset2 = MathKt.roundToInt((float)(endKeylines.getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        }
        return offset2;
    }

    @NotNull
    public static final SnapPosition KeylineSnapPosition(@NotNull CarouselPageSize pageSize) {
        Intrinsics.checkNotNullParameter((Object)pageSize, (String)"pageSize");
        return new SnapPosition(pageSize){
            final /* synthetic */ CarouselPageSize $pageSize;
            {
                this.$pageSize = $pageSize;
            }

            public int position(int layoutSize, int itemSize, int beforeContentPadding, int afterContentPadding, int itemIndex, int itemCount) {
                return KeylineSnapPositionKt.getSnapPositionOffset(this.$pageSize.getStrategy(), itemIndex, itemCount);
            }
        };
    }
}

