/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import dev.romainguy.kotlin.math.Float2;
import dev.romainguy.kotlin.math.Float4;
import dev.romainguy.kotlin.math.Mat4;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.krafiks.Camera;
import vet.inpulse.krafiks.GLES_jvmKt;
import vet.inpulse.krafiks.LayoutBuilder;
import vet.inpulse.krafiks.M4;
import vet.inpulse.krafiks.M4Kt;
import vet.inpulse.krafiks.Mesh;
import vet.inpulse.krafiks.Shader;
import vet.inpulse.krafiks.ShaderKt;
import vet.inpulse.krafiks.Usage;
import vet.inpulse.krafiks.VertexBufferLayout;
import vet.inpulse.krafiks.VertexBufferLayoutKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b*\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 \u008c\u00012\u00020\u0001:\u0004\u008c\u0001\u008d\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u001cJ0\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u0002082\u0006\u0010e\u001a\u0002082\u0006\u0010f\u001a\u0002082\u0006\u0010g\u001a\u0002082\b\b\u0002\u0010h\u001a\u000202J*\u0010i\u001a\u00020c2\u0006\u0010d\u001a\u0002082\u0006\u0010e\u001a\u0002082\b\b\u0002\u0010h\u001a\u0002022\b\b\u0002\u0010j\u001a\u000208J:\u0010k\u001a\u00020c2\u0006\u0010l\u001a\u00020\u00052\u0006\u0010m\u001a\u00020\u00052\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u00072\b\b\u0002\u0010h\u001a\u0002022\b\b\u0002\u0010j\u001a\u000208J:\u0010p\u001a\u00020c2\u0006\u0010q\u001a\u00020\u00072\u0006\u0010r\u001a\u00020\u00052\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u00072\b\b\u0002\u0010h\u001a\u0002022\b\b\u0002\u0010j\u001a\u000208J\u0018\u0010s\u001a\u00020c2\u0006\u0010d\u001a\u0002082\u0006\u0010e\u001a\u000208H\u0002J,\u0010t\u001a\u00020c2\u0006\u0010d\u001a\u0002082\u0006\u0010e\u001a\u0002082\b\b\u0002\u0010h\u001a\u0002022\b\b\u0002\u0010j\u001a\u000208H\u0002J\u0018\u0010u\u001a\u00020c2\u0006\u0010d\u001a\u0002082\u0006\u0010e\u001a\u000208H\u0002J(\u0010v\u001a\u00020c2\u0006\u0010l\u001a\u00020\u00052\u0006\u0010m\u001a\u00020\u00052\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u0007H\u0002J\u0006\u0010w\u001a\u00020cJ\u0016\u0010x\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|J\u0006\u0010}\u001a\u00020cJ\u0018\u0010~\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|H\u0002J[\u0010\u0081\u0001\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010d\u001a\u0002082\u0006\u0010e\u001a\u0002082\u0006\u0010f\u001a\u0002082\u0006\u0010g\u001a\u0002082\u0007\u0010\u0082\u0001\u001a\u0002082\u0007\u0010\u0083\u0001\u001a\u0002082\u0006\u0010j\u001a\u0002082\u0007\u0010\u0084\u0001\u001a\u0002022\u0007\u0010\u0085\u0001\u001a\u000202J\u0017\u0010\u0086\u0001\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|J\u0019\u0010\u0087\u0001\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|H\u0002J1\u0010\u0088\u0001\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|2\u0007\u0010\u0089\u0001\u001a\u00020\u000e2\u0006\u0010n\u001a\u00020\u00072\u0007\u0010\u008a\u0001\u001a\u00020\u0007J\u0019\u0010\u008b\u0001\u001a\u00020c2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u001f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR\u0011\u0010!\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00104\"\u0004\b?\u00106R\u001a\u0010@\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010:\"\u0004\bB\u0010<R\u001a\u0010C\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010:\"\u0004\bE\u0010<R\u001a\u0010F\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010+\"\u0004\bH\u0010-R\u001a\u0010I\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010+\"\u0004\bK\u0010-R\u001a\u0010L\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010N\"\u0004\bS\u0010PR\u000e\u0010T\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010V\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0010R\u0011\u0010X\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\fR\u001a\u0010Z\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\u001a\u0010_\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010N\"\u0004\ba\u0010PR\u0012\u0010\u007f\u001a\u00020\n\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0080\u0001\u0010\f\u00a8\u0006\u008e\u0001"}, d2={"Lvet/inpulse/krafiks/Renderer;", "", "<init>", "()V", "resizeIfNeeded", "", "current", "", "toAdd", "pointsShader", "Lvet/inpulse/krafiks/Shader;", "getPointsShader", "()Lvet/inpulse/krafiks/Shader;", "pointsMesh", "Lvet/inpulse/krafiks/Mesh;", "getPointsMesh", "()Lvet/inpulse/krafiks/Mesh;", "instancedLineShader", "getInstancedLineShader", "generateIndexData", "", "resolution", "centerIndex", "topIndex", "bottomIndex", "reverseOrder", "", "generateVertexData", "Lkotlin/Pair;", "lineMesh", "getLineMesh", "filledLineShader", "getFilledLineShader", "filledLineMesh", "getFilledLineMesh", "mode", "Lvet/inpulse/krafiks/Renderer$Mode;", "getMode", "()Lvet/inpulse/krafiks/Renderer$Mode;", "setMode", "(Lvet/inpulse/krafiks/Renderer$Mode;)V", "debug", "getDebug", "()Z", "setDebug", "(Z)V", "flippedY", "getFlippedY", "setFlippedY", "lineColorMin", "Ldev/romainguy/kotlin/math/Float4;", "getLineColorMin", "()Ldev/romainguy/kotlin/math/Float4;", "setLineColorMin", "(Ldev/romainguy/kotlin/math/Float4;)V", "lineValueMin", "", "getLineValueMin", "()F", "setLineValueMin", "(F)V", "lineColorMax", "getLineColorMax", "setLineColorMax", "lineValueMax", "getLineValueMax", "setLineValueMax", "lineThickness", "getLineThickness", "setLineThickness", "lineStrip", "getLineStrip", "setLineStrip", "lineCap", "getLineCap", "setLineCap", "lineDataX", "getLineDataX", "()[F", "setLineDataX", "([F)V", "lineDataY", "getLineDataY", "setLineDataY", "pointsBuffer", "points", "quadMesh", "getQuadMesh", "quadShader", "getQuadShader", "quads", "getQuads", "()I", "setQuads", "(I)V", "quadsInstanceBuffer", "getQuadsInstanceBuffer", "setQuadsInstanceBuffer", "addQuad", "", "x", "y", "sizeX", "sizeY", "color", "addPoint", "thickness", "addPoints", "xs", "ys", "offset", "length", "addPointsIndexed", "firstIndex", "p", "lineAddPoint", "pointAddPoint", "filledAddPoint", "filledAddPoints", "reset", "render", "camera", "Lvet/inpulse/krafiks/Camera;", "model", "Ldev/romainguy/kotlin/math/Mat4;", "release", "renderPoints", "gridShader", "getGridShader", "renderGrid", "div", "offsetY", "minorColor", "majorColor", "renderQuads", "renderLines", "renderWaveform", "waveformData", "wavePoints", "renderLinesFilled", "Companion", "Mode", "krafiks-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer.kt\nvet/inpulse/krafiks/Renderer\n+ 2 Vector.kt\ndev/romainguy/kotlin/math/Float4\n*L\n1#1,770:1\n327#2:771\n332#2:772\n337#2:773\n342#2:774\n*S KotlinDebug\n*F\n+ 1 Renderer.kt\nvet/inpulse/krafiks/Renderer\n*L\n257#1:771\n258#1:772\n259#1:773\n260#1:774\n*E\n"})
public final class Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shader pointsShader = ShaderKt.shaderFromResource$default("/point_shader.vert", "/point_shader.frag", null, 4, null);
    @NotNull
    private final Mesh pointsMesh;
    @NotNull
    private final Shader instancedLineShader;
    @NotNull
    private final Mesh lineMesh;
    @NotNull
    private final Shader filledLineShader;
    @NotNull
    private final Mesh filledLineMesh;
    @NotNull
    private Mode mode;
    private boolean debug;
    private boolean flippedY;
    @NotNull
    private Float4 lineColorMin;
    private float lineValueMin;
    @NotNull
    private Float4 lineColorMax;
    private float lineValueMax;
    private float lineThickness;
    private boolean lineStrip;
    private boolean lineCap;
    @NotNull
    private float[] lineDataX;
    @NotNull
    private float[] lineDataY;
    @NotNull
    private float[] pointsBuffer;
    private int points;
    @NotNull
    private final Mesh quadMesh;
    @NotNull
    private final Shader quadShader;
    private int quads;
    @NotNull
    private float[] quadsInstanceBuffer;
    @NotNull
    private final Shader gridShader;
    public static final int $stable = 8;
    @NotNull
    private static final Float4 BLACK_FLOAT4 = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
    public static final int POINT_SIZE_FLOATS = 7;
    public static final int QUAD_INSTANCE_SIZE_FLOATS = 8;
    @NotNull
    public static final String ATTR_POS_A_X = "pos_a_x";
    @NotNull
    public static final String ATTR_POS_A_Y = "pos_a_y";
    @NotNull
    public static final String ATTR_POS_B_X = "pos_b_x";
    @NotNull
    public static final String ATTR_POS_B_Y = "pos_b_y";
    @NotNull
    public static final String U_RESOLUTION = "u_resolution";
    @NotNull
    public static final String U_WIDTH = "u_width";
    @NotNull
    public static final String U_COLOR_MIN = "u_color_min";
    @NotNull
    public static final String U_VALUE_MIN = "u_value_min";
    @NotNull
    public static final String U_COLOR_MAX = "u_color_max";
    @NotNull
    public static final String U_VALUE_MAX = "u_value_max";
    @NotNull
    public static final String U_FLIPPED_Y = "u_flipped_y";
    @NotNull
    public static final String U_GRID_DIV = "grid_div";
    @NotNull
    public static final String U_GRID_THICKNESS = "grid_thickness";
    @NotNull
    public static final String U_GRID_OFFSET_Y = "grid_offset_y";
    @NotNull
    public static final String U_GRID_SIZE = "grid_size";
    @NotNull
    public static final String U_GRID_POS = "grid_pos";
    @NotNull
    public static final String U_GRID_DIV_COLOR = "grid_div_color";
    @NotNull
    public static final String U_GRID_MAJOR_COLOR = "grid_major_color";
    @NotNull
    public static final String U_CAMERA_POS = "camera_pos";

    public Renderer() {
        Object[] objectArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::pointsMesh$lambda$1))};
        this.pointsMesh = new Mesh.Builder().primitive(0).layout((VertexBufferLayout[])objectArray).build();
        this.instancedLineShader = ShaderKt.shaderFromResource$default("/inst_line_shader.vert", "/simple_shader.frag", null, 4, null);
        Pair<float[], short[]> pair = this.generateVertexData();
        Renderer renderer = this;
        boolean bl = false;
        float[] v = (float[])pair.component1();
        short[] i = (short[])pair.component2();
        VertexBufferLayout[] vertexBufferLayoutArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::lineMesh$lambda$6$lambda$3)), VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::lineMesh$lambda$6$lambda$4)), VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::lineMesh$lambda$6$lambda$5))};
        renderer.lineMesh = Mesh.indexData$default(Mesh.bufferData$default(new Mesh.Builder().layout(vertexBufferLayoutArray).primitive(4).withIndices().build(), 0, v, 0, 0, 35044, 12, null), i, 0, 0, 0, 14, null);
        this.filledLineShader = ShaderKt.shaderFromResource$default("/gradient_shader.vert", "/simple_shader.frag", null, 4, null);
        objectArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::filledLineMesh$lambda$7))};
        this.filledLineMesh = new Mesh.Builder().layout((VertexBufferLayout[])objectArray).primitive(5).build();
        this.mode = Mode.LINE;
        this.lineColorMin = new Float4(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.lineColorMax = new Float4(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.lineValueMax = 1.0f;
        this.lineThickness = 1.0f;
        this.lineDataX = new float[1024];
        this.lineDataY = new float[1024];
        this.pointsBuffer = new float[10000];
        objectArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::quadMesh$lambda$8)), VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)Renderer::quadMesh$lambda$9))};
        Mesh mesh = new Mesh.Builder().primitive(4).withIndices().layout((VertexBufferLayout[])objectArray).build();
        objectArray = new float[8];
        objectArray[0] = (VertexBufferLayout)0.0f;
        objectArray[1] = (VertexBufferLayout)0.0f;
        objectArray[2] = (VertexBufferLayout)0.0f;
        objectArray[3] = (VertexBufferLayout)1.0f;
        objectArray[4] = (VertexBufferLayout)1.0f;
        objectArray[5] = (VertexBufferLayout)1.0f;
        objectArray[6] = (VertexBufferLayout)1.0f;
        objectArray[7] = (VertexBufferLayout)0.0f;
        Mesh mesh2 = Mesh.bufferData$default(mesh, 0, (float[])objectArray, 0, 0, 0, 28, null);
        objectArray = new short[6];
        objectArray[0] = (VertexBufferLayout)true;
        objectArray[1] = (VertexBufferLayout)false;
        objectArray[2] = (VertexBufferLayout)3;
        objectArray[3] = (VertexBufferLayout)2;
        objectArray[4] = (VertexBufferLayout)true;
        objectArray[5] = (VertexBufferLayout)3;
        this.quadMesh = Mesh.indexData$default(mesh2, (short[])objectArray, 0, 0, 0, 14, null);
        this.quadShader = ShaderKt.shaderFromResource$default("/inst_quad_shader.vert", "/simple_shader.frag", null, 4, null);
        this.quadsInstanceBuffer = new float[0x100000];
        this.gridShader = ShaderKt.shaderFromResource$default("/inst_quad_shader.vert", "/grid_shader.frag", null, 4, null);
    }

    private final float[] resizeIfNeeded(float[] $this$resizeIfNeeded, int current, int toAdd) {
        if (current + toAdd < $this$resizeIfNeeded.length) {
            return $this$resizeIfNeeded;
        }
        float[] ret = $this$resizeIfNeeded;
        int newSize = Math.max($this$resizeIfNeeded.length * 2, current + toAdd);
        if (!(newSize < 2000000)) {
            boolean bl = false;
            String string2 = "requested size too big: " + newSize;
            throw new IllegalArgumentException(string2.toString());
        }
        try {
            if (current + toAdd > $this$resizeIfNeeded.length) {
                float[] fArray = Arrays.copyOf($this$resizeIfNeeded, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
                ret = fArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("currentSize=" + $this$resizeIfNeeded.length + ". newSize=" + newSize, e);
        }
        return ret;
    }

    @NotNull
    public final Shader getPointsShader() {
        return this.pointsShader;
    }

    @NotNull
    public final Mesh getPointsMesh() {
        return this.pointsMesh;
    }

    @NotNull
    public final Shader getInstancedLineShader() {
        return this.instancedLineShader;
    }

    @NotNull
    public final short[] generateIndexData(int resolution, int centerIndex, int topIndex, int bottomIndex, boolean reverseOrder) {
        short[] sArray;
        short[] topTrig;
        int numTriangles = resolution - 2;
        short[] indices = new short[numTriangles * 3];
        for (int i = 0; i < numTriangles; ++i) {
            int index = i * 3;
            indices[index + 0] = (short)centerIndex;
            if (!reverseOrder) {
                indices[index + 1] = (short)(centerIndex + i + 1);
                indices[index + 2] = (short)(centerIndex + i + 2);
                continue;
            }
            indices[index + 1] = (short)(centerIndex + i + 2);
            indices[index + 2] = (short)(centerIndex + i + 1);
        }
        if (!reverseOrder) {
            index = new short[]{(short)centerIndex, (short)topIndex, (short)(centerIndex + 1)};
            v0 = index;
        } else {
            index = new short[]{(short)centerIndex, (short)(centerIndex + 1), (short)topIndex};
            v0 = topTrig = index;
        }
        if (!reverseOrder) {
            var10_12 = new short[]{(short)centerIndex, (short)(centerIndex + resolution - 1), (short)bottomIndex};
            sArray = var10_12;
        } else {
            var10_12 = new short[]{(short)centerIndex, (short)bottomIndex, (short)(centerIndex + resolution - 1)};
            sArray = var10_12;
        }
        short[] bottomTrig = sArray;
        return ArraysKt.plus((short[])ArraysKt.plus((short[])topTrig, (short[])indices), (short[])bottomTrig);
    }

    @NotNull
    public final Pair<float[], short[]> generateVertexData() {
        float[] yLeft2;
        int resolution = 5;
        int arraySize = (resolution - 1) * 3;
        float[] vertexLeft = new float[arraySize];
        float[] vertexRight = new float[arraySize];
        float step = (float)Math.PI / (float)resolution;
        float startingAngle = 1.5707964f;
        for (int i = 1; i < resolution; ++i) {
            float xLeft = (float)Math.cos(startingAngle + step * (float)i) * 0.5f;
            float yLeft2 = (float)Math.sin(startingAngle + step * (float)i) * 0.5f;
            float xRight = -((float)Math.cos(startingAngle + step * (float)i)) * 0.5f;
            float yRight = (float)Math.sin(startingAngle + step * (float)i) * 0.5f;
            int index = (i - 1) * 3;
            vertexLeft[index + 0] = xLeft;
            vertexLeft[index + 1] = yLeft2;
            vertexLeft[index + 2] = 0.0f;
            vertexRight[index + 0] = xRight;
            vertexRight[index + 1] = yRight;
            vertexRight[index + 2] = 1.0f;
        }
        float[] centerLeft = new float[3];
        float[] $this$generateVertexData_u24lambda_u242 = yLeft2 = new float[3];
        boolean bl = false;
        $this$generateVertexData_u24lambda_u242[2] = 1.0f;
        float[] centerRight = yLeft2;
        $this$generateVertexData_u24lambda_u242 = new float[]{0.0f, -0.5f, 0.0f, 0.0f, -0.5f, 1.0f, 0.0f, 0.5f, 1.0f, 0.0f, 0.5f, 0.0f};
        float[] quadData = $this$generateVertexData_u24lambda_u242;
        float[] vertexData = ArraysKt.plus((float[])ArraysKt.plus((float[])ArraysKt.plus((float[])ArraysKt.plus((float[])quadData, (float[])centerLeft), (float[])vertexLeft), (float[])centerRight), (float[])vertexRight);
        short[] index = new short[]{0, 1, 2, 0, 2, 3};
        short[] quadIndices = index;
        short[] leftIndices = this.generateIndexData(resolution, 4, 3, 0, false);
        int rightOffsetInVert = (quadData.length + centerLeft.length + vertexLeft.length) / 3;
        short[] rightIndices = this.generateIndexData(resolution, rightOffsetInVert, 2, 1, true);
        short[] indexData = ArraysKt.plus((short[])ArraysKt.plus((short[])quadIndices, (short[])leftIndices), (short[])rightIndices);
        return TuplesKt.to((Object)vertexData, (Object)indexData);
    }

    @NotNull
    public final Mesh getLineMesh() {
        return this.lineMesh;
    }

    @NotNull
    public final Shader getFilledLineShader() {
        return this.filledLineShader;
    }

    @NotNull
    public final Mesh getFilledLineMesh() {
        return this.filledLineMesh;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public final boolean getFlippedY() {
        return this.flippedY;
    }

    public final void setFlippedY(boolean bl) {
        this.flippedY = bl;
    }

    @NotNull
    public final Float4 getLineColorMin() {
        return this.lineColorMin;
    }

    public final void setLineColorMin(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColorMin = float4;
    }

    public final float getLineValueMin() {
        return this.lineValueMin;
    }

    public final void setLineValueMin(float f) {
        this.lineValueMin = f;
    }

    @NotNull
    public final Float4 getLineColorMax() {
        return this.lineColorMax;
    }

    public final void setLineColorMax(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColorMax = float4;
    }

    public final float getLineValueMax() {
        return this.lineValueMax;
    }

    public final void setLineValueMax(float f) {
        this.lineValueMax = f;
    }

    public final float getLineThickness() {
        return this.lineThickness;
    }

    public final void setLineThickness(float f) {
        this.lineThickness = f;
    }

    public final boolean getLineStrip() {
        return this.lineStrip;
    }

    public final void setLineStrip(boolean bl) {
        this.lineStrip = bl;
    }

    public final boolean getLineCap() {
        return this.lineCap;
    }

    public final void setLineCap(boolean bl) {
        this.lineCap = bl;
    }

    @NotNull
    public final float[] getLineDataX() {
        return this.lineDataX;
    }

    public final void setLineDataX(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.lineDataX = fArray;
    }

    @NotNull
    public final float[] getLineDataY() {
        return this.lineDataY;
    }

    public final void setLineDataY(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.lineDataY = fArray;
    }

    @NotNull
    public final Mesh getQuadMesh() {
        return this.quadMesh;
    }

    @NotNull
    public final Shader getQuadShader() {
        return this.quadShader;
    }

    public final int getQuads() {
        return this.quads;
    }

    public final void setQuads(int n) {
        this.quads = n;
    }

    @NotNull
    public final float[] getQuadsInstanceBuffer() {
        return this.quadsInstanceBuffer;
    }

    public final void setQuadsInstanceBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.quadsInstanceBuffer = fArray;
    }

    public final void addQuad(float x, float y, float sizeX, float sizeY, @NotNull Float4 color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int i = this.quads;
        this.quadsInstanceBuffer = this.resizeIfNeeded(this.quadsInstanceBuffer, i, 8);
        Float4 this_$iv = color;
        boolean $i$f$getR = false;
        this.quadsInstanceBuffer[i + 0] = this_$iv.getX();
        this_$iv = color;
        boolean $i$f$getG = false;
        this.quadsInstanceBuffer[i + 1] = this_$iv.getY();
        this_$iv = color;
        boolean $i$f$getB = false;
        this.quadsInstanceBuffer[i + 2] = this_$iv.getZ();
        this_$iv = color;
        boolean $i$f$getA = false;
        this.quadsInstanceBuffer[i + 3] = this_$iv.getW();
        this.quadsInstanceBuffer[i + 4] = x;
        this.quadsInstanceBuffer[i + 5] = y;
        this.quadsInstanceBuffer[i + 6] = sizeX;
        this.quadsInstanceBuffer[i + 7] = sizeY;
        this.quads += 8;
    }

    public static /* synthetic */ void addQuad$default(Renderer renderer, float f, float f2, float f3, float f4, Float4 float4, int n, Object object) {
        if ((n & 0x10) != 0) {
            float4 = BLACK_FLOAT4;
        }
        renderer.addQuad(f, f2, f3, f4, float4);
    }

    public final void addPoint(float x, float y, @NotNull Float4 color, float thickness) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.pointAddPoint(x, y, color, thickness);
                break;
            }
            case 2: {
                this.lineAddPoint(x, y);
                break;
            }
            case 3: {
                this.filledAddPoint(x, y);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void addPoint$default(Renderer renderer, float f, float f2, Float4 float4, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            float4 = BLACK_FLOAT4;
        }
        if ((n & 8) != 0) {
            f3 = 1.0f;
        }
        renderer.addPoint(f, f2, float4, f3);
    }

    public final void addPoints(@NotNull float[] xs, @NotNull float[] ys, int offset, int length, @NotNull Float4 color, float thickness) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 2: {
                this.lineDataX = this.resizeIfNeeded(this.lineDataX, this.points, length);
                this.lineDataY = this.resizeIfNeeded(this.lineDataY, this.points, length);
                ArraysKt.copyInto((float[])xs, (float[])this.lineDataX, (int)this.points, (int)offset, (int)(offset + length));
                ArraysKt.copyInto((float[])ys, (float[])this.lineDataY, (int)this.points, (int)offset, (int)(offset + length));
                break;
            }
            case 1: {
                for (int i = 0; i < length; ++i) {
                    this.pointAddPoint(xs[offset + i], ys[offset + i], color, thickness);
                }
                break;
            }
            case 3: {
                this.filledAddPoints(xs, ys, offset, length);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.points += length;
    }

    public static /* synthetic */ void addPoints$default(Renderer renderer, float[] fArray, float[] fArray2, int n, int n2, Float4 float4, float f, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            float4 = BLACK_FLOAT4;
        }
        if ((n3 & 0x20) != 0) {
            f = 1.0f;
        }
        renderer.addPoints(fArray, fArray2, n, n2, float4, f);
    }

    public final void addPointsIndexed(int firstIndex, @NotNull float[] p, int offset, int length, @NotNull Float4 color, float thickness) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                for (int i = 0; i < length; ++i) {
                    this.pointAddPoint(firstIndex + i, p[i + offset], color, thickness);
                }
                break;
            }
            case 2: {
                this.lineDataX = this.resizeIfNeeded(this.lineDataX, this.points, length);
                this.lineDataY = this.resizeIfNeeded(this.lineDataY, this.points, length);
                for (int i = 0; i < length; ++i) {
                    this.lineDataX[this.points + i] = firstIndex + i;
                }
                ArraysKt.copyInto((float[])p, (float[])this.lineDataY, (int)this.points, (int)offset, (int)(offset + length));
                break;
            }
            case 3: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.points += length;
    }

    public static /* synthetic */ void addPointsIndexed$default(Renderer renderer, int n, float[] fArray, int n2, int n3, Float4 float4, float f, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            float4 = BLACK_FLOAT4;
        }
        if ((n4 & 0x20) != 0) {
            f = 1.0f;
        }
        renderer.addPointsIndexed(n, fArray, n2, n3, float4, f);
    }

    private final void lineAddPoint(float x, float y) {
        this.lineDataX = this.resizeIfNeeded(this.lineDataX, this.points, 1);
        this.lineDataY = this.resizeIfNeeded(this.lineDataY, this.points, 1);
        this.lineDataX[this.points] = x;
        this.lineDataY[this.points] = y;
        ++this.points;
    }

    private final void pointAddPoint(float x, float y, Float4 color, float thickness) {
        int i = this.points * 7;
        this.pointsBuffer = this.resizeIfNeeded(this.pointsBuffer, i, 7);
        this.pointsBuffer[i + 0] = x;
        this.pointsBuffer[i + 1] = y;
        this.pointsBuffer[i + 2] = color.getX();
        this.pointsBuffer[i + 3] = color.getY();
        this.pointsBuffer[i + 4] = color.getZ();
        this.pointsBuffer[i + 5] = color.getW();
        this.pointsBuffer[i + 6] = thickness;
        ++this.points;
    }

    static /* synthetic */ void pointAddPoint$default(Renderer renderer, float f, float f2, Float4 float4, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            float4 = BLACK_FLOAT4;
        }
        if ((n & 8) != 0) {
            f3 = 1.0f;
        }
        renderer.pointAddPoint(f, f2, float4, f3);
    }

    private final void filledAddPoint(float x, float y) {
        this.pointsBuffer = this.resizeIfNeeded(this.pointsBuffer, this.points, 6);
        this.pointsBuffer[this.points + 0] = x;
        this.pointsBuffer[this.points + 1] = 0.0f;
        this.pointsBuffer[this.points + 2] = 0.0f;
        this.pointsBuffer[this.points + 3] = x;
        this.pointsBuffer[this.points + 4] = y;
        this.pointsBuffer[this.points + 5] = 0.0f;
        this.points += 6;
    }

    private final void filledAddPoints(float[] xs, float[] ys, int offset, int length) {
        int toAdd = length * 6;
        this.pointsBuffer = this.resizeIfNeeded(this.pointsBuffer, this.points, toAdd);
        for (int i = 0; i < length; ++i) {
            float x = xs[offset + i];
            float y = ys[offset + i];
            this.pointsBuffer[this.points + 0] = x;
            this.pointsBuffer[this.points + 1] = 0.0f;
            this.pointsBuffer[this.points + 2] = 0.0f;
            this.pointsBuffer[this.points + 3] = x;
            this.pointsBuffer[this.points + 4] = y;
            this.pointsBuffer[this.points + 5] = 0.0f;
        }
        this.points += toAdd;
    }

    public final void reset() {
        this.points = 0;
        this.quads = 0;
    }

    public final void render(@NotNull Camera camera, @NotNull Mat4 model) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.renderPoints(camera, model);
                break;
            }
            case 2: {
                this.renderLines(camera, model);
                break;
            }
            case 3: {
                this.renderLinesFilled(camera, model);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void release() {
        this.pointsShader.release();
        this.pointsMesh.release();
        this.instancedLineShader.release();
        this.lineMesh.release();
        this.quadMesh.release();
        this.quadShader.release();
        this.gridShader.release();
    }

    private final void renderPoints(Camera camera, Mat4 model) {
        Mesh.bufferSubData$default(this.pointsMesh, 0, this.pointsBuffer, 0, this.points * 7, 0, 16, null);
        this.pointsShader.bind();
        this.pointsMesh.bind(this.pointsShader);
        this.pointsShader.setMvpMatrix-hHmvo7A(M4.times-AMxtLaU(M4Kt.toM4(camera.getVp()), M4Kt.toM4(model)));
        Mesh.render$default(this.pointsMesh, 0, this.points, 1, null);
        if (this.debug) {
            this.pointsMesh.unbind();
            this.pointsShader.unbind();
        }
    }

    @NotNull
    public final Shader getGridShader() {
        return this.gridShader;
    }

    public final void renderGrid(@NotNull Camera camera, float x, float y, float sizeX, float sizeY, float div, float offsetY, float thickness, @NotNull Float4 minorColor, @NotNull Float4 majorColor) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)minorColor, (String)"minorColor");
        Intrinsics.checkNotNullParameter((Object)majorColor, (String)"majorColor");
        this.quads = 0;
        Renderer.addQuad$default(this, x, y, sizeX, sizeY, null, 16, null);
        this.quadMesh.bufferSubData(1, this.quadsInstanceBuffer, 0, this.quads, 0);
        this.gridShader.bind();
        this.quadMesh.bind(this.gridShader);
        this.quadMesh.bindBuffer(1);
        Integer translationHandle = this.quadShader.getAttributes().get((Object)Usage.TRANSLATION_2D);
        Integer scaleHandle = this.quadShader.getAttributes().get((Object)Usage.SCALE_2D);
        Integer colorHandle = this.quadShader.getAttributes().get((Object)Usage.COLOR);
        if (colorHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(colorHandle, 1);
        }
        if (translationHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(translationHandle, 1);
        }
        if (scaleHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(scaleHandle, 1);
        }
        this.gridShader.setMvpMatrix(camera.getVp());
        Integer gridSizeHandle = this.gridShader.getAllUniforms().get(U_GRID_SIZE);
        Integer gridPosHandle = this.gridShader.getAllUniforms().get(U_GRID_POS);
        Integer gridOffsetYHandle = this.gridShader.getAllUniforms().get(U_GRID_OFFSET_Y);
        Integer n = this.gridShader.getAllUniforms().get(U_GRID_DIV);
        Intrinsics.checkNotNull((Object)n);
        int gridDivHandle = ((Number)n).intValue();
        Integer n2 = this.gridShader.getAllUniforms().get(U_GRID_THICKNESS);
        Intrinsics.checkNotNull((Object)n2);
        int gridThicknessHandle = ((Number)n2).intValue();
        Integer n3 = this.gridShader.getAllUniforms().get(U_GRID_DIV_COLOR);
        Intrinsics.checkNotNull((Object)n3);
        int gridDivColorHandle = ((Number)n3).intValue();
        Integer n4 = this.gridShader.getAllUniforms().get(U_GRID_MAJOR_COLOR);
        Intrinsics.checkNotNull((Object)n4);
        int gridMajorColorHandle = ((Number)n4).intValue();
        Integer resolutionHandle = this.gridShader.getAllUniforms().get(U_RESOLUTION);
        Integer flippedYHandle = this.gridShader.getAllUniforms().get(U_FLIPPED_Y);
        Integer cameraPosHandle = this.gridShader.getAllUniforms().get(U_CAMERA_POS);
        this.gridShader.setUniformFloat2(gridSizeHandle, new Float2(sizeX, sizeY));
        this.gridShader.setUniformFloat2(gridPosHandle, new Float2(x, y));
        this.gridShader.setUniformFloat(gridDivHandle, div);
        this.gridShader.setUniformFloat(gridOffsetYHandle, offsetY);
        this.gridShader.setUniformFloat(gridThicknessHandle, thickness);
        this.gridShader.setUniformFloat4(gridDivColorHandle, minorColor);
        this.gridShader.setUniformFloat4(gridMajorColorHandle, majorColor);
        this.gridShader.setUniformFloat2(resolutionHandle, new Float2(camera.getWidth(), camera.getHeight()));
        this.gridShader.setUniform1i(flippedYHandle, this.flippedY ? 1 : 0);
        float f = camera.getEye().getX();
        float f2 = div * 5.0f;
        float f3 = f % f2;
        float cameraModX = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
        f2 = camera.getEye().getY();
        f3 = div * 5.0f;
        float f4 = f2 % f3;
        float cameraModY = !(f4 == 0.0f) && !(Math.signum(f4) == Math.signum(f3)) ? f4 + f3 : f4;
        this.gridShader.setUniformFloat2(cameraPosHandle, new Float2(cameraModX, cameraModY));
        Mesh.renderInstanced$default(this.quadMesh, 0, 0, this.quads / 8, 3, null);
        if (colorHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(colorHandle, 0);
        }
        if (translationHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(translationHandle, 0);
        }
        if (scaleHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(scaleHandle, 0);
        }
        if (this.debug) {
            this.quadMesh.unbind();
            this.gridShader.unbind();
        }
        this.quads = 0;
    }

    public final void renderQuads(@NotNull Camera camera, @NotNull Mat4 model) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (this.quads < 1) {
            return;
        }
        this.quadMesh.bufferSubData(1, this.quadsInstanceBuffer, 0, this.quads, 0);
        this.quadShader.bind();
        this.quadMesh.bind(this.quadShader);
        this.quadMesh.bindBuffer(1);
        Integer translationHandle = this.quadShader.getAttributes().get((Object)Usage.TRANSLATION_2D);
        Integer scaleHandle = this.quadShader.getAttributes().get((Object)Usage.SCALE_2D);
        Integer colorHandle = this.quadShader.getAttributes().get((Object)Usage.COLOR);
        if (colorHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(colorHandle, 1);
        }
        if (translationHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(translationHandle, 1);
        }
        if (scaleHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(scaleHandle, 1);
        }
        this.quadShader.setMvpMatrix-hHmvo7A(M4.times-AMxtLaU(M4Kt.toM4(camera.getVp()), M4Kt.toM4(model)));
        Mesh.renderInstanced$default(this.quadMesh, 0, 0, this.quads / 8, 3, null);
        if (colorHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(colorHandle, 0);
        }
        if (translationHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(translationHandle, 0);
        }
        if (scaleHandle != null) {
            GLES_jvmKt.glVertexAttribDivisor(scaleHandle, 0);
        }
        if (this.debug) {
            this.quadMesh.unbind();
            this.quadShader.unbind();
        }
    }

    private final void renderLines(Camera camera, Mat4 model) {
        if (this.points < 2) {
            return;
        }
        this.lineMesh.bufferSubData(1, this.lineDataX, 0, this.points, 0);
        this.lineMesh.bufferSubData(2, this.lineDataY, 0, this.points, 0);
        this.instancedLineShader.bind();
        this.lineMesh.bind(this.instancedLineShader);
        int stride = this.lineStrip ? 0 : 8;
        this.lineMesh.bindBuffer(1);
        Integer n = this.instancedLineShader.getAllAttributes().get(ATTR_POS_A_X);
        Intrinsics.checkNotNull((Object)n);
        int posAXHandle = ((Number)n).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posAXHandle);
        GLES_jvmKt.glVertexAttribPointer(posAXHandle, 1, 5126, false, stride, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAXHandle, 1);
        Integer n2 = this.instancedLineShader.getAllAttributes().get(ATTR_POS_B_X);
        Intrinsics.checkNotNull((Object)n2);
        int posBXHandle = ((Number)n2).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posBXHandle);
        GLES_jvmKt.glVertexAttribPointer(posBXHandle, 1, 5126, false, stride, 4);
        GLES_jvmKt.glVertexAttribDivisor(posBXHandle, 1);
        this.lineMesh.bindBuffer(2);
        Integer n3 = this.instancedLineShader.getAllAttributes().get(ATTR_POS_A_Y);
        Intrinsics.checkNotNull((Object)n3);
        int posAYHandle = ((Number)n3).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posAYHandle);
        GLES_jvmKt.glVertexAttribPointer(posAYHandle, 1, 5126, false, stride, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAYHandle, 1);
        Integer n4 = this.instancedLineShader.getAllAttributes().get(ATTR_POS_B_Y);
        Intrinsics.checkNotNull((Object)n4);
        int posBYHandle = ((Number)n4).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posBYHandle);
        GLES_jvmKt.glVertexAttribPointer(posBYHandle, 1, 5126, false, stride, 4);
        GLES_jvmKt.glVertexAttribDivisor(posBYHandle, 1);
        this.instancedLineShader.setMvpMatrix-hHmvo7A(M4.times-AMxtLaU(M4Kt.toM4(camera.getVp()), M4Kt.toM4(model)));
        this.instancedLineShader.setUniformFloat(this.instancedLineShader.getAllUniforms().get(U_WIDTH), this.lineThickness);
        this.instancedLineShader.setUniformFloat2(this.instancedLineShader.getAllUniforms().get(U_RESOLUTION), new Float2(camera.getWidth(), camera.getHeight()));
        this.instancedLineShader.setUniformFloat4(this.instancedLineShader.getAllUniforms().get(U_COLOR_MIN), this.lineColorMin);
        this.instancedLineShader.setUniformFloat(this.instancedLineShader.getAllUniforms().get(U_VALUE_MIN), this.lineValueMin);
        this.instancedLineShader.setUniformFloat4(this.instancedLineShader.getAllUniforms().get(U_COLOR_MAX), this.lineColorMax);
        this.instancedLineShader.setUniformFloat(this.instancedLineShader.getAllUniforms().get(U_VALUE_MAX), this.lineValueMax);
        int instances = this.lineStrip ? this.points - 1 : this.points / 2;
        int count = this.lineCap ? this.lineMesh.numVertices() : 6;
        Mesh.renderInstanced$default(this.lineMesh, 0, count, instances, 1, null);
        GLES_jvmKt.glVertexAttribDivisor(posAXHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posBXHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAYHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posBYHandle, 0);
        if (this.debug) {
            this.lineMesh.unbind();
            this.instancedLineShader.unbind();
        }
    }

    public final void renderWaveform(@NotNull Camera camera, @NotNull Mat4 model, @NotNull Mesh waveformData, int offset, int wavePoints) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)waveformData, (String)"waveformData");
        this.instancedLineShader.bind();
        this.lineMesh.bind(this.instancedLineShader);
        int stride = 0;
        waveformData.bindBuffer(0);
        Integer n = this.instancedLineShader.getAllAttributes().get(ATTR_POS_A_X);
        Intrinsics.checkNotNull((Object)n);
        int posAXHandle = ((Number)n).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posAXHandle);
        GLES_jvmKt.glVertexAttribPointer(posAXHandle, 1, 5126, false, stride, offset * 4);
        GLES_jvmKt.glVertexAttribDivisor(posAXHandle, 1);
        Integer n2 = this.instancedLineShader.getAllAttributes().get(ATTR_POS_B_X);
        Intrinsics.checkNotNull((Object)n2);
        int posBXHandle = ((Number)n2).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posBXHandle);
        GLES_jvmKt.glVertexAttribPointer(posBXHandle, 1, 5126, false, stride, (offset + 1) * 4);
        GLES_jvmKt.glVertexAttribDivisor(posBXHandle, 1);
        waveformData.bindBuffer(1);
        Integer n3 = this.instancedLineShader.getAllAttributes().get(ATTR_POS_A_Y);
        Intrinsics.checkNotNull((Object)n3);
        int posAYHandle = ((Number)n3).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posAYHandle);
        GLES_jvmKt.glVertexAttribPointer(posAYHandle, 1, 5126, false, stride, offset * 4);
        GLES_jvmKt.glVertexAttribDivisor(posAYHandle, 1);
        Integer n4 = this.instancedLineShader.getAllAttributes().get(ATTR_POS_B_Y);
        Intrinsics.checkNotNull((Object)n4);
        int posBYHandle = ((Number)n4).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posBYHandle);
        GLES_jvmKt.glVertexAttribPointer(posBYHandle, 1, 5126, false, stride, (offset + 1) * 4);
        GLES_jvmKt.glVertexAttribDivisor(posBYHandle, 1);
        this.instancedLineShader.setMvpMatrix-hHmvo7A(M4.times-AMxtLaU(M4Kt.toM4(camera.getVp()), M4Kt.toM4(model)));
        this.instancedLineShader.setUniformFloat(this.instancedLineShader.getAllUniforms().get(U_WIDTH), this.lineThickness);
        this.instancedLineShader.setUniformFloat2(this.instancedLineShader.getAllUniforms().get(U_RESOLUTION), new Float2(camera.getWidth(), camera.getHeight()));
        this.instancedLineShader.setUniformFloat4(this.instancedLineShader.getAllUniforms().get(U_COLOR_MIN), this.lineColorMin);
        this.instancedLineShader.setUniformFloat(this.instancedLineShader.getAllUniforms().get(U_VALUE_MIN), this.lineValueMin);
        this.instancedLineShader.setUniformFloat4(this.instancedLineShader.getAllUniforms().get(U_COLOR_MAX), this.lineColorMax);
        this.instancedLineShader.setUniformFloat(this.instancedLineShader.getAllUniforms().get(U_VALUE_MAX), this.lineValueMax);
        int instances = wavePoints - 1;
        int count = 6;
        Mesh.renderInstanced$default(this.lineMesh, 0, count, instances, 1, null);
        GLES_jvmKt.glVertexAttribDivisor(posAXHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posBXHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAYHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posBYHandle, 0);
        if (this.debug) {
            this.lineMesh.unbind();
            this.instancedLineShader.unbind();
        }
    }

    private final void renderLinesFilled(Camera camera, Mat4 model) {
        if (this.points < 9) {
            return;
        }
        this.filledLineMesh.bufferSubData(0, this.pointsBuffer, 0, this.points, 0);
        this.filledLineShader.bind();
        this.filledLineMesh.bind(this.filledLineShader);
        this.filledLineShader.setMvpMatrix-hHmvo7A(M4.times-AMxtLaU(M4Kt.toM4(camera.getVp()), M4Kt.toM4(model)));
        this.filledLineShader.setUniformFloat4(this.filledLineShader.getAllUniforms().get(U_COLOR_MIN), this.lineColorMin);
        this.filledLineShader.setUniformFloat(this.filledLineShader.getAllUniforms().get(U_VALUE_MIN), this.lineValueMin);
        this.filledLineShader.setUniformFloat4(this.filledLineShader.getAllUniforms().get(U_COLOR_MAX), this.lineColorMax);
        this.filledLineShader.setUniformFloat(this.filledLineShader.getAllUniforms().get(U_VALUE_MAX), this.lineValueMax);
        Mesh.render$default(this.filledLineMesh, 0, this.points / 3, 1, null);
        if (this.debug) {
            this.filledLineMesh.unbind();
            this.filledLineShader.unbind();
        }
    }

    private static final Unit pointsMesh$lambda$1(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionX();
        $this$bufferLayout.positionY();
        $this$bufferLayout.color();
        $this$bufferLayout.width();
        return Unit.INSTANCE;
    }

    private static final Unit lineMesh$lambda$6$lambda$3(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.position();
        return Unit.INSTANCE;
    }

    private static final Unit lineMesh$lambda$6$lambda$4(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionX();
        return Unit.INSTANCE;
    }

    private static final Unit lineMesh$lambda$6$lambda$5(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionY();
        return Unit.INSTANCE;
    }

    private static final Unit filledLineMesh$lambda$7(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.position();
        return Unit.INSTANCE;
    }

    private static final Unit quadMesh$lambda$8(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.position2d();
        return Unit.INSTANCE;
    }

    private static final Unit quadMesh$lambda$9(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.color();
        $this$bufferLayout.translation2d();
        $this$bufferLayout.scale2d();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lvet/inpulse/krafiks/Renderer$Companion;", "", "<init>", "()V", "BLACK_FLOAT4", "Ldev/romainguy/kotlin/math/Float4;", "getBLACK_FLOAT4", "()Ldev/romainguy/kotlin/math/Float4;", "POINT_SIZE_FLOATS", "", "QUAD_INSTANCE_SIZE_FLOATS", "ATTR_POS_A_X", "", "ATTR_POS_A_Y", "ATTR_POS_B_X", "ATTR_POS_B_Y", "U_RESOLUTION", "U_WIDTH", "U_COLOR_MIN", "U_VALUE_MIN", "U_COLOR_MAX", "U_VALUE_MAX", "U_FLIPPED_Y", "U_GRID_DIV", "U_GRID_THICKNESS", "U_GRID_OFFSET_Y", "U_GRID_SIZE", "U_GRID_POS", "U_GRID_DIV_COLOR", "U_GRID_MAJOR_COLOR", "U_CAMERA_POS", "krafiks-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Float4 getBLACK_FLOAT4() {
            return BLACK_FLOAT4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lvet/inpulse/krafiks/Renderer$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "POINT", "LINE", "LINE_FILLED", "krafiks-core"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode POINT = new Mode();
        public static final /* enum */ Mode LINE = new Mode();
        public static final /* enum */ Mode LINE_FILLED = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.POINT, Mode.LINE, Mode.LINE_FILLED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.POINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.LINE_FILLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

