/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import dev.romainguy.kotlin.math.Float2;
import dev.romainguy.kotlin.math.Float4;
import dev.romainguy.kotlin.math.Mat4;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.krafiks.Camera;
import vet.inpulse.krafiks.GLES_jvmKt;
import vet.inpulse.krafiks.LayoutBuilder;
import vet.inpulse.krafiks.LineRenderer;
import vet.inpulse.krafiks.Mesh;
import vet.inpulse.krafiks.Shader;
import vet.inpulse.krafiks.ShaderKt;
import vet.inpulse.krafiks.VertexBufferLayout;
import vet.inpulse.krafiks.VertexBufferLayoutKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 O2\u00020\u0001:\u0001OB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t0\u0012J(\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0010H\u0016J\u0010\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020\u000bH\u0002J\u0018\u0010D\u001a\u00020;2\u0006\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020,H\u0016J.\u0010G\u001a\u00020;2\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000bJ\b\u0010M\u001a\u00020;H\u0016J\b\u0010N\u001a\u00020;H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010(\"\u0004\b3\u0010*R\u001a\u00104\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010.\"\u0004\b6\u00100R\u001a\u00107\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010.\"\u0004\b9\u00100\u00a8\u0006P"}, d2={"Lvet/inpulse/krafiks/InstancedLineRenderer;", "Lvet/inpulse/krafiks/LineRenderer;", "<init>", "()V", "shader", "Lvet/inpulse/krafiks/Shader;", "getShader", "()Lvet/inpulse/krafiks/Shader;", "generateIndexData", "", "resolution", "", "centerIndex", "topIndex", "bottomIndex", "reverseOrder", "", "generateVertexData", "Lkotlin/Pair;", "", "mesh", "Lvet/inpulse/krafiks/Mesh;", "getMesh", "()Lvet/inpulse/krafiks/Mesh;", "lineDataX", "getLineDataX", "()[F", "setLineDataX", "([F)V", "lineDataY", "getLineDataY", "setLineDataY", "points", "getPoints", "()I", "setPoints", "(I)V", "lineColorMin", "Ldev/romainguy/kotlin/math/Float4;", "getLineColorMin", "()Ldev/romainguy/kotlin/math/Float4;", "setLineColorMin", "(Ldev/romainguy/kotlin/math/Float4;)V", "lineValueMin", "", "getLineValueMin", "()F", "setLineValueMin", "(F)V", "lineColorMax", "getLineColorMax", "setLineColorMax", "lineValueMax", "getLineValueMax", "setLineValueMax", "lineThickness", "getLineThickness", "setLineThickness", "render", "", "camera", "Lvet/inpulse/krafiks/Camera;", "model", "Ldev/romainguy/kotlin/math/Mat4;", "strip", "cap", "resizeIfNeeded", "toAdd", "addPoint", "x", "y", "addPoints", "xs", "offsetX", "ys", "offsetY", "length", "reset", "release", "Companion", "krafiks-core"})
@StabilityInferred(parameters=0)
public final class InstancedLineRenderer
implements LineRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shader shader = ShaderKt.shaderFromResource$default("/inst_line_shader.vert", "/simple_shader.frag", null, 4, null);
    @NotNull
    private final Mesh mesh;
    @NotNull
    private float[] lineDataX;
    @NotNull
    private float[] lineDataY;
    private int points;
    @NotNull
    private Float4 lineColorMin;
    private float lineValueMin;
    @NotNull
    private Float4 lineColorMax;
    private float lineValueMax;
    private float lineThickness;
    public static final int $stable = 8;
    @NotNull
    public static final String ATTR_POS_A_X = "pos_a_x";
    @NotNull
    public static final String ATTR_POS_A_Y = "pos_a_y";
    @NotNull
    public static final String ATTR_POS_B_X = "pos_b_x";
    @NotNull
    public static final String ATTR_POS_B_Y = "pos_b_y";
    @NotNull
    public static final String U_RESOLUTION = "u_resolution";
    @NotNull
    public static final String U_WIDTH = "u_width";
    @NotNull
    public static final String U_COLOR_MIN = "u_color_min";
    @NotNull
    public static final String U_VALUE_MIN = "u_value_min";
    @NotNull
    public static final String U_COLOR_MAX = "u_color_max";
    @NotNull
    public static final String U_VALUE_MAX = "u_value_max";

    public InstancedLineRenderer() {
        Pair<float[], short[]> pair = this.generateVertexData();
        InstancedLineRenderer instancedLineRenderer = this;
        boolean bl = false;
        float[] v = (float[])pair.component1();
        short[] i = (short[])pair.component2();
        VertexBufferLayout[] vertexBufferLayoutArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)InstancedLineRenderer::mesh$lambda$4$lambda$1)), VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)InstancedLineRenderer::mesh$lambda$4$lambda$2)), VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)InstancedLineRenderer::mesh$lambda$4$lambda$3))};
        instancedLineRenderer.mesh = Mesh.indexData$default(Mesh.bufferData$default(new Mesh.Builder().layout(vertexBufferLayoutArray).primitive(4).withIndices().build(), 0, v, 0, 0, 35048, 12, null), i, 0, 0, 0, 14, null);
        this.lineDataX = new float[1024];
        this.lineDataY = new float[1024];
        this.lineColorMin = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
        this.lineColorMax = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
        this.lineValueMax = 1.0f;
        this.lineThickness = 2.0f;
    }

    @NotNull
    public final Shader getShader() {
        return this.shader;
    }

    @NotNull
    public final short[] generateIndexData(int resolution, int centerIndex, int topIndex, int bottomIndex, boolean reverseOrder) {
        short[] sArray;
        short[] topTrig;
        int numTriangles = resolution - 2;
        short[] indices = new short[numTriangles * 3];
        for (int i = 0; i < numTriangles; ++i) {
            int index = i * 3;
            indices[index + 0] = (short)centerIndex;
            if (!reverseOrder) {
                indices[index + 1] = (short)(centerIndex + i + 1);
                indices[index + 2] = (short)(centerIndex + i + 2);
                continue;
            }
            indices[index + 1] = (short)(centerIndex + i + 2);
            indices[index + 2] = (short)(centerIndex + i + 1);
        }
        if (!reverseOrder) {
            index = new short[]{(short)centerIndex, (short)topIndex, (short)(centerIndex + 1)};
            v0 = index;
        } else {
            index = new short[]{(short)centerIndex, (short)(centerIndex + 1), (short)topIndex};
            v0 = topTrig = index;
        }
        if (!reverseOrder) {
            var10_12 = new short[]{(short)centerIndex, (short)(centerIndex + resolution - 1), (short)bottomIndex};
            sArray = var10_12;
        } else {
            var10_12 = new short[]{(short)centerIndex, (short)bottomIndex, (short)(centerIndex + resolution - 1)};
            sArray = var10_12;
        }
        short[] bottomTrig = sArray;
        return ArraysKt.plus((short[])ArraysKt.plus((short[])topTrig, (short[])indices), (short[])bottomTrig);
    }

    @NotNull
    public final Pair<float[], short[]> generateVertexData() {
        float[] yLeft2;
        int resolution = 5;
        int arraySize = (resolution - 1) * 3;
        float[] vertexLeft = new float[arraySize];
        float[] vertexRight = new float[arraySize];
        float step = (float)Math.PI / (float)resolution;
        float startingAngle = 1.5707964f;
        for (int i = 1; i < resolution; ++i) {
            float xLeft = (float)Math.cos(startingAngle + step * (float)i) * 0.5f;
            float yLeft2 = (float)Math.sin(startingAngle + step * (float)i) * 0.5f;
            float xRight = -((float)Math.cos(startingAngle + step * (float)i)) * 0.5f;
            float yRight = (float)Math.sin(startingAngle + step * (float)i) * 0.5f;
            int index = (i - 1) * 3;
            vertexLeft[index + 0] = xLeft;
            vertexLeft[index + 1] = yLeft2;
            vertexLeft[index + 2] = 0.0f;
            vertexRight[index + 0] = xRight;
            vertexRight[index + 1] = yRight;
            vertexRight[index + 2] = 1.0f;
        }
        float[] centerLeft = new float[3];
        float[] $this$generateVertexData_u24lambda_u240 = yLeft2 = new float[3];
        boolean bl = false;
        $this$generateVertexData_u24lambda_u240[2] = 1.0f;
        float[] centerRight = yLeft2;
        $this$generateVertexData_u24lambda_u240 = new float[]{0.0f, -0.5f, 0.0f, 0.0f, -0.5f, 1.0f, 0.0f, 0.5f, 1.0f, 0.0f, 0.5f, 0.0f};
        float[] quadData = $this$generateVertexData_u24lambda_u240;
        float[] vertexData = ArraysKt.plus((float[])ArraysKt.plus((float[])ArraysKt.plus((float[])ArraysKt.plus((float[])quadData, (float[])centerLeft), (float[])vertexLeft), (float[])centerRight), (float[])vertexRight);
        short[] index = new short[]{0, 1, 2, 0, 2, 3};
        short[] quadIndices = index;
        short[] leftIndices = this.generateIndexData(resolution, 4, 3, 0, false);
        int rightOffsetInVert = (quadData.length + centerLeft.length + vertexLeft.length) / 3;
        short[] rightIndices = this.generateIndexData(resolution, rightOffsetInVert, 2, 1, true);
        short[] indexData = ArraysKt.plus((short[])ArraysKt.plus((short[])quadIndices, (short[])leftIndices), (short[])rightIndices);
        return TuplesKt.to((Object)vertexData, (Object)indexData);
    }

    @NotNull
    public final Mesh getMesh() {
        return this.mesh;
    }

    @NotNull
    public final float[] getLineDataX() {
        return this.lineDataX;
    }

    public final void setLineDataX(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.lineDataX = fArray;
    }

    @NotNull
    public final float[] getLineDataY() {
        return this.lineDataY;
    }

    public final void setLineDataY(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.lineDataY = fArray;
    }

    public final int getPoints() {
        return this.points;
    }

    public final void setPoints(int n) {
        this.points = n;
    }

    @Override
    @NotNull
    public Float4 getLineColorMin() {
        return this.lineColorMin;
    }

    @Override
    public void setLineColorMin(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColorMin = float4;
    }

    @Override
    public float getLineValueMin() {
        return this.lineValueMin;
    }

    @Override
    public void setLineValueMin(float f) {
        this.lineValueMin = f;
    }

    @Override
    @NotNull
    public Float4 getLineColorMax() {
        return this.lineColorMax;
    }

    @Override
    public void setLineColorMax(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColorMax = float4;
    }

    @Override
    public float getLineValueMax() {
        return this.lineValueMax;
    }

    @Override
    public void setLineValueMax(float f) {
        this.lineValueMax = f;
    }

    @Override
    public float getLineThickness() {
        return this.lineThickness;
    }

    @Override
    public void setLineThickness(float f) {
        this.lineThickness = f;
    }

    @Override
    public void render(@NotNull Camera camera, @NotNull Mat4 model, boolean strip, boolean cap) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (this.points < 2) {
            return;
        }
        this.mesh.bufferSubData(1, this.lineDataX, 0, this.points, 0);
        this.mesh.bufferSubData(2, this.lineDataY, 0, this.points, 0);
        this.shader.bind();
        this.mesh.bind(this.shader);
        int stride = strip ? 0 : 8;
        this.mesh.bindBuffer(1);
        Integer n = this.shader.getAllAttributes().get(ATTR_POS_A_X);
        Intrinsics.checkNotNull((Object)n);
        int posAXHandle = ((Number)n).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posAXHandle);
        GLES_jvmKt.glVertexAttribPointer(posAXHandle, 1, 5126, false, stride, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAXHandle, 1);
        Integer n2 = this.shader.getAllAttributes().get(ATTR_POS_B_X);
        Intrinsics.checkNotNull((Object)n2);
        int posBXHandle = ((Number)n2).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posBXHandle);
        GLES_jvmKt.glVertexAttribPointer(posBXHandle, 1, 5126, false, stride, 4);
        GLES_jvmKt.glVertexAttribDivisor(posBXHandle, 1);
        this.mesh.bindBuffer(2);
        Integer n3 = this.shader.getAllAttributes().get(ATTR_POS_A_Y);
        Intrinsics.checkNotNull((Object)n3);
        int posAYHandle = ((Number)n3).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posAYHandle);
        GLES_jvmKt.glVertexAttribPointer(posAYHandle, 1, 5126, false, stride, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAYHandle, 1);
        Integer n4 = this.shader.getAllAttributes().get(ATTR_POS_B_Y);
        Intrinsics.checkNotNull((Object)n4);
        int posBYHandle = ((Number)n4).intValue();
        GLES_jvmKt.glEnableVertexAttribArray(posBYHandle);
        GLES_jvmKt.glVertexAttribPointer(posBYHandle, 1, 5126, false, stride, 4);
        GLES_jvmKt.glVertexAttribDivisor(posBYHandle, 1);
        this.shader.setMvpMatrix(camera.getVp().times(model));
        this.shader.setUniformFloat(this.shader.getAllUniforms().get(U_WIDTH), this.getLineThickness());
        this.shader.setUniformFloat2(this.shader.getAllUniforms().get(U_RESOLUTION), new Float2(camera.getWidth(), camera.getHeight()));
        this.shader.setUniformFloat4(this.shader.getAllUniforms().get(U_COLOR_MIN), this.getLineColorMin());
        this.shader.setUniformFloat(this.shader.getAllUniforms().get(U_VALUE_MIN), this.getLineValueMin());
        this.shader.setUniformFloat4(this.shader.getAllUniforms().get(U_COLOR_MAX), this.getLineColorMax());
        this.shader.setUniformFloat(this.shader.getAllUniforms().get(U_VALUE_MAX), this.getLineValueMax());
        int instances = strip ? this.points - 1 : this.points / 2;
        int count = cap ? this.mesh.numVertices() : 6;
        Mesh.renderInstanced$default(this.mesh, 0, count, instances, 1, null);
        GLES_jvmKt.glVertexAttribDivisor(posAXHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posBXHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posAYHandle, 0);
        GLES_jvmKt.glVertexAttribDivisor(posBYHandle, 0);
        this.mesh.unbind();
        this.shader.unbind();
    }

    private final void resizeIfNeeded(int toAdd) {
        int newSize = RangesKt.coerceAtLeast((int)(this.lineDataX.length * 2), (int)(this.points + toAdd));
        if (!(newSize < 1000000)) {
            boolean bl = false;
            String string2 = "requested size too big: " + newSize;
            throw new IllegalArgumentException(string2.toString());
        }
        try {
            if (this.points + toAdd > this.lineDataX.length) {
                float[] fArray = Arrays.copyOf(this.lineDataX, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
                this.lineDataX = fArray;
                float[] fArray2 = Arrays.copyOf(this.lineDataY, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"copyOf(...)");
                this.lineDataY = fArray2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("currentSize=" + this.lineDataX.length + ". newSize=" + newSize, e);
        }
    }

    @Override
    public void addPoint(float x, float y) {
        this.resizeIfNeeded(1);
        this.lineDataX[this.points] = x;
        this.lineDataY[this.points] = y;
        ++this.points;
    }

    public final void addPoints(@NotNull float[] xs, int offsetX, @NotNull float[] ys, int offsetY, int length) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        this.resizeIfNeeded(length);
        ArraysKt.copyInto((float[])xs, (float[])this.lineDataX, (int)this.points, (int)offsetX, (int)(offsetX + length));
        ArraysKt.copyInto((float[])ys, (float[])this.lineDataY, (int)this.points, (int)offsetY, (int)(offsetY + length));
        this.points += length;
    }

    @Override
    public void reset() {
        this.points = 0;
    }

    @Override
    public void release() {
        this.shader.release();
        this.mesh.release();
    }

    private static final Unit mesh$lambda$4$lambda$1(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.position();
        return Unit.INSTANCE;
    }

    private static final Unit mesh$lambda$4$lambda$2(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionX();
        return Unit.INSTANCE;
    }

    private static final Unit mesh$lambda$4$lambda$3(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.positionY();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lvet/inpulse/krafiks/InstancedLineRenderer$Companion;", "", "<init>", "()V", "ATTR_POS_A_X", "", "ATTR_POS_A_Y", "ATTR_POS_B_X", "ATTR_POS_B_Y", "U_RESOLUTION", "U_WIDTH", "U_COLOR_MIN", "U_VALUE_MIN", "U_COLOR_MAX", "U_VALUE_MAX", "krafiks-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

