/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.krafiks;

import androidx.compose.runtime.internal.StabilityInferred;
import dev.romainguy.kotlin.math.Float2;
import dev.romainguy.kotlin.math.Float3;
import dev.romainguy.kotlin.math.Float4;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.krafiks.Camera;
import vet.inpulse.krafiks.LayoutBuilder;
import vet.inpulse.krafiks.Mesh;
import vet.inpulse.krafiks.Shader;
import vet.inpulse.krafiks.ShaderKt;
import vet.inpulse.krafiks.VertexBufferLayout;
import vet.inpulse.krafiks.VertexBufferLayoutKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-J\u0016\u0010+\u001a\u00020*2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u001bJ\b\u00100\u001a\u00020*H\u0002J\u001e\u00101\u001a\u00020*2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00067"}, d2={"Lvet/inpulse/krafiks/GeometryShaderLineRenderer;", "", "<init>", "()V", "shader", "Lvet/inpulse/krafiks/Shader;", "getShader", "()Lvet/inpulse/krafiks/Shader;", "mesh", "Lvet/inpulse/krafiks/Mesh;", "getMesh", "()Lvet/inpulse/krafiks/Mesh;", "lineBufferStride", "", "getLineBufferStride", "()I", "lineCpuBuffer", "", "getLineCpuBuffer", "()[F", "setLineCpuBuffer", "([F)V", "lineCpuBufferLength", "getLineCpuBufferLength", "setLineCpuBufferLength", "(I)V", "lineWidth", "", "getLineWidth", "()F", "setLineWidth", "(F)V", "aaRadius", "getAaRadius", "setAaRadius", "lineColor", "Ldev/romainguy/kotlin/math/Float4;", "getLineColor", "()Ldev/romainguy/kotlin/math/Float4;", "setLineColor", "(Ldev/romainguy/kotlin/math/Float4;)V", "startLine", "", "pushPoint", "point", "Ldev/romainguy/kotlin/math/Float3;", "x", "y", "ensureSize", "flush", "camera", "Lvet/inpulse/krafiks/Camera;", "width", "height", "Companion", "krafiks-core"})
@StabilityInferred(parameters=0)
public final class GeometryShaderLineRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shader shader = ShaderKt.shaderFromResource("/line_shader.vert", "/line_shader.frag", "/line_shader.geom");
    @NotNull
    private final Mesh mesh;
    private final int lineBufferStride;
    @NotNull
    private float[] lineCpuBuffer;
    private int lineCpuBufferLength;
    private float lineWidth;
    private float aaRadius;
    @NotNull
    private Float4 lineColor;
    public static final int $stable = 8;
    @NotNull
    public static final String UNIFORM_LINE_WIDTH = "u_line_width";
    @NotNull
    public static final String UNIFORM_COLOR = "u_line_color";
    @NotNull
    public static final String UNIFORM_VIEWPORT_SIZE = "u_viewport_size";
    @NotNull
    public static final String UNIFORM_AA_RADIUS = "u_aa_radius";
    public static final boolean useGeomShader = true;

    public GeometryShaderLineRenderer() {
        VertexBufferLayout[] vertexBufferLayoutArray = new VertexBufferLayout[]{VertexBufferLayoutKt.bufferLayout((Function1<? super LayoutBuilder, Unit>)((Function1)GeometryShaderLineRenderer::mesh$lambda$0))};
        this.mesh = new Mesh.Builder().layout(vertexBufferLayoutArray).primitive(3).build();
        this.lineBufferStride = 2;
        this.lineCpuBuffer = new float[1024];
        this.lineWidth = 1.0f;
        this.aaRadius = 1.0f;
        this.lineColor = new Float4(0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Shader getShader() {
        return this.shader;
    }

    @NotNull
    public final Mesh getMesh() {
        return this.mesh;
    }

    public final int getLineBufferStride() {
        return this.lineBufferStride;
    }

    @NotNull
    public final float[] getLineCpuBuffer() {
        return this.lineCpuBuffer;
    }

    public final void setLineCpuBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.lineCpuBuffer = fArray;
    }

    public final int getLineCpuBufferLength() {
        return this.lineCpuBufferLength;
    }

    public final void setLineCpuBufferLength(int n) {
        this.lineCpuBufferLength = n;
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public final void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public final float getAaRadius() {
        return this.aaRadius;
    }

    public final void setAaRadius(float f) {
        this.aaRadius = f;
    }

    @NotNull
    public final Float4 getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.lineColor = float4;
    }

    public final void startLine() {
        this.lineCpuBufferLength = 0;
    }

    public final void pushPoint(@NotNull Float3 point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.ensureSize();
        this.lineCpuBuffer[this.lineCpuBufferLength + 0] = point.getX();
        this.lineCpuBuffer[this.lineCpuBufferLength + 1] = point.getY();
        this.lineCpuBufferLength += this.lineBufferStride;
    }

    public final void pushPoint(float x, float y) {
        this.ensureSize();
        this.lineCpuBuffer[this.lineCpuBufferLength + 0] = x;
        this.lineCpuBuffer[this.lineCpuBufferLength + 1] = y;
        this.lineCpuBufferLength += this.lineBufferStride;
    }

    private final void ensureSize() {
        if (this.lineCpuBuffer.length <= this.lineCpuBufferLength + this.lineBufferStride) {
            float[] newBuffer = new float[this.lineCpuBuffer.length * 2];
            ArraysKt.copyInto$default((float[])this.lineCpuBuffer, (float[])newBuffer, (int)0, (int)0, (int)0, (int)14, null);
            this.lineCpuBuffer = newBuffer;
        }
    }

    public final void flush(@NotNull Camera camera, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (this.lineCpuBufferLength <= 0) {
            return;
        }
        Mesh.bufferSubData$default(this.mesh, 0, this.lineCpuBuffer, 0, this.lineCpuBufferLength, 0, 16, null);
        this.shader.bind();
        Integer n = this.shader.getAllUniforms().get(UNIFORM_LINE_WIDTH);
        Intrinsics.checkNotNull((Object)n);
        this.shader.setUniformFloat(n, this.lineWidth);
        Integer n2 = this.shader.getAllUniforms().get(UNIFORM_COLOR);
        Intrinsics.checkNotNull((Object)n2);
        this.shader.setUniformFloat4(n2, this.lineColor);
        Integer n3 = this.shader.getAllUniforms().get(UNIFORM_VIEWPORT_SIZE);
        Intrinsics.checkNotNull((Object)n3);
        this.shader.setUniformFloat2(n3, new Float2((float)width, (float)height));
        Integer n4 = this.shader.getAllUniforms().get(UNIFORM_AA_RADIUS);
        Intrinsics.checkNotNull((Object)n4);
        this.shader.setUniformFloat2(n4, new Float2(this.aaRadius, this.aaRadius));
        this.shader.setMvpMatrix(camera.getVp());
        this.mesh.bind(this.shader);
        this.mesh.render(0, this.lineCpuBufferLength / this.lineBufferStride);
        this.lineCpuBufferLength = 0;
    }

    private static final Unit mesh$lambda$0(LayoutBuilder $this$bufferLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$bufferLayout, (String)"$this$bufferLayout");
        $this$bufferLayout.position();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lvet/inpulse/krafiks/GeometryShaderLineRenderer$Companion;", "", "<init>", "()V", "UNIFORM_LINE_WIDTH", "", "UNIFORM_COLOR", "UNIFORM_VIEWPORT_SIZE", "UNIFORM_AA_RADIUS", "useGeomShader", "", "krafiks-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

