/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh;

import com.github.hypfvieh.XmlHelper;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbusHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbusHelper.class);

    private DbusHelper() {
    }

    public static Set<String> findNodes(DBusConnection _connection, String _path) {
        LinkedHashSet<String> foundNodes = new LinkedHashSet<String>();
        if (_connection == null || _path == null || _path.trim().isEmpty()) {
            return foundNodes;
        }
        try {
            Introspectable remoteObject = (Introspectable)_connection.getRemoteObject("org.bluez", _path, Introspectable.class);
            String introspect = remoteObject.Introspect();
            Document doc = XmlHelper.parseXmlString(introspect);
            NodeList nodes = XmlHelper.applyXpathExpressionToDocument("/node/node", doc);
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!(nodes.item(i) instanceof Element)) continue;
                Element elem = (Element)nodes.item(i);
                foundNodes.add(elem.getAttribute("name"));
            }
            return foundNodes;
        }
        catch (DBusException _ex) {
            LOGGER.info("Exception while search DBus.", (Throwable)_ex);
        }
        catch (IOException _ex) {
            LOGGER.error("Exception while applying Xpath to introspection result", (Throwable)_ex);
        }
        catch (Exception _ex) {
            LOGGER.error("Critical error while reading DBUS response (maybe no bluetoothd daemon running?)", (Throwable)_ex);
        }
        return foundNodes;
    }

    public static <T extends DBusInterface> T getRemoteObject(DBusConnection _connection, String _path, Class<T> _objClass) {
        try {
            return (T)_connection.getRemoteObject("org.bluez", _path, _objClass);
        }
        catch (DBusException _ex) {
            LOGGER.warn("Error while converting dbus response to object.", (Throwable)_ex);
            return null;
        }
    }
}

