/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.D3;
import org.jetbrains.kotlinx.multik.ndarray.data.D4;
import org.jetbrains.kotlinx.multik.ndarray.data.DN;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.ImmutableMemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.InternalsKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiIndexProgression;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiIndexProgressionKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArrayIterator;
import org.jetbrains.kotlinx.multik.ndarray.data.ScalarsGettersAndSettersKt;
import org.jetbrains.kotlinx.multik.ndarray.data.ViewGettersAndSettersKt;
import org.jetbrains.kotlinx.multik.ndarray.operations.TransformationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004BQ\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00028\u0001\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0\u0000j\b\u0012\u0004\u0012\u00028\u0000`-J\u001c\u0010.\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020/0\u0000j\b\u0012\u0004\u0012\u00028\u0000`0J\u001c\u00101\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002020\u0000j\b\u0012\u0004\u0012\u00028\u0000`3J\u001c\u00104\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002050\u0000j\b\u0012\u0004\u0012\u00028\u0000`6J\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002080\u0000J!\u00109\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u00028\u00010\u0000\"\n\b\u0002\u0010:\u0018\u0001*\u00020;H\u0086\bJ$\u00109\u001a\u000e\u0012\u0004\u0012\u0002H:\u0012\u0004\u0012\u00028\u00010\u0000\"\b\b\u0002\u0010:*\u00020;2\u0006\u0010<\u001a\u00020=J6\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0018\u0010?\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e0@2\u0006\u0010A\u001a\u00020\bH\u0016J)\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eH\u0096\u0004J0\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010A\u001a\u00020\bH\u0016J\u0014\u0010B\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\u0014\u0010C\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\u0013\u0010D\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010EH\u0096\u0002J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0\u000eH\u0016J\b\u0010G\u001a\u00020\bH\u0016J\b\u0010H\u001a\u00020\u0013H\u0016J\b\u0010I\u001a\u00020\u0013H\u0016J\b\u0010J\u001a\u00020\u0013H\u0016J\u000f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000LH\u0096\u0002J&\u0010M\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0\u0000j\b\u0012\u0004\u0012\u00028\u0000`-2\u0006\u0010N\u001a\u00020\bH\u0016J.\u0010M\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020/0\u0000j\b\u0012\u0004\u0012\u00028\u0000`02\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020\bH\u0016J6\u0010M\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002020\u0000j\b\u0012\u0004\u0012\u00028\u0000`32\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\bH\u0016J>\u0010M\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002050\u0000j\b\u0012\u0004\u0012\u00028\u0000`62\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\bH\u0016J@\u0010M\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002080\u00002\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\n\u0010R\u001a\u00020\n\"\u00020\bH\u0016J \u0010S\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002080\u00002\n\u0010T\u001a\u00020\n\"\u00020\bH\u0016J\b\u0010U\u001a\u00020VH\u0016J \u0010W\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\n\u0010T\u001a\u00020\n\"\u00020\bH\u0016J \u0010X\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002080\u00002\n\u0010T\u001a\u00020\n\"\u00020\bH\u0016R$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\f\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010%R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010'\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "T", "D", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MutableMultiArray;", "data", "Lorg/jetbrains/kotlinx/multik/ndarray/data/ImmutableMemoryView;", "offset", "", "shape", "", "strides", "dim", "base", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/ImmutableMemoryView;I[I[ILorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)V", "getBase", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "consistent", "", "getConsistent", "()Z", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;", "getData", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;", "getDim", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "multiIndices", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexProgression;", "getMultiIndices", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexProgression;", "getOffset", "()I", "getShape", "()[I", "size", "getSize", "getStrides", "asD1Array", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1Array;", "asD2Array", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2Array;", "asD3Array", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D3;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D3Array;", "asD4Array", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D4;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D4Array;", "asDNArray", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DN;", "asType", "E", "", "dataType", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "cat", "other", "", "axis", "copy", "deepCopy", "equals", "", "flatten", "hashCode", "isEmpty", "isNotEmpty", "isScalar", "iterator", "", "reshape", "dim1", "dim2", "dim3", "dim4", "dims", "squeeze", "axes", "toString", "", "transpose", "unsqueeze", "multik-core"})
@SourceDebugExtension(value={"SMAP\nNDArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NDArray.kt\norg/jetbrains/kotlinx/multik/ndarray/data/NDArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 5 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n+ 6 Internals.kt\norg/jetbrains/kotlinx/multik/ndarray/data/InternalsKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,436:1\n1#2:437\n1#2:454\n1#2:458\n1#2:463\n1#2:468\n1#2:473\n12762#3,3:438\n13330#3:456\n13331#3:460\n13330#3:461\n13331#3:465\n13330#3:466\n13331#3:470\n13330#3:471\n13331#3:475\n12762#3,3:476\n12313#3,2:486\n79#4:441\n13#5,11:442\n98#6:453\n99#6:455\n98#6:457\n99#6:459\n98#6:462\n99#6:464\n98#6:467\n99#6:469\n98#6:472\n99#6:474\n766#7:479\n857#7,2:480\n1549#7:482\n1620#7,3:483\n1726#7,3:488\n*S KotlinDebug\n*F\n+ 1 NDArray.kt\norg/jetbrains/kotlinx/multik/ndarray/data/NDArray\n*L\n109#1:454\n126#1:458\n143#1:463\n160#1:468\n177#1:473\n41#1:438,3\n126#1:456\n126#1:460\n143#1:461\n143#1:465\n160#1:466\n160#1:470\n177#1:471\n177#1:475\n178#1:476,3\n219#1:486,2\n67#1:441\n67#1:442,11\n109#1:453\n109#1:455\n126#1:457\n126#1:459\n143#1:462\n143#1:464\n160#1:467\n160#1:469\n177#1:472\n177#1:474\n217#1:479\n217#1:480,2\n217#1:482\n217#1:483,3\n251#1:488,3\n*E\n"})
public final class NDArray<T, D extends Dimension>
implements MutableMultiArray<T, D> {
    private final int offset;
    @NotNull
    private final int[] shape;
    @NotNull
    private final int[] strides;
    @NotNull
    private final D dim;
    @Nullable
    private final MultiArray<T, ? extends Dimension> base;
    @NotNull
    private final MemoryView<T> data;

    public NDArray(@NotNull ImmutableMemoryView<T> data2, int offset, @NotNull int[] shape, @NotNull int[] strides, @NotNull D dim, @Nullable MultiArray<T, ? extends Dimension> base) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter(dim, (String)"dim");
        this.offset = offset;
        this.shape = shape;
        this.strides = strides;
        this.dim = dim;
        this.base = base;
        if (!(!(this.getShape().length == 0))) {
            boolean bl = false;
            String string = "Shape can't be empty.";
            throw new IllegalStateException(string.toString());
        }
        this.data = (MemoryView)data2;
    }

    public /* synthetic */ NDArray(ImmutableMemoryView immutableMemoryView, int n, int[] nArray, int[] nArray2, Dimension dimension, MultiArray multiArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            nArray2 = InternalsKt.computeStrides(nArray);
        }
        if ((n2 & 0x20) != 0) {
            multiArray = null;
        }
        this(immutableMemoryView, n, nArray, nArray2, dimension, multiArray);
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    public int[] getShape() {
        return this.shape;
    }

    @Override
    @NotNull
    public int[] getStrides() {
        return this.strides;
    }

    @Override
    @NotNull
    public D getDim() {
        return this.dim;
    }

    @Override
    @Nullable
    public MultiArray<T, ? extends Dimension> getBase() {
        return this.base;
    }

    @Override
    @NotNull
    public MemoryView<T> getData() {
        return this.data;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getSize() {
        void $this$fold$iv;
        int[] nArray = this.getShape();
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void p1;
            void element$iv;
            void var8_8 = element$iv = $this$fold$iv[i];
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        return accumulator$iv;
    }

    @Override
    public boolean getConsistent() {
        return this.getOffset() == 0 && this.getSize() == this.getData().getSize() && Arrays.equals(this.getStrides(), InternalsKt.computeStrides(this.getShape()));
    }

    @Override
    @NotNull
    public IntRange getIndices() {
        return RangesKt.until((int)0, (int)this.getSize());
    }

    @Override
    @NotNull
    public MultiIndexProgression getMultiIndices() {
        int n = 0;
        int n2 = this.getDim().getD();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[this.getDim().getD()];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = this.getShape()[n3] - 1;
        }
        return MultiIndexProgressionKt.rangeTo(nArray2, nArray);
    }

    @Override
    public boolean isScalar() {
        return this.getShape().length == 0 || this.getShape().length == 1 && ArraysKt.first((int[])this.getShape()) == 1;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getConsistent() ? ((MemoryView)this.getData()).iterator() : (Iterator)new NDArrayIterator(this.getData(), this.getOffset(), this.getStrides(), this.getShape());
    }

    public final /* synthetic */ <E extends Number> NDArray<E, D> asType() {
        DataType dataType;
        boolean $i$f$asType = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"E");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Number.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        DataType dataType2 = dataType;
        return this.asType(dataType2);
    }

    @NotNull
    public final <E extends Number> NDArray<E, D> asType(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        MemoryView newData2 = MemoryViewKt.initMemoryView(this.getData().getSize(), dataType, (Function1)new Function1<Integer, E>(this){
            final /* synthetic */ NDArray<T, D> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final E invoke(int it) {
                T t = this.this$0.getData().get(it);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type E of org.jetbrains.kotlinx.multik.ndarray.data.NDArray.asType");
                return (E)((Number)t);
            }
        });
        return new NDArray<T, D>(newData2, this.getOffset(), this.getShape(), this.getStrides(), (Dimension)this.getDim(), null, 32, null);
    }

    @Override
    @NotNull
    public NDArray<T, D> copy() {
        ImmutableMemoryView immutableMemoryView = ((MemoryView)this.getData()).copyOf();
        int n = this.getOffset();
        int[] nArray = this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] nArray3 = this.getStrides();
        int[] nArray4 = Arrays.copyOf(nArray3, nArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"copyOf(...)");
        return new NDArray<T, D>(immutableMemoryView, n, nArray2, nArray4, (Dimension)this.getDim(), null, 32, null);
    }

    @Override
    @NotNull
    public NDArray<T, D> deepCopy() {
        MemoryView<T> data2 = null;
        if (this.getConsistent()) {
            data2 = ((MemoryView)this.getData()).copyOf();
        } else {
            data2 = MemoryViewKt.initMemoryView(this.getSize(), this.getDtype());
            int index = 0;
            Iterator<T> iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                T el = iterator2.next();
                data2.set(index++, el);
            }
        }
        ImmutableMemoryView immutableMemoryView = data2;
        int[] nArray = this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray<T, D>(immutableMemoryView, 0, nArray2, null, (Dimension)this.getDim(), null, 40, null);
    }

    @Override
    @NotNull
    public MultiArray<T, D1> flatten() {
        int[] nArray;
        Object object;
        if (this.getConsistent()) {
            object = ((MemoryView)this.getData()).copyOf();
        } else {
            MemoryView<T> tmpData = MemoryViewKt.initMemoryView(this.getSize(), this.getDtype());
            int index = 0;
            Iterator<T> iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                T el = iterator2.next();
                tmpData.set(index++, el);
            }
            object = nArray;
        }
        MemoryView data2 = object;
        nArray = new int[]{this.getSize()};
        return new NDArray<T, D>(data2, 0, nArray, null, D1.Companion, null, 40, null);
    }

    @Override
    @NotNull
    public NDArray<T, D1> reshape(int dim1) {
        NDArray<T, D> nDArray;
        int newOffset;
        MultiArray multiArray;
        ImmutableMemoryView newData2;
        boolean $i$f$requirePositiveShape = false;
        if (!(dim1 > 0)) {
            boolean $i$a$-require-InternalsKt$requirePositiveShape$1$iv22 = false;
            String $i$a$-require-InternalsKt$requirePositiveShape$1$iv22 = "Shape must be positive but was " + dim1 + '.';
            throw new IllegalArgumentException($i$a$-require-InternalsKt$requirePositiveShape$1$iv22.toString());
        }
        if (!(dim1 == this.getSize())) {
            boolean $i$a$-require-NDArray$reshape$22 = false;
            String $i$a$-require-NDArray$reshape$22 = "Cannot reshape array of size " + this.getSize() + " into a new shape (" + dim1 + ')';
            throw new IllegalArgumentException($i$a$-require-NDArray$reshape$22.toString());
        }
        ImmutableMemoryView immutableMemoryView = newData2 = this.getConsistent() ? this.getData() : ((NDArray)this.deepCopy()).getData();
        if (this.getConsistent()) {
            multiArray = this.getBase();
            if (multiArray == null) {
                multiArray = this;
            }
        } else {
            multiArray = null;
        }
        MultiArray newBase = multiArray;
        int n = newOffset = this.getConsistent() ? this.getOffset() : 0;
        if (this.getDim().getD() == 1 && ArraysKt.first((int[])this.getShape()) == dim1) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D1>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D1Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            nDArray = this;
        } else {
            int[] nArray = new int[]{dim1};
            NDArray<T, D> nDArray2 = new NDArray<T, D>(newData2, newOffset, nArray, null, D1.Companion, newBase, 8, null);
            nDArray = nDArray2;
        }
        return nDArray;
    }

    @Override
    @NotNull
    public NDArray<T, D2> reshape(int dim1, int dim2) {
        NDArray<T, D> nDArray;
        int newOffset;
        MultiArray multiArray;
        ImmutableMemoryView newData2;
        int[] newShape;
        int[] nArray = new int[]{dim1, dim2};
        int[] $this$forEach$iv = newShape = nArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            boolean $i$f$requirePositiveShape = false;
            if (it > 0) continue;
            boolean bl2 = false;
            String string = "Shape must be positive but was " + it + '.';
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dim1 * dim2 == this.getSize())) {
            boolean $i$a$-require-NDArray$reshape$42 = false;
            String $i$a$-require-NDArray$reshape$42 = "Cannot reshape array of size " + this.getSize() + " into a new shape (" + dim1 + ", " + dim2 + ')';
            throw new IllegalArgumentException($i$a$-require-NDArray$reshape$42.toString());
        }
        ImmutableMemoryView immutableMemoryView = newData2 = this.getConsistent() ? this.getData() : ((NDArray)this.deepCopy()).getData();
        if (this.getConsistent()) {
            multiArray = this.getBase();
            if (multiArray == null) {
                multiArray = this;
            }
        } else {
            multiArray = null;
        }
        MultiArray newBase = multiArray;
        int n2 = newOffset = this.getConsistent() ? this.getOffset() : 0;
        if (Arrays.equals(this.getShape(), newShape)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            nDArray = this;
        } else {
            nDArray = new NDArray<T, D>(newData2, newOffset, newShape, null, D2.Companion, newBase, 8, null);
        }
        return nDArray;
    }

    @Override
    @NotNull
    public NDArray<T, D3> reshape(int dim1, int dim2, int dim3) {
        NDArray<T, D> nDArray;
        int newOffset;
        MultiArray multiArray;
        ImmutableMemoryView newData2;
        int[] newShape;
        int[] nArray = new int[]{dim1, dim2, dim3};
        int[] $this$forEach$iv = newShape = nArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            boolean $i$f$requirePositiveShape = false;
            if (it > 0) continue;
            boolean bl2 = false;
            String string = "Shape must be positive but was " + it + '.';
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dim1 * dim2 * dim3 == this.getSize())) {
            boolean $i$a$-require-NDArray$reshape$62 = false;
            String $i$a$-require-NDArray$reshape$62 = "Cannot reshape array of size " + this.getSize() + " into a new shape (" + dim1 + ", " + dim2 + ", " + dim3 + ')';
            throw new IllegalArgumentException($i$a$-require-NDArray$reshape$62.toString());
        }
        ImmutableMemoryView immutableMemoryView = newData2 = this.getConsistent() ? this.getData() : ((NDArray)this.deepCopy()).getData();
        if (this.getConsistent()) {
            multiArray = this.getBase();
            if (multiArray == null) {
                multiArray = this;
            }
        } else {
            multiArray = null;
        }
        MultiArray newBase = multiArray;
        int n2 = newOffset = this.getConsistent() ? this.getOffset() : 0;
        if (Arrays.equals(this.getShape(), newShape)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D3>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D3Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            nDArray = this;
        } else {
            nDArray = new NDArray<T, D>(newData2, newOffset, newShape, null, D3.Companion, newBase, 8, null);
        }
        return nDArray;
    }

    @Override
    @NotNull
    public NDArray<T, D4> reshape(int dim1, int dim2, int dim3, int dim4) {
        NDArray<T, D> nDArray;
        int newOffset;
        MultiArray multiArray;
        ImmutableMemoryView newData2;
        int[] newShape;
        int[] nArray = new int[]{dim1, dim2, dim3, dim4};
        int[] $this$forEach$iv = newShape = nArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            boolean $i$f$requirePositiveShape = false;
            if (it > 0) continue;
            boolean bl2 = false;
            String string = "Shape must be positive but was " + it + '.';
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dim1 * dim2 * dim3 * dim4 == this.getSize())) {
            boolean $i$a$-require-NDArray$reshape$82 = false;
            String $i$a$-require-NDArray$reshape$82 = "Cannot reshape array of size " + this.getSize() + " into a new shape (" + dim1 + ", " + dim2 + ", " + dim3 + ", " + dim4 + ')';
            throw new IllegalArgumentException($i$a$-require-NDArray$reshape$82.toString());
        }
        ImmutableMemoryView immutableMemoryView = newData2 = this.getConsistent() ? this.getData() : ((NDArray)this.deepCopy()).getData();
        if (this.getConsistent()) {
            multiArray = this.getBase();
            if (multiArray == null) {
                multiArray = this;
            }
        } else {
            multiArray = null;
        }
        MultiArray newBase = multiArray;
        int n2 = newOffset = this.getConsistent() ? this.getOffset() : 0;
        if (Arrays.equals(this.getShape(), newShape)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D4>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D4Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            nDArray = this;
        } else {
            nDArray = new NDArray<T, D>(newData2, newOffset, newShape, null, D4.Companion, newBase, 8, null);
        }
        return nDArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray<T, DN> reshape(int dim1, int dim2, int dim3, int dim4, int ... dims) {
        NDArray<T, D> nDArray;
        int newOffset;
        MultiArray multiArray;
        ImmutableMemoryView newData2;
        void $this$fold$iv;
        boolean $i$f$requirePositiveShape;
        int[] newShape;
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        int[] nArray = new int[]{dim1, dim2, dim3, dim4};
        int[] $this$forEach$iv = newShape = ArraysKt.plus((int[])nArray, (int[])dims);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $i$f$requirePositiveShape = false;
            if (it > 0) continue;
            boolean $i$a$-require-InternalsKt$requirePositiveShape$1$iv22 = false;
            String $i$a$-require-InternalsKt$requirePositiveShape$1$iv22 = "Shape must be positive but was " + it + '.';
            throw new IllegalArgumentException($i$a$-require-InternalsKt$requirePositiveShape$1$iv22.toString());
        }
        $this$forEach$iv = newShape;
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void p1;
            $i$f$requirePositiveShape = element$iv;
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        if (!(accumulator$iv == this.getSize())) {
            boolean $i$a$-require-NDArray$reshape$112 = false;
            String $i$a$-require-NDArray$reshape$112 = "Cannot reshape array of size " + this.getSize() + " into a new shape " + ArraysKt.joinToString$default((int[])newShape, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null);
            throw new IllegalArgumentException($i$a$-require-NDArray$reshape$112.toString());
        }
        ImmutableMemoryView immutableMemoryView = newData2 = this.getConsistent() ? this.getData() : ((NDArray)this.deepCopy()).getData();
        if (this.getConsistent()) {
            multiArray = this.getBase();
            if (multiArray == null) {
                multiArray = this;
            }
        } else {
            multiArray = null;
        }
        MultiArray newBase = multiArray;
        int n2 = newOffset = this.getConsistent() ? this.getOffset() : 0;
        if (Arrays.equals(this.getShape(), newShape)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.DN>");
            nDArray = this;
        } else {
            nDArray = new NDArray<T, D>(newData2, newOffset, newShape, null, new DN(newShape.length), newBase, 8, null);
        }
        return nDArray;
    }

    @Override
    @NotNull
    public NDArray<T, D> transpose(int ... axes) {
        Intrinsics.checkNotNullParameter((Object)axes, (String)"axes");
        if (!(axes.length == 0 || axes.length == this.getDim().getD())) {
            boolean $i$a$-require-NDArray$transpose$42 = false;
            String $i$a$-require-NDArray$transpose$42 = "All dimensions must be indicated.";
            throw new IllegalArgumentException($i$a$-require-NDArray$transpose$42.toString());
        }
        int $i$a$-require-NDArray$transpose$42 = axes.length;
        for (int i = 0; i < $i$a$-require-NDArray$transpose$42; ++i) {
            int axis = axes[i];
            if (0 <= axis ? axis < this.getDim().getD() : false) continue;
            boolean $i$a$-require-NDArray$transpose$52 = false;
            String $i$a$-require-NDArray$transpose$52 = "Dimension must be from 0 to " + this.getDim().getD() + '.';
            throw new IllegalArgumentException($i$a$-require-NDArray$transpose$52.toString());
        }
        if (!(ArraysKt.toSet((int[])axes).size() == axes.length)) {
            boolean $i$a$-require-NDArray$transpose$62 = false;
            String $i$a$-require-NDArray$transpose$62 = "The specified dimensions must be unique.";
            throw new IllegalArgumentException($i$a$-require-NDArray$transpose$62.toString());
        }
        if (this.getDim().getD() == 1) {
            return new NDArray<T, D>(this.getData(), this.getOffset(), this.getShape(), this.getStrides(), (Dimension)this.getDim(), null, 32, null);
        }
        int[] newShape = null;
        int[] newStrides = null;
        if (axes.length == 0) {
            newShape = ArraysKt.reversedArray((int[])this.getShape());
            newStrides = ArraysKt.reversedArray((int[])this.getStrides());
        } else {
            newShape = new int[this.getShape().length];
            newStrides = new int[this.getStrides().length];
            int n = axes.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                int axis = axes[i];
                newShape[i2] = this.getShape()[axis];
                newStrides[i2] = this.getStrides()[axis];
            }
        }
        int n = this.getOffset();
        D d2 = this.getDim();
        MultiArray multiArray = this.getBase();
        if (multiArray == null) {
            multiArray = this;
        }
        return new NDArray<T, D>(this.getData(), n, newShape, newStrides, d2, multiArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray<T, DN> squeeze(int ... axes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)axes, (String)"axes");
        if (axes.length == 0) {
            void $this$mapTo$iv$iv;
            IndexedValue it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ArraysKt.withIndex((int[])this.getShape());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IndexedValue)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() == 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndex());
            }
            list = (List)destination$iv$iv;
        } else {
            boolean bl;
            block7: {
                int[] $this$all$iv = axes;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (this.getShape()[it] == 1) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (!bl) {
                boolean bl3 = false;
                String string = "Cannot select an axis to squeeze out which has size not equal to one.";
                throw new IllegalArgumentException(string.toString());
            }
            list = ArraysKt.toList((int[])axes);
        }
        List cutAxes = list;
        int[] newShape = ArraysKt.sliceArray((int[])this.getShape(), (Collection)CollectionsKt.minus((Iterable)((Iterable)ArraysKt.getIndices((int[])this.getShape())), (Iterable)cutAxes));
        int n = this.getOffset();
        Dimension dimension = new DN(newShape.length);
        MultiArray multiArray = this.getBase();
        if (multiArray == null) {
            multiArray = this;
        }
        return new NDArray<T, D>(this.getData(), n, newShape, null, dimension, multiArray, 8, null);
    }

    @Override
    @NotNull
    public NDArray<T, DN> unsqueeze(int ... axes) {
        MultiArray multiArray;
        ImmutableMemoryView newData2;
        Intrinsics.checkNotNullParameter((Object)axes, (String)"axes");
        List newShape = ArraysKt.toMutableList((int[])this.getShape());
        Iterator iterator2 = ArraysKt.sorted((int[])axes).iterator();
        while (iterator2.hasNext()) {
            int axis = ((Number)iterator2.next()).intValue();
            newShape.add(axis, 1);
        }
        ImmutableMemoryView immutableMemoryView = newData2 = this.getConsistent() ? this.getData() : ((NDArray)this.deepCopy()).getData();
        if (this.getConsistent()) {
            multiArray = this.getBase();
            if (multiArray == null) {
                multiArray = this;
            }
        } else {
            multiArray = null;
        }
        MultiArray newBase = multiArray;
        int newOffset = this.getConsistent() ? this.getOffset() : 0;
        return new NDArray<T, D>(newData2, newOffset, CollectionsKt.toIntArray((Collection)newShape), null, new DN(newShape.size()), newBase, 8, null);
    }

    @Override
    @NotNull
    public NDArray<T, D> cat(@NotNull MultiArray<T, D> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.cat(CollectionsKt.listOf(other), 0);
    }

    @Override
    @NotNull
    public NDArray<T, D> cat(@NotNull MultiArray<T, D> other, int axis) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.cat(CollectionsKt.listOf(other), axis);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray<T, D> cat(@NotNull List<? extends MultiArray<T, D>> other, int axis) {
        int n;
        Object it2;
        boolean bl;
        int actualAxis;
        block7: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter(other, (String)"other");
            actualAxis = InternalsKt.actualAxis(this, axis);
            if (!(0 <= actualAxis ? actualAxis < this.getDim().getD() : false)) {
                boolean $i$a$-require-NDArray$cat$22 = false;
                String $i$a$-require-NDArray$cat$22 = "Axis " + axis + " is out of bounds for array of dimension " + this.getDim();
                throw new IllegalArgumentException($i$a$-require-NDArray$cat$22.toString());
            }
            MultiArray arr = (MultiArray)CollectionsKt.first(other);
            Iterable $i$a$-require-NDArray$cat$22 = ArraysKt.withIndex((int[])this.getShape());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv22 : $this$all$iv) {
                    it2 = (IndexedValue)element$iv22;
                    boolean bl2 = false;
                    if (it2.getIndex() == axis || ((Number)it2.getValue()).intValue() == arr.getShape()[it2.getIndex()]) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-NDArray$cat$42 = false;
            String $i$a$-require-NDArray$cat$42 = "All dimensions of input arrays for the concatenation axis must match exactly.";
            throw new IllegalArgumentException($i$a$-require-NDArray$cat$42.toString());
        }
        int[] nArray = this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] newShape = nArray2;
        Iterable $i$a$-require-NDArray$cat$42 = other;
        int n2 = this.getShape()[actualAxis];
        int n3 = actualAxis;
        int[] nArray3 = newShape;
        int n4 = 0;
        for (Object it2 : $i$a$-require-NDArray$cat$42) {
            void it3;
            MultiArray bl2 = (MultiArray)it2;
            n = n4;
            boolean bl3 = false;
            int n5 = it3.getShape()[actualAxis];
            n4 = n + n5;
        }
        n = n4;
        nArray3[n3] = n2 + n;
        Iterable iterable = other;
        int n6 = this.getSize();
        int element$iv22 = 0;
        for (Object it3 : iterable) {
            void it4;
            MultiArray bl3 = (MultiArray)it3;
            n3 = element$iv22;
            boolean bl4 = false;
            n2 = it4.getSize();
            element$iv22 = n3 + n2;
        }
        n3 = element$iv22;
        int newSize = n6 + n3;
        List element$iv22 = CollectionsKt.toMutableList((Collection)other);
        it2 = element$iv22;
        boolean bl5 = false;
        it2.add(0, this);
        List arrays = element$iv22;
        NDArray<T, D> result = new NDArray<T, D>(MemoryViewKt.initMemoryView(newSize, this.getDtype()), 0, newShape, null, (Dimension)this.getDim(), null, 40, null);
        TransformationKt.concatenate(arrays, result, actualAxis);
        return result;
    }

    @NotNull
    public final NDArray<T, D1> asD1Array() {
        if (this.getDim().getD() == 1) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D1>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D1Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            return this;
        }
        throw new ClassCastException("Cannot cast NDArray of dimension " + this.getDim().getD() + " to NDArray of dimension 1.");
    }

    @NotNull
    public final NDArray<T, D2> asD2Array() {
        if (this.getDim().getD() == 2) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            return this;
        }
        throw new ClassCastException("Cannot cast NDArray of dimension " + this.getDim().getD() + " to NDArray of dimension 2.");
    }

    @NotNull
    public final NDArray<T, D3> asD3Array() {
        if (this.getDim().getD() == 3) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D3>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D3Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            return this;
        }
        throw new ClassCastException("Cannot cast NDArray of dimension " + this.getDim().getD() + " to NDArray of dimension 3.");
    }

    @NotNull
    public final NDArray<T, D4> asD4Array() {
        if (this.getDim().getD() == 4) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.D4>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D4Array<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray> }");
            return this;
        }
        throw new ClassCastException("Cannot cast NDArray of dimension " + this.getDim().getD() + " to NDArray of dimension 4.");
    }

    @NotNull
    public final NDArray<T, DN> asDNArray() {
        if (this.getDim().getD() == -1) {
            throw new Exception("Array dimension is undefined");
        }
        if (this.getDim().getD() > 4) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray, org.jetbrains.kotlinx.multik.ndarray.data.DN>");
            return this;
        }
        int n = this.getOffset();
        int[] nArray = this.getShape();
        int[] nArray2 = this.getStrides();
        Dimension dimension = new DN(this.getDim().getD());
        MultiArray multiArray = this.getBase();
        if (multiArray == null) {
            multiArray = this;
        }
        return new NDArray<T, Dimension>(this.getData(), n, nArray, nArray2, dimension, multiArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() != other.getClass()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<*, *>");
        NDArray cfr_ignored_0 = (NDArray)other;
        if (this.getSize() != ((NDArray)other).getSize()) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), ((NDArray)other).getShape())) {
            return false;
        }
        if (this.getDtype() != ((NDArray)other).getDtype()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getDim(), ((NDArray)other).getDim())) {
            return false;
        }
        Iterator<T> thIt = this.iterator();
        Iterator<T> othIt = ((NDArray)other).iterator();
        while (thIt.hasNext() && othIt.hasNext()) {
            T left = thIt.next();
            T right = othIt.next();
            if (!(left instanceof ComplexFloat && right instanceof ComplexFloat ? !ComplexFloat.eq-tRyw6i8$multik_core(((ComplexFloat)left).unbox-impl(), ((ComplexFloat)right).unbox-impl()) : (left instanceof ComplexDouble && right instanceof ComplexDouble ? !((ComplexDouble)left).eq(right) : !Intrinsics.areEqual(left, right)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        Iterator<T> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            T el;
            T t = el = iterator2.next();
            result = 31 * result + (t != null ? t.hashCode() : 0);
        }
        return result;
    }

    @NotNull
    public String toString() {
        String string;
        switch (this.getDim().getD()) {
            case 1: {
                StringBuilder stringBuilder;
                StringBuilder $this$toString_u24lambda_u2424 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray.toString$lambda$24, org.jetbrains.kotlinx.multik.ndarray.data.D1>");
                $this$toString_u24lambda_u2424.append('[');
                int n = ArraysKt.first((int[])this.getShape());
                for (int i = 0; i < n; ++i) {
                    $this$toString_u24lambda_u2424.append(ScalarsGettersAndSettersKt.genGet1(this, i));
                    if (i >= ArraysKt.first((int[])this.getShape()) - 1) continue;
                    $this$toString_u24lambda_u2424.append(", ");
                }
                $this$toString_u24lambda_u2424.append(']');
                String string2 = stringBuilder.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                break;
            }
            case 2: {
                StringBuilder stringBuilder;
                StringBuilder $this$toString_u24lambda_u2425 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray.toString$lambda$25, org.jetbrains.kotlinx.multik.ndarray.data.D2>");
                $this$toString_u24lambda_u2425.append('[');
                int n = this.getShape()[0];
                for (int ax0 = 0; ax0 < n; ++ax0) {
                    $this$toString_u24lambda_u2425.append('[');
                    int n2 = this.getShape()[1];
                    for (int ax1 = 0; ax1 < n2; ++ax1) {
                        $this$toString_u24lambda_u2425.append(ScalarsGettersAndSettersKt.genGet2(this, ax0, ax1));
                        if (ax1 >= this.getShape()[1] - 1) continue;
                        $this$toString_u24lambda_u2425.append(", ");
                    }
                    $this$toString_u24lambda_u2425.append(']');
                    if (ax0 >= this.getShape()[0] - 1) continue;
                    $this$toString_u24lambda_u2425.append(",\n");
                }
                $this$toString_u24lambda_u2425.append(']');
                String string3 = stringBuilder.toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                break;
            }
            case 3: {
                StringBuilder stringBuilder;
                StringBuilder $this$toString_u24lambda_u2426 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray.toString$lambda$26, org.jetbrains.kotlinx.multik.ndarray.data.D3>");
                $this$toString_u24lambda_u2426.append('[');
                int n = this.getShape()[0];
                for (int ax0 = 0; ax0 < n; ++ax0) {
                    $this$toString_u24lambda_u2426.append('[');
                    int n3 = this.getShape()[1];
                    for (int ax1 = 0; ax1 < n3; ++ax1) {
                        $this$toString_u24lambda_u2426.append('[');
                        int n4 = this.getShape()[2];
                        for (int ax2 = 0; ax2 < n4; ++ax2) {
                            $this$toString_u24lambda_u2426.append(ScalarsGettersAndSettersKt.genGet3(this, ax0, ax1, ax2));
                            if (ax2 >= this.getShape()[2] - 1) continue;
                            $this$toString_u24lambda_u2426.append(", ");
                        }
                        $this$toString_u24lambda_u2426.append(']');
                        if (ax1 >= this.getShape()[1] - 1) continue;
                        $this$toString_u24lambda_u2426.append(",\n");
                    }
                    $this$toString_u24lambda_u2426.append(']');
                    if (ax0 >= this.getShape()[0] - 1) continue;
                    $this$toString_u24lambda_u2426.append(",\n\n");
                }
                $this$toString_u24lambda_u2426.append(']');
                String string4 = stringBuilder.toString();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                break;
            }
            case 4: {
                StringBuilder stringBuilder;
                StringBuilder $this$toString_u24lambda_u2427 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.ndarray.data.NDArray.toString$lambda$27, org.jetbrains.kotlinx.multik.ndarray.data.D4>");
                $this$toString_u24lambda_u2427.append('[');
                int n = this.getShape()[0];
                for (int ax0 = 0; ax0 < n; ++ax0) {
                    $this$toString_u24lambda_u2427.append('[');
                    int n5 = this.getShape()[1];
                    for (int ax1 = 0; ax1 < n5; ++ax1) {
                        $this$toString_u24lambda_u2427.append('[');
                        int n6 = this.getShape()[2];
                        for (int ax2 = 0; ax2 < n6; ++ax2) {
                            $this$toString_u24lambda_u2427.append('[');
                            int n7 = this.getShape()[3];
                            for (int ax3 = 0; ax3 < n7; ++ax3) {
                                $this$toString_u24lambda_u2427.append(ScalarsGettersAndSettersKt.genGet4(this, ax0, ax1, ax2, ax3));
                                if (ax3 >= this.getShape()[3] - 1) continue;
                                $this$toString_u24lambda_u2427.append(", ");
                            }
                            $this$toString_u24lambda_u2427.append(']');
                            if (ax2 >= this.getShape()[2] - 1) continue;
                            $this$toString_u24lambda_u2427.append(",\n");
                        }
                        $this$toString_u24lambda_u2427.append(']');
                        if (ax1 >= this.getShape()[1] - 1) continue;
                        $this$toString_u24lambda_u2427.append(",\n\n");
                    }
                    $this$toString_u24lambda_u2427.append(']');
                    if (ax0 >= this.getShape()[0] - 1) continue;
                    $this$toString_u24lambda_u2427.append(",\n\n\n");
                }
                $this$toString_u24lambda_u2427.append(']');
                String string5 = stringBuilder.toString();
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                break;
            }
            default: {
                StringBuilder stringBuilder;
                StringBuilder $this$toString_u24lambda_u2428 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<*, org.jetbrains.kotlinx.multik.ndarray.data.DN>");
                $this$toString_u24lambda_u2428.append('[');
                int n = ArraysKt.first((int[])this.getShape());
                for (int ind = 0; ind < n; ++ind) {
                    int[] ax1 = new int[]{ind};
                    $this$toString_u24lambda_u2428.append(ViewGettersAndSettersKt.getV(this).get(ax1).toString());
                    if (ind >= ArraysKt.first((int[])this.getShape()) - 1) continue;
                    String newLine = StringsKt.repeat((CharSequence)"\n", (int)(((DN)this.getDim()).getD() - 1));
                    $this$toString_u24lambda_u2428.append(',' + newLine);
                }
                $this$toString_u24lambda_u2428.append(']');
                String string6 = stringBuilder.toString();
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            }
        }
        return string;
    }

    @Override
    @NotNull
    public DataType getDtype() {
        return MutableMultiArray.DefaultImpls.getDtype(this);
    }
}

