/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiIndexIterator;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiIndexProgressionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0086\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001b\u0010\u000b\u001a\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexProgression;", "", "first", "", "last", "step", "", "([I[II)V", "getFirst", "()[I", "getLast", "reverse", "getReverse", "()Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexProgression;", "reverse$delegate", "Lkotlin/Lazy;", "getStep", "()I", "equals", "", "other", "hashCode", "iterator", "", "toString", "", "multik-core"})
@SourceDebugExtension(value={"SMAP\nMultiIndexProgression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiIndexProgression.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MultiIndexProgression\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class MultiIndexProgression {
    @NotNull
    private final int[] first;
    @NotNull
    private final int[] last;
    private final int step;
    @NotNull
    private final Lazy reverse$delegate;

    public MultiIndexProgression(@NotNull int[] first, @NotNull int[] last, int step) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)last, (String)"last");
        this.first = first;
        this.last = last;
        this.step = step;
        if (!(this.step != 0)) {
            boolean $i$a$-require-MultiIndexProgression$42 = false;
            String $i$a$-require-MultiIndexProgression$42 = "Step must be non-zero.";
            throw new IllegalArgumentException($i$a$-require-MultiIndexProgression$42.toString());
        }
        if (!(this.step != Integer.MIN_VALUE)) {
            boolean $i$a$-require-MultiIndexProgression$52 = false;
            String $i$a$-require-MultiIndexProgression$52 = "Step must be greater than Int.MIN_VALUE to avoid overflow on negation.";
            throw new IllegalArgumentException($i$a$-require-MultiIndexProgression$52.toString());
        }
        if (!(this.first.length == this.last.length)) {
            boolean bl = false;
            String string = "Sizes first and last must be identical.";
            throw new IllegalArgumentException(string.toString());
        }
        this.reverse$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MultiIndexProgression>(this){
            final /* synthetic */ MultiIndexProgression this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MultiIndexProgression invoke() {
                return MultiIndexProgressionKt.downTo(this.this$0.getLast(), this.this$0.getFirst());
            }
        }));
    }

    public /* synthetic */ MultiIndexProgression(int[] nArray, int[] nArray2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(nArray, nArray2, n);
    }

    @NotNull
    public final int[] getFirst() {
        return this.first;
    }

    @NotNull
    public final int[] getLast() {
        return this.last;
    }

    public final int getStep() {
        return this.step;
    }

    @NotNull
    public final MultiIndexProgression getReverse() {
        Lazy lazy = this.reverse$delegate;
        return (MultiIndexProgression)lazy.getValue();
    }

    @NotNull
    public final Iterator<int[]> iterator() {
        return new MultiIndexIterator(this.first, this.last, this.step);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MultiIndexProgression && Arrays.equals(this.first, ((MultiIndexProgression)other).first) && Arrays.equals(this.last, ((MultiIndexProgression)other).last);
    }

    public int hashCode() {
        return ArraysKt.plus((int[])this.first, (int[])this.last).hashCode();
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default((int[])this.first, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null) + ".." + ArraysKt.joinToString$default((int[])this.last, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null);
    }
}

