/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDoubleArray;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloatArray;
import org.jetbrains.kotlinx.multik.ndarray.complex._ComplexArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewByteArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewComplexDoubleArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewComplexFloatArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewDoubleArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewFloatArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewIntArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewLongArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewShortArray;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\b\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00020\t\u001a$\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"initMemoryView", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MemoryView;", "T", "", "size", "", "dataType", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "init", "Lkotlin/Function1;", "toViewPrimitiveArray", "", "multik-core"})
@SourceDebugExtension(value={"SMAP\nMemoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewKt\n+ 2 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 3 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n*L\n1#1,1057:1\n79#2:1058\n13#3,11:1059\n*S KotlinDebug\n*F\n+ 1 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewKt\n*L\n993#1:1058\n993#1:1059,11\n*E\n"})
public final class MemoryViewKt {
    public static final /* synthetic */ <T> MemoryView<T> initMemoryView(int size) {
        DataType dataType;
        boolean $i$f$initMemoryView = false;
        DataType.Companion companion = DataType.Companion;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass type$iv = Reflection.getOrCreateKotlinClass(Object.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv.getSimpleName());
        }
        return MemoryViewKt.initMemoryView(size, dataType);
    }

    @NotNull
    public static final <T> MemoryView<T> initMemoryView(int size, @NotNull DataType dataType) {
        MemoryView memoryView;
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                memoryView = new MemoryViewByteArray(new byte[size]);
                break;
            }
            case 2: {
                memoryView = new MemoryViewShortArray(new short[size]);
                break;
            }
            case 3: {
                memoryView = new MemoryViewIntArray(new int[size]);
                break;
            }
            case 4: {
                memoryView = new MemoryViewLongArray(new long[size]);
                break;
            }
            case 5: {
                memoryView = new MemoryViewFloatArray(new float[size]);
                break;
            }
            case 6: {
                memoryView = new MemoryViewDoubleArray(new double[size]);
                break;
            }
            case 7: {
                memoryView = new MemoryViewComplexFloatArray(new ComplexFloatArray(size));
                break;
            }
            case 8: {
                memoryView = new MemoryViewComplexDoubleArray(new ComplexDoubleArray(size));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MemoryView t = memoryView;
        return t;
    }

    @NotNull
    public static final <T> MemoryView<T> initMemoryView(int size, @NotNull DataType dataType, @NotNull Function1<? super Integer, ? extends T> init) {
        MemoryView memoryView;
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                int n;
                int n2 = 0;
                Object[] objectArray = new byte[size];
                Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1);
                while (n2 < size) {
                    n = n2++;
                    objectArray[n] = ((Number)function1.invoke((Object)n)).byteValue();
                }
                Object[] objectArray2 = objectArray;
                memoryView = new MemoryViewByteArray((byte[])objectArray2);
                break;
            }
            case 2: {
                int n;
                int n2 = 0;
                Object[] objectArray = new short[size];
                Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1);
                while (n2 < size) {
                    n = n2++;
                    objectArray[n] = ((Number)function1.invoke((Object)n)).shortValue();
                }
                Object[] objectArray3 = objectArray;
                memoryView = new MemoryViewShortArray((short[])objectArray3);
                break;
            }
            case 3: {
                int n;
                int n2 = 0;
                Object[] objectArray = new int[size];
                Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1);
                while (n2 < size) {
                    n = n2++;
                    objectArray[n] = ((Number)function1.invoke((Object)n)).intValue();
                }
                Object[] objectArray4 = objectArray;
                memoryView = new MemoryViewIntArray((int[])objectArray4);
                break;
            }
            case 4: {
                int n;
                int n2 = 0;
                Object[] objectArray = new long[size];
                Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1);
                while (n2 < size) {
                    n = n2++;
                    objectArray[n] = (byte)((Number)function1.invoke((Object)n)).longValue();
                }
                Object[] objectArray5 = objectArray;
                memoryView = new MemoryViewLongArray((long[])objectArray5);
                break;
            }
            case 5: {
                int n;
                int n2 = 0;
                Object[] objectArray = new float[size];
                Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1);
                while (n2 < size) {
                    n = n2++;
                    objectArray[n] = (byte)((Number)function1.invoke((Object)n)).floatValue();
                }
                Object[] objectArray6 = objectArray;
                memoryView = new MemoryViewFloatArray((float[])objectArray6);
                break;
            }
            case 6: {
                int n;
                int n2 = 0;
                Object[] objectArray = new double[size];
                Function1 function1 = (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1);
                while (n2 < size) {
                    n = n2++;
                    objectArray[n] = (byte)((Number)function1.invoke((Object)n)).doubleValue();
                }
                Object[] objectArray7 = objectArray;
                memoryView = new MemoryViewDoubleArray((double[])objectArray7);
                break;
            }
            case 7: {
                memoryView = new MemoryViewComplexFloatArray(new ComplexFloatArray(size, (Function1<? super Integer, ComplexFloat>)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1))));
                break;
            }
            case 8: {
                memoryView = new MemoryViewComplexDoubleArray(new ComplexDoubleArray(size, (Function1<? super Integer, ? extends ComplexDouble>)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(init, (int)1))));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MemoryView t = memoryView;
        return t;
    }

    @NotNull
    public static final <T> MemoryView<T> toViewPrimitiveArray(@NotNull List<? extends T> $this$toViewPrimitiveArray, @NotNull DataType dataType) {
        MemoryView memoryView;
        Intrinsics.checkNotNullParameter($this$toViewPrimitiveArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                memoryView = new MemoryViewByteArray(CollectionsKt.toByteArray((Collection)$this$toViewPrimitiveArray));
                break;
            }
            case 2: {
                memoryView = new MemoryViewShortArray(CollectionsKt.toShortArray((Collection)$this$toViewPrimitiveArray));
                break;
            }
            case 3: {
                memoryView = new MemoryViewIntArray(CollectionsKt.toIntArray((Collection)$this$toViewPrimitiveArray));
                break;
            }
            case 4: {
                memoryView = new MemoryViewLongArray(CollectionsKt.toLongArray((Collection)$this$toViewPrimitiveArray));
                break;
            }
            case 5: {
                memoryView = new MemoryViewFloatArray(CollectionsKt.toFloatArray((Collection)$this$toViewPrimitiveArray));
                break;
            }
            case 6: {
                memoryView = new MemoryViewDoubleArray(CollectionsKt.toDoubleArray((Collection)$this$toViewPrimitiveArray));
                break;
            }
            case 7: {
                memoryView = new MemoryViewComplexFloatArray(_ComplexArraysKt.toComplexFloatArray((Collection<ComplexFloat>)$this$toViewPrimitiveArray));
                break;
            }
            case 8: {
                memoryView = new MemoryViewComplexDoubleArray(_ComplexArraysKt.toComplexDoubleArray((Collection<? extends ComplexDouble>)$this$toViewPrimitiveArray));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MemoryView t = memoryView;
        return t;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.ByteDataType.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ShortDataType.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.IntDataType.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.LongDataType.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.FloatDataType.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DoubleDataType.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ComplexFloatDataType.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ComplexDoubleDataType.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

