/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0081\b\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a\u0019\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0080\b\u001a\u0019\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0081\b\u001a\u0019\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0080\b\u001a\u0019\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0080\b\u001a\u0011\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0005H\u0080\b\u001a\u0011\u0010\u0018\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\tH\u0081\b\u001a\u001c\u0010\u0019\u001a\u00020\u0005*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a$\u0010\u001b\u001a\u00020\u0005\"\b\b\u0000\u0010\u001c*\u00020\u001d*\u00020\u001d2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0086\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u0014\u0010 \u001a\u00020\t*\u00020\t2\u0006\u0010!\u001a\u00020\u0005H\u0001\u001a\u001a\u0010\"\u001a\u00020\t*\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0000\u001a\u001e\u0010%\u001a\u0002H\u001c\"\n\b\u0000\u0010\u001c\u0018\u0001*\u00020\u001d*\u00020\u001dH\u0081\b\u00a2\u0006\u0002\u0010&\u001a!\u0010%\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d*\u00020\u001d2\u0006\u0010'\u001a\u00020(\u00a2\u0006\u0002\u0010)\u00a8\u0006*"}, d2={"checkBounds", "", "value", "", "index", "", "axis", "size", "computeStrides", "", "shape", "requireArraySizes", "rightSize", "otherSize", "requireDimension", "dim", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "shapeSize", "requireElementsWithShape", "elementSize", "requireEqualShape", "left", "right", "requirePositiveShape", "requireShapeEmpty", "actualAxis", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "compareTo", "T", "", "other", "(Ljava/lang/Number;Ljava/lang/Number;)I", "remove", "pos", "removeAll", "indices", "", "toPrimitiveType", "(Ljava/lang/Number;)Ljava/lang/Number;", "dtype", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "(Ljava/lang/Number;Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;)Ljava/lang/Number;", "multik-core"})
@SourceDebugExtension(value={"SMAP\nInternals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Internals.kt\norg/jetbrains/kotlinx/multik/ndarray/data/InternalsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,182:1\n1#2:183\n3908#3:184\n4016#3:185\n13404#3,2:186\n4017#3,2:188\n13406#3:190\n4019#3:191\n*S KotlinDebug\n*F\n+ 1 Internals.kt\norg/jetbrains/kotlinx/multik/ndarray/data/InternalsKt\n*L\n180#1:184\n180#1:185\n180#1:186,2\n180#1:188,2\n180#1:190\n180#1:191\n*E\n"})
public final class InternalsKt {
    @PublishedApi
    public static final void checkBounds(boolean value, int index, int axis, int size) {
        boolean $i$f$checkBounds = false;
        if (!value) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds shape dimension " + axis + " with size " + size);
        }
    }

    @PublishedApi
    public static final void requireDimension(@NotNull Dimension dim, int shapeSize) {
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        boolean $i$f$requireDimension = false;
        if (!(dim.getD() == shapeSize || dim.getD() > 4 && shapeSize > 4)) {
            boolean bl = false;
            String string = "Dimension doesn't match the size of the shape: dimension (" + dim.getD() + ") != " + shapeSize + " shape size.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @PublishedApi
    public static final void requireShapeEmpty(@NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        boolean $i$f$requireShapeEmpty = false;
        if (!(!(shape.length == 0))) {
            boolean bl = false;
            String string = "Shape cannot be empty.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void requireElementsWithShape(int elementSize, int shapeSize) {
        boolean $i$f$requireElementsWithShape = false;
        if (!(elementSize == shapeSize)) {
            boolean bl = false;
            String string = "The number of elements doesn't match the shape: " + elementSize + "!=" + shapeSize;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void requireArraySizes(int rightSize, int otherSize) {
        boolean $i$f$requireArraySizes = false;
        if (!(rightSize == otherSize)) {
            boolean bl = false;
            String string = "Array sizes don't match: (right operand size) " + rightSize + " != " + otherSize + " (left operand size)";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void requireEqualShape(@NotNull int[] left, @NotNull int[] right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        boolean $i$f$requireEqualShape = false;
        if (!Arrays.equals(left, right)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Array shapes don't match: ");
            String string = Arrays.toString(left);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append(" != ");
            String string2 = Arrays.toString(right);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = stringBuilder2.append(string2).toString();
            throw new IllegalArgumentException(string3.toString());
        }
    }

    public static final void requirePositiveShape(int dim) {
        boolean $i$f$requirePositiveShape = false;
        if (!(dim > 0)) {
            boolean bl = false;
            String string = "Shape must be positive but was " + dim + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final int[] computeStrides(@NotNull int[] shape) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        int[] nArray2 = Arrays.copyOf(shape, shape.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] $this$computeStrides_u24lambda_u246 = nArray = nArray2;
        boolean bl = false;
        $this$computeStrides_u24lambda_u246[ArraysKt.getLastIndex((int[])$this$computeStrides_u24lambda_u246)] = 1;
        for (int i = ArraysKt.getLastIndex((int[])$this$computeStrides_u24lambda_u246) - 1; -1 < i; --i) {
            $this$computeStrides_u24lambda_u246[i] = $this$computeStrides_u24lambda_u246[i + 1] * shape[i + 1];
        }
        return nArray;
    }

    @PublishedApi
    public static final /* synthetic */ <T extends Number> T toPrimitiveType(Number $this$toPrimitiveType) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$toPrimitiveType, (String)"<this>");
        boolean $i$f$toPrimitiveType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Number.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = $this$toPrimitiveType.byteValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            number = $this$toPrimitiveType.shortValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            number = $this$toPrimitiveType.intValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = $this$toPrimitiveType.longValue();
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf($this$toPrimitiveType.floatValue());
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = $this$toPrimitiveType.doubleValue();
        } else {
            throw new Exception("Type not defined.");
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)number;
    }

    @NotNull
    public static final <T extends Number> T toPrimitiveType(@NotNull Number $this$toPrimitiveType, @NotNull DataType dtype) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$toPrimitiveType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)dtype), (String)"dtype");
        switch (dtype.getNativeCode()) {
            case 1: {
                number = $this$toPrimitiveType.byteValue();
                break;
            }
            case 2: {
                number = $this$toPrimitiveType.shortValue();
                break;
            }
            case 3: {
                number = $this$toPrimitiveType.intValue();
                break;
            }
            case 4: {
                number = $this$toPrimitiveType.longValue();
                break;
            }
            case 5: {
                number = Float.valueOf($this$toPrimitiveType.floatValue());
                break;
            }
            case 6: {
                number = $this$toPrimitiveType.doubleValue();
                break;
            }
            default: {
                throw new Exception("Type not defined.");
            }
        }
        return (T)number;
    }

    public static final <T extends Number> int compareTo(@NotNull Number $this$compareTo, @NotNull T other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return $this$compareTo instanceof Float && other instanceof Float ? Float.compare($this$compareTo.floatValue(), other.floatValue()) : ($this$compareTo instanceof Double && other instanceof Double ? Double.compare($this$compareTo.doubleValue(), other.doubleValue()) : ($this$compareTo instanceof Integer && other instanceof Integer ? Intrinsics.compare((int)$this$compareTo.intValue(), (int)other.intValue()) : ($this$compareTo instanceof Long && other instanceof Long ? Intrinsics.compare((long)$this$compareTo.longValue(), (long)other.longValue()) : ($this$compareTo instanceof Short && other instanceof Short ? Intrinsics.compare((int)$this$compareTo.intValue(), (int)other.intValue()) : ($this$compareTo instanceof Byte && other instanceof Byte ? Intrinsics.compare((int)$this$compareTo.intValue(), (int)other.intValue()) : Double.compare($this$compareTo.doubleValue(), other.doubleValue()))))));
    }

    public static final int actualAxis(@NotNull MultiArray<?, ?> $this$actualAxis, int axis) {
        Intrinsics.checkNotNullParameter($this$actualAxis, (String)"<this>");
        return axis < 0 ? $this$actualAxis.getDim().getD() + axis : axis;
    }

    @PublishedApi
    @NotNull
    public static final int[] remove(@NotNull int[] $this$remove, int pos) {
        Intrinsics.checkNotNullParameter((Object)$this$remove, (String)"<this>");
        int n = pos;
        return n == 0 ? ArraysKt.sliceArray((int[])$this$remove, (IntRange)new IntRange(1, ArraysKt.getLastIndex((int[])$this$remove))) : (n == ArraysKt.getLastIndex((int[])$this$remove) ? ArraysKt.sliceArray((int[])$this$remove, (IntRange)RangesKt.until((int)0, (int)ArraysKt.getLastIndex((int[])$this$remove))) : ArraysKt.plus((int[])ArraysKt.sliceArray((int[])$this$remove, (IntRange)RangesKt.until((int)0, (int)pos)), (int[])ArraysKt.sliceArray((int[])$this$remove, (IntRange)new IntRange(pos + 1, ArraysKt.getLastIndex((int[])$this$remove)))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] removeAll(@NotNull int[] $this$removeAll, @NotNull List<Integer> indices) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)$this$removeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        if (indices.isEmpty()) {
            nArray = $this$removeAll;
        } else if (indices.size() == 1) {
            nArray = InternalsKt.remove($this$removeAll, ((Number)CollectionsKt.first(indices)).intValue());
        } else {
            void $this$filterIndexedTo$iv$iv;
            int[] $this$filterIndexed$iv = $this$removeAll;
            boolean $i$f$filterIndexed = false;
            int[] nArray2 = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n = index$iv$iv$iv++;
                void var13_13 = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                int index = index$iv$iv;
                boolean bl2 = false;
                if (!(!indices.contains(index))) continue;
                destination$iv$iv.add((int)element$iv$iv);
            }
            nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        }
        return nArray;
    }
}

