/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.ndarray.complex;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexArrayIteratorsKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDoubleIterator;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble_jvmKt;
import org.jetbrains.kotlinx.multik.ndarray.complex._ComplexArraysKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0013\u001a\u00020\u000bJ\b\u0010\u0014\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0006H\u0086\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;", "", "size", "", "init", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "(ILkotlin/jvm/functions/Function1;)V", "(I)V", "_size", "data", "", "getSize", "()I", "equals", "", "other", "get", "index", "getFlatArray", "hashCode", "iterator", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleIterator;", "set", "", "value", "toString", "", "multik-core"})
public final class ComplexDoubleArray {
    private final int size;
    private final int _size;
    @NotNull
    private final double[] data;

    public ComplexDoubleArray(int size) {
        this.size = size;
        this._size = this.size * 2;
        this.data = new double[this._size];
    }

    public /* synthetic */ ComplexDoubleArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getSize() {
        return this.size;
    }

    public ComplexDoubleArray(int size, @NotNull Function1<? super Integer, ? extends ComplexDouble> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size);
        for (int i = 0; i < size; ++i) {
            ComplexDouble complexDouble = (ComplexDouble)init.invoke((Object)i);
            double re = complexDouble.component1();
            double im = complexDouble.component2();
            int index = i * 2;
            this.data[index] = re;
            this.data[index + 1] = im;
        }
    }

    @NotNull
    public final ComplexDouble get(int index) {
        ComplexArraysKt.access$checkElementIndex(index, this.size);
        int i = index << 1;
        return ComplexDouble_jvmKt.ComplexDouble(this.data[i], this.data[i + 1]);
    }

    public final void set(int index, @NotNull ComplexDouble value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ComplexArraysKt.access$checkElementIndex(index, this.size);
        int i = index << 1;
        this.data[i] = value.getRe();
        this.data[i + 1] = value.getIm();
    }

    @NotNull
    public final double[] getFlatArray() {
        return this.data;
    }

    @NotNull
    public final ComplexDoubleIterator iterator() {
        return ComplexArrayIteratorsKt.iterator(this);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof ComplexDoubleArray ? _ComplexArraysKt.contentEquals(this, (ComplexDoubleArray)other) : false);
    }

    public int hashCode() {
        return _ComplexArraysKt.contentHashCode(this);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(2 + this._size * 3);
        sb.append("[");
        for (int i = 0; i < this._size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data[i] + " + " + this.data[++i] + 'i');
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public ComplexDoubleArray() {
        this(0, 1, null);
    }
}

