/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.api.stat;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.ImmutableMemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\u0007\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\t\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\u000b\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\r\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\u000f\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\u0011\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\u0013\u001a7\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u00030\u0006H\u0007\u00a2\u0006\u0002\b\u0015\u001a\u0011\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0082\b\u001a\u0011\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0010H\u0082\b\u00a8\u0006\u0016"}, d2={"abs", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "", "D", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dimension;", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "absByte", "", "absDouble", "", "absFloat", "", "absInt", "", "absLong", "", "absShort", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "absComplexDouble", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloat;", "absComplexFloat", "multik-core"})
@SourceDebugExtension(value={"SMAP\nStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Statistics.kt\norg/jetbrains/kotlinx/multik/api/stat/StatisticsKt\n+ 2 MemoryView.kt\norg/jetbrains/kotlinx/multik/ndarray/data/MemoryViewKt\n+ 3 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 4 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n*L\n1#1,172:1\n166#1:173\n172#1:174\n993#2:175\n993#2:188\n993#2:201\n993#2:214\n79#3:176\n79#3:189\n79#3:202\n79#3:215\n13#4,11:177\n13#4,11:190\n13#4,11:203\n13#4,11:216\n*S KotlinDebug\n*F\n+ 1 Statistics.kt\norg/jetbrains/kotlinx/multik/api/stat/StatisticsKt\n*L\n66#1:173\n79#1:174\n115#1:175\n128#1:188\n141#1:201\n154#1:214\n115#1:176\n128#1:189\n141#1:202\n154#1:215\n115#1:177,11\n128#1:190,11\n141#1:203,11\n154#1:216,11\n*E\n"})
public final class StatisticsKt {
    @JvmName(name="absByte")
    @NotNull
    public static final <D extends Dimension> NDArray<Byte, D> absByte(@NotNull MultiArray<Byte, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        MemoryView<Byte> ret = MemoryViewKt.initMemoryView(a.getSize(), a.getDtype());
        int index = 0;
        Iterator<Byte> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            byte element = ((Number)iterator2.next()).byteValue();
            int n = index++;
            boolean $i$f$absByte = false;
            ret.set(n, element < 0 ? (byte)(-element) : element);
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absShort")
    @NotNull
    public static final <D extends Dimension> NDArray<Short, D> absShort(@NotNull MultiArray<Short, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        MemoryView<Short> ret = MemoryViewKt.initMemoryView(a.getSize(), a.getDtype());
        int index = 0;
        Iterator<Short> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            short element = ((Number)iterator2.next()).shortValue();
            int n = index++;
            boolean $i$f$absShort = false;
            ret.set(n, element < 0 ? (short)(-element) : element);
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absInt")
    @NotNull
    public static final <D extends Dimension> NDArray<Integer, D> absInt(@NotNull MultiArray<Integer, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        MemoryView<Integer> ret = MemoryViewKt.initMemoryView(a.getSize(), a.getDtype());
        int index = 0;
        Iterator<Integer> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            int element = ((Number)iterator2.next()).intValue();
            ret.set(index++, Math.abs(element));
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absLong")
    @NotNull
    public static final <D extends Dimension> NDArray<Long, D> absLong(@NotNull MultiArray<Long, D> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        MemoryView<Long> ret = MemoryViewKt.initMemoryView(a.getSize(), a.getDtype());
        int index = 0;
        Iterator<Long> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            long element = ((Number)iterator2.next()).longValue();
            ret.set(index++, Math.abs(element));
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absFloat")
    @NotNull
    public static final <D extends Dimension> NDArray<Float, D> absFloat(@NotNull MultiArray<Float, D> a) {
        DataType dataType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int size$iv = a.getSize();
        boolean $i$f$initMemoryView = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Float.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        MemoryView<Float> ret = MemoryViewKt.initMemoryView(size$iv, dataType);
        int index = 0;
        Iterator<Float> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            float element = ((Number)iterator2.next()).floatValue();
            ret.set(index++, Float.valueOf(Math.abs(element)));
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absDouble")
    @NotNull
    public static final <D extends Dimension> NDArray<Double, D> absDouble(@NotNull MultiArray<Double, D> a) {
        DataType dataType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int size$iv = a.getSize();
        boolean $i$f$initMemoryView = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Double.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        MemoryView<Double> ret = MemoryViewKt.initMemoryView(size$iv, dataType);
        int index = 0;
        Iterator<Double> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            double element = ((Number)iterator2.next()).doubleValue();
            ret.set(index++, Math.abs(element));
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absComplexFloat")
    @NotNull
    public static final <D extends Dimension> NDArray<Float, D> absComplexFloat(@NotNull MultiArray<ComplexFloat, D> a) {
        DataType dataType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int size$iv = a.getSize();
        boolean $i$f$initMemoryView = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Float.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        MemoryView<Float> ret = MemoryViewKt.initMemoryView(size$iv, dataType);
        int index = 0;
        Iterator<ComplexFloat> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            long element = iterator2.next().unbox-impl();
            ret.set(index++, Float.valueOf(ComplexFloat.abs-impl(element)));
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    @JvmName(name="absComplexDouble")
    @NotNull
    public static final <D extends Dimension> NDArray<Double, D> absComplexDouble(@NotNull MultiArray<ComplexDouble, D> a) {
        DataType dataType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int size$iv = a.getSize();
        boolean $i$f$initMemoryView = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Double.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        MemoryView<Double> ret = MemoryViewKt.initMemoryView(size$iv, dataType);
        int index = 0;
        Iterator<ComplexDouble> iterator2 = a.iterator();
        while (iterator2.hasNext()) {
            ComplexDouble element = iterator2.next();
            ret.set(index++, element.abs());
        }
        ImmutableMemoryView immutableMemoryView = ret;
        int[] nArray = a.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        return new NDArray(immutableMemoryView, 0, nArray2, null, (Dimension)a.getDim(), null, 40, null);
    }

    private static final byte absByte(byte a) {
        boolean $i$f$absByte = false;
        return a < 0 ? (byte)(-a) : a;
    }

    private static final short absShort(short a) {
        boolean $i$f$absShort = false;
        return a < 0 ? (short)(-a) : a;
    }
}

