/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.api;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.api.DefaultEngineType;
import org.jetbrains.kotlinx.multik.api.Engine;
import org.jetbrains.kotlinx.multik.api.EngineType;
import org.jetbrains.kotlinx.multik.api.KEEngineType;
import org.jetbrains.kotlinx.multik.api.NativeEngineType;
import org.jetbrains.kotlinx.multik.api.linalg.LinAlg;
import org.jetbrains.kotlinx.multik.api.math.Math;
import org.jetbrains.kotlinx.multik.api.stat.Statistics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001f0!\"\u0002H\u001fH\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/multik/api/Multik;", "", "()V", "_engines", "", "", "Lorg/jetbrains/kotlinx/multik/api/EngineType;", "engine", "getEngine", "()Ljava/lang/String;", "engines", "", "getEngines", "()Ljava/util/Map;", "linalg", "Lorg/jetbrains/kotlinx/multik/api/linalg/LinAlg;", "getLinalg", "()Lorg/jetbrains/kotlinx/multik/api/linalg/LinAlg;", "math", "Lorg/jetbrains/kotlinx/multik/api/math/Math;", "getMath", "()Lorg/jetbrains/kotlinx/multik/api/math/Math;", "stat", "Lorg/jetbrains/kotlinx/multik/api/stat/Statistics;", "getStat", "()Lorg/jetbrains/kotlinx/multik/api/stat/Statistics;", "addEngine", "", "type", "get", "", "T", "elements", "", "([Ljava/lang/Object;)Ljava/util/List;", "setEngine", "multik-core"})
public final class Multik {
    @NotNull
    public static final Multik INSTANCE = new Multik();
    @NotNull
    private static final Map<String, EngineType> _engines;

    private Multik() {
    }

    @Nullable
    public final String getEngine() {
        return Engine.Companion.getDefaultEngine$multik_core();
    }

    @NotNull
    public final Map<String, EngineType> getEngines() {
        return _engines;
    }

    @NotNull
    public final Math getMath() {
        return Engine.Companion.getMath();
    }

    @NotNull
    public final LinAlg getLinalg() {
        return Engine.Companion.getLinAlg();
    }

    @NotNull
    public final Statistics getStat() {
        return Engine.Companion.getStatistics();
    }

    public final void addEngine(@NotNull EngineType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!_engines.containsKey(type.getName())) {
            _engines.put(type.getName(), type);
        }
    }

    public final void setEngine(@NotNull EngineType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.getEngines().containsKey(type.getName())) {
            Engine.Companion.setDefaultEngine$multik_core(type);
        }
    }

    @NotNull
    public final <T> List<T> get(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return ArraysKt.toList((Object[])elements);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEFAULT", (Object)DefaultEngineType.INSTANCE), TuplesKt.to((Object)"KOTLIN", (Object)KEEngineType.INSTANCE), TuplesKt.to((Object)"NATIVE", (Object)NativeEngineType.INSTANCE)};
        _engines = MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

