/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.models.report.anesthetic_record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.model.AnestheticRecord;
import vet.inpulse.core.models.model.Drug;
import vet.inpulse.core.models.model.DrugInfusionElement;
import vet.inpulse.core.models.model.Establishment;
import vet.inpulse.core.models.model.FullAnestheticRecord;
import vet.inpulse.core.models.model.FullPatient;
import vet.inpulse.core.models.model.MonitorEventElement;
import vet.inpulse.core.models.model.MonitorEventType;
import vet.inpulse.core.models.model.NibpResultElement;
import vet.inpulse.core.models.model.Owner;
import vet.inpulse.core.models.model.Patient;
import vet.inpulse.core.models.model.RegistrationId;
import vet.inpulse.core.models.model.Veterinarian;
import vet.inpulse.core.models.record_data.CapnoSample;
import vet.inpulse.core.models.record_data.Spo2Sample;
import vet.inpulse.core.models.record_data.TempSample;
import vet.inpulse.core.models.report.ReportBuilderUtilsKt;
import vet.inpulse.core.models.report.anesthetic_record.AnestheticReportChartData;
import vet.inpulse.core.models.report.anesthetic_record.AnestheticReportData;
import vet.inpulse.core.models.report.anesthetic_record.AnestheticReportDataBuilderConfig;
import vet.inpulse.core.models.report.anesthetic_record.AnestheticReportDrugInfusion;
import vet.inpulse.core.models.report.anesthetic_record.AnestheticReportMonitorEvent;
import vet.inpulse.core.models.report.anesthetic_record.TimedValue;
import vet.inpulse.core.models.report.shared.ReportNibpResult;
import vet.inpulse.core.models.repository.StringsRepository;
import vet.inpulse.core.models.repository.internationalization.CommonStrings;
import vet.inpulse.shared.utils.StringExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJT\u0010\u0017\u001a2\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f0\u0018j\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f`\u001c*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J4\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f*\b\u0012\u0004\u0012\u00020!0\u000fH\u0002Jx\u0010#\u001a2\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f0\u0018j\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f`\u001c26\u0010$\u001a2\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f0\u0018j\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000f`\u001c2\u0006\u0010%\u001a\u00020\u001eH\u0002J&\u0010&\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b0\u000fH\u0002J\f\u0010'\u001a\u00020(*\u00020)H\u0002J\f\u0010'\u001a\u00020**\u00020+H\u0002J\u001b\u0010'\u001a\u00020,*\u00020-2\b\u0010.\u001a\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDataBuilder;", "", "r", "Lvet/inpulse/core/models/repository/StringsRepository;", "config", "Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDataBuilderConfig;", "<init>", "(Lvet/inpulse/core/models/repository/StringsRepository;Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDataBuilderConfig;)V", "getConfig", "()Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDataBuilderConfig;", "buildReportChartData", "Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportChartData;", "fullAnestheticRecord", "Lvet/inpulse/core/models/model/FullAnestheticRecord;", "drugList", "", "Lvet/inpulse/core/models/model/Drug;", "buildReportData", "Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportData;", "asString", "", "getAsString", "(Ljava/lang/Object;)Ljava/lang/String;", "splitIfThereIsAGap", "Ljava/util/ArrayList;", "Lvet/inpulse/core/models/report/anesthetic_record/TimedValue;", "", "Lvet/inpulse/core/models/report/anesthetic_record/TimedFloat;", "Lkotlin/collections/ArrayList;", "maxGapInMs", "", "compactElementsWithinATimeFrame", "timeGap", "", "getTimeDeltas", "compactList", "list", "chunkSize", "compact", "toV1", "Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportMonitorEvent$V1;", "Lvet/inpulse/core/models/model/MonitorEventElement;", "Lvet/inpulse/core/models/report/shared/ReportNibpResult$V1;", "Lvet/inpulse/core/models/model/NibpResultElement;", "Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDrugInfusion$V1;", "Lvet/inpulse/core/models/model/DrugInfusionElement;", "maximumFinalTime", "(Lvet/inpulse/core/models/model/DrugInfusionElement;Ljava/lang/Long;)Lvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDrugInfusion$V1;", "core-models"})
@SourceDebugExtension(value={"SMAP\nAnestheticReportDataBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnestheticReportDataBuilder.kt\nvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDataBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,461:1\n1563#2:462\n1634#2,3:463\n1563#2:466\n1634#2,3:467\n774#2:470\n865#2,2:471\n1193#2,2:473\n1267#2,2:475\n774#2:477\n865#2,2:478\n1563#2:480\n1634#2,3:481\n1270#2:484\n1563#2:485\n1634#2,3:486\n1563#2:489\n1634#2,3:490\n774#2:493\n865#2,2:494\n1563#2:496\n1634#2,3:497\n774#2:500\n865#2,2:501\n1563#2:503\n1634#2,3:504\n1563#2:507\n1634#2,3:508\n1563#2:511\n1634#2,3:512\n774#2:515\n865#2,2:516\n1878#2,3:518\n1#3:521\n*S KotlinDebug\n*F\n+ 1 AnestheticReportDataBuilder.kt\nvet/inpulse/core/models/report/anesthetic_record/AnestheticReportDataBuilder\n*L\n65#1:462\n65#1:463,3\n69#1:466\n69#1:467,3\n71#1:470\n71#1:471,2\n72#1:473,2\n72#1:475,2\n73#1:477\n73#1:478,2\n76#1:480\n76#1:481,3\n72#1:484\n81#1:485\n81#1:486,3\n106#1:489\n106#1:490,3\n111#1:493\n111#1:494,2\n112#1:496\n112#1:497,3\n117#1:500\n117#1:501,2\n118#1:503\n118#1:504,3\n123#1:507\n123#1:508,3\n127#1:511\n127#1:512,3\n307#1:515\n307#1:516,2\n343#1:518,3\n*E\n"})
public final class AnestheticReportDataBuilder {
    @NotNull
    private final StringsRepository r;
    @NotNull
    private final AnestheticReportDataBuilderConfig config;

    public AnestheticReportDataBuilder(@NotNull StringsRepository r, @NotNull AnestheticReportDataBuilderConfig config) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.r = r;
        this.config = config;
    }

    public /* synthetic */ AnestheticReportDataBuilder(StringsRepository stringsRepository, AnestheticReportDataBuilderConfig anestheticReportDataBuilderConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            anestheticReportDataBuilderConfig = new AnestheticReportDataBuilderConfig(0, 0, 0, 7, null);
        }
        this(stringsRepository, anestheticReportDataBuilderConfig);
    }

    @NotNull
    public final AnestheticReportDataBuilderConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnestheticReportChartData buildReportChartData(@NotNull FullAnestheticRecord fullAnestheticRecord, @NotNull List<Drug> drugList) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv4;
        void $this$map$iv4;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Collection collection;
        void $this$mapTo$iv$iv5;
        void $this$map$iv5;
        int n;
        void $this$mapTo$iv$iv6;
        Object unit;
        Iterable $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv3;
        Iterable $this$filter$iv3;
        void $this$mapTo$iv$iv7;
        Object object;
        void $this$mapTo$iv$iv8;
        long l;
        Intrinsics.checkNotNullParameter((Object)fullAnestheticRecord, (String)"fullAnestheticRecord");
        Intrinsics.checkNotNullParameter(drugList, (String)"drugList");
        Long firstDataTime = fullAnestheticRecord.getFirstRecordDataTime();
        Long lastDataTime = fullAnestheticRecord.getLastRecordDataTime();
        if (firstDataTime != null && lastDataTime != null) {
            long deltaTime = lastDataTime - firstDataTime;
            int numPoints = RangesKt.coerceIn((int)((int)Math.ceil((double)deltaTime / 60000.0 / (double)2)), (int)1, (int)this.config.getMaxNumberPoints());
            l = deltaTime / (long)numPoints;
        } else {
            l = 180000L;
        }
        long compressionTimeGapInMs = l;
        Iterable $this$map$iv6 = fullAnestheticRecord.getNibpList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv6;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv8) {
            Iterator it;
            NibpResultElement nibpResultElement = (NibpResultElement)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.toV1((NibpResultElement)((Object)it)));
        }
        List nibpResultsList = (List)destination$iv$iv;
        List<DrugInfusionElement> allInfusions = fullAnestheticRecord.getDrugInfusionList();
        Iterable $this$map$iv7 = allInfusions;
        boolean $i$f$map22 = false;
        Iterable $i$f$mapTo22 = $this$map$iv7;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv7) {
            void it;
            DrugInfusionElement drugInfusionElement = (DrugInfusionElement)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(it.getDrugId());
        }
        List usedDrugIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        Iterable $i$f$map22 = drugList;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            Drug it = (Drug)element$iv$iv;
            boolean bl = false;
            if (!usedDrugIds.contains(it.getId())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associate$iv;
        Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv9;
            void $this$filterTo$iv$iv4;
            Map bl = destination$iv$iv4;
            Drug drug = (Drug)element$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv4 = allInfusions;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv4;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv4) {
                DrugInfusionElement it = (DrugInfusionElement)element$iv$iv2;
                boolean bl3 = false;
                if (!(it.getDrugId() == drug.getId())) continue;
                destination$iv$iv5.add(element$iv$iv2);
            }
            List infusionsWithThisDrug = (List)destination$iv$iv5;
            unit = ((DrugInfusionElement)CollectionsKt.first((List)infusionsWithThisDrug)).getReadableUnit();
            String drugReference = this.r.getDrugName(drug) + " (" + (String)unit + ")";
            Iterable $this$map$iv8 = infusionsWithThisDrug;
            boolean $i$f$map3 = false;
            Iterable iterable3 = $this$map$iv8;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv8, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv9) {
                void it;
                DrugInfusionElement drugInfusionElement = (DrugInfusionElement)item$iv$iv;
                Collection collection2 = destination$iv$iv6;
                boolean bl4 = false;
                collection2.add(this.toV1((DrugInfusionElement)it, lastDataTime));
            }
            List infusionsV1 = (List)destination$iv$iv6;
            drug = TuplesKt.to((Object)drugReference, (Object)infusionsV1);
            bl.put(drug.getFirst(), drug.getSecond());
        }
        Map drugInfusionsList = destination$iv$iv4;
        Iterable $this$map$iv9 = fullAnestheticRecord.getEventList();
        boolean $i$f$map4 = false;
        $this$associateTo$iv$iv = $this$map$iv9;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv9, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv6) {
            void it;
            MonitorEventElement bl = (MonitorEventElement)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl5 = false;
            object.add(this.toV1((MonitorEventElement)it));
        }
        List monitorEventsList = (List)destination$iv$iv4;
        if (firstDataTime != null && lastDataTime != null) {
            long deltaTime = lastDataTime - firstDataTime;
            n = RangesKt.coerceIn((int)((int)Math.ceil((double)deltaTime / 60000.0)), (int)1, (int)this.config.getMaxNumberHrvPoints());
        } else {
            n = this.config.getMaxNumberHrvPoints();
        }
        int numPointsToPlot = n;
        Iterable<List<TimedValue<Float>>> it = this.splitIfThereIsAGap(this.getTimeDeltas(fullAnestheticRecord.getEcgPulseList()), this.config.getDiscontinuityGapLimit());
        boolean bl = false;
        int numHrvToCompact22 = fullAnestheticRecord.getEcgPulseList().size() / numPointsToPlot;
        ArrayList<List<TimedValue<Float>>> hrvList = numHrvToCompact22 > 0 ? this.compactList((ArrayList<List<TimedValue<Float>>>)it, numHrvToCompact22) : it;
        it = fullAnestheticRecord.getSpo2List();
        object = this;
        boolean $i$f$map32 = false;
        void numHrvToCompact22 = $this$map$iv5;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            void it2;
            unit = (Spo2Sample)item$iv$iv;
            collection = destination$iv$iv7;
            boolean bl6 = false;
            collection.add(new TimedValue<Float>(it2.getTimestamp(), Float.valueOf(it2.getValue())));
        }
        List<TimedValue<Float>> spo2List = super.compactElementsWithinATimeFrame((List)destination$iv$iv7, compressionTimeGapInMs);
        Iterable $i$f$map32 = fullAnestheticRecord.getTempList();
        object = this;
        boolean $i$f$filter3 = false;
        destination$iv$iv7 = $this$filter$iv2;
        Collection destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            TempSample it3 = (TempSample)element$iv$iv;
            boolean bl7 = false;
            if (!(it3.getT1() > 0.0f)) continue;
            destination$iv$iv8.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv8;
        boolean $i$f$map422 = false;
        $this$filterTo$iv$iv2 = $this$map$iv4;
        destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo6 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            TempSample it3 = (TempSample)item$iv$iv;
            collection = destination$iv$iv8;
            boolean bl8 = false;
            collection.add(new TimedValue<Float>(it3.getTimestamp(), Float.valueOf(it3.getT1())));
        }
        List<TimedValue<Float>> temp1List = super.compactElementsWithinATimeFrame((List)destination$iv$iv8, compressionTimeGapInMs);
        Iterable $i$f$map422 = fullAnestheticRecord.getTempList();
        object = this;
        boolean $i$f$filter4 = false;
        destination$iv$iv8 = $this$filter$iv;
        Collection destination$iv$iv9 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TempSample it4 = (TempSample)element$iv$iv;
            boolean bl9 = false;
            if (!(it4.getT2() > 0.0f)) continue;
            destination$iv$iv9.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv9;
        boolean $i$f$map52 = false;
        $this$filterTo$iv$iv = $this$map$iv3;
        destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo7 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            TempSample it4 = (TempSample)item$iv$iv;
            collection = destination$iv$iv9;
            boolean bl10 = false;
            collection.add(new TimedValue<Float>(it4.getTimestamp(), Float.valueOf(it4.getT2())));
        }
        List<TimedValue<Float>> temp2List = super.compactElementsWithinATimeFrame((List)destination$iv$iv9, compressionTimeGapInMs);
        Iterable $i$f$map52 = fullAnestheticRecord.getCapnoList();
        object = this;
        boolean $i$f$map62 = false;
        destination$iv$iv9 = $this$map$iv2;
        Collection destination$iv$iv10 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo8 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it5;
            CapnoSample bl10 = (CapnoSample)item$iv$iv;
            collection = destination$iv$iv10;
            boolean bl11 = false;
            collection.add(new TimedValue<Float>(it5.getTimestamp(), Float.valueOf(it5.getEtCO2())));
        }
        List<TimedValue<Float>> etco2List = super.compactElementsWithinATimeFrame((List)destination$iv$iv10, compressionTimeGapInMs);
        Iterable $i$f$map62 = fullAnestheticRecord.getCapnoList();
        object = this;
        boolean $i$f$map7 = false;
        destination$iv$iv10 = $this$map$iv;
        Collection destination$iv$iv11 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo9 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            CapnoSample bl11 = (CapnoSample)item$iv$iv;
            collection = destination$iv$iv11;
            boolean bl12 = false;
            collection.add(new TimedValue<Float>(it6.getTimestamp(), Float.valueOf(it6.getRespRate())));
        }
        List<TimedValue<Float>> respRateList = super.compactElementsWithinATimeFrame((List)destination$iv$iv11, compressionTimeGapInMs);
        return new AnestheticReportChartData.V1(nibpResultsList, drugInfusionsList, monitorEventsList, (List<? extends List<TimedValue<Float>>>)hrvList, spo2List, temp1List, temp2List, etco2List, respRateList, firstDataTime, lastDataTime);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnestheticReportData buildReportData(@NotNull FullAnestheticRecord fullAnestheticRecord, @NotNull List<Drug> drugList) {
        void $this$buildReportData_u24lambda_u2421;
        StringBuilder $this$buildReportData_u24lambda_u2420;
        StringBuilder $this$buildReportData_u24lambda_u2419;
        StringBuilder $this$buildReportData_u24lambda_u2418;
        StringBuilder $this$buildReportData_u24lambda_u2417;
        StringBuilder $this$buildReportData_u24lambda_u2416;
        StringBuilder $this$buildReportData_u24lambda_u2415;
        StringBuilder stringBuilder;
        Object object;
        Object object2;
        Object stringPatient;
        Intrinsics.checkNotNullParameter((Object)fullAnestheticRecord, (String)"fullAnestheticRecord");
        Intrinsics.checkNotNullParameter(drugList, (String)"drugList");
        AnestheticRecord record = fullAnestheticRecord.getRecord();
        AnestheticReportChartData chartData = this.buildReportChartData(fullAnestheticRecord, drugList);
        Object object3 = fullAnestheticRecord.getPatient();
        if (object3 == null || (object3 = ReportBuilderUtilsKt.toReportString((FullPatient)object3, this.r, record.getRecordStart())) == null) {
            object3 = stringPatient = "-";
        }
        if ((object2 = fullAnestheticRecord.getPatient()) == null || (object2 = ((FullPatient)object2).getOwner()) == null || (object2 = ((Owner)object2).getName()) == null) {
            Object object4 = fullAnestheticRecord.getPatient();
            object2 = object4 != null && (object4 = ((FullPatient)object4).getPatient()) != null ? ((Patient)object4).getOwnerName() : null;
        }
        Object ownerName = object2;
        String string = this.r.get(CommonStrings.IDENTIFICATION).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String string2 = this.r.get(CommonStrings.PRE_EVAL).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String string3 = this.r.get(CommonStrings.PROTOCOL).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String string4 = this.r.get(CommonStrings.POST_PROCEDURE).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        Object object5 = fullAnestheticRecord.getEstablishment();
        if (object5 == null || (object5 = ((Establishment)object5).getName()) == null) {
            object5 = "";
        }
        if ((object = fullAnestheticRecord.getEstablishment()) == null || (object = ((Establishment)object).getAddress()) == null) {
            object = "";
        }
        Establishment establishment = fullAnestheticRecord.getEstablishment();
        String string5 = establishment != null ? establishment.getLogoUrl() : null;
        Veterinarian veterinarian = fullAnestheticRecord.getResponsible();
        String string6 = this.r.get(CommonStrings.RESPONSIBLE) + ": " + this.getAsString(veterinarian != null ? veterinarian.getName() : null);
        Object object6 = fullAnestheticRecord.getResponsible();
        if (object6 == null || (object6 = ((Veterinarian)object6).getProfessionalRegistration()) == null || (object6 = ((RegistrationId)object6).toString()) == null) {
            object6 = "";
        }
        Veterinarian veterinarian2 = fullAnestheticRecord.getSurgeon();
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        String string7 = this.r.get(CommonStrings.SURGEON) + ": " + this.getAsString(veterinarian2 != null ? veterinarian2.getName() : null);
        String string8 = StringsRepository.getDate$default(this.r, record.getRecordStart(), null, null, 6, null);
        String string9 = "Ref: " + this.getAsString(record.getRefCode());
        String string10 = this.r.get(CommonStrings.OWNER) + ": " + this.getAsString(ownerName);
        String string11 = this.r.get(CommonStrings.PATIENT) + ": " + (String)stringPatient;
        Object object7 = object6;
        String string12 = string6;
        String string13 = string5;
        Object object8 = object;
        Object object9 = object5;
        String string14 = string4;
        String string15 = string3;
        String string16 = string2;
        String string17 = string;
        String string18 = "";
        boolean bl = false;
        Veterinarian auxiliar1 = fullAnestheticRecord.getAuxiliary1();
        Veterinarian auxiliar2 = fullAnestheticRecord.getAuxiliary2();
        if (auxiliar1 != null || auxiliar2 != null) {
            $this$buildReportData_u24lambda_u2415.append(this.r.get(CommonStrings.AUXILIARS));
            $this$buildReportData_u24lambda_u2415.append(": ");
            if (auxiliar1 != null) {
                $this$buildReportData_u24lambda_u2415.append(auxiliar1.getName());
            }
            if (auxiliar1 != null && auxiliar2 != null) {
                $this$buildReportData_u24lambda_u2415.append(" ");
                $this$buildReportData_u24lambda_u2415.append(this.r.get(CommonStrings.AND));
                $this$buildReportData_u24lambda_u2415.append(" ");
            }
            if (auxiliar2 != null) {
                $this$buildReportData_u24lambda_u2415.append(auxiliar2.getName());
            }
        }
        Object object10 = Unit.INSTANCE;
        String string19 = stringBuilder.toString();
        $this$buildReportData_u24lambda_u2415 = stringBuilder = new StringBuilder();
        String string20 = this.r.get(CommonStrings.PAIN) + ": " + this.r.getPain(record.getPainScale());
        String string21 = this.r.get(CommonStrings.STATE) + ": " + this.r.getPatientState(record.getState());
        String string22 = this.r.get(CommonStrings.CLASSIFICATION_ASA) + ": " + this.r.getClassificationASA(record.getAsaClassification());
        String string23 = this.r.get(CommonStrings.PROCEDURE) + ": " + this.getAsString(record.getProcedureDescription());
        object10 = string19;
        boolean bl2 = false;
        $this$buildReportData_u24lambda_u2416.append(this.r.get(CommonStrings.TEMPERATURE));
        $this$buildReportData_u24lambda_u2416.append(": ");
        $this$buildReportData_u24lambda_u2416.append(this.getAsString(record.getTemperature()));
        Float f = record.getTemperature();
        float f2 = f != null ? f.floatValue() : -1.0f;
        if (f2 > 0.0f) {
            $this$buildReportData_u24lambda_u2416.append(" \u00baC");
        }
        Object object11 = Unit.INSTANCE;
        String string24 = stringBuilder.toString();
        $this$buildReportData_u24lambda_u2416 = stringBuilder = new StringBuilder();
        object11 = string24;
        boolean bl3 = false;
        $this$buildReportData_u24lambda_u2417.append(this.r.get(CommonStrings.CARDIAC_FREQUENCY));
        $this$buildReportData_u24lambda_u2417.append(": ");
        $this$buildReportData_u24lambda_u2417.append(this.getAsString(record.getCardiacFrequency()));
        Integer n = record.getCardiacFrequency();
        if ((n != null ? n : -1) > 0) {
            $this$buildReportData_u24lambda_u2417.append(" bpm");
        }
        Object object12 = Unit.INSTANCE;
        String string25 = stringBuilder.toString();
        $this$buildReportData_u24lambda_u2417 = stringBuilder = new StringBuilder();
        object12 = string25;
        boolean bl4 = false;
        $this$buildReportData_u24lambda_u2418.append(this.r.get(CommonStrings.RESPIRATORY_FREQUENCY));
        $this$buildReportData_u24lambda_u2418.append(": ");
        $this$buildReportData_u24lambda_u2418.append(this.getAsString(record.getRespiratoryFrequency()));
        Integer n2 = record.getRespiratoryFrequency();
        if ((n2 != null ? n2 : -1) > 0) {
            $this$buildReportData_u24lambda_u2418.append(" rpm");
        }
        Object object13 = Unit.INSTANCE;
        String string26 = stringBuilder.toString();
        $this$buildReportData_u24lambda_u2418 = stringBuilder = new StringBuilder();
        object13 = string26;
        boolean bl5 = false;
        $this$buildReportData_u24lambda_u2419.append(this.r.get(CommonStrings.FASTING));
        $this$buildReportData_u24lambda_u2419.append(": ");
        $this$buildReportData_u24lambda_u2419.append(this.getAsString(record.getHoursInFasting()));
        Integer n3 = record.getHoursInFasting();
        if ((n3 != null ? n3 : -1) > 0) {
            $this$buildReportData_u24lambda_u2419.append(" ");
            $this$buildReportData_u24lambda_u2419.append(this.r.get(CommonStrings.HOURS));
        }
        Object object14 = Unit.INSTANCE;
        String string27 = stringBuilder.toString();
        $this$buildReportData_u24lambda_u2419 = stringBuilder = new StringBuilder();
        String string28 = this.r.get(CommonStrings.HYDRATION) + ": " + this.r.getHydration(record.getHydrationLevel());
        object14 = string27;
        boolean bl6 = false;
        $this$buildReportData_u24lambda_u2420.append(this.r.get(CommonStrings.TPC));
        $this$buildReportData_u24lambda_u2420.append(": ");
        $this$buildReportData_u24lambda_u2420.append(this.getAsString(record.getCrt()));
        Float f3 = record.getCrt();
        float f4 = f3 != null ? f3.floatValue() : -1.0f;
        if (f4 > 0.0f) {
            $this$buildReportData_u24lambda_u2420.append(" s");
        }
        Object object15 = Unit.INSTANCE;
        String string29 = stringBuilder.toString();
        $this$buildReportData_u24lambda_u2420 = stringBuilder = new StringBuilder();
        String string30 = this.r.get(CommonStrings.REGIONAL_BLOCK) + ": " + this.getAsString(record.getRegionalBlock());
        String string31 = this.r.get(CommonStrings.INDUCTION) + ": " + this.getAsString(record.getAnestheticInductionMedication());
        String string32 = this.r.get(CommonStrings.MPA) + ": " + record.getPreanestheticMedication();
        String string33 = this.r.get(CommonStrings.VENTILATION) + ": " + this.r.getVentilation(record.getVentilation());
        String string34 = this.r.get(CommonStrings.ANESTHESIA_END) + ": " + StringsRepository.getTime$default(this.r, record.getRecordEnd(), null, 2, null);
        String string35 = this.r.get(CommonStrings.ANESTHESIA_START) + ": " + StringsRepository.getTime$default(this.r, record.getRecordStart(), null, 2, null);
        String string36 = this.r.get(CommonStrings.EXAMS) + ": " + this.getAsString(record.getPreEvalExams());
        String string37 = this.r.get(CommonStrings.DRUGS_IN_COURSE) + ": " + this.getAsString(record.getPreEvalDrugs());
        object15 = string29;
        boolean bl7 = false;
        $this$buildReportData_u24lambda_u2421.append(this.r.get(CommonStrings.COMMENTS) + ": " + this.getAsString(record.getPostAnestheticComments()));
        $this$buildReportData_u24lambda_u2421.append("\n");
        $this$buildReportData_u24lambda_u2421.append(this.r.get(CommonStrings.DRUGS) + ": " + this.getAsString(record.getPostAnestheticMedication()));
        Unit unit = Unit.INSTANCE;
        AnestheticReportChartData anestheticReportChartData = chartData;
        String string38 = stringBuilder.toString();
        String string39 = string30;
        String string40 = string31;
        String string41 = string32;
        String string42 = string33;
        String string43 = string34;
        String string44 = string35;
        String string45 = string36;
        String string46 = string37;
        Object object16 = object15;
        String string47 = string28;
        Object object17 = object14;
        Object object18 = object13;
        Object object19 = object12;
        Object object20 = object11;
        String string48 = string20;
        String string49 = string21;
        String string50 = string22;
        String string51 = string23;
        Object object21 = object10;
        String string52 = string7;
        String string53 = string8;
        String string54 = string9;
        String string55 = string10;
        String string56 = string11;
        Object object22 = object7;
        String string57 = string12;
        String string58 = string13;
        Object object23 = object8;
        Object object24 = object9;
        String string59 = string14;
        String string60 = string15;
        String string61 = string16;
        String string62 = string17;
        String string63 = string18;
        return new AnestheticReportData.V1(string63, string62, string61, string60, string59, (String)object24, (String)object23, string58, string57, (String)object22, string56, string55, string54, string53, string52, (String)object21, string51, string50, string49, string48, (String)object20, (String)object19, (String)object18, (String)object17, string47, (String)object16, string46, string45, string44, string43, string42, string41, string40, string39, string38, anestheticReportChartData);
    }

    private final String getAsString(Object $this$asString) {
        Object object;
        Object object2 = $this$asString;
        if (object2 instanceof Float) {
            object = ((Number)$this$asString).floatValue() > 0.0f ? StringExtensionsKt.toString((float)((Number)$this$asString).floatValue(), (int)1) : "-";
        } else if (object2 instanceof Integer) {
            object = ((Number)$this$asString).intValue() > 0 ? String.valueOf(((Number)$this$asString).intValue()) : "-";
        } else {
            object = $this$asString;
            if (object == null || (object = object.toString()) == null) {
                object = "-";
            }
        }
        return object;
    }

    private final ArrayList<List<TimedValue<Float>>> splitIfThereIsAGap(List<TimedValue<Float>> $this$splitIfThereIsAGap, int maxGapInMs) {
        ArrayList<List<TimedValue<Float>>> list = new ArrayList<List<TimedValue<Float>>>();
        int indexFromLastGap = 0;
        int n = ((Collection)$this$splitIfThereIsAGap).size();
        for (int index = 0; index < n; ++index) {
            long deltaTime;
            TimedValue<Float> actual = $this$splitIfThereIsAGap.get(index);
            long l = deltaTime = index == 0 ? 0L : actual.getTime() - $this$splitIfThereIsAGap.get(index - 1).getTime();
            if (deltaTime <= (long)maxGapInMs) continue;
            list.add($this$splitIfThereIsAGap.subList(indexFromLastGap, index));
            indexFromLastGap = index;
        }
        if (CollectionsKt.getLastIndex($this$splitIfThereIsAGap) > indexFromLastGap) {
            list.add($this$splitIfThereIsAGap.subList(indexFromLastGap, CollectionsKt.getLastIndex($this$splitIfThereIsAGap)));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TimedValue<Float>> compactElementsWithinATimeFrame(List<TimedValue<Float>> $this$compactElementsWithinATimeFrame, long timeGap) {
        if ($this$compactElementsWithinATimeFrame.isEmpty()) {
            return $this$compactElementsWithinATimeFrame;
        }
        ArrayList list = new ArrayList();
        long firstTime = ((TimedValue)CollectionsKt.first($this$compactElementsWithinATimeFrame)).getTime();
        long lastTime = ((TimedValue)CollectionsKt.last($this$compactElementsWithinATimeFrame)).getTime();
        long initialTimeWindow = 0L;
        initialTimeWindow = firstTime;
        long finalTimeWindow = 0L;
        finalTimeWindow = initialTimeWindow + timeGap;
        while (lastTime > initialTimeWindow) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$compactElementsWithinATimeFrame;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TimedValue it = (TimedValue)element$iv$iv;
                boolean bl = false;
                long l = it.getTime();
                boolean bl2 = initialTimeWindow <= l ? l < finalTimeWindow : false;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List subList = (List)destination$iv$iv;
            if (!((Collection)subList).isEmpty()) {
                ((Collection)list).add(this.compact(subList));
            }
            initialTimeWindow = finalTimeWindow;
            finalTimeWindow += timeGap;
        }
        return list;
    }

    private final List<TimedValue<Float>> getTimeDeltas(List<Long> $this$getTimeDeltas) {
        if ($this$getTimeDeltas.size() < 2) {
            return CollectionsKt.emptyList();
        }
        ArrayList<TimedValue<Float>> list = new ArrayList<TimedValue<Float>>($this$getTimeDeltas.size() - 1);
        int n = $this$getTimeDeltas.size();
        for (int i = 1; i < n; ++i) {
            long actualRIndex = ((Number)$this$getTimeDeltas.get(i)).longValue();
            long lastRIndex = ((Number)$this$getTimeDeltas.get(i - 1)).longValue();
            long delta = actualRIndex - lastRIndex;
            list.add(new TimedValue<Float>(actualRIndex, Float.valueOf(60000.0f / (float)delta)));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<List<TimedValue<Float>>> compactList(ArrayList<List<TimedValue<Float>>> list, int chunkSize) {
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void innerList;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv;
            int index = n;
            boolean bl = false;
            list.set(index, CollectionsKt.chunked((Iterable)((Iterable)innerList), (int)chunkSize, arg_0 -> AnestheticReportDataBuilder.compactList$lambda$24$lambda$23(this, arg_0)));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final TimedValue<Float> compact(List<TimedValue<Float>> $this$compact) {
        double d;
        double d2;
        Iterable iterable = $this$compact;
        double d3 = 0.0;
        for (Object t : iterable) {
            void it;
            TimedValue timedValue = (TimedValue)t;
            d2 = d3;
            boolean bl = false;
            d = ((Number)it.getValue()).floatValue();
            d3 = d2 + d;
        }
        double sumValue = d3;
        Iterable iterable2 = $this$compact;
        double d4 = 0.0;
        for (Object e : iterable2) {
            void it;
            TimedValue timedValue = (TimedValue)e;
            d2 = d4;
            boolean bl = false;
            d = it.getTime();
            d4 = d2 + d;
        }
        double sumTime = d4;
        return new TimedValue<Float>((long)(sumTime / (double)$this$compact.size()), Float.valueOf((float)(sumValue / (double)$this$compact.size())));
    }

    private final AnestheticReportMonitorEvent.V1 toV1(MonitorEventElement $this$toV1) {
        String string;
        String eventName = this.r.getMonitorEventType($this$toV1.getEventType());
        if ($this$toV1.getEventType() == MonitorEventType.CUSTOM) {
            string = $this$toV1.getEventDescription();
            if (string == null) {
                string = "";
            }
        } else {
            string = eventName;
        }
        String description = string;
        return new AnestheticReportMonitorEvent.V1($this$toV1.getEventType(), description, $this$toV1.getTimestamp());
    }

    private final ReportNibpResult.V1 toV1(NibpResultElement $this$toV1) {
        return new ReportNibpResult.V1($this$toV1.getTimestamp(), $this$toV1.getBloodPressureValues());
    }

    private final AnestheticReportDrugInfusion.V1 toV1(DrugInfusionElement $this$toV1, Long maximumFinalTime) {
        Long l;
        StringBuilder stringBuilder;
        StringBuilder $this$toV1_u24lambda_u2427 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toV1_u24lambda_u2427.append(StringExtensionsKt.toStringAutoPrecision((float)$this$toV1.getAmount(), (int)3));
        if ($this$toV1.getContinuous()) {
            $this$toV1_u24lambda_u2427.append("/" + $this$toV1.getTimeUnit().getUnitString());
        }
        String readableAmount = stringBuilder.toString();
        if ($this$toV1.getContinuous()) {
            l = $this$toV1.getFinalTime();
            if (l == null) {
                l = maximumFinalTime;
            }
        } else {
            l = null;
        }
        Long finalTime = l;
        return new AnestheticReportDrugInfusion.V1(readableAmount, $this$toV1.getTimestamp(), finalTime);
    }

    private static final TimedValue compactList$lambda$24$lambda$23(AnestheticReportDataBuilder this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.compact(it);
    }
}

