/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core.layout;

import androidx.window.core.layout.WindowHeightSizeClass;
import androidx.window.core.layout.WindowWidthSizeClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0013\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Landroidx/window/core/layout/WindowSizeClass;", "", "minWidthDp", "", "minHeightDp", "<init>", "(II)V", "widthDp", "", "heightDp", "(FF)V", "getMinWidthDp", "()I", "getMinHeightDp", "windowWidthSizeClass", "Landroidx/window/core/layout/WindowWidthSizeClass;", "getWindowWidthSizeClass$annotations", "()V", "getWindowWidthSizeClass", "()Landroidx/window/core/layout/WindowWidthSizeClass;", "windowHeightSizeClass", "Landroidx/window/core/layout/WindowHeightSizeClass;", "getWindowHeightSizeClass$annotations", "getWindowHeightSizeClass", "()Landroidx/window/core/layout/WindowHeightSizeClass;", "isWidthAtLeastBreakpoint", "", "widthDpBreakpoint", "isHeightAtLeastBreakpoint", "heightDpBreakpoint", "isAtLeastBreakpoint", "equals", "other", "hashCode", "toString", "", "Companion", "window-core"})
@SourceDebugExtension(value={"SMAP\nWindowSizeClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowSizeClass.kt\nandroidx/window/core/layout/WindowSizeClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1374#2:211\n1460#2,2:212\n1563#2:214\n1634#2,3:215\n1462#2,3:218\n*S KotlinDebug\n*F\n+ 1 WindowSizeClass.kt\nandroidx/window/core/layout/WindowSizeClass\n*L\n170#1:211\n170#1:212,2\n171#1:214\n171#1:215,3\n170#1:218,3\n*E\n"})
public final class WindowSizeClass {
    @NotNull
    public static final Companion Companion;
    private final int minWidthDp;
    private final int minHeightDp;
    public static final int WIDTH_DP_MEDIUM_LOWER_BOUND = 600;
    public static final int WIDTH_DP_EXPANDED_LOWER_BOUND = 840;
    public static final int HEIGHT_DP_MEDIUM_LOWER_BOUND = 480;
    public static final int HEIGHT_DP_EXPANDED_LOWER_BOUND = 900;
    @NotNull
    private static final List<Integer> WIDTH_DP_BREAKPOINTS_V1;
    @NotNull
    private static final List<Integer> HEIGHT_DP_BREAKPOINTS_V1;
    @JvmField
    @NotNull
    public static final Set<WindowSizeClass> BREAKPOINTS_V1;

    public WindowSizeClass(int minWidthDp, int minHeightDp) {
        this.minWidthDp = minWidthDp;
        this.minHeightDp = minHeightDp;
        if (!(this.minWidthDp >= 0)) {
            boolean $i$a$-require-WindowSizeClass$32 = false;
            String $i$a$-require-WindowSizeClass$32 = "Expected minWidthDp to be at least 0, minWidthDp: " + this.minWidthDp + ".";
            throw new IllegalArgumentException($i$a$-require-WindowSizeClass$32.toString());
        }
        if (!(this.minHeightDp >= 0)) {
            boolean bl = false;
            String string = "Expected minHeightDp to be at least 0, minHeightDp: " + this.minHeightDp + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getMinWidthDp() {
        return this.minWidthDp;
    }

    public final int getMinHeightDp() {
        return this.minHeightDp;
    }

    public WindowSizeClass(float widthDp, float heightDp) {
        this((int)widthDp, (int)heightDp);
    }

    @NotNull
    public final WindowWidthSizeClass getWindowWidthSizeClass() {
        return WindowWidthSizeClass.Companion.compute$window_core(this.minWidthDp);
    }

    @Deprecated(message="Use either isWidthAtLeastBreakpoint or isAtLeastBreakpoint to check matching bounds.")
    public static /* synthetic */ void getWindowWidthSizeClass$annotations() {
    }

    @NotNull
    public final WindowHeightSizeClass getWindowHeightSizeClass() {
        return WindowHeightSizeClass.Companion.compute$window_core(this.minHeightDp);
    }

    @Deprecated(message="Use either isHeightAtLeastBreakpoint or isAtLeastBreakpoint to check matching bounds.")
    public static /* synthetic */ void getWindowHeightSizeClass$annotations() {
    }

    public final boolean isWidthAtLeastBreakpoint(int widthDpBreakpoint) {
        return this.minWidthDp >= widthDpBreakpoint;
    }

    public final boolean isHeightAtLeastBreakpoint(int heightDpBreakpoint) {
        return this.minHeightDp >= heightDpBreakpoint;
    }

    public final boolean isAtLeastBreakpoint(int widthDpBreakpoint, int heightDpBreakpoint) {
        return this.isWidthAtLeastBreakpoint(widthDpBreakpoint) && this.isHeightAtLeastBreakpoint(heightDpBreakpoint);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WindowSizeClass cfr_ignored_0 = (WindowSizeClass)other;
        if (this.minWidthDp != ((WindowSizeClass)other).minWidthDp) {
            return false;
        }
        return this.minHeightDp == ((WindowSizeClass)other).minHeightDp;
    }

    public int hashCode() {
        int result = this.minWidthDp;
        result = 31 * result + this.minHeightDp;
        return result;
    }

    @NotNull
    public String toString() {
        return "WindowSizeClass(minWidthDp=" + this.minWidthDp + ", minHeightDp=" + this.minHeightDp + ")";
    }

    @JvmStatic
    @Deprecated(message="Use computeWindowSizeClass instead.", replaceWith=@ReplaceWith(expression="BREAKPOINTS_V1.computeWindowSizeClass(widthDp = dpWidth, heightDp = dpHeight)", imports={"androidx.window.core.layout.computeWindowSizeClass"}))
    @NotNull
    public static final WindowSizeClass compute(float dpWidth, float dpHeight) {
        return Companion.compute(dpWidth, dpHeight);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new Integer[]{0, 600, 840};
        WIDTH_DP_BREAKPOINTS_V1 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{0, 480, 900};
        HEIGHT_DP_BREAKPOINTS_V1 = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$flatMap$iv = WIDTH_DP_BREAKPOINTS_V1;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            int widthBp = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            Iterable $this$map$iv = HEIGHT_DP_BREAKPOINTS_V1;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heightBp;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new WindowSizeClass(widthBp, (int)heightBp));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        BREAKPOINTS_V1 = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/window/core/layout/WindowSizeClass$Companion;", "", "<init>", "()V", "WIDTH_DP_MEDIUM_LOWER_BOUND", "", "WIDTH_DP_EXPANDED_LOWER_BOUND", "HEIGHT_DP_MEDIUM_LOWER_BOUND", "HEIGHT_DP_EXPANDED_LOWER_BOUND", "WIDTH_DP_BREAKPOINTS_V1", "", "HEIGHT_DP_BREAKPOINTS_V1", "BREAKPOINTS_V1", "", "Landroidx/window/core/layout/WindowSizeClass;", "compute", "dpWidth", "", "dpHeight", "window-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Deprecated(message="Use computeWindowSizeClass instead.", replaceWith=@ReplaceWith(expression="BREAKPOINTS_V1.computeWindowSizeClass(widthDp = dpWidth, heightDp = dpHeight)", imports={"androidx.window.core.layout.computeWindowSizeClass"}))
        @NotNull
        public final WindowSizeClass compute(float dpWidth, float dpHeight) {
            int widthDp = dpWidth >= 840.0f ? 840 : (dpWidth >= 600.0f ? 600 : 0);
            int heightDp = dpHeight >= 900.0f ? 900 : (dpHeight >= 480.0f ? 480 : 0);
            return new WindowSizeClass(widthDp, heightDp);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

