/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.URIFileContent;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.http.content.JarFileContent;
import io.ktor.server.http.content.LocalFileContent;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.util.PathsKt;
import io.ktor.utils.io.InternalAPI;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u001aG\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000b\u001aS\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\n\u0010\u000f\u001a5\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0013\u0010\u0016\u001a\u00020\u0001*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a!\u0010\u0018\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\"'\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0014\u0010 \u001a\u00020\u00018\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lio/ktor/server/application/ApplicationCall;", "", "path", "resourcePackage", "Ljava/lang/ClassLoader;", "classLoader", "Lkotlin/Function1;", "Lio/ktor/http/ContentType;", "mimeResolve", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "resolveResource", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Lio/ktor/server/application/Application;", "Ljava/net/URL;", "Lkotlin/Pair;", "(Lio/ktor/server/application/Application;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "url", "resourceClasspathResource", "(Ljava/net/URL;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/io/File;", "findContainingJarFile", "(Ljava/lang/String;)Ljava/io/File;", "extension", "(Ljava/lang/String;)Ljava/lang/String;", "normalisedPath", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/concurrent/ConcurrentHashMap;", "resourceCache$delegate", "Lkotlin/Lazy;", "getResourceCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "resourceCache", "JAR_PREFIX", "Ljava/lang/String;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nStaticContentResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaticContentResolution.kt\nio/ktor/server/http/content/StaticContentResolutionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class StaticContentResolutionKt {
    @NotNull
    private static final Lazy resourceCache$delegate = LazyKt.lazy(StaticContentResolutionKt::resourceCache_delegate$lambda$0);
    @NotNull
    private static final String JAR_PREFIX = "jar:file:";

    @Nullable
    public static final OutgoingContent.ReadChannelContent resolveResource(@NotNull ApplicationCall $this$resolveResource, @NotNull String path, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String normalizedPath = StaticContentResolutionKt.normalisedPath(resourcePackage, path);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        for (URL url2 : SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration))) {
            Intrinsics.checkNotNull((Object)url2);
            OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(url2, normalizedPath, (Function1<? super URL, ContentType>)((Function1)arg_0 -> StaticContentResolutionKt.resolveResource$lambda$1(mimeResolve, arg_0)));
            if (readChannelContent == null) continue;
            OutgoingContent.ReadChannelContent content2 = readChannelContent;
            boolean bl = false;
            return content2;
        }
        return null;
    }

    public static /* synthetic */ OutgoingContent.ReadChannelContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = StaticContentResolutionKt::resolveResource$lambda$0;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, (Function1<? super String, ContentType>)function1);
    }

    private static final ConcurrentHashMap<String, URL> getResourceCache() {
        Lazy lazy = resourceCache$delegate;
        return (ConcurrentHashMap)lazy.getValue();
    }

    @Nullable
    public static final Pair<URL, OutgoingContent.ReadChannelContent> resolveResource(@NotNull Application $this$resolveResource, @NotNull String path, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super URL, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$resolveResource), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String normalizedPath = StaticContentResolutionKt.normalisedPath(resourcePackage, path);
        String cacheKey = "" + classLoader.hashCode() + '/' + normalizedPath;
        Function1 resolveContent = arg_0 -> StaticContentResolutionKt.resolveResource$lambda$3(normalizedPath, mimeResolve, arg_0);
        URL uRL = StaticContentResolutionKt.getResourceCache().get(cacheKey);
        if (uRL == null || (uRL = (Pair)resolveContent.invoke((Object)uRL)) == null) {
            Object object;
            Iterator iterator;
            block5: {
                Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
                iterator = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)).iterator();
                while (iterator.hasNext()) {
                    Object object2 = resolveContent.invoke(iterator.next());
                    if (object2 == null) continue;
                    object = object2;
                    break block5;
                }
                object = null;
            }
            Pair pair = (Pair)object;
            if (pair != null) {
                Pair pair2 = pair;
                iterator = pair2;
                boolean bl = false;
                URL url2 = (URL)iterator.component1();
                ((Map)StaticContentResolutionKt.getResourceCache()).put(cacheKey, url2);
                uRL = pair2;
            } else {
                uRL = null;
            }
        }
        return uRL;
    }

    public static /* synthetic */ Pair resolveResource$default(Application application, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = application.getEnvironment().getClassLoader();
        }
        return StaticContentResolutionKt.resolveResource(application, string, string2, classLoader, (Function1<? super URL, ContentType>)function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalAPI
    @Nullable
    public static final OutgoingContent.ReadChannelContent resourceClasspathResource(@NotNull URL url2, @NotNull String path, @NotNull Function1<? super URL, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        String string = url2.getProtocol();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 3143036: {
                if (string.equals("file")) {
                    n = 1;
                }
                break;
            }
            case -341064690: {
                if (string.equals("resource")) {
                    n = 2;
                }
                break;
            }
            case 104987: {
                if (string.equals("jar")) {
                    n = 3;
                }
                break;
            }
            case 105516: {
                if (string.equals("jrt")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String string2 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                File file2 = new File(CodecsKt.decodeURLPart$default((String)string2, (int)0, (int)0, null, (int)7, null));
                OutgoingContent.ReadChannelContent readChannelContent = file2.isFile() ? new LocalFileContent(file2, (ContentType)mimeResolve.invoke((Object)url2)) : null;
                return readChannelContent;
            }
            case 3: {
                JarFileContent jarFileContent;
                if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                    jarFileContent = null;
                } else {
                    JarFileContent jarFileContent2;
                    String string3 = url2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    File zipFile = StaticContentResolutionKt.findContainingJarFile(string3);
                    if (zipFile == null) {
                        return (OutgoingContent.ReadChannelContent)new URIFileContent(url2, (ContentType)mimeResolve.invoke((Object)url2));
                    }
                    JarFileContent it = jarFileContent2 = new JarFileContent(zipFile, path, (ContentType)mimeResolve.invoke((Object)url2));
                    boolean bl = false;
                    jarFileContent = it.isFile() ? jarFileContent2 : null;
                }
                OutgoingContent.ReadChannelContent readChannelContent = jarFileContent;
                return readChannelContent;
            }
            case 2: {
                OutgoingContent.ReadChannelContent readChannelContent = (OutgoingContent.ReadChannelContent)new URIFileContent(url2, (ContentType)mimeResolve.invoke((Object)url2));
                return readChannelContent;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final File findContainingJarFile(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (!StringsKt.startsWith$default((String)url2, (String)JAR_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        int jarPathSeparator = StringsKt.indexOf$default((CharSequence)url2, (String)"!", (int)9, (boolean)false, (int)4, null);
        if (jarPathSeparator == -1) {
            return null;
        }
        int nextJarSeparator = StringsKt.indexOf$default((CharSequence)url2, (String)"!", (int)(jarPathSeparator + 1), (boolean)false, (int)4, null);
        if (nextJarSeparator != -1) {
            throw new IllegalArgumentException("Only local jars are supported (jar:file:)");
        }
        String string = url2.substring(9, jarPathSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new File(CodecsKt.decodeURLPart$default((String)string, (int)0, (int)0, null, (int)7, null));
    }

    @NotNull
    public static final String extension(@NotNull String $this$extension) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$extension, (String)"<this>");
        Integer n2 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, (char)'/', (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it != -1 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, (char)'\\', (int)0, (boolean)false, (int)6, null);
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 != -1 ? n4 : null;
            n = n5 != null ? n5 : 0;
        }
        int indexOfName = n;
        int indexOfDot = StringsKt.indexOf$default((CharSequence)$this$extension, (char)'.', (int)indexOfName, (boolean)false, (int)4, null);
        if (indexOfDot >= 0) {
            String string2 = $this$extension.substring(indexOfDot);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    private static final String normalisedPath(String resourcePackage, String path) {
        char[] cArray = new char[]{'/', '\\'};
        List pathComponents = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (pathComponents.contains("..")) {
            throw new BadRequestException("Relative path should not contain path traversing characters: " + path, null, 2, null);
        }
        String string = resourcePackage;
        if (string == null) {
            string = "";
        }
        cArray = new char[]{'.', '/', '\\'};
        return CollectionsKt.joinToString$default((Iterable)PathsKt.normalizePathComponents(CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (Iterable)pathComponents)), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private static final ContentType resolveResource$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FileContentTypeKt.defaultForFileExtension((ContentType.Companion)ContentType.Companion, (String)it);
    }

    private static final ContentType resolveResource$lambda$1(Function1 $mimeResolve, URL it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return (ContentType)$mimeResolve.invoke((Object)StaticContentResolutionKt.extension(string));
    }

    private static final ConcurrentHashMap resourceCache_delegate$lambda$0() {
        return new ConcurrentHashMap();
    }

    private static final Pair resolveResource$lambda$3(String $normalizedPath, Function1 $mimeResolve, URL url2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(url2, $normalizedPath, (Function1<? super URL, ContentType>)$mimeResolve);
        if (readChannelContent != null) {
            OutgoingContent.ReadChannelContent it = readChannelContent;
            boolean bl = false;
            pair = TuplesKt.to((Object)url2, (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }
}

