/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.validators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"CNPJ_PATTERN", "", "verifyCNPJ", "", "strCNPJ", "shared"})
public final class CnpjValidatorKt {
    @NotNull
    private static final String CNPJ_PATTERN = "^(\\d{14})|(\\d{2}.\\d{3}.\\d{3}/\\d{4}-\\d{2})$";

    public static final boolean verifyCNPJ(@Nullable String strCNPJ) {
        boolean bl;
        CharSequence charSequence = strCNPJ;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bl = false;
        } else {
            charSequence = strCNPJ;
            if (!new Regex(CNPJ_PATTERN).matches(charSequence)) {
                bl = false;
            } else {
                int n;
                int i;
                int n2;
                int i2;
                CharSequence charSequence2 = strCNPJ;
                Regex regex = new Regex("\\D");
                String string = "";
                String trimmedCNPJ = regex.replace(charSequence2, string);
                int soma = 0;
                String string2 = trimmedCNPJ.substring(0, 12);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Object cnpjCalc = string2;
                char[] cArray = trimmedCNPJ.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                char[] chrCnpj = cArray;
                for (i2 = 0; i2 < 4; ++i2) {
                    n2 = chrCnpj[i2] - 48;
                    boolean bl2 = 0 <= n2 ? n2 < 10 : false;
                    if (!bl2) continue;
                    soma += (chrCnpj[i2] - 48) * (6 - (i2 + 1));
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    n2 = chrCnpj[i2 + 4] - 48;
                    boolean bl3 = 0 <= n2 ? n2 < 10 : false;
                    if (!bl3) continue;
                    soma += (chrCnpj[i2 + 4] - 48) * (10 - (i2 + 1));
                }
                int dig = 11 - soma % 11;
                cnpjCalc = (String)cnpjCalc + (switch (dig) {
                    case 10, 11 -> "0";
                    default -> String.valueOf(dig);
                });
                soma = 0;
                for (i = 0; i < 5; ++i) {
                    n = chrCnpj[i] - 48;
                    boolean bl4 = 0 <= n ? n < 10 : false;
                    if (!bl4) continue;
                    soma += (chrCnpj[i] - 48) * (7 - (i + 1));
                }
                for (i = 0; i < 8; ++i) {
                    n = chrCnpj[i + 5] - 48;
                    boolean bl5 = 0 <= n ? n < 10 : false;
                    if (!bl5) continue;
                    soma += (chrCnpj[i + 5] - 48) * (10 - (i + 1));
                }
                dig = 11 - soma % 11;
                cnpjCalc = (String)cnpjCalc + (switch (dig) {
                    case 10, 11 -> "0";
                    default -> String.valueOf(dig);
                });
                bl = Intrinsics.areEqual((Object)trimmedCNPJ, (Object)cnpjCalc);
            }
        }
        return bl;
    }
}

