/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.utils.collections;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001(B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u001a\b\u0004\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0018\u0012\u0004\u0012\u00020\u00150\u0006H\u0086\b\u00f8\u0001\u0000JR\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042B\u0010\u0017\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u0014\u001a\u00020\u00152\u0014\b\u0004\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150\u0006H\u0086\b\u00f8\u0001\u0000J\u0014\u0010\u001e\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002JT\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010 \u001a\u00020\u00042B\u0010\u0017\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00150\u0019J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J2\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010 \u001a\u00020\u00042\u001a\b\u0004\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0018\u0012\u0004\u0012\u00020\u00150\u0006H\u0086\b\u00f8\u0001\u0000J\u0006\u0010!\u001a\u00020\u0015J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"Lvet/inpulse/shared/utils/collections/RingBuffer;", "T", "", "capacity", "", "builder", "Lkotlin/Function1;", "<init>", "(ILkotlin/jvm/functions/Function1;)V", "getCapacity", "()I", "buffer", "", "head", "Lkotlinx/atomicfu/AtomicInt;", "tail", "full", "Lkotlinx/atomicfu/AtomicBoolean;", "size", "calculateSize", "produce", "", "amount", "op", "Lkotlin/sequences/Sequence;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "first", "second", "getAndIncrementWrapping", "consume", "desiredAmount", "clear", "getBufferChunk", "Lvet/inpulse/shared/utils/collections/RingBuffer$FirstAndSecondList;", "startIndex", "length", "toString", "", "FirstAndSecondList", "shared"})
public final class RingBuffer<T> {
    private final int capacity;
    @NotNull
    private final List<T> buffer;
    @NotNull
    private final AtomicInt head;
    @NotNull
    private final AtomicInt tail;
    @NotNull
    private final AtomicBoolean full;

    /*
     * WARNING - void declaration
     */
    public RingBuffer(int capacity, @NotNull Function1<? super Integer, ? extends T> builder) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.capacity = capacity;
        ArrayList arrayList2 = arrayList = new ArrayList(this.capacity);
        RingBuffer ringBuffer = this;
        boolean bl = false;
        int n = this.capacity;
        for (int index = 0; index < n; ++index) {
            void $this$buffer_u24lambda_u240;
            $this$buffer_u24lambda_u240.add(builder.invoke((Object)index));
        }
        ringBuffer.buffer = arrayList;
        this.head = AtomicFU.atomic((int)0);
        this.tail = AtomicFU.atomic((int)0);
        this.full = AtomicFU.atomic((boolean)false);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int size() {
        return this.calculateSize(this.head.getValue(), this.tail.getValue());
    }

    private final int calculateSize(int head, int tail) {
        int diff = head - tail;
        return diff > 0 ? diff : (diff == 0 ? (this.full.getValue() ? this.capacity : 0) : this.capacity + diff);
    }

    public final void produce(int amount, @NotNull Function1<? super Sequence<? extends T>, Unit> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        boolean $i$f$produce = false;
        this.produce(amount, (Function2)new Function2<List<? extends T>, List<? extends T>, Unit>(op){
            final /* synthetic */ Function1<Sequence<? extends T>, Unit> $op;
            {
                this.$op = $op;
            }

            public final void invoke(List<? extends T> first, List<? extends T> second) {
                Intrinsics.checkNotNullParameter(first, (String)"first");
                Intrinsics.checkNotNullParameter(second, (String)"second");
                this.$op.invoke((Object)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)first), (Sequence)CollectionsKt.asSequence((Iterable)second)));
            }
        });
    }

    public final void produce(int amount, @NotNull Function2<? super List<? extends T>, ? super List<? extends T>, Unit> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (!(amount <= this.capacity)) {
            boolean $i$a$-require-RingBuffer$produce$32 = false;
            String $i$a$-require-RingBuffer$produce$32 = "Amount to be produced should not be bigger than the buffer capacity";
            throw new IllegalArgumentException($i$a$-require-RingBuffer$produce$32.toString());
        }
        if (amount > 0) {
            int currentTail = this.tail.getValue();
            int currentHead = this.getAndIncrementWrapping(this.head, amount);
            int size = this.calculateSize(currentHead, currentTail);
            FirstAndSecondList<T> firstAndSecondList = this.getBufferChunk(currentHead, amount);
            List<T> first = firstAndSecondList.component1();
            List<T> second = firstAndSecondList.component2();
            op.invoke(first, second);
            if (amount + size >= this.capacity && this.tail.compareAndSet(currentTail, this.head.getValue())) {
                this.full.setValue(true);
            }
        }
    }

    public final void produce(@NotNull Function1<? super T, Unit> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        boolean $i$f$produce = false;
        this.produce(1, (Function2)new Function2<List<? extends T>, List<? extends T>, Unit>(op){
            final /* synthetic */ Function1<T, Unit> $op;
            {
                this.$op = $op;
            }

            public final void invoke(List<? extends T> first, List<? extends T> list) {
                Intrinsics.checkNotNullParameter(first, (String)"first");
                Intrinsics.checkNotNullParameter(list, (String)"<unused var>");
                this.$op.invoke(first.get(0));
            }
        });
    }

    private final int getAndIncrementWrapping(AtomicInt $this$getAndIncrementWrapping, int amount) {
        int newRawValue;
        int prev = 0;
        int next = 0;
        while (!$this$getAndIncrementWrapping.compareAndSet(prev, next = (newRawValue = (prev = $this$getAndIncrementWrapping.getValue()) + amount) >= this.capacity ? newRawValue - this.capacity : newRawValue)) {
        }
        return prev;
    }

    public final void consume(int desiredAmount, @NotNull Function2<? super List<? extends T>, ? super List<? extends T>, Unit> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        if (desiredAmount > 0) {
            int size = RangesKt.coerceAtMost((int)desiredAmount, (int)this.size());
            int currentTail = this.getAndIncrementWrapping(this.tail, size);
            this.full.setValue(false);
            if (size > 0) {
                FirstAndSecondList<T> firstAndSecondList = this.getBufferChunk(currentTail, size);
                List<T> first = firstAndSecondList.component1();
                List<T> second = firstAndSecondList.component2();
                op.invoke(first, second);
            }
        }
    }

    public static /* synthetic */ void consume$default(RingBuffer ringBuffer, int n, Function2 function2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ringBuffer.size();
        }
        ringBuffer.consume(n, function2);
    }

    public final void consume(int amount) {
        this.consume(amount, RingBuffer::consume$lambda$2);
    }

    public final void consume(int desiredAmount, @NotNull Function1<? super Sequence<? extends T>, Unit> op) {
        Intrinsics.checkNotNullParameter(op, (String)"op");
        boolean $i$f$consume = false;
        this.consume(desiredAmount, (Function2)new Function2<List<? extends T>, List<? extends T>, Unit>(op){
            final /* synthetic */ Function1<Sequence<? extends T>, Unit> $op;
            {
                this.$op = $op;
            }

            public final void invoke(List<? extends T> first, List<? extends T> second) {
                Intrinsics.checkNotNullParameter(first, (String)"first");
                Intrinsics.checkNotNullParameter(second, (String)"second");
                this.$op.invoke((Object)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)first), (Sequence)CollectionsKt.asSequence((Iterable)second)));
            }
        });
    }

    public static /* synthetic */ void consume$default(RingBuffer $this, int desiredAmount, Function1 op, int n, Object object) {
        if ((n & 1) != 0) {
            desiredAmount = $this.size();
        }
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        boolean $i$f$consume = false;
        $this.consume(desiredAmount, (Function2)new /* invalid duplicate definition of identical inner class */);
    }

    public final void clear() {
        this.full.setValue(false);
        this.tail.setValue(0);
        this.head.setValue(0);
    }

    private final FirstAndSecondList<T> getBufferChunk(int startIndex, int length) {
        FirstAndSecondList<T> firstAndSecondList;
        if (startIndex + length <= this.capacity) {
            firstAndSecondList = new FirstAndSecondList<T>(this.buffer.subList(startIndex, startIndex + length), CollectionsKt.emptyList());
        } else {
            int sizeBetweenCapacityAndRightIndex = this.capacity - startIndex;
            int firstChunkSize = RangesKt.coerceAtMost((int)length, (int)sizeBetweenCapacityAndRightIndex);
            List<T> first = this.buffer.subList(startIndex, startIndex + firstChunkSize);
            int numExtraElements = length - firstChunkSize;
            List<T> second = this.buffer.subList(0, numExtraElements);
            firstAndSecondList = new FirstAndSecondList<T>(first, second);
        }
        return firstAndSecondList;
    }

    @NotNull
    public String toString() {
        return "Head: " + this.head.getValue() + "   Tail: " + this.tail.getValue() + "  Buffer: " + this.buffer;
    }

    private static final Unit consume$lambda$2(List list, List list2) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)list2, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003J/\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lvet/inpulse/shared/utils/collections/RingBuffer$FirstAndSecondList;", "T", "", "first", "", "second", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getFirst", "()Ljava/util/List;", "getSecond", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "shared"})
    private static final class FirstAndSecondList<T> {
        @NotNull
        private final List<T> first;
        @NotNull
        private final List<T> second;

        public FirstAndSecondList(@NotNull List<? extends T> first, @NotNull List<? extends T> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            this.first = first;
            this.second = second;
        }

        @NotNull
        public final List<T> getFirst() {
            return this.first;
        }

        @NotNull
        public final List<T> getSecond() {
            return this.second;
        }

        @NotNull
        public final List<T> component1() {
            return this.first;
        }

        @NotNull
        public final List<T> component2() {
            return this.second;
        }

        @NotNull
        public final FirstAndSecondList<T> copy(@NotNull List<? extends T> first, @NotNull List<? extends T> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            return new FirstAndSecondList<T>(first, second);
        }

        public static /* synthetic */ FirstAndSecondList copy$default(FirstAndSecondList firstAndSecondList, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = firstAndSecondList.first;
            }
            if ((n & 2) != 0) {
                list2 = firstAndSecondList.second;
            }
            return firstAndSecondList.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "FirstAndSecondList(first=" + this.first + ", second=" + this.second + ")";
        }

        public int hashCode() {
            int result = ((Object)this.first).hashCode();
            result = result * 31 + ((Object)this.second).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FirstAndSecondList)) {
                return false;
            }
            FirstAndSecondList firstAndSecondList = (FirstAndSecondList)other;
            if (!Intrinsics.areEqual(this.first, firstAndSecondList.first)) {
                return false;
            }
            return Intrinsics.areEqual(this.second, firstAndSecondList.second);
        }
    }
}

