/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.shared.models.UUIDKt;
import vet.inpulse.shared.utils.StringExtensions_jvmKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u001a\f\u0010\u000b\u001a\u00020\n*\u0004\u0018\u00010\u0005\u001a\u0014\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e*\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u000f\u001a\u00060\rj\u0002`\u000e*\u00020\u0005\u001a\u001a\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00050\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005\u001a\u0012\u0010\u0015\u001a\u00020\u0005*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007\u001a\u0012\u0010\u0015\u001a\u00020\u0005*\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0007\u001a\u0014\u0010\u0019\u001a\u00020\u0005*\u00020\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001b"}, d2={"notAsciiRegex", "Lkotlin/text/Regex;", "getNotAsciiRegex", "()Lkotlin/text/Regex;", "normalize", "", "compareNormalized", "", "other", "containsNormalized", "", "isUuid", "toUuidOrNull", "Lkotlin/uuid/Uuid;", "Lvet/inpulse/shared/models/UUID;", "toUuid", "", "segmentText", "", "Lkotlin/ranges/IntRange;", "keyword", "toString", "", "precision", "", "toStringAutoPrecision", "maxPrecision", "shared"})
@SourceDebugExtension(value={"SMAP\nStringExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringExtensions.kt\nvet/inpulse/shared/utils/StringExtensionsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,122:1\n975#2:123\n1046#2,3:124\n*S KotlinDebug\n*F\n+ 1 StringExtensions.kt\nvet/inpulse/shared/utils/StringExtensionsKt\n*L\n64#1:123\n64#1:124,3\n*E\n"})
public final class StringExtensionsKt {
    @NotNull
    private static final Regex notAsciiRegex = new Regex("[^\\p{ASCII}]");

    @NotNull
    public static final Regex getNotAsciiRegex() {
        return notAsciiRegex;
    }

    @NotNull
    public static final String normalize(@NotNull String $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        CharSequence charSequence = StringExtensions_jvmKt.nfdNormalize($this$normalize);
        Regex regex = notAsciiRegex;
        String string = "";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    public static final int compareNormalized(@NotNull String $this$compareNormalized, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareNormalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(StringExtensionsKt.normalize($this$compareNormalized), StringExtensionsKt.normalize(other));
    }

    public static final boolean containsNormalized(@NotNull String $this$containsNormalized, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$containsNormalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return StringsKt.contains$default((CharSequence)StringExtensionsKt.normalize($this$containsNormalized), (CharSequence)StringExtensionsKt.normalize(other), (boolean)false, (int)2, null);
    }

    public static final boolean isUuid(@Nullable String $this$isUuid) {
        return StringExtensionsKt.toUuidOrNull($this$isUuid) != null;
    }

    @Nullable
    public static final Uuid toUuidOrNull(@Nullable String $this$toUuidOrNull) {
        Uuid uuid;
        if ($this$toUuidOrNull != null) {
            Uuid uuid2;
            try {
                uuid2 = StringExtensionsKt.toUuid($this$toUuidOrNull);
            }
            catch (Exception ignored) {
                uuid2 = null;
            }
            uuid = uuid2;
        } else {
            uuid = null;
        }
        return uuid;
    }

    @NotNull
    public static final Uuid toUuid(@NotNull String $this$toUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$toUuid, (String)"<this>");
        return UUIDKt.fromString(Uuid.Companion, $this$toUuid);
    }

    public static final boolean containsNormalized(@NotNull Iterable<String> $this$containsNormalized, @Nullable String other) {
        Intrinsics.checkNotNullParameter($this$containsNormalized, (String)"<this>");
        CharSequence charSequence = other;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return true;
        }
        for (String str : $this$containsNormalized) {
            if (!StringExtensionsKt.containsNormalized(str, other)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IntRange> segmentText(@NotNull String $this$segmentText, @NotNull String keyword) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$segmentText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        CharSequence $this$map$iv = StringExtensionsKt.normalize(keyword);
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.isLetterOrDigit((char)it) ? Character.valueOf((char)it) : "\\" + (char)it);
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)new Regex(string), (CharSequence)StringExtensionsKt.normalize($this$segmentText), (int)0, (int)2, null), StringExtensionsKt::segmentText$lambda$1));
    }

    @NotNull
    public static final String toString(float $this$toString, int precision) {
        return StringExtensionsKt.toString((double)$this$toString, precision);
    }

    @NotNull
    public static final String toString(double $this$toString, int precision) {
        int x = 1;
        int leftShifted = (int)Math.rint(Math.abs($this$toString) * Math.pow(10.0, precision));
        StringBuilder s = new StringBuilder(String.valueOf(leftShifted));
        int n = precision + 1 - s.length();
        if (x <= n) {
            while (true) {
                s.insert(0, "0");
                if (x == n) break;
                ++x;
            }
        }
        if (precision != 0) {
            s.insert(StringsKt.getLastIndex((CharSequence)s) - (precision - 1), ".");
        }
        if ($this$toString < 0.0) {
            s.insert(0, "-");
        }
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String toStringAutoPrecision(float $this$toStringAutoPrecision, int maxPrecision) {
        int precision = RangesKt.coerceAtLeast((int)(maxPrecision - (int)Math.log10($this$toStringAutoPrecision)), (int)0);
        return StringExtensionsKt.toString($this$toStringAutoPrecision, precision);
    }

    public static /* synthetic */ String toStringAutoPrecision$default(float f, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return StringExtensionsKt.toStringAutoPrecision(f, n);
    }

    private static final IntRange segmentText$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange();
    }
}

