/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.shared.log;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.shared.log.DefaultLoggerFormatter;
import vet.inpulse.shared.log.LogEvent;
import vet.inpulse.shared.log.LogFormatter;
import vet.inpulse.shared.log.LoggerOutput;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lvet/inpulse/shared/log/FileLoggerOutput;", "Lvet/inpulse/shared/log/LoggerOutput;", "filePath", "Lokio/Path;", "formatter", "Lvet/inpulse/shared/log/LogFormatter;", "fileSystem", "Lokio/FileSystem;", "<init>", "(Lokio/Path;Lvet/inpulse/shared/log/LogFormatter;Lokio/FileSystem;)V", "buffer", "Lokio/BufferedSink;", "open", "", "close", "output", "logEvent", "Lvet/inpulse/shared/log/LogEvent;", "shared"})
public final class FileLoggerOutput
implements LoggerOutput {
    @NotNull
    private final Path filePath;
    @NotNull
    private final LogFormatter formatter;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private BufferedSink buffer;

    public FileLoggerOutput(@NotNull Path filePath, @NotNull LogFormatter formatter, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.filePath = filePath;
        this.formatter = formatter;
        this.fileSystem = fileSystem;
    }

    public /* synthetic */ FileLoggerOutput(Path path, LogFormatter logFormatter, FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logFormatter = new DefaultLoggerFormatter(null, null, false, 6, null);
        }
        if ((n & 4) != 0) {
            fileSystem = FileSystem.SYSTEM;
        }
        this(path, logFormatter, fileSystem);
    }

    @Override
    public void open() {
        this.buffer = Okio.buffer((Sink)this.fileSystem.sink(this.filePath));
    }

    @Override
    public void close() {
        block0: {
            BufferedSink bufferedSink = this.buffer;
            if (bufferedSink == null) break block0;
            bufferedSink.close();
        }
    }

    @Override
    public void output(@NotNull LogEvent logEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
            BufferedSink bufferedSink = this.buffer;
            if (bufferedSink == null) break block0;
            bufferedSink.writeUtf8(this.formatter.format(logEvent));
        }
    }
}

