/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.record_data.NibpPulseInfo;
import vet.inpulse.core.signalprocessing.math_utils.MathUtilsKt;
import vet.inpulse.core.signalprocessing.nibp.internal.NibpPulseCalculator;
import vet.inpulse.math.SignalUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/SimpleNibpPulseCalculator;", "Lvet/inpulse/core/signalprocessing/nibp/internal/NibpPulseCalculator;", "fs", "", "<init>", "(I)V", "calculatePulsePeaks", "Lvet/inpulse/core/models/record_data/NibpPulseInfo;", "oscillometryData", "", "offset", "length", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nNibpPulseCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NibpPulseCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/SimpleNibpPulseCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n1563#2:63\n1634#2,3:64\n1056#2:67\n1563#2:68\n1634#2,3:69\n11591#3:72\n11926#3,3:73\n*S KotlinDebug\n*F\n+ 1 NibpPulseCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/SimpleNibpPulseCalculator\n*L\n33#1:63\n33#1:64,3\n34#1:67\n35#1:68\n35#1:69,3\n42#1:72\n42#1:73,3\n*E\n"})
public final class SimpleNibpPulseCalculator
implements NibpPulseCalculator {
    private final int fs;

    public SimpleNibpPulseCalculator(int fs) {
        this.fs = fs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NibpPulseInfo calculatePulsePeaks(@NotNull float[] oscillometryData, int offset, int length) {
        float f;
        void $this$mapTo$iv$iv;
        void $this$sortedBy$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)oscillometryData, (String)"oscillometryData");
        float[] filtered = new float[oscillometryData.length];
        MathUtilsKt.lowPassSignal(oscillometryData, filtered, this.fs, 1.6f, 2);
        int n = 0;
        Object object = new double[length];
        while (n < length) {
            int n2 = n++;
            object[n2] = RangesKt.coerceAtLeast((float)filtered[n2 + offset], (float)0.0f);
        }
        double[] inputToFindPeaks = object;
        object = SignalUtilsKt.findPeaks$default((double[])inputToFindPeaks, (double)0.0, (int)0, (double)0.0, (double)0.0, (boolean)false, (int)62, null);
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IndexedValue(it.getIndex(), it.getValue()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List peaks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        Iterable $this$map$iv2 = peaks;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue bl = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getIndex());
        }
        int[] deltaPeaks = MathUtilsKt.getDeltas((List)destination$iv$iv2);
        float peaksAverage = !(deltaPeaks.length == 0) ? (float)ArraysKt.average((int[])deltaPeaks) : 0.0f;
        if (!(deltaPeaks.length == 0)) {
            void $this$mapTo$iv$iv3;
            int[] $this$map$iv3 = deltaPeaks;
            boolean $i$f$map3 = false;
            int[] $i$f$mapTo22 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv3.length);
            boolean $i$f$mapTo3 = false;
            int n3 = ((void)$this$mapTo$iv$iv3).length;
            for (int i = 0; i < n3; ++i) {
                void it;
                void item$iv$iv;
                void var18_32 = item$iv$iv = $this$mapTo$iv$iv3[i];
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(Float.valueOf((float)it));
            }
            f = SignalUtilsKt.stddev((float[])CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv3)));
        } else {
            f = 0.0f;
        }
        float peaksStd = f;
        float rsd = !(deltaPeaks.length == 0) ? peaksStd / peaksAverage : 0.0f;
        return new NibpPulseInfo(peaks, peaksAverage, peaksStd, rsd, filtered, inputToFindPeaks);
    }
}

