/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.experimental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.record_data.NibpOscillometryData;
import vet.inpulse.core.models.utils.SignalProcessingAlgorithmVersion;
import vet.inpulse.core.signalprocessing.math_utils.MathUtilsKt;
import vet.inpulse.core.signalprocessing.nibp.CommonNibpCalculator;
import vet.inpulse.core.signalprocessing.nibp.SimpleNibpCalculator;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.wavelet.CoefficientRanges;
import vet.inpulse.math.wavelet.SymletKt;
import vet.inpulse.math.wavelet.Wavelet;
import vet.inpulse.math.wavelet.WaveletTransformKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/experimental/WaveletNibpCalculator;", "Lvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator;", "samplingFrequency", "", "simpleNibpCalculator", "Lvet/inpulse/core/signalprocessing/nibp/SimpleNibpCalculator;", "<init>", "(ILvet/inpulse/core/signalprocessing/nibp/SimpleNibpCalculator;)V", "version", "Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "getVersion", "()Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "calculateEnvelopes", "", "Lvet/inpulse/core/models/record_data/NibpOscillometryData;", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nWaveletNibpCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaveletNibpCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/experimental/WaveletNibpCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1056#2:185\n1056#2:186\n774#2:187\n865#2,2:188\n1056#2:190\n1056#2:192\n774#2:193\n865#2,2:194\n1056#2:196\n1#3:191\n*S KotlinDebug\n*F\n+ 1 WaveletNibpCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/experimental/WaveletNibpCalculator\n*L\n70#1:185\n110#1:186\n111#1:187\n111#1:188,2\n121#1:190\n140#1:192\n141#1:193\n141#1:194,2\n151#1:196\n*E\n"})
public final class WaveletNibpCalculator
extends CommonNibpCalculator {
    @NotNull
    private final SimpleNibpCalculator simpleNibpCalculator;
    @NotNull
    private final SignalProcessingAlgorithmVersion version;

    public WaveletNibpCalculator(int samplingFrequency, @NotNull SimpleNibpCalculator simpleNibpCalculator) {
        Intrinsics.checkNotNullParameter((Object)simpleNibpCalculator, (String)"simpleNibpCalculator");
        super(samplingFrequency);
        this.simpleNibpCalculator = simpleNibpCalculator;
        this.version = new SignalProcessingAlgorithmVersion("WAVELET-0.1");
    }

    @NotNull
    public SignalProcessingAlgorithmVersion getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void calculateEnvelopes(@NotNull NibpOscillometryData $this$calculateEnvelopes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Iterable $this$sortedBy$iv2;
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$calculateEnvelopes, (String)"<this>");
        int length = 16384;
        double[] original = new double[length];
        double[] temp1 = new double[length];
        double[] temp2 = new double[length];
        double[] temp3 = new double[length];
        double[] temp4 = new double[length];
        double[] dArray = new double[]{0.0, (double)length / 2.0, length - 1};
        double[] thresholdX = dArray;
        double[] dArray2 = new double[]{0.0, 8.0E-7, 0.0};
        double[] thresholdY = dArray2;
        int offset = $this$calculateEnvelopes.getOscillometry().length - length;
        for (int i2 = 0; i2 < length; ++i2) {
            original[i2] = $this$calculateEnvelopes.getOscillometry()[i2 + offset];
        }
        SignalUtilsKt.l2normalize((double[])original, (double[])original);
        Wavelet wavelet = SymletKt.symlet((int)7);
        CoefficientRanges ranges = WaveletTransformKt.decomposeCompact((Wavelet)wavelet, (double[])original, (int)0, (int)1, (double[])temp1, (int)0, (int)1, (int)length, (int)8);
        ArraysUtilsKt.copy((double[])temp1, (IntProgression)ranges.d(6), (double[])temp2, (IntProgression)ranges.d(6));
        ArraysUtilsKt.copy((double[])temp1, (IntProgression)ranges.d(5), (double[])temp3, (IntProgression)ranges.d(5));
        WaveletTransformKt.idwt((Wavelet)wavelet, (double[])temp2, (int)0, (int)1, (double[])temp1, (int)0, (int)1, (int)length, (int)6, (double[])temp4);
        WaveletTransformKt.idwt((Wavelet)wavelet, (double[])temp3, (int)0, (int)1, (double[])temp2, (int)0, (int)1, (int)length, (int)5, (double[])temp4);
        for (int i3 = 0; i3 < length; ++i3) {
            temp3[i3] = Math.pow(temp1[i3] + temp2[i3], 2);
        }
        Iterable $this$sortedBy$iv3 = SignalUtilsKt.findPeaks$default((double[])temp3, (double)0.0, (int)256, (double)0.0, (double)0.0, (boolean)false, (int)58, null);
        boolean $i$f$sortedBy = false;
        List peaksFound = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        for (int i4 = 0; i4 < length; ++i4) {
            temp4[i4] = i4;
        }
        SignalUtilsKt.linearInterpolate((double[])thresholdX, (double[])thresholdY, (double[])temp4, (double[])temp1);
        Pair pair = SignalUtilsKt.toLocPeaks((List)peaksFound);
        double[] recLocs = (double[])pair.component1();
        double[] recPeaks = (double[])pair.component2();
        SignalUtilsKt.linearInterpolate((double[])recLocs, (double[])recPeaks, (double[])temp4, (double[])temp2);
        for (i = 0; i < length; ++i) {
            temp3[i] = temp2[i] > temp1[i] ? 0.0 : 1.0;
        }
        for (i = 0; i < length; ++i) {
            double v = original[i];
            temp1[i] = v >= 0.0 ? v : 0.0;
        }
        Iterable v = SignalUtilsKt.findPeaks$default((double[])temp1, (double)2.0E-6, (int)200, (double)0.0, (double)0.0, (boolean)false, (int)24, null);
        boolean $i$f$sortedBy2 = false;
        $this$sortedBy$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        boolean $i$f$filter = false;
        void var20_31 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!(temp3[it.getIndex()] > 0.0 && !(((Number)it.getValue()).doubleValue() == 0.0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$calculateEnvelopes_u24lambda_u244 = $this$filter$iv2 = CollectionsKt.toMutableList((Collection)MathUtilsKt.ratioFilter((List)destination$iv$iv, 0.5, 1.7, WaveletNibpCalculator::calculateEnvelopes$lambda$3));
        boolean bl = false;
        $this$calculateEnvelopes_u24lambda_u244.add(new IndexedValue(0, (Object)0.0));
        $this$calculateEnvelopes_u24lambda_u244.add(new IndexedValue(length - 1, (Object)0.0));
        $this$filter$iv2 = $this$filter$iv2;
        $i$f$sortedBy = false;
        Pair pair2 = SignalUtilsKt.toLocPeaks((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        }));
        double[] positiveLocs = (double[])pair2.component1();
        double[] positivePeaks = (double[])pair2.component2();
        if (positiveLocs.length < 10) {
            SimpleNibpCalculator $this$calculateEnvelopes_u24lambda_u246 = this.simpleNibpCalculator;
            boolean bl2 = false;
            $this$calculateEnvelopes_u24lambda_u246.calculateEnvelopes($this$calculateEnvelopes);
            return;
        }
        for (int i5 = 0; i5 < length; ++i5) {
            double v2 = original[i5];
            temp1[i5] = v2 <= 0.0 ? v2 : 0.0;
        }
        Iterable v2 = SignalUtilsKt.findPeaks$default((double[])temp1, (double)0.0, (int)200, (double)0.0, (double)0.0, (boolean)true, (int)26, null);
        boolean $i$f$sortedBy3 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        boolean $i$f$filter2 = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl3 = false;
            if (!(temp3[it.getIndex()] > 0.0 && !(((Number)it.getValue()).doubleValue() == 0.0))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List $this$calculateEnvelopes_u24lambda_u2410 = $this$filter$iv = CollectionsKt.toMutableList((Collection)MathUtilsKt.ratioFilter((List)destination$iv$iv2, 0.5, 1.7, WaveletNibpCalculator::calculateEnvelopes$lambda$9));
        boolean bl4 = false;
        $this$calculateEnvelopes_u24lambda_u2410.add(new IndexedValue(0, (Object)0.0));
        $this$calculateEnvelopes_u24lambda_u2410.add(new IndexedValue(length - 1, (Object)0.0));
        $this$filter$iv = $this$filter$iv;
        $i$f$sortedBy = false;
        Pair pair3 = SignalUtilsKt.toLocPeaks((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        }));
        double[] negativeLocs = (double[])pair3.component1();
        double[] negativePeaks = (double[])pair3.component2();
        SignalUtilsKt.linearInterpolate((double[])positiveLocs, (double[])positivePeaks, (double[])temp4, (double[])temp1);
        SignalUtilsKt.linearInterpolate((double[])negativeLocs, (double[])negativePeaks, (double[])temp4, (double[])temp2);
        for (int i6 = 0; i6 < length; ++i6) {
            temp3[i6] = Math.abs(temp1[i6]) + Math.abs(temp2[i6]);
        }
        SignalUtilsKt.movavg((double[])temp3, (int)0, (int)1, (double[])temp1, (int)0, (int)1, (int)length, (int)600);
        int startIndex = $this$calculateEnvelopes.getEnvelope().length - length;
        for (int i7 = 0; i7 < length; ++i7) {
            $this$calculateEnvelopes.getEnvelope()[startIndex + i7] = (float)temp1[i7];
            $this$calculateEnvelopes.getRoughEnvelope()[startIndex + i7] = (float)temp1[i7];
        }
    }

    private static final double calculateEnvelopes$lambda$3(IndexedValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)it.getValue()).doubleValue();
    }

    private static final double calculateEnvelopes$lambda$9(IndexedValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)it.getValue()).doubleValue();
    }
}

