/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.record_data.NibpCuffSize;
import vet.inpulse.core.signalprocessing.nibp.internal.TheoreticalEnvelopeCalculator;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.Curve;
import vet.inpulse.math.Curves;
import vet.inpulse.math.Data;
import vet.inpulse.math.DataKt;
import vet.inpulse.math.DoubleData;
import vet.inpulse.math.ExpCurve;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.Sin3Curve;
import vet.inpulse.math.TestSignalsKt;
import vet.inpulse.math.Windowing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jt\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u000fJ8\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/NibpSyntheticProcedure;", "", "<init>", "()V", "humanCuffSin3Curve", "Lvet/inpulse/math/Sin3Curve;", "getHumanCuffSin3Curve", "()Lvet/inpulse/math/Sin3Curve;", "peakCurve", "Lvet/inpulse/math/ExpCurve;", "getPeakCurve", "()Lvet/inpulse/math/ExpCurve;", "generate", "", "slope", "", "startPressure", "endPressure", "targetBpm", "cuffSize", "Lvet/inpulse/core/models/record_data/NibpCuffSize;", "samplingRate", "peakSeconds", "envelopeStart", "envelopeStartMultiplier", "envelopeEndMultiplier", "envelopeMax", "fullTheoreticalEnvelope", "size", "", "startMult", "endMult", "startOffset", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nNibpSyntheticProcedure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NibpSyntheticProcedure.kt\nvet/inpulse/core/signalprocessing/nibp/NibpSyntheticProcedure\n+ 2 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n*L\n1#1,143:1\n962#2,9:144\n962#2,9:153\n*S KotlinDebug\n*F\n+ 1 NibpSyntheticProcedure.kt\nvet/inpulse/core/signalprocessing/nibp/NibpSyntheticProcedure\n*L\n91#1:144,9\n133#1:153,9\n*E\n"})
public final class NibpSyntheticProcedure {
    @NotNull
    public static final NibpSyntheticProcedure INSTANCE = new NibpSyntheticProcedure();
    @NotNull
    private static final Sin3Curve humanCuffSin3Curve = new Sin3Curve(270.6, 0.1328, -0.1968, 393.2, 0.6162, 1.112, 366.9, 0.6374, 4.082, 0.0);
    @NotNull
    private static final ExpCurve peakCurve = new ExpCurve(2.509, -3.766, 306.8, -0.004381, -309.3);

    private NibpSyntheticProcedure() {
    }

    @NotNull
    public final Sin3Curve getHumanCuffSin3Curve() {
        return humanCuffSin3Curve;
    }

    @NotNull
    public final ExpCurve getPeakCurve() {
        return peakCurve;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[] generate(double slope, double startPressure, double endPressure, double targetBpm, @NotNull NibpCuffSize cuffSize, double samplingRate, double peakSeconds, double envelopeStart, double envelopeStartMultiplier, double envelopeEndMultiplier, double envelopeMax) {
        Intrinsics.checkNotNullParameter((Object)cuffSize, (String)"cuffSize");
        double durationSeconds = (endPressure - startPressure) / slope;
        int signalSize = (int)(samplingRate * durationSeconds);
        double[] fullTheoreticalEnvelope = this.fullTheoreticalEnvelope(signalSize, samplingRate, slope, envelopeStartMultiplier, envelopeEndMultiplier, (int)(samplingRate * durationSeconds * envelopeStart));
        SignalUtilsKt.rescaleInplace((Data)((Data)DataKt.asData$default((double[])fullTheoreticalEnvelope, (int)0, (int)0, (int)0, (int)7, null)), (double)envelopeMax);
        double bpmRatio = TestSignalsKt.getNibpOnePumpOriginalBpm() / targetBpm;
        double[] onePumpBpm = SignalUtilsKt.linearInterpolate((double[])TestSignalsKt.getNibpOnePumpSignal(), (int)((int)Math.floor((double)TestSignalsKt.getNibpOnePumpSignal().length * bpmRatio)));
        DoubleData raw = DataKt.asData$default((double[])new double[signalSize], (int)0, (int)0, (int)0, (int)7, null);
        SignalUtilsKt.signalRepeat$default((Data)((Data)raw), (Data)((Data)DataKt.asData$default((double[])onePumpBpm, (int)0, (int)0, (int)0, (int)7, null)), (int)0, (int)4, null);
        SignalUtilsKt.signalMultiplyInplace((Data)((Data)raw), (Data)((Data)DataKt.asData$default((double[])fullTheoreticalEnvelope, (int)0, (int)0, (int)0, (int)7, null)));
        double[] slopeSignal = SignalUtilsKt.linspace((int)signalSize, (double)startPressure, (double)endPressure);
        SignalUtilsKt.signalSumInplaceRepeat((Data)((Data)raw), (Data)((Data)DataKt.asData$default((double[])slopeSignal, (int)0, (int)0, (int)0, (int)7, null)));
        double[] peak = Curves.INSTANCE.generateCurve(0.0, peakSeconds, 1.0 / samplingRate, (Curve)peakCurve);
        double peakOffset = peak[ArraysKt.getLastIndex((double[])peak)];
        Data data$iv = (Data)DataKt.asData$default((double[])peak, (int)0, (int)0, (int)0, (int)7, null);
        int length$iv = data$iv.getLength();
        boolean $i$f$transformInplace = false;
        int i$iv = 0;
        while (i$iv < length$iv) {
            void it;
            double d = data$iv.get(i$iv);
            int n = i$iv++;
            Data data = data$iv;
            boolean bl = false;
            void var43_31 = it + raw.get(0) - peakOffset;
            data.set(n, (double)var43_31);
        }
        Sin3Curve cuffInflationCurve = switch (WhenMappings.$EnumSwitchMapping$0[cuffSize.ordinal()]) {
            case 1 -> humanCuffSin3Curve;
            case 2 -> humanCuffSin3Curve;
            case 3 -> humanCuffSin3Curve;
            case 4 -> humanCuffSin3Curve;
            case 5 -> humanCuffSin3Curve;
            case 6 -> humanCuffSin3Curve;
            default -> throw new NoWhenBranchMatchedException();
        };
        double[] inflation = Curves.INSTANCE.generateUntil(0.0, 1.0 / samplingRate, (Curve)cuffInflationCurve, (arg_0, arg_1) -> NibpSyntheticProcedure.generate$lambda$1(peak, arg_0, arg_1));
        List procedure = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ArraysKt.asList((double[])inflation), (Iterable)ArraysKt.asList((double[])peak)), (Iterable)ArraysKt.asList((double[])raw.getData()));
        return CollectionsKt.toDoubleArray((Collection)procedure);
    }

    public static /* synthetic */ double[] generate$default(NibpSyntheticProcedure nibpSyntheticProcedure, double d, double d2, double d3, double d4, NibpCuffSize nibpCuffSize, double d5, double d6, double d7, double d8, double d9, double d10, int n, Object object) {
        if ((n & 1) != 0) {
            d = -8.0;
        }
        if ((n & 2) != 0) {
            d2 = 250.0;
        }
        if ((n & 4) != 0) {
            d3 = 30.0;
        }
        if ((n & 8) != 0) {
            d4 = 60.0;
        }
        if ((n & 0x10) != 0) {
            nibpCuffSize = NibpCuffSize.HUMAN;
        }
        if ((n & 0x20) != 0) {
            d5 = 600.0;
        }
        if ((n & 0x40) != 0) {
            d6 = 2.0;
        }
        if ((n & 0x80) != 0) {
            d7 = 0.3;
        }
        if ((n & 0x100) != 0) {
            d8 = 0.2;
        }
        if ((n & 0x200) != 0) {
            d9 = 0.4;
        }
        if ((n & 0x400) != 0) {
            d10 = 1.0;
        }
        return nibpSyntheticProcedure.generate(d, d2, d3, d4, nibpCuffSize, d5, d6, d7, d8, d9, d10);
    }

    /*
     * WARNING - void declaration
     */
    private final double[] fullTheoreticalEnvelope(int size, double samplingRate, double slope, double startMult, double endMult, int startOffset) {
        TheoreticalEnvelopeCalculator theoreticalEnvelopeCalculator = new TheoreticalEnvelopeCalculator(MathKt.roundToInt((double)samplingRate));
        float[] envelope = TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$default(theoreticalEnvelopeCalculator, (float)Math.abs(slope), 0.0f, 0.0f, 6, null);
        double[] window = Windowing.INSTANCE.planckTaper(envelope.length, 0.1).getData();
        SignalUtilsKt.signalMultiplyInplace((Data)((Data)DataKt.asData$default((float[])envelope, (int)0, (int)0, (int)0, (int)7, null)), (Data)((Data)DataKt.asData$default((double[])window, (int)0, (int)0, (int)0, (int)7, null)));
        double[] raw = new double[size];
        SignalUtilsKt.smoothstep((Data)((Data)DataKt.asData$default((double[])raw, (int)startOffset, (int)0, (int)RangesKt.coerceAtMost((int)envelope.length, (int)(raw.length - startOffset)), (int)2, null)));
        int endOffset = RangesKt.coerceAtMost((int)(startOffset + envelope.length), (int)raw.length);
        ArraysUtilsKt.fill((double[])raw, (int)endOffset, (int)(raw.length - endOffset), (double)1.0);
        SignalUtilsKt.rescaleInplace((Data)((Data)DataKt.asData$default((double[])raw, (int)0, (int)0, (int)0, (int)7, null)), (double)(endMult - startMult));
        Data data$iv = (Data)DataKt.asData$default((double[])raw, (int)0, (int)0, (int)0, (int)7, null);
        int length$iv = data$iv.getLength();
        boolean $i$f$transformInplace = false;
        int i$iv = 0;
        while (i$iv < length$iv) {
            void it;
            double d = data$iv.get(i$iv);
            int n = i$iv++;
            Data data = data$iv;
            boolean bl = false;
            void var25_20 = it + startMult;
            data.set(n, (double)var25_20);
        }
        SignalUtilsKt.signalSumInplace((Data)((Data)DataKt.asData$default((double[])raw, (int)startOffset, (int)0, (int)(raw.length - startOffset), (int)2, null)), (Data)((Data)DataKt.asData$default((float[])envelope, (int)0, (int)0, (int)0, (int)7, null)));
        SignalUtilsKt.rescaleInplace((Data)((Data)DataKt.asData$default((double[])raw, (int)0, (int)0, (int)0, (int)7, null)), (double)1.0);
        return raw;
    }

    private static final boolean generate$lambda$1(double[] $peak, double d, double y) {
        return y > $peak[0];
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NibpCuffSize.values().length];
            try {
                nArray[NibpCuffSize.NEONATE_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpCuffSize.NEONATE_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpCuffSize.NEONATE_3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpCuffSize.NEONATE_4.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpCuffSize.NEONATE_5.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NibpCuffSize.HUMAN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

