/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.model.NibpCalculator;
import vet.inpulse.core.models.record_data.BloodPressureIndex;
import vet.inpulse.core.models.record_data.BloodPressureIndexes;
import vet.inpulse.core.models.record_data.NibpCalculatorOutput;
import vet.inpulse.core.models.record_data.NibpMeasurementScores;
import vet.inpulse.core.models.record_data.NibpModelsKt;
import vet.inpulse.core.models.record_data.NibpOscillometryData;
import vet.inpulse.core.models.record_data.NibpPulseInfo;
import vet.inpulse.core.models.record_data.PulsePerMinute;
import vet.inpulse.core.signalprocessing.math_utils.MathUtilsKt;
import vet.inpulse.core.signalprocessing.nibp.internal.KsCalculator;
import vet.inpulse.core.signalprocessing.nibp.internal.NibpMeasurementScoreCalculator;
import vet.inpulse.core.signalprocessing.nibp.internal.NibpTheoreticalScoreCalculator;
import vet.inpulse.core.signalprocessing.nibp.internal.SimpleNibpPulseCalculator;
import vet.inpulse.core.signalprocessing.nibp.internal.TheoreticalScoreCalculatorResult;
import vet.inpulse.shared.utils.collections.CollectionsUtilsKt;
import vet.inpulse.sigproc.filters.CombinedFilter;
import vet.inpulse.sigproc.filters.Filter;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001:\u0001FB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH&J\u001e\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u0003H\u0016J?\u0010$\u001a\u00020%2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010*J1\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010,J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0016J\u001f\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u000106H\u0016\u00a2\u0006\u0002\u00107J)\u00108\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u00109J\u001d\u0010:\u001a\u00020;2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b=J%\u0010>\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b@J\u0018\u0010A\u001a\u00020\u001d2\u0006\u0010B\u001a\u0002002\u0006\u0010C\u001a\u000200H\u0002J\u001d\u0010D\u001a\u00020\u001d2\u0006\u0010B\u001a\u0002002\u0006\u0010C\u001a\u000200H\u0000\u00a2\u0006\u0002\bER\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0003X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006G"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator;", "Lvet/inpulse/core/models/model/NibpCalculator;", "samplingFrequency", "", "<init>", "(I)V", "getSamplingFrequency", "()I", "ksCalculator", "Lvet/inpulse/core/signalprocessing/nibp/internal/KsCalculator;", "getKsCalculator", "()Lvet/inpulse/core/signalprocessing/nibp/internal/KsCalculator;", "leftTrimThreshold", "getLeftTrimThreshold", "rightTrimThreshold", "getRightTrimThreshold", "minimumDifferenceBetweenMeanAndSystolicPressures", "maximumDifferenceBetweenMeanAndSystolicPressures", "theoreticalScoreCalculator", "Lvet/inpulse/core/signalprocessing/nibp/internal/NibpTheoreticalScoreCalculator;", "scoreCalculator", "Lvet/inpulse/core/signalprocessing/nibp/internal/NibpMeasurementScoreCalculator;", "getScoreCalculator", "()Lvet/inpulse/core/signalprocessing/nibp/internal/NibpMeasurementScoreCalculator;", "pulseCalculator", "Lvet/inpulse/core/signalprocessing/nibp/internal/SimpleNibpPulseCalculator;", "getPulseCalculator", "()Lvet/inpulse/core/signalprocessing/nibp/internal/SimpleNibpPulseCalculator;", "calculateEnvelopes", "", "Lvet/inpulse/core/models/record_data/NibpOscillometryData;", "calculateOscillometryData", "rawBloodPressure", "", "", "startDeflationIndex", "calculateResult", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "timestamp", "", "customLeftTrim", "customRightTrim", "(Ljava/util/List;IJLjava/lang/Integer;Ljava/lang/Integer;)Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "data", "(Lvet/inpulse/core/models/record_data/NibpOscillometryData;JLjava/lang/Integer;Ljava/lang/Integer;)Lvet/inpulse/core/models/record_data/NibpCalculatorOutput;", "calculatePulsePeaks", "Lvet/inpulse/core/models/record_data/NibpPulseInfo;", "oscillometryData", "", "offset", "length", "calculateScores", "Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "systolicOutOfBounds", "", "(Lvet/inpulse/core/models/record_data/NibpOscillometryData;Ljava/lang/Boolean;)Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "calculateMeanIndex", "(Lvet/inpulse/core/models/record_data/NibpOscillometryData;Ljava/lang/Integer;Ljava/lang/Integer;)I", "calculateSystolicIndex", "Lvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator$SystolicPressureResult;", "indexMeanPressure", "calculateSystolicIndex$core_signal_processing", "calculateDiastolicIndex", "indexSystolicPressure", "calculateDiastolicIndex$core_signal_processing", "calculateDeflationCurve", "source", "dest", "calculateOscilometricCurve", "calculateOscilometricCurve$core_signal_processing", "SystolicPressureResult", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nCommonNibpCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonNibpCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,345:1\n1999#2,14:346\n388#2,7:361\n360#2,7:368\n388#2,7:375\n388#2,7:388\n1#3:360\n1940#4,6:382\n*S KotlinDebug\n*F\n+ 1 CommonNibpCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator\n*L\n232#1:346,14\n268#1:361,7\n303#1:368,7\n129#1:375,7\n249#1:388,7\n135#1:382,6\n*E\n"})
public abstract class CommonNibpCalculator
implements NibpCalculator {
    private final int samplingFrequency;
    @NotNull
    private final KsCalculator ksCalculator;
    private final int leftTrimThreshold;
    private final int rightTrimThreshold;
    private final int minimumDifferenceBetweenMeanAndSystolicPressures;
    private final int maximumDifferenceBetweenMeanAndSystolicPressures;
    @NotNull
    private final NibpTheoreticalScoreCalculator theoreticalScoreCalculator;
    @NotNull
    private final NibpMeasurementScoreCalculator scoreCalculator;
    @NotNull
    private final SimpleNibpPulseCalculator pulseCalculator;

    public CommonNibpCalculator(int samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
        this.ksCalculator = new KsCalculator((Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(60.0f), (Object)Float.valueOf(0.6f)), (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(120.0f), (Object)Float.valueOf(0.45f)));
        this.leftTrimThreshold = 50;
        this.rightTrimThreshold = 40;
        this.minimumDifferenceBetweenMeanAndSystolicPressures = 8;
        this.maximumDifferenceBetweenMeanAndSystolicPressures = 40;
        this.theoreticalScoreCalculator = new NibpTheoreticalScoreCalculator(this.getSamplingFrequency(), null, 2, null);
        this.scoreCalculator = new NibpMeasurementScoreCalculator(this.getSamplingFrequency());
        this.pulseCalculator = new SimpleNibpPulseCalculator(this.getSamplingFrequency());
    }

    public int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    @NotNull
    protected final KsCalculator getKsCalculator() {
        return this.ksCalculator;
    }

    protected final int getLeftTrimThreshold() {
        return this.leftTrimThreshold;
    }

    protected final int getRightTrimThreshold() {
        return this.rightTrimThreshold;
    }

    @NotNull
    public final NibpMeasurementScoreCalculator getScoreCalculator() {
        return this.scoreCalculator;
    }

    @NotNull
    public final SimpleNibpPulseCalculator getPulseCalculator() {
        return this.pulseCalculator;
    }

    public abstract void calculateEnvelopes(@NotNull NibpOscillometryData var1);

    @NotNull
    public NibpOscillometryData calculateOscillometryData(@NotNull List<Float> rawBloodPressure, int startDeflationIndex) {
        NibpOscillometryData nibpOscillometryData;
        Intrinsics.checkNotNullParameter(rawBloodPressure, (String)"rawBloodPressure");
        float[] rawFloatArray = CollectionsKt.toFloatArray((Collection)CollectionsUtilsKt.fromIndex(rawBloodPressure, (int)startDeflationIndex));
        float[] deflation = new float[rawFloatArray.length];
        float[] oscillometry = new float[rawFloatArray.length];
        float[] envelope = new float[rawFloatArray.length];
        float[] roughEnvelope = new float[rawFloatArray.length];
        this.calculateDeflationCurve(rawFloatArray, deflation);
        this.calculateOscilometricCurve$core_signal_processing(rawFloatArray, oscillometry);
        NibpOscillometryData $this$calculateOscillometryData_u24lambda_u240 = nibpOscillometryData = new NibpOscillometryData(rawBloodPressure, startDeflationIndex, deflation, oscillometry, roughEnvelope, envelope);
        boolean bl = false;
        this.calculateEnvelopes($this$calculateOscillometryData_u24lambda_u240);
        return nibpOscillometryData;
    }

    @NotNull
    public NibpCalculatorOutput calculateResult(@NotNull List<Float> rawBloodPressure, int startDeflationIndex, long timestamp, @Nullable Integer customLeftTrim, @Nullable Integer customRightTrim) {
        NibpCalculatorOutput nibpCalculatorOutput;
        Intrinsics.checkNotNullParameter(rawBloodPressure, (String)"rawBloodPressure");
        try {
            NibpOscillometryData data = this.calculateOscillometryData(rawBloodPressure, startDeflationIndex);
            nibpCalculatorOutput = this.calculateResult(data, timestamp, customLeftTrim, customRightTrim);
        }
        catch (Exception e) {
            nibpCalculatorOutput = (NibpCalculatorOutput)new NibpCalculatorOutput.Failed(timestamp, (Throwable)e);
        }
        return nibpCalculatorOutput;
    }

    @NotNull
    public NibpCalculatorOutput calculateResult(@NotNull NibpOscillometryData data, long timestamp, @Nullable Integer customLeftTrim, @Nullable Integer customRightTrim) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            int indexMean = this.calculateMeanIndex(data, customLeftTrim, customRightTrim);
            SystolicPressureResult systolicPressureResult = this.calculateSystolicIndex$core_signal_processing(data, indexMean);
            int indexSystolic = systolicPressureResult.component1();
            boolean systolicOutOfBounds = systolicPressureResult.component2();
            int indexDiastolic = this.calculateDiastolicIndex$core_signal_processing(data, indexSystolic, indexMean);
            Integer n = customLeftTrim;
            int indexLeftTrim = n != null ? n : CommonNibpCalculator.calculateResult$findLeftTrim(data, this, indexSystolic);
            Integer n2 = customRightTrim;
            int indexRightTrim = n2 != null ? n2 : CommonNibpCalculator.calculateResult$findRightTrim(data, this, indexDiastolic);
            NibpMeasurementScores scores = this.scoreCalculator.calculateScores(data, systolicOutOfBounds);
            PulsePerMinute pulsePerMinute = this.pulseCalculator.calculatePulsePeaks(data.getOscillometry(), indexLeftTrim, indexRightTrim - indexLeftTrim).pulsePerMinute-Bd7UW9M(this.getSamplingFrequency());
            BloodPressureIndexes bpIndexes = new BloodPressureIndexes(BloodPressureIndex.Systolic.constructor-impl((int)(indexSystolic - indexLeftTrim)), BloodPressureIndex.Mean.constructor-impl((int)(indexMean - indexLeftTrim)), BloodPressureIndex.Diastolic.constructor-impl((int)(indexDiastolic - indexLeftTrim)), null);
            Uuid uuid = Uuid.Companion.random();
            List list = data.getRawBloodPressure();
            int n3 = data.getStartDeflationIndex();
            List list2 = ArraysKt.asList((float[])data.getDeflation()).subList(indexLeftTrim, indexRightTrim);
            List list3 = ArraysKt.asList((float[])data.getOscillometry()).subList(indexLeftTrim, indexRightTrim);
            List list4 = ArraysKt.asList((float[])data.getEnvelope()).subList(indexLeftTrim, indexRightTrim);
            String string = this.getVersion().getRawVersion();
            NibpCalculatorOutput.Success result = new NibpCalculatorOutput.Success(uuid, timestamp, list, n3, list2, list3, list4, bpIndexes, bpIndexes, indexLeftTrim, indexRightTrim, pulsePerMinute, null, null, string, scores, null);
            return (NibpCalculatorOutput)NibpModelsKt.withNormalizedEnvelope((NibpCalculatorOutput.Success)result);
        }
        catch (Exception ex) {
            return (NibpCalculatorOutput)new NibpCalculatorOutput.Failed(timestamp, (Throwable)ex);
        }
    }

    @NotNull
    public NibpPulseInfo calculatePulsePeaks(@NotNull float[] oscillometryData, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)oscillometryData, (String)"oscillometryData");
        return this.pulseCalculator.calculatePulsePeaks(oscillometryData, offset, length);
    }

    @NotNull
    public NibpMeasurementScores calculateScores(@NotNull NibpOscillometryData data, @Nullable Boolean systolicOutOfBounds) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.scoreCalculator.calculateScores(data, systolicOutOfBounds);
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateMeanIndex(NibpOscillometryData data, Integer customLeftTrim, Integer customRightTrim) {
        int n;
        Object v2;
        void $this$maxByOrNull$iv;
        Integer n2 = customLeftTrim;
        int leftOffset = n2 != null ? n2 : 0;
        Integer n3 = customRightTrim;
        int rightOffset = n3 != null ? n3 : ArraysKt.getLastIndex((float[])data.getDeflation());
        TheoreticalScoreCalculatorResult result = NibpTheoreticalScoreCalculator.calculateScoreSignal$default(this.theoreticalScoreCalculator, data.getRoughEnvelope(), null, leftOffset, rightOffset, 300, 2, null);
        TheoreticalScoreCalculatorResult theoreticalScoreCalculatorResult = result;
        if (theoreticalScoreCalculatorResult instanceof TheoreticalScoreCalculatorResult.Failed) {
            throw ((TheoreticalScoreCalculatorResult.Failed)result).getError();
        }
        if (!(theoreticalScoreCalculatorResult instanceof TheoreticalScoreCalculatorResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        int indexMaxCorrelation = ((IndexedValue)CollectionsKt.first(((TheoreticalScoreCalculatorResult.Success)result).getScorePeaks())).getIndex();
        int initialIndex = RangesKt.coerceAtLeast((int)(indexMaxCorrelation - this.getSamplingFrequency()), (int)leftOffset);
        int finalIndex = RangesKt.coerceAtMost((int)(indexMaxCorrelation + this.getSamplingFrequency()), (int)rightOffset);
        Iterable iterable = CollectionsKt.withIndex((Iterable)ArraysKt.asList((float[])data.getEnvelope()).subList(initialIndex, finalIndex));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                IndexedValue it = (IndexedValue)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = ((Number)it.getValue()).floatValue();
                do {
                    Object e$iv = iterator$iv.next();
                    IndexedValue it2 = (IndexedValue)e$iv;
                    $i$a$-maxByOrNull-CommonNibpCalculator$calculateMeanIndex$1 = false;
                    float v$iv = ((Number)it2.getValue()).floatValue();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        IndexedValue indexedValue = v2;
        if (indexedValue != null) {
            IndexedValue it = indexedValue;
            boolean bl = false;
            n = it.getIndex() + initialIndex;
        } else {
            n = indexMaxCorrelation;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SystolicPressureResult calculateSystolicIndex$core_signal_processing(@NotNull NibpOscillometryData data, int indexMeanPressure) {
        int n;
        int minSystolicIndex;
        block1: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            List<Float> deflationUntilMeanPressure = ArraysKt.asList((float[])data.getDeflation()).subList(0, indexMeanPressure);
            float meanPressure = data.getDeflation()[indexMeanPressure];
            float maxSystolicPressure = meanPressure + (float)this.maximumDifferenceBetweenMeanAndSystolicPressures;
            minSystolicIndex = CommonNibpCalculator.calculateSystolicIndex$findIndex(deflationUntilMeanPressure, maxSystolicPressure);
            float minSystolicPressure = meanPressure + (float)this.minimumDifferenceBetweenMeanAndSystolicPressures;
            int maxSystolicIndex = CommonNibpCalculator.calculateSystolicIndex$findIndex(deflationUntilMeanPressure, minSystolicPressure);
            float ks = this.ksCalculator.calculateKs(meanPressure);
            float maxEnvelope = data.getEnvelope()[indexMeanPressure];
            float systolicThreshold = maxEnvelope * ks;
            List list = ArraysKt.asList((float[])data.getEnvelope()).subList(minSystolicIndex, maxSystolicIndex);
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                float it = ((Number)iterator$iv.previous()).floatValue();
                boolean bl = false;
                if (!(it < systolicThreshold)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        int index = n;
        boolean bl = false;
        boolean outOfBounds = index < 0;
        int indexSystolic = outOfBounds ? minSystolicIndex : index + minSystolicIndex;
        return new SystolicPressureResult(indexSystolic, outOfBounds);
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateDiastolicIndex$core_signal_processing(@NotNull NibpOscillometryData data, int indexSystolicPressure, int indexMeanPressure) {
        int n;
        int initialIndex;
        block2: {
            void $this$indexOfFirst$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            float meanPressure = data.getDeflation()[indexMeanPressure];
            float systolicPressure = data.getDeflation()[indexSystolicPressure];
            float diastolicPressure = ((float)3 * meanPressure - systolicPressure) / (float)2;
            initialIndex = RangesKt.coerceAtMost((int)(indexMeanPressure + this.getSamplingFrequency()), (int)ArraysKt.getLastIndex((float[])data.getDeflation()));
            List list = CollectionsUtilsKt.fromIndex((List)ArraysKt.asList((float[])data.getDeflation()), (int)initialIndex);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                float it = ((Number)item$iv).floatValue();
                boolean bl = false;
                if (it < diastolicPressure) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        return it + initialIndex;
    }

    private final void calculateDeflationCurve(float[] source, float[] dest) {
        MathUtilsKt.lowPassSignal(source, dest, this.getSamplingFrequency(), 0.5f, 2);
    }

    public final void calculateOscilometricCurve$core_signal_processing(@NotNull float[] source, @NotNull float[] dest) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        MathUtilsKt.filtFiltSignal(source, dest, this.getSamplingFrequency(), (Function1<? super CombinedFilter, Unit>)((Function1)arg_0 -> CommonNibpCalculator.calculateOscilometricCurve$lambda$10(this, arg_0)));
    }

    public float calculateMeanSlope(@NotNull NibpOscillometryData data, float ignorePercent, @Nullable Integer customLeftTrim, @Nullable Integer customRightTrim) {
        return super.calculateMeanSlope(data, ignorePercent, customLeftTrim, customRightTrim);
    }

    /*
     * WARNING - void declaration
     */
    private static final int calculateResult$findLeftTrim(NibpOscillometryData $data, CommonNibpCalculator this$0, int indexSystolicPressure) {
        int n;
        block1: {
            void $this$indexOfLast$iv;
            float threshold = $data.getDeflation()[indexSystolicPressure] + (float)this$0.leftTrimThreshold;
            List list = ArraysKt.asList((float[])$data.getDeflation()).subList(0, indexSystolicPressure);
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                float it = ((Number)iterator$iv.previous()).floatValue();
                boolean bl = false;
                if (!(it > threshold)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        return RangesKt.coerceAtLeast((int)n, (int)0);
    }

    private static final int calculateResult$findRightTrim(NibpOscillometryData $data, CommonNibpCalculator this$0, int indexDiastolicPressure) {
        int n;
        block2: {
            float threshold = RangesKt.coerceAtLeast((float)($data.getDeflation()[indexDiastolicPressure] - (float)this$0.rightTrimThreshold), (float)20.0f);
            float[] $this$indexOfLast$iv = $data.getDeflation();
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    float it = $this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!(it > threshold)) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n2);
            }
            n = -1;
        }
        return n;
    }

    private static final int calculateSystolicIndex$findIndex(List<Float> deflationUntilMeanPressure, float pressure) {
        int n;
        block1: {
            List<Float> $this$indexOfLast$iv = deflationUntilMeanPressure;
            boolean $i$f$indexOfLast = false;
            ListIterator<Float> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                float it = ((Number)iterator$iv.previous()).floatValue();
                boolean bl = false;
                if (!(it > pressure)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        return RangesKt.coerceAtLeast((int)n, (int)0);
    }

    private static final Unit calculateOscilometricCurve$lambda$10(CommonNibpCalculator this$0, CombinedFilter $this$filtFiltSignal) {
        Intrinsics.checkNotNullParameter((Object)$this$filtFiltSignal, (String)"$this$filtFiltSignal");
        $this$filtFiltSignal.add((Filter)new SimpleFilter(this$0.getSamplingFrequency(), IIR.INSTANCE.notch((Number)Float.valueOf(60.0f), this$0.getSamplingFrequency(), 10)));
        $this$filtFiltSignal.add((Filter)new SimpleFilter(this$0.getSamplingFrequency(), IIR.INSTANCE.butter(2, 1.5f, 0.0f, this$0.getSamplingFrequency(), IIR_TYPE.HIGH_PASS)));
        $this$filtFiltSignal.add((Filter)new SimpleFilter(this$0.getSamplingFrequency(), IIR.INSTANCE.butter(2, 20.0f, 0.0f, this$0.getSamplingFrequency(), IIR_TYPE.LOW_PASS)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator$SystolicPressureResult;", "", "index", "", "outOfBounds", "", "<init>", "(IZ)V", "getIndex", "()I", "getOutOfBounds", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "core-signal-processing"})
    public static final class SystolicPressureResult {
        private final int index;
        private final boolean outOfBounds;

        public SystolicPressureResult(int index, boolean outOfBounds) {
            this.index = index;
            this.outOfBounds = outOfBounds;
        }

        public final int getIndex() {
            return this.index;
        }

        public final boolean getOutOfBounds() {
            return this.outOfBounds;
        }

        public final int component1() {
            return this.index;
        }

        public final boolean component2() {
            return this.outOfBounds;
        }

        @NotNull
        public final SystolicPressureResult copy(int index, boolean outOfBounds) {
            return new SystolicPressureResult(index, outOfBounds);
        }

        public static /* synthetic */ SystolicPressureResult copy$default(SystolicPressureResult systolicPressureResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = systolicPressureResult.index;
            }
            if ((n2 & 2) != 0) {
                bl = systolicPressureResult.outOfBounds;
            }
            return systolicPressureResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "SystolicPressureResult(index=" + this.index + ", outOfBounds=" + this.outOfBounds + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + Boolean.hashCode(this.outOfBounds);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SystolicPressureResult)) {
                return false;
            }
            SystolicPressureResult systolicPressureResult = (SystolicPressureResult)other;
            if (this.index != systolicPressureResult.index) {
                return false;
            }
            return this.outOfBounds == systolicPressureResult.outOfBounds;
        }
    }
}

