/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.math_utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.math_utils.SimpleRegression;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.sigproc.filters.CombinedFilter;
import vet.inpulse.sigproc.filters.Filter;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a9\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\u000eH\u0000\u001aB\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00130\fH\u0000\u001a\"\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u001a.\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006\u001a\u0010\u0010\u001c\u001a\u00020\u001d*\b\u0012\u0004\u0012\u00020\u00060\u0010\u001a\u0010\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f*\u00020\u0003\u001a\u001e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006\u00a8\u0006$"}, d2={"lowPassSignal", "", "source", "", "dest", "fs", "", "filterFreq", "", "order", "filtFiltSignal", "filtBuilder", "Lkotlin/Function1;", "Lvet/inpulse/sigproc/filters/CombinedFilter;", "Lkotlin/ExtensionFunctionType;", "ratioFilter", "", "T", "minRatio", "", "maxRatio", "valueFunction", "correlation", "xArray", "yArray", "offsetX", "offsetY", "length", "getDeltas", "", "indicesAsDouble", "Lkotlin/sequences/Sequence;", "getNumSamplesForDesiredPressureWidth", "slope", "pressureRange", "samplingFrequency", "core-signal-processing"})
public final class MathUtilsKt {
    public static final void lowPassSignal(@NotNull float[] source, @NotNull float[] dest, int fs, float filterFreq, int order) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        CombinedFilter filter = new CombinedFilter(fs);
        filter.add((Filter)new SimpleFilter(fs, IIR.INSTANCE.butter(order, filterFreq, 0.0f, fs, IIR_TYPE.LOW_PASS)));
        filter.filtFilt(source, 0, dest, 0, source.length);
    }

    public static final void filtFiltSignal(@NotNull float[] source, @NotNull float[] dest, int fs, @NotNull Function1<? super CombinedFilter, Unit> filtBuilder) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter(filtBuilder, (String)"filtBuilder");
        CombinedFilter filter = new CombinedFilter(fs);
        filtBuilder.invoke((Object)filter);
        filter.filtFilt(source, 0, dest, 0, source.length);
    }

    @NotNull
    public static final <T> List<T> ratioFilter(@NotNull List<? extends T> $this$ratioFilter, double minRatio, double maxRatio, @NotNull Function1<? super T, Double> valueFunction) {
        Intrinsics.checkNotNullParameter($this$ratioFilter, (String)"<this>");
        Intrinsics.checkNotNullParameter(valueFunction, (String)"valueFunction");
        return ArraysUtilsKt.ratioFilter($this$ratioFilter, (double)minRatio, (double)maxRatio, valueFunction);
    }

    public static final double correlation(@NotNull List<Float> xArray, @NotNull List<Float> yArray) {
        Intrinsics.checkNotNullParameter(xArray, (String)"xArray");
        Intrinsics.checkNotNullParameter(yArray, (String)"yArray");
        SimpleRegression regression = new SimpleRegression();
        if (xArray.size() != yArray.size() || xArray.size() < 2) {
            throw new IllegalArgumentException("Wrong parameters");
        }
        int n = ((Collection)xArray).size();
        for (int i = 0; i < n; ++i) {
            regression.addData(((Number)xArray.get(i)).floatValue(), ((Number)yArray.get(i)).floatValue());
        }
        return regression.getR();
    }

    public static final double correlation(@NotNull float[] xArray, int offsetX, @NotNull float[] yArray, int offsetY, int length) {
        Intrinsics.checkNotNullParameter((Object)xArray, (String)"xArray");
        Intrinsics.checkNotNullParameter((Object)yArray, (String)"yArray");
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < length; ++i) {
            int indexX = offsetX + i;
            int indexY = offsetY + i;
            regression.addData(xArray[indexX], yArray[indexY]);
        }
        return regression.getR();
    }

    @NotNull
    public static final int[] getDeltas(@NotNull List<Integer> $this$getDeltas) {
        int[] nArray;
        Intrinsics.checkNotNullParameter($this$getDeltas, (String)"<this>");
        if ($this$getDeltas.size() > 1) {
            int n = 0;
            int n2 = $this$getDeltas.size() - 1;
            int[] nArray2 = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray2[n3] = ((Number)$this$getDeltas.get(n3 + 1)).intValue() - ((Number)$this$getDeltas.get(n3)).intValue();
            }
            nArray = nArray2;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @NotNull
    public static final Sequence<Double> indicesAsDouble(@NotNull float[] $this$indicesAsDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$indicesAsDouble, (String)"<this>");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)ArraysKt.getIndices((float[])$this$indicesAsDouble))), MathUtilsKt::indicesAsDouble$lambda$0);
    }

    public static final int getNumSamplesForDesiredPressureWidth(float slope, int pressureRange, int samplingFrequency) {
        return (int)((float)(pressureRange * samplingFrequency) / slope);
    }

    private static final double indicesAsDouble$lambda$0(int it) {
        return it;
    }
}

