/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.math_utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lvet/inpulse/core/signalprocessing/math_utils/Averages;", "", "<init>", "()V", "Companion", "core-signal-processing"})
public final class Averages {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u0014\u0010\u000b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u0014\u0010\f\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a8\u0006\u000e"}, d2={"Lvet/inpulse/core/signalprocessing/math_utils/Averages$Companion;", "", "<init>", "()V", "nthRoot", "", "num", "root", "getArithmeticMean", "values", "", "getGeometricMean", "getHarmonicMean", "", "core-signal-processing"})
    @SourceDebugExtension(value={"SMAP\nAverages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Averages.kt\nvet/inpulse/core/signalprocessing/math_utils/Averages$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n2783#2,7:61\n*S KotlinDebug\n*F\n+ 1 Averages.kt\nvet/inpulse/core/signalprocessing/math_utils/Averages$Companion\n*L\n50#1:61,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final float nthRoot(float num, float root) {
            return (float)Math.pow(Math.E, Math.log(num) / (double)root);
        }

        public final float getArithmeticMean(@NotNull float[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            float sum = 0.0f;
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                float value = values[i];
                sum += value;
            }
            return sum / (float)values.length;
        }

        public final float getGeometricMean(@NotNull float[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            float product = values[0];
            int n = values.length;
            for (int i = 1; i < n; ++i) {
                product *= values[i];
            }
            return this.nthRoot(product, values.length);
        }

        public final float getHarmonicMean(@NotNull float[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            float sumInverses = 0.0f;
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                float value = values[i];
                sumInverses += 1.0f / value;
            }
            return (float)values.length / sumInverses;
        }

        public final float getArithmeticMean(@NotNull List<Float> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            if (values.isEmpty()) {
                return 0.0f;
            }
            return CollectionsKt.sumOfFloat((Iterable)values) / (float)values.size();
        }

        /*
         * WARNING - void declaration
         */
        public final float getGeometricMean(@NotNull List<Float> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Iterable $this$reduce$iv = values;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                float f = ((Number)iterator$iv.next()).floatValue();
                float acc = ((Number)accumulator$iv).floatValue();
                boolean bl = false;
                accumulator$iv = Float.valueOf(acc * i);
            }
            float product = ((Number)accumulator$iv).floatValue();
            return this.nthRoot(product, values.size());
        }

        public final float getHarmonicMean(@NotNull List<Float> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            if (!(!((Collection)values).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

