/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg.onlinedetector;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.signalprocessing.ecg.online_detector.NonlinearDecayThresholdCalculator;
import vet.inpulse.core.signalprocessing.ecg.online_detector.ThresholdCalculator;
import vet.inpulse.core.signalprocessing.ecg.onlinedetector.Buffer;
import vet.inpulse.core.signalprocessing.ecg.onlinedetector.IOnlineEcgDetector;
import vet.inpulse.core.signalprocessing.ecg.onlinedetector.SpeciesForOnlineDetector;
import vet.inpulse.core.signalprocessing.filters.MovingAverageFilter;
import vet.inpulse.shared.log.CoreLogModuleKt;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\b\u0010\"\u001a\u00020 H\u0002J\u0006\u0010#\u001a\u00020 J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020\u0005H\u0002J\b\u0010(\u001a\u00020%H\u0002J\u001c\u0010)\u001a\u00020 2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020 0+H\u0002J\b\u0010,\u001a\u00020\u000bH\u0002J\f\u0010-\u001a\u00020\u0011*\u00020\u0003H\u0002J\f\u0010.\u001a\u00020\u000b*\u00020/H\u0002J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/OnlineEcgDetector;", "Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/IOnlineEcgDetector;", "species", "Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/SpeciesForOnlineDetector;", "fs", "", "<init>", "(Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/SpeciesForOnlineDetector;I)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "lastDetectionSignalValue", "", "getLastDetectionSignalValue", "()F", "currentThreshold", "getCurrentThreshold", "config", "Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/OnlineEcgDetector$Config;", "detectionSignalFilter", "Lvet/inpulse/sigproc/filters/SimpleFilter;", "inputDataBuffer", "Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/Buffer;", "detectionSignalBuffer", "counterSamplesAfterDetection", "hrvFilter", "Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "thresholdCalculator", "Lvet/inpulse/core/signalprocessing/ecg/online_detector/ThresholdCalculator;", "timeDelayAfterDetection", "configSpeciesRequired", "Lkotlinx/atomicfu/AtomicBoolean;", "changeSpecies", "", "newSpecies", "configureNewSpecies", "reset", "addSample", "", "sampleIn", "calculateTimeDelayAfterDetection", "shouldDetect", "detectPeak", "onPeakFound", "Lkotlin/Function1;", "calculateDetectionValue", "toConfig", "bpmToSamples", "", "createThresholdCalculator", "Config", "core-signal-processing"})
public final class OnlineEcgDetector
implements IOnlineEcgDetector {
    @NotNull
    private SpeciesForOnlineDetector species;
    private final int fs;
    @NotNull
    private final LoggerInterface logger;
    @NotNull
    private Config config;
    private SimpleFilter detectionSignalFilter;
    @NotNull
    private final Buffer inputDataBuffer;
    @NotNull
    private final Buffer detectionSignalBuffer;
    private int counterSamplesAfterDetection;
    @NotNull
    private final MovingAverageFilter hrvFilter;
    @NotNull
    private ThresholdCalculator thresholdCalculator;
    private int timeDelayAfterDetection;
    @NotNull
    private final AtomicBoolean configSpeciesRequired;

    public OnlineEcgDetector(@NotNull SpeciesForOnlineDetector species, int fs) {
        Intrinsics.checkNotNullParameter((Object)((Object)species), (String)"species");
        this.species = species;
        this.fs = fs;
        this.logger = CoreLogModuleKt.getCoreLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.config = this.toConfig(this.species);
        this.inputDataBuffer = new Buffer(3);
        this.detectionSignalBuffer = new Buffer(6);
        this.hrvFilter = new MovingAverageFilter(10, null, 2, null);
        this.thresholdCalculator = this.createThresholdCalculator(this.config);
        this.timeDelayAfterDetection = this.calculateTimeDelayAfterDetection();
        this.configSpeciesRequired = AtomicFU.atomic((boolean)false);
        this.configureNewSpecies();
    }

    public final float getLastDetectionSignalValue() {
        return this.detectionSignalBuffer.get(0);
    }

    public final float getCurrentThreshold() {
        return this.thresholdCalculator.getCurrentThreshold();
    }

    public final void changeSpecies(@NotNull SpeciesForOnlineDetector newSpecies) {
        Intrinsics.checkNotNullParameter((Object)((Object)newSpecies), (String)"newSpecies");
        this.species = newSpecies;
        this.configSpeciesRequired.setValue(true);
    }

    private final void configureNewSpecies() {
        float lowPassFilterFreq = this.species.getMaxBpm().floatValue() / 60.0f;
        this.detectionSignalFilter = new SimpleFilter(this.fs, IIR.INSTANCE.butter(2, lowPassFilterFreq, 0.0f, this.fs, IIR_TYPE.LOW_PASS));
        this.reset();
        this.config = this.toConfig(this.species);
        this.thresholdCalculator = this.createThresholdCalculator(this.config);
        this.timeDelayAfterDetection = this.calculateTimeDelayAfterDetection();
    }

    public final void reset() {
        this.counterSamplesAfterDetection = 0;
        this.inputDataBuffer.clear();
        this.detectionSignalBuffer.clear();
        SimpleFilter simpleFilter = this.detectionSignalFilter;
        if (simpleFilter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"detectionSignalFilter");
            simpleFilter = null;
        }
        simpleFilter.reset();
        this.hrvFilter.getValues().clear();
    }

    @Override
    public boolean addSample(float sampleIn) {
        Ref.BooleanRef detectionResult = new Ref.BooleanRef();
        if (this.configSpeciesRequired.compareAndSet(true, false)) {
            this.configureNewSpecies();
        }
        this.inputDataBuffer.addLast(sampleIn);
        if (!this.inputDataBuffer.isFull()) {
            return detectionResult.element;
        }
        float currentOutput = this.calculateDetectionValue();
        this.detectionSignalBuffer.addLast(currentOutput);
        if (!this.detectionSignalBuffer.isFull()) {
            return detectionResult.element;
        }
        if (this.shouldDetect()) {
            if (currentOutput > this.thresholdCalculator.getCurrentThreshold() && currentOutput < this.config.getMaxThreshold()) {
                this.detectPeak((Function1<? super Float, Unit>)((Function1)arg_0 -> OnlineEcgDetector.addSample$lambda$0(this, detectionResult, arg_0)));
            } else {
                this.thresholdCalculator.decayThreshold();
            }
        }
        int n = this.counterSamplesAfterDetection;
        this.counterSamplesAfterDetection = n + 1;
        return detectionResult.element;
    }

    private final int calculateTimeDelayAfterDetection() {
        int n;
        float currentHrv = this.hrvFilter.getMean();
        Config $this$calculateTimeDelayAfterDetection_u24lambda_u243 = this.config;
        boolean bl = false;
        float min = $this$calculateTimeDelayAfterDetection_u24lambda_u243.getMinIntervalBetweenPeaksInSamples();
        float max = (float)2 * min;
        int it = n = (int)RangesKt.coerceIn((float)(currentHrv * $this$calculateTimeDelayAfterDetection_u24lambda_u243.getPercentageOfPeaksIntervalForTimeDelay()), (float)min, (float)max);
        boolean bl2 = false;
        this.logger.v(() -> OnlineEcgDetector.calculateTimeDelayAfterDetection$lambda$3$lambda$2$lambda$1(min, max, it));
        return n;
    }

    private final boolean shouldDetect() {
        return this.hrvFilter.getValues().isEmpty() || this.counterSamplesAfterDetection > this.timeDelayAfterDetection;
    }

    private final void detectPeak(Function1<? super Float, Unit> onPeakFound) {
        float delta2;
        Buffer $this$detectPeak_u24lambda_u244 = this.detectionSignalBuffer;
        boolean bl = false;
        float delta1 = $this$detectPeak_u24lambda_u244.diff(0);
        boolean hasInflection = delta1 * (delta2 = $this$detectPeak_u24lambda_u244.diff(1)) < 0.0f;
        float diff2 = delta1 - delta2;
        if (hasInflection && diff2 < 0.0f) {
            onPeakFound.invoke((Object)Float.valueOf($this$detectPeak_u24lambda_u244.get(1)));
        }
    }

    private final float calculateDetectionValue() {
        double secondDerivative = (double)this.inputDataBuffer.diff(0) - (double)this.inputDataBuffer.diff(1);
        double value = Math.pow(secondDerivative, 2) * 1000.0;
        SimpleFilter simpleFilter = this.detectionSignalFilter;
        if (simpleFilter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"detectionSignalFilter");
            simpleFilter = null;
        }
        return simpleFilter.filterData((float)value);
    }

    private final Config toConfig(SpeciesForOnlineDetector $this$toConfig) {
        return new Config($this$toConfig.getMaxDetectionThreshold(), $this$toConfig.getMinDetectionThreshold(), (int)this.bpmToSamples($this$toConfig.getMinBpm()), (int)this.bpmToSamples($this$toConfig.getMaxBpm()), 0.0f, 16, null);
    }

    private final float bpmToSamples(Number $this$bpmToSamples) {
        return 60.0f * (float)this.fs / $this$bpmToSamples.floatValue();
    }

    private final ThresholdCalculator createThresholdCalculator(Config config) {
        return new NonlinearDecayThresholdCalculator(config.getMinThreshold(), config.getMinIntervalBetweenPeaksInSamples(), config.getMaxIntervalBetweenPeaksInSamples());
    }

    private static final Unit addSample$lambda$0(OnlineEcgDetector this$0, Ref.BooleanRef $detectionResult, float peakValue) {
        this$0.thresholdCalculator.setNewThreshold(peakValue);
        $detectionResult.element = true;
        if (this$0.counterSamplesAfterDetection < this$0.config.getMaxIntervalBetweenPeaksInSamples()) {
            this$0.hrvFilter.add(this$0.counterSamplesAfterDetection);
        }
        this$0.counterSamplesAfterDetection = 0;
        if (this$0.hrvFilter.getValues().size() > 3) {
            this$0.thresholdCalculator.updatePeaksInterval(this$0.hrvFilter.getMean());
            this$0.timeDelayAfterDetection = this$0.calculateTimeDelayAfterDetection();
        }
        return Unit.INSTANCE;
    }

    private static final String calculateTimeDelayAfterDetection$lambda$3$lambda$2$lambda$1(float $min, float $max, int $it) {
        return "calculating time delay: min " + $min + "   max " + $max + "    calculated: " + $it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001e"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/onlinedetector/OnlineEcgDetector$Config;", "", "maxThreshold", "", "minThreshold", "maxIntervalBetweenPeaksInSamples", "", "minIntervalBetweenPeaksInSamples", "percentageOfPeaksIntervalForTimeDelay", "<init>", "(FFIIF)V", "getMaxThreshold", "()F", "getMinThreshold", "getMaxIntervalBetweenPeaksInSamples", "()I", "getMinIntervalBetweenPeaksInSamples", "getPercentageOfPeaksIntervalForTimeDelay", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "core-signal-processing"})
    public static final class Config {
        private final float maxThreshold;
        private final float minThreshold;
        private final int maxIntervalBetweenPeaksInSamples;
        private final int minIntervalBetweenPeaksInSamples;
        private final float percentageOfPeaksIntervalForTimeDelay;

        public Config(float maxThreshold, float minThreshold, int maxIntervalBetweenPeaksInSamples, int minIntervalBetweenPeaksInSamples, float percentageOfPeaksIntervalForTimeDelay) {
            this.maxThreshold = maxThreshold;
            this.minThreshold = minThreshold;
            this.maxIntervalBetweenPeaksInSamples = maxIntervalBetweenPeaksInSamples;
            this.minIntervalBetweenPeaksInSamples = minIntervalBetweenPeaksInSamples;
            this.percentageOfPeaksIntervalForTimeDelay = percentageOfPeaksIntervalForTimeDelay;
        }

        public /* synthetic */ Config(float f, float f2, int n, int n2, float f3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                f3 = 0.5f;
            }
            this(f, f2, n, n2, f3);
        }

        public final float getMaxThreshold() {
            return this.maxThreshold;
        }

        public final float getMinThreshold() {
            return this.minThreshold;
        }

        public final int getMaxIntervalBetweenPeaksInSamples() {
            return this.maxIntervalBetweenPeaksInSamples;
        }

        public final int getMinIntervalBetweenPeaksInSamples() {
            return this.minIntervalBetweenPeaksInSamples;
        }

        public final float getPercentageOfPeaksIntervalForTimeDelay() {
            return this.percentageOfPeaksIntervalForTimeDelay;
        }

        public final float component1() {
            return this.maxThreshold;
        }

        public final float component2() {
            return this.minThreshold;
        }

        public final int component3() {
            return this.maxIntervalBetweenPeaksInSamples;
        }

        public final int component4() {
            return this.minIntervalBetweenPeaksInSamples;
        }

        public final float component5() {
            return this.percentageOfPeaksIntervalForTimeDelay;
        }

        @NotNull
        public final Config copy(float maxThreshold, float minThreshold, int maxIntervalBetweenPeaksInSamples, int minIntervalBetweenPeaksInSamples, float percentageOfPeaksIntervalForTimeDelay) {
            return new Config(maxThreshold, minThreshold, maxIntervalBetweenPeaksInSamples, minIntervalBetweenPeaksInSamples, percentageOfPeaksIntervalForTimeDelay);
        }

        public static /* synthetic */ Config copy$default(Config config, float f, float f2, int n, int n2, float f3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                f = config.maxThreshold;
            }
            if ((n3 & 2) != 0) {
                f2 = config.minThreshold;
            }
            if ((n3 & 4) != 0) {
                n = config.maxIntervalBetweenPeaksInSamples;
            }
            if ((n3 & 8) != 0) {
                n2 = config.minIntervalBetweenPeaksInSamples;
            }
            if ((n3 & 0x10) != 0) {
                f3 = config.percentageOfPeaksIntervalForTimeDelay;
            }
            return config.copy(f, f2, n, n2, f3);
        }

        @NotNull
        public String toString() {
            return "Config(maxThreshold=" + this.maxThreshold + ", minThreshold=" + this.minThreshold + ", maxIntervalBetweenPeaksInSamples=" + this.maxIntervalBetweenPeaksInSamples + ", minIntervalBetweenPeaksInSamples=" + this.minIntervalBetweenPeaksInSamples + ", percentageOfPeaksIntervalForTimeDelay=" + this.percentageOfPeaksIntervalForTimeDelay + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.maxThreshold);
            result = result * 31 + Float.hashCode(this.minThreshold);
            result = result * 31 + Integer.hashCode(this.maxIntervalBetweenPeaksInSamples);
            result = result * 31 + Integer.hashCode(this.minIntervalBetweenPeaksInSamples);
            result = result * 31 + Float.hashCode(this.percentageOfPeaksIntervalForTimeDelay);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (Float.compare(this.maxThreshold, config.maxThreshold) != 0) {
                return false;
            }
            if (Float.compare(this.minThreshold, config.minThreshold) != 0) {
                return false;
            }
            if (this.maxIntervalBetweenPeaksInSamples != config.maxIntervalBetweenPeaksInSamples) {
                return false;
            }
            if (this.minIntervalBetweenPeaksInSamples != config.minIntervalBetweenPeaksInSamples) {
                return false;
            }
            return Float.compare(this.percentageOfPeaksIntervalForTimeDelay, config.percentageOfPeaksIntervalForTimeDelay) == 0;
        }
    }
}

