/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg.online_detector;

import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.ecg.online_detector.CoercedLinearFunction;
import vet.inpulse.core.signalprocessing.ecg.online_detector.ThresholdCalculator;
import vet.inpulse.core.signalprocessing.filters.MovingAverageFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/online_detector/NewNonlinearDecayThresholdCalculator;", "Lvet/inpulse/core/signalprocessing/ecg/online_detector/ThresholdCalculator;", "minThreshold", "", "minInterval", "", "maxInterval", "<init>", "(FII)V", "currentThreshold", "getCurrentThreshold", "()F", "setCurrentThreshold", "(F)V", "ratioTh", "getRatioTh", "setRatioTh", "deltaTh", "getDeltaTh", "setDeltaTh", "currentTau", "decaySamplesCounter", "Lkotlinx/atomicfu/AtomicInt;", "filter", "Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "getFilter", "()Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "incrementFunction", "Lvet/inpulse/core/signalprocessing/ecg/online_detector/CoercedLinearFunction;", "updateTimeConstant", "hrvInSamples", "(Ljava/lang/Float;)F", "updatePeaksInterval", "", "setNewThreshold", "peakValue", "decayThreshold", "core-signal-processing"})
public final class NewNonlinearDecayThresholdCalculator
implements ThresholdCalculator {
    private final float minThreshold;
    private final int minInterval;
    private final int maxInterval;
    private float currentThreshold;
    private float ratioTh;
    private float deltaTh;
    private float currentTau;
    @NotNull
    private final AtomicInt decaySamplesCounter;
    @NotNull
    private final MovingAverageFilter filter;
    @NotNull
    private final CoercedLinearFunction incrementFunction;

    public NewNonlinearDecayThresholdCalculator(float minThreshold, int minInterval, int maxInterval) {
        this.minThreshold = minThreshold;
        this.minInterval = minInterval;
        this.maxInterval = maxInterval;
        this.currentThreshold = this.minThreshold;
        this.currentTau = this.updateTimeConstant(null);
        this.decaySamplesCounter = AtomicFU.atomic((int)0);
        this.filter = new MovingAverageFilter(30, null, 2, null);
        this.incrementFunction = new CoercedLinearFunction(0.0f, 3.0f, 0.0f, 0.95f);
    }

    @Override
    public float getCurrentThreshold() {
        return this.currentThreshold;
    }

    public void setCurrentThreshold(float f) {
        this.currentThreshold = f;
    }

    public final float getRatioTh() {
        return this.ratioTh;
    }

    public final void setRatioTh(float f) {
        this.ratioTh = f;
    }

    public final float getDeltaTh() {
        return this.deltaTh;
    }

    public final void setDeltaTh(float f) {
        this.deltaTh = f;
    }

    @NotNull
    public final MovingAverageFilter getFilter() {
        return this.filter;
    }

    private final float updateTimeConstant(Float hrvInSamples) {
        float minimumTau = (float)this.minInterval * 50.0f;
        float maximumTau = (float)this.maxInterval * 50.0f;
        return hrvInSamples != null ? RangesKt.coerceIn((float)(hrvInSamples.floatValue() * 50.0f), (float)minimumTau, (float)maximumTau) : maximumTau;
    }

    @Override
    public void updatePeaksInterval(float hrvInSamples) {
        this.currentTau = this.updateTimeConstant(Float.valueOf(hrvInSamples));
    }

    @Override
    public void setNewThreshold(float peakValue) {
        float deltaThreshold;
        float ratio;
        this.decaySamplesCounter.setValue(0);
        float signal = this.filter.addAndGetMean(peakValue);
        this.ratioTh = ratio = signal / this.getCurrentThreshold();
        this.deltaTh = deltaThreshold = RangesKt.coerceAtLeast((float)((this.getCurrentThreshold() - this.minThreshold) / this.getCurrentThreshold()), (float)0.0f);
        float x = ratio * deltaThreshold;
        float factor = this.incrementFunction.calculate(x);
        float delta = RangesKt.coerceAtLeast((float)(signal - this.getCurrentThreshold()), (float)0.0f);
        this.setCurrentThreshold(this.getCurrentThreshold() + factor * delta);
    }

    @Override
    public void decayThreshold() {
        float f;
        int t = this.decaySamplesCounter.getAndIncrement();
        if ((float)t <= (float)5 * this.currentTau) {
            float gain = RangesKt.coerceAtLeast((float)(this.getCurrentThreshold() - this.minThreshold), (float)0.0f);
            f = gain * (float)Math.exp((float)(-t) / this.currentTau) + this.minThreshold;
        } else {
            f = this.minThreshold;
        }
        this.setCurrentThreshold(f);
    }
}

