/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.model.DFAResult;
import vet.inpulse.core.signalprocessing.ecg.Linear;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.Data;
import vet.inpulse.math.DataKt;
import vet.inpulse.math.PolynomialKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"dfaCommon", "Lvet/inpulse/core/models/model/DFAResult;", "data", "", "scale", "", "m", "", "core-signal-processing"})
public final class DFAKt {
    @NotNull
    public static final DFAResult dfaCommon(@NotNull float[] data, @NotNull int[] scale, int m) {
        int j2;
        double[] rootMeanSquared22;
        int tempSize;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        if (data.length < Linear.INSTANCE.max(scale)) {
            return (DFAResult)DFAResult.Error.DataIsShortForThisScale.INSTANCE;
        }
        double[] x = ArraysUtilsKt.cumulativeSumMinusMean$default((Data)((Data)DataKt.asData$default((float[])data, (int)0, (int)0, (int)0, (int)7, null)), null, (int)2, null).toDoubleArray();
        int scaleSize = scale.length;
        int dataSize = data.length;
        double[] frequencies = new double[scaleSize];
        for (int i = 0; i < scaleSize; ++i) {
            tempSize = (int)Math.floor(dataSize / scale[i]);
            rootMeanSquared22 = new double[tempSize];
            j2 = 1;
            if (j2 <= tempSize) {
                while (true) {
                    double mean;
                    int indexStart = (j2 - 1) * scale[i] + 1;
                    int indexStop = j2 * scale[i];
                    double[] xPart = ArraysKt.copyOfRange((double[])x, (int)(indexStart - 1), (int)indexStop);
                    int n = 0;
                    int n2 = xPart.length;
                    double[] dArray = new double[n2];
                    while (n < n2) {
                        int n3 = n++;
                        dArray[n3] = n3;
                    }
                    double[] index = dArray;
                    double sum = PolynomialKt.polyfitWithResiduals((Data)((Data)DataKt.asData$default((double[])index, (int)0, (int)0, (int)0, (int)7, null)), (Data)((Data)DataKt.asData$default((double[])xPart, (int)0, (int)0, (int)0, (int)7, null)), (int)m).component3();
                    rootMeanSquared22[j2 - 1] = mean = sum / (double)xPart.length;
                    if (j2 == tempSize) break;
                    ++j2;
                }
            }
            frequencies[i] = Math.sqrt(Linear.INSTANCE.mean(rootMeanSquared22));
        }
        tempSize = 0;
        rootMeanSquared22 = new double[scaleSize];
        while (tempSize < scaleSize) {
            j2 = tempSize++;
            rootMeanSquared22[j2] = Linear.INSTANCE.log((double)scale[j2], 2);
        }
        double[] logScale = rootMeanSquared22;
        int rootMeanSquared22 = 0;
        double[] j2 = new double[scaleSize];
        while (rootMeanSquared22 < scaleSize) {
            int n = rootMeanSquared22++;
            j2[n] = Linear.INSTANCE.log(frequencies[n], 2);
        }
        double[] logF = j2;
        double[] coefficients = PolynomialKt.polyfit((Data)((Data)DataKt.asData$default((double[])logScale, (int)0, (int)0, (int)0, (int)7, null)), (Data)((Data)DataKt.asData$default((double[])logF, (int)0, (int)0, (int)0, (int)7, null)), (int)m);
        float ret = (float)coefficients[ArraysKt.getLastIndex((double[])coefficients)];
        return (DFAResult)new DFAResult.Success(ret);
    }
}

