/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.model.DFAResult;
import vet.inpulse.core.signalprocessing.ecg.Linear;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/DFA;", "", "<init>", "()V", "dfa", "Lvet/inpulse/core/models/model/DFAResult;", "data", "", "scale", "", "m", "", "cumsum", "core-signal-processing"})
public final class DFA {
    @NotNull
    public static final DFA INSTANCE = new DFA();

    private DFA() {
    }

    @NotNull
    public final DFAResult dfa(@NotNull float[] data, @NotNull int[] scale, int m) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        if (data.length < Linear.INSTANCE.max(scale)) {
            return (DFAResult)DFAResult.Error.DataIsShortForThisScale.INSTANCE;
        }
        float[] x = this.cumsum(data);
        int dataSize = x.length;
        int scaleSize = scale.length;
        float[] F = new float[scaleSize];
        for (int i = 0; i < scaleSize; ++i) {
            int tempSize = (int)Math.floor(dataSize / scale[i]);
            float[] rms2 = new float[tempSize];
            int j = 1;
            if (j <= tempSize) {
                while (true) {
                    PolynomialCurveFitter fitter;
                    int Idx_start = (j - 1) * scale[i] + 1;
                    int Idx_stop = j * scale[i];
                    float[] X_ = new float[Idx_stop - Idx_start + 1];
                    float[] index = new float[Idx_stop - Idx_start + 1];
                    int n = index.length;
                    for (int k = 0; k < n; ++k) {
                        index[k] = k;
                    }
                    System.arraycopy(x, Idx_start - 1, X_, 0, Idx_stop - Idx_start + 1);
                    double[] dif2 = new double[index.length];
                    Intrinsics.checkNotNullExpressionValue((Object)PolynomialCurveFitter.create((int)m), (String)"create(...)");
                    WeightedObservedPoints observedPoints = new WeightedObservedPoints();
                    int n2 = index.length;
                    for (int k = 0; k < n2; ++k) {
                        observedPoints.add((double)index[k], (double)X_[k]);
                    }
                    PolynomialFunction fitted = new PolynomialFunction(fitter.fit((Collection)observedPoints.toList()));
                    int n3 = index.length;
                    for (int k = 0; k < n3; ++k) {
                        dif2[k] = ((double)X_[k] - fitted.value((double)k)) * ((double)X_[k] - fitted.value((double)k));
                    }
                    rms2[j - 1] = (float)(Math.sqrt(Linear.INSTANCE.mean(dif2)) * Math.sqrt(Linear.INSTANCE.mean(dif2)));
                    if (j == tempSize) break;
                    ++j;
                }
            }
            F[i] = (float)Math.sqrt(Linear.INSTANCE.mean(rms2));
        }
        double[] logScale = new double[scaleSize];
        double[] logF = new double[scaleSize];
        PolynomialCurveFitter polynomialCurveFitter = PolynomialCurveFitter.create((int)m);
        Intrinsics.checkNotNullExpressionValue((Object)polynomialCurveFitter, (String)"create(...)");
        PolynomialCurveFitter fitter2 = polynomialCurveFitter;
        WeightedObservedPoints observedPoints2 = new WeightedObservedPoints();
        for (int i = 0; i < scaleSize; ++i) {
            logScale[i] = Linear.INSTANCE.log(scale[i], 2);
            logF[i] = Linear.INSTANCE.log(F[i], 2);
            observedPoints2.add(logScale[i], logF[i]);
        }
        double[] dArray = fitter2.fit((Collection)observedPoints2.toList());
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"fit(...)");
        double[] C = dArray;
        return (DFAResult)new DFAResult.Success((float)C[C.length - 1]);
    }

    @NotNull
    public final float[] cumsum(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int size = data.length;
        float[] csum = new float[data.length];
        float mean = Linear.INSTANCE.mean(data);
        csum[0] = data[0] - mean;
        for (int i = 1; i < size; ++i) {
            csum[i] = csum[i - 1] + data[i] - mean;
        }
        return csum;
    }
}

