/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.utils.SignalProcessingAlgorithmVersion;
import vet.inpulse.core.signalprocessing.filters.MovingAverageFilter;
import vet.inpulse.shared.log.CoreLogModuleKt;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.sigproc.filters.CombinedFilter;
import vet.inpulse.sigproc.filters.Filter;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010(\u001a\u00020)J \u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017J\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0005R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u00063"}, d2={"Lvet/inpulse/core/signalprocessing/Spo2Calculator;", "", "samplingFrequency", "", "<init>", "(I)V", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "algorithmVersion", "Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "getAlgorithmVersion", "()Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "Kb", "getKb", "()I", "setKb", "Ka", "getKa", "setKa", "filterInflectionSignal", "Lvet/inpulse/sigproc/filters/CombinedFilter;", "bufferInflectionSignalDiffs", "", "", "sizeBufferInflectionSignal", "inflectionFilterDelay", "inflectionFilterDelayWindow", "valleySearchWindow", "baselineFilterDelay", "bufferPeakDetectionSize", "sizeBufferDiffs", "bufferRed", "bufferInfraRed", "bufferInfraRedBaseline", "bufferLastMaxPs", "Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "thresholdP", "movingAverageRedAmplitudes", "lastInflectionSignal", "Ljava/lang/Float;", "reset", "", "addSampleToDetectPeak", "Lvet/inpulse/core/signalprocessing/Spo2Calculator$DetectionSpo2values;", "redFiltered", "infraRedFiltered", "infraRedFilteredBaseline", "isPeak", "", "bufferDeltas", "DetectionSpo2values", "core-signal-processing"})
public final class Spo2Calculator {
    @NotNull
    private final LoggerInterface logger = CoreLogModuleKt.getCoreLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
    @NotNull
    private final SignalProcessingAlgorithmVersion algorithmVersion = new SignalProcessingAlgorithmVersion("DEFAULT-1.0");
    private int Kb = 112;
    private int Ka = 25;
    @NotNull
    private final CombinedFilter filterInflectionSignal;
    @NotNull
    private final List<Float> bufferInflectionSignalDiffs;
    private final int sizeBufferInflectionSignal;
    private final int inflectionFilterDelay;
    private final int inflectionFilterDelayWindow;
    private final int valleySearchWindow;
    private final int baselineFilterDelay;
    private final int bufferPeakDetectionSize;
    private final int sizeBufferDiffs;
    @NotNull
    private final List<Float> bufferRed;
    @NotNull
    private final List<Float> bufferInfraRed;
    @NotNull
    private final List<Float> bufferInfraRedBaseline;
    @NotNull
    private final MovingAverageFilter bufferLastMaxPs;
    private float thresholdP;
    @NotNull
    private final MovingAverageFilter movingAverageRedAmplitudes;
    @Nullable
    private Float lastInflectionSignal;

    /*
     * WARNING - void declaration
     */
    public Spo2Calculator(int samplingFrequency) {
        void $this$filterInflectionSignal_u24lambda_u240;
        CombinedFilter combinedFilter;
        CombinedFilter combinedFilter2 = combinedFilter = new CombinedFilter(samplingFrequency);
        Spo2Calculator spo2Calculator = this;
        boolean bl = false;
        $this$filterInflectionSignal_u24lambda_u240.add((Filter)new SimpleFilter(samplingFrequency, IIR.INSTANCE.butter(2, 3.0f, 0.0f, samplingFrequency, IIR_TYPE.LOW_PASS)));
        $this$filterInflectionSignal_u24lambda_u240.add((Filter)new SimpleFilter(samplingFrequency, IIR.INSTANCE.butter(2, 3.0f, 0.0f, samplingFrequency, IIR_TYPE.LOW_PASS)));
        spo2Calculator.filterInflectionSignal = combinedFilter;
        this.bufferInflectionSignalDiffs = new ArrayList();
        this.sizeBufferInflectionSignal = 4;
        this.inflectionFilterDelay = 52;
        this.inflectionFilterDelayWindow = 18;
        this.valleySearchWindow = 104;
        this.baselineFilterDelay = 94;
        this.bufferPeakDetectionSize = 300;
        this.sizeBufferDiffs = this.inflectionFilterDelay;
        this.bufferRed = new ArrayList();
        this.bufferInfraRed = new ArrayList();
        this.bufferInfraRedBaseline = new ArrayList();
        this.bufferLastMaxPs = new MovingAverageFilter(5, null, 2, null);
        this.thresholdP = 0.002f;
        this.movingAverageRedAmplitudes = new MovingAverageFilter(3, null, 2, null);
    }

    @NotNull
    public final SignalProcessingAlgorithmVersion getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public final int getKb() {
        return this.Kb;
    }

    public final void setKb(int n) {
        this.Kb = n;
    }

    public final int getKa() {
        return this.Ka;
    }

    public final void setKa(int n) {
        this.Ka = n;
    }

    public final void reset() {
        this.bufferRed.clear();
        this.bufferInfraRed.clear();
        this.bufferInfraRedBaseline.clear();
        this.bufferLastMaxPs.clear();
        this.thresholdP = 0.002f;
        this.movingAverageRedAmplitudes.clear();
        this.lastInflectionSignal = null;
        this.logger.d(Spo2Calculator::reset$lambda$1);
    }

    @Nullable
    public final DetectionSpo2values addSampleToDetectPeak(float redFiltered, float infraRedFiltered, float infraRedFilteredBaseline) {
        DetectionSpo2values result = null;
        this.bufferRed.add(Float.valueOf(redFiltered));
        this.bufferInfraRed.add(Float.valueOf(infraRedFiltered));
        this.bufferInfraRedBaseline.add(Float.valueOf(infraRedFilteredBaseline));
        float inflectionSignal = this.filterInflectionSignal.filterData(infraRedFilteredBaseline);
        if (this.lastInflectionSignal != null) {
            Float f = this.lastInflectionSignal;
            Intrinsics.checkNotNull((Object)f);
            float actualDiff = inflectionSignal - f.floatValue();
            this.bufferInflectionSignalDiffs.add(Float.valueOf(actualDiff));
            if (this.bufferInflectionSignalDiffs.size() > this.sizeBufferDiffs) {
                if (this.isPeak(this.bufferInflectionSignalDiffs)) {
                    int peakIndex = 0;
                    int valleyIndex = 0;
                    if (CollectionsKt.getLastIndex(this.bufferInfraRedBaseline) > this.inflectionFilterDelay + this.inflectionFilterDelayWindow + this.valleySearchWindow) {
                        int peakIndexStart = CollectionsKt.getLastIndex(this.bufferInfraRedBaseline) - this.inflectionFilterDelay - this.inflectionFilterDelayWindow;
                        int peakIndexEnd = CollectionsKt.getLastIndex(this.bufferInfraRedBaseline) - this.inflectionFilterDelay + this.inflectionFilterDelayWindow;
                        List<Float> peakSearchList = this.bufferInfraRedBaseline.subList(peakIndexStart, peakIndexEnd);
                        peakIndex = CollectionsKt.indexOf(peakSearchList, (Object)CollectionsKt.maxOrNull((Iterable)peakSearchList)) + peakIndexStart;
                        int valleyIndexStart = peakIndex - this.valleySearchWindow;
                        int valleyIndexEnd = peakIndex;
                        List<Float> valleySearchList = this.bufferInfraRedBaseline.subList(valleyIndexStart, valleyIndexEnd);
                        valleyIndex = CollectionsKt.indexOf(valleySearchList, (Object)CollectionsKt.minOrNull((Iterable)valleySearchList)) + valleyIndexStart;
                    } else {
                        peakIndex = CollectionsKt.indexOf(this.bufferInfraRedBaseline, (Object)CollectionsKt.maxOrNull((Iterable)this.bufferInfraRedBaseline));
                        valleyIndex = CollectionsKt.indexOf(this.bufferInfraRedBaseline, (Object)CollectionsKt.minOrNull((Iterable)this.bufferInfraRedBaseline));
                    }
                    if (peakIndex > this.baselineFilterDelay && valleyIndex > this.baselineFilterDelay) {
                        peakIndex -= this.baselineFilterDelay;
                        valleyIndex -= this.baselineFilterDelay;
                    }
                    float redPeak = ((Number)this.bufferRed.get(peakIndex)).floatValue();
                    float infraredPeak = ((Number)this.bufferInfraRed.get(peakIndex)).floatValue();
                    float redValley = ((Number)this.bufferRed.get(valleyIndex)).floatValue();
                    float infraredValley = ((Number)this.bufferInfraRed.get(valleyIndex)).floatValue();
                    float redAC = redPeak - redValley;
                    float infraRedAC = infraredPeak - infraredValley;
                    float perfusionIndex = (float)100 * Math.abs(infraRedAC / infraredPeak);
                    if (perfusionIndex < 50.0f) {
                        float redDC = redValley + (redPeak - redValley) / (float)2;
                        float infraRedDC = infraredValley + (infraredPeak - infraredValley) / (float)2;
                        float R = redAC / redDC / (infraRedAC / infraRedDC);
                        float spo2 = (float)this.Kb - (float)this.Ka * R;
                        LoggerInterface.t$default((LoggerInterface)this.logger, null, () -> Spo2Calculator.addSampleToDetectPeak$lambda$2(redAC, infraRedAC, redDC, infraRedDC, redPeak, infraredPeak, redValley, infraredValley, perfusionIndex, spo2), (int)1, null);
                        result = new DetectionSpo2values(RangesKt.coerceIn((float)spo2, (float)0.0f, (float)100.0f), perfusionIndex, ((Number)this.bufferInfraRedBaseline.get(peakIndex)).floatValue(), ((Number)this.bufferInfraRedBaseline.get(valleyIndex)).floatValue());
                    }
                }
                CollectionsKt.removeFirstOrNull(this.bufferInflectionSignalDiffs);
            }
        }
        if (this.bufferRed.size() > this.bufferPeakDetectionSize) {
            CollectionsKt.removeFirstOrNull(this.bufferRed);
            CollectionsKt.removeFirstOrNull(this.bufferInfraRed);
            CollectionsKt.removeFirstOrNull(this.bufferInfraRedBaseline);
        }
        this.lastInflectionSignal = Float.valueOf(inflectionSignal);
        return result;
    }

    private final boolean isPeak(List<Float> bufferDeltas) {
        boolean isPeak = true;
        List<Float> signalDeltas = bufferDeltas.subList(bufferDeltas.size() - this.sizeBufferInflectionSignal, bufferDeltas.size());
        if (((Number)CollectionsKt.first(signalDeltas)).floatValue() > 0.0f) {
            int n = signalDeltas.size();
            for (int i = 1; i < n; ++i) {
                if (!(((Number)signalDeltas.get(i)).floatValue() >= 0.0f)) continue;
                isPeak = false;
                break;
            }
        } else {
            isPeak = false;
        }
        if (isPeak) {
            float maxP = 0.0f;
            int i = 3;
            int n = bufferDeltas.size();
            if (i <= n) {
                while (true) {
                    List<Float> bufferCalcP = bufferDeltas.subList(i - 3, i);
                    float p = 1.0E9f;
                    for (int n2 = 1; n2 < 4; ++n2) {
                        p *= ((Number)bufferCalcP.get(bufferCalcP.size() - n2)).floatValue();
                    }
                    if (p > maxP) {
                        maxP = p;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if ((double)(maxP = RangesKt.coerceAtMost((float)maxP, (float)500.0f)) < 5.0E-5) {
                isPeak = false;
            } else {
                this.thresholdP = RangesKt.coerceAtLeast((float)(0.1f * this.bufferLastMaxPs.addAndGetMean(maxP)), (float)5.0E-5f);
                if (maxP <= this.thresholdP) {
                    isPeak = false;
                }
            }
        }
        return isPeak;
    }

    private static final String reset$lambda$1() {
        return "spo2Calculator was reset";
    }

    private static final String addSampleToDetectPeak$lambda$2(float $redAC, float $infraRedAC, float $redDC, float $infraRedDC, float $redPeak, float $infraredPeak, float $redValley, float $infraredValley, float $perfusionIndex, float $spo2) {
        return "redAC: " + $redAC + ", infraRedAC: " + $infraRedAC + ", redDC: " + $redDC + ", infraRedDC: " + $infraRedDC + ",  redPeak: " + $redPeak + ",  irPeak: " + $infraredPeak + ",  redValley: " + $redValley + ",  irValley: " + $infraredValley + ",  perfusionIndex: " + $perfusionIndex + ", spo2: " + $spo2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/core/signalprocessing/Spo2Calculator$DetectionSpo2values;", "", "spo2", "", "perfusionIndex", "irPeak", "irValley", "<init>", "(FFFF)V", "getSpo2", "()F", "getPerfusionIndex", "getIrPeak", "getIrValley", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core-signal-processing"})
    public static final class DetectionSpo2values {
        private final float spo2;
        private final float perfusionIndex;
        private final float irPeak;
        private final float irValley;

        public DetectionSpo2values(float spo2, float perfusionIndex, float irPeak, float irValley) {
            this.spo2 = spo2;
            this.perfusionIndex = perfusionIndex;
            this.irPeak = irPeak;
            this.irValley = irValley;
        }

        public final float getSpo2() {
            return this.spo2;
        }

        public final float getPerfusionIndex() {
            return this.perfusionIndex;
        }

        public final float getIrPeak() {
            return this.irPeak;
        }

        public final float getIrValley() {
            return this.irValley;
        }

        public final float component1() {
            return this.spo2;
        }

        public final float component2() {
            return this.perfusionIndex;
        }

        public final float component3() {
            return this.irPeak;
        }

        public final float component4() {
            return this.irValley;
        }

        @NotNull
        public final DetectionSpo2values copy(float spo2, float perfusionIndex, float irPeak, float irValley) {
            return new DetectionSpo2values(spo2, perfusionIndex, irPeak, irValley);
        }

        public static /* synthetic */ DetectionSpo2values copy$default(DetectionSpo2values detectionSpo2values, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = detectionSpo2values.spo2;
            }
            if ((n & 2) != 0) {
                f2 = detectionSpo2values.perfusionIndex;
            }
            if ((n & 4) != 0) {
                f3 = detectionSpo2values.irPeak;
            }
            if ((n & 8) != 0) {
                f4 = detectionSpo2values.irValley;
            }
            return detectionSpo2values.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "DetectionSpo2values(spo2=" + this.spo2 + ", perfusionIndex=" + this.perfusionIndex + ", irPeak=" + this.irPeak + ", irValley=" + this.irValley + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.spo2);
            result = result * 31 + Float.hashCode(this.perfusionIndex);
            result = result * 31 + Float.hashCode(this.irPeak);
            result = result * 31 + Float.hashCode(this.irValley);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectionSpo2values)) {
                return false;
            }
            DetectionSpo2values detectionSpo2values = (DetectionSpo2values)other;
            if (Float.compare(this.spo2, detectionSpo2values.spo2) != 0) {
                return false;
            }
            if (Float.compare(this.perfusionIndex, detectionSpo2values.perfusionIndex) != 0) {
                return false;
            }
            if (Float.compare(this.irPeak, detectionSpo2values.irPeak) != 0) {
                return false;
            }
            return Float.compare(this.irValley, detectionSpo2values.irValley) == 0;
        }
    }
}

