/*
 * Decompiled with CFR 0.152.
 */
package dev.romainguy.kotlin.math;

import dev.romainguy.kotlin.math.Rational;
import kotlin.Metadata;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0019\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0082\u0010\u001a\u0019\u0010\f\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082\u0010\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Rational", "Ldev/romainguy/kotlin/math/Rational;", "value", "", "(D)J", "", "(F)J", "", "(I)J", "numerator", "denominator", "(II)J", "gcd", "a", "b", "", "pack", "kotlin-math"})
public final class RationalKt {
    public static final long Rational(double value) {
        return RationalKt.pack(value);
    }

    public static final long Rational(float value) {
        return RationalKt.pack(value);
    }

    public static final long Rational(int value) {
        return Rational.constructor-impl(RationalKt.pack(value, 1));
    }

    public static final long Rational(int numerator, int denominator) {
        return Rational.constructor-impl(RationalKt.pack(numerator, denominator));
    }

    private static final int gcd(int a, int b) {
        while (b != 0) {
            int n = b;
            int n2 = a % b;
            a = n;
            b = n2;
        }
        return Math.abs(a);
    }

    private static final long gcd(long a, long b) {
        while (b != 0L) {
            long l = b;
            long l2 = a % b;
            a = l;
            b = l2;
        }
        return Math.abs(a);
    }

    private static final long pack(double value) {
        long l;
        if (Double.isNaN(value)) {
            l = Rational.Companion.getNaN--nfT5vM();
        } else if (Double.isInfinite(value)) {
            l = value > 0.0 ? Rational.Companion.getPOSITIVE_INFINITY--nfT5vM() : Rational.Companion.getNEGATIVE_INFINITY--nfT5vM();
        } else if (value == 0.0) {
            l = Math.signum(value) > 0.0 ? Rational.Companion.getZERO--nfT5vM() : Rational.unaryMinus--nfT5vM(Rational.Companion.getZERO--nfT5vM());
        } else {
            long bits = Double.doubleToRawLongBits(value);
            long sign = bits >>> 63;
            long exponent = (bits >>> 52 ^ sign << 11) - 1023L;
            long fraction = bits << 12;
            long n = 1L;
            long d = 1L;
            for (int i = 63; i >= 12; --i) {
                n = n * 2L + (fraction >>> i & 1L);
                d *= 2L;
            }
            if (exponent > 0L) {
                n *= 1L << (int)exponent;
            } else {
                d *= 1L << -((int)exponent);
            }
            if (sign == 1L) {
                n *= (long)-1;
            }
            long gcd = RationalKt.gcd(n, d);
            l = RationalKt.Rational((int)(n /= gcd), (int)(d /= gcd));
        }
        return l;
    }

    private static final long pack(int numerator, int denominator) {
        int n = numerator;
        int d = denominator;
        if (d < 0) {
            n = -n;
            d = -d;
        }
        if (d == 0) {
            n = n > 0 ? 1 : (n < 0 ? -1 : 0);
        } else if (n == 0) {
            d = 1;
        } else {
            int gcd = RationalKt.gcd(n, d);
            n /= gcd;
            d /= gcd;
        }
        return (long)n << 32 | (long)d;
    }

    public static final /* synthetic */ long access$gcd(long a, long b) {
        return RationalKt.gcd(a, b);
    }
}

