/*
 * Decompiled with CFR 0.152.
 */
package dev.romainguy.kotlin.math;

import dev.romainguy.kotlin.math.Float3;
import dev.romainguy.kotlin.math.Float4;
import dev.romainguy.kotlin.math.Mat3;
import dev.romainguy.kotlin.math.MatrixColumn;
import dev.romainguy.kotlin.math.MatrixKt;
import dev.romainguy.kotlin.math.Quaternion;
import dev.romainguy.kotlin.math.RotationsOrder;
import dev.romainguy.kotlin.math.VectorKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 R2\u00020\u0001:\u0001RB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tB-\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\t\u0010/\u001a\u00020\u000bH\u00c6\u0003J\t\u00100\u001a\u00020\u000bH\u00c6\u0003J\t\u00101\u001a\u00020\u000bH\u00c6\u0003J\t\u00102\u001a\u00020\u000bH\u00c6\u0003J1\u00103\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bH\u00c6\u0001J\t\u00104\u001a\u00020\u0000H\u0086\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u000207H\u0086\u0002J\u0013\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0086\u0002J\u0019\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0086\u0002J\u0011\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020?H\u0086\u0002J\u0019\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020?2\u0006\u0010>\u001a\u00020?H\u0086\u0002J\t\u0010@\u001a\u00020?H\u00d6\u0001J\t\u0010A\u001a\u00020\u0000H\u0086\u0002J\u0019\u0010B\u001a\u0002072\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020?H\u0086\u0002J!\u0010B\u001a\u00020C2\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020?2\u0006\u00106\u001a\u000207H\u0086\u0002J\u0011\u0010D\u001a\u00020\u00002\u0006\u00106\u001a\u000207H\u0086\u0002J\u0011\u0010E\u001a\u00020\u00002\u0006\u00106\u001a\u000207H\u0086\u0002J\u0019\u0010F\u001a\u00020C2\u0006\u0010<\u001a\u00020?2\u0006\u00106\u001a\u00020\u000bH\u0086\u0002J!\u0010F\u001a\u00020C2\u0006\u0010<\u001a\u00020?2\u0006\u0010>\u001a\u00020?2\u0006\u00106\u001a\u000207H\u0086\u0002J\u0011\u0010G\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000bH\u0086\u0002J\u0011\u0010G\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010G\u001a\u00020\u00002\u0006\u00106\u001a\u000207H\u0086\u0002J\u0010\u0010H\u001a\u00020\u00032\b\b\u0002\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020LJ\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020PH\u0016J\t\u0010Q\u001a\u00020\u0000H\u0086\u0002R&\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0012\u0010\u001b\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0012\u0010\u001d\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R&\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u0012\u0010!\u001a\u00020\"8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010&\"\u0004\b*\u0010(R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010&\"\u0004\b,\u0010(R\u001a\u0010\r\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(\u00a8\u0006S"}, d2={"Ldev/romainguy/kotlin/math/Mat4;", "", "right", "Ldev/romainguy/kotlin/math/Float3;", "up", "forward", "position", "(Ldev/romainguy/kotlin/math/Float3;Ldev/romainguy/kotlin/math/Float3;Ldev/romainguy/kotlin/math/Float3;Ldev/romainguy/kotlin/math/Float3;)V", "m", "(Ldev/romainguy/kotlin/math/Mat4;)V", "x", "Ldev/romainguy/kotlin/math/Float4;", "y", "z", "w", "(Ldev/romainguy/kotlin/math/Float4;Ldev/romainguy/kotlin/math/Float4;Ldev/romainguy/kotlin/math/Float4;Ldev/romainguy/kotlin/math/Float4;)V", "value", "getForward", "()Ldev/romainguy/kotlin/math/Float3;", "setForward", "(Ldev/romainguy/kotlin/math/Float3;)V", "getPosition", "setPosition", "getRight", "setRight", "rotation", "getRotation", "scale", "getScale", "translation", "getTranslation", "getUp", "setUp", "upperLeft", "Ldev/romainguy/kotlin/math/Mat3;", "getUpperLeft", "()Ldev/romainguy/kotlin/math/Mat3;", "getW", "()Ldev/romainguy/kotlin/math/Float4;", "setW", "(Ldev/romainguy/kotlin/math/Float4;)V", "getX", "setX", "getY", "setY", "getZ", "setZ", "component1", "component2", "component3", "component4", "copy", "dec", "div", "v", "", "equals", "", "other", "get", "column", "Ldev/romainguy/kotlin/math/MatrixColumn;", "row", "", "hashCode", "inc", "invoke", "", "minus", "plus", "set", "times", "toEulerAngles", "order", "Ldev/romainguy/kotlin/math/RotationsOrder;", "toFloatArray", "", "toQuaternion", "Ldev/romainguy/kotlin/math/Quaternion;", "toString", "", "unaryMinus", "Companion", "kotlin-math"})
public final class Mat4 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Float4 x;
    @NotNull
    private Float4 y;
    @NotNull
    private Float4 z;
    @NotNull
    private Float4 w;

    public Mat4(@NotNull Float4 x, @NotNull Float4 y, @NotNull Float4 z, @NotNull Float4 w) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public /* synthetic */ Mat4(Float4 float4, Float4 float42, Float4 float43, Float4 float44, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            float4 = new Float4(1.0f, 0.0f, 0.0f, 0.0f, 14, null);
        }
        if ((n & 2) != 0) {
            float42 = new Float4(0.0f, 1.0f, 0.0f, 0.0f, 13, null);
        }
        if ((n & 4) != 0) {
            float43 = new Float4(0.0f, 0.0f, 1.0f, 0.0f, 11, null);
        }
        if ((n & 8) != 0) {
            float44 = new Float4(0.0f, 0.0f, 0.0f, 1.0f, 7, null);
        }
        this(float4, float42, float43, float44);
    }

    @NotNull
    public final Float4 getX() {
        return this.x;
    }

    public final void setX(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.x = float4;
    }

    @NotNull
    public final Float4 getY() {
        return this.y;
    }

    public final void setY(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.y = float4;
    }

    @NotNull
    public final Float4 getZ() {
        return this.z;
    }

    public final void setZ(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.z = float4;
    }

    @NotNull
    public final Float4 getW() {
        return this.w;
    }

    public final void setW(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.w = float4;
    }

    public Mat4(@NotNull Float3 right, @NotNull Float3 up, @NotNull Float3 forward, @NotNull Float3 position) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(new Float4(right, 0.0f, 2, null), new Float4(up, 0.0f, 2, null), new Float4(forward, 0.0f, 2, null), new Float4(position, 1.0f));
    }

    public /* synthetic */ Mat4(Float3 float3, Float3 float32, Float3 float33, Float3 float34, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            float34 = new Float3(0.0f, 0.0f, 0.0f, 7, null);
        }
        this(float3, float32, float33, float34);
    }

    public Mat4(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(Float4.copy$default(m.x, 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Float4.copy$default(m.y, 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Float4.copy$default(m.z, 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Float4.copy$default(m.w, 0.0f, 0.0f, 0.0f, 0.0f, 15, null));
    }

    @NotNull
    public final Float3 getRight() {
        boolean $i$f$getRight = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setRight(@NotNull Float3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setRight = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Float3 getUp() {
        boolean $i$f$getUp = false;
        Float4 this_$iv = this.getY();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setUp(@NotNull Float3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setUp = false;
        Float4 this_$iv = this.getY();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Float3 getForward() {
        boolean $i$f$getForward = false;
        Float4 this_$iv = this.getZ();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setForward(@NotNull Float3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setForward = false;
        Float4 this_$iv = this.getZ();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Float3 getPosition() {
        boolean $i$f$getPosition = false;
        Float4 this_$iv = this.getW();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setPosition(@NotNull Float3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setPosition = false;
        Float4 this_$iv = this.getW();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Float3 getScale() {
        boolean $i$f$getScale = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        Float3 v$iv = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        boolean $i$f$length = false;
        float f = (float)Math.sqrt(v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ());
        this_$iv = this.getY();
        $i$f$getXyz = false;
        v$iv = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        $i$f$length = false;
        float f2 = (float)Math.sqrt(v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ());
        this_$iv = this.getZ();
        $i$f$getXyz = false;
        v$iv = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        $i$f$length = false;
        return new Float3(f, f2, (float)Math.sqrt(v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ()));
    }

    @NotNull
    public final Float3 getTranslation() {
        boolean $i$f$getTranslation = false;
        Float4 this_$iv = this.getW();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    @NotNull
    public final Float3 getRotation() {
        Float3 float3;
        boolean $i$f$degrees;
        Mat4 this_$iv = this;
        boolean $i$f$getRight = false;
        Float4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Float3 x = VectorKt.normalize(new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ()));
        Mat4 this_$iv2 = this;
        boolean $i$f$getUp = false;
        Float4 this_$iv$iv2 = this_$iv2.getY();
        boolean $i$f$getXyz2 = false;
        Float3 y = VectorKt.normalize(new Float3(this_$iv$iv2.getX(), this_$iv$iv2.getY(), this_$iv$iv2.getZ()));
        Mat4 this_$iv3 = this;
        boolean $i$f$getForward = false;
        Float4 this_$iv$iv3 = this_$iv3.getZ();
        boolean $i$f$getXyz3 = false;
        Float3 z = VectorKt.normalize(new Float3(this_$iv$iv3.getX(), this_$iv$iv3.getY(), this_$iv$iv3.getZ()));
        if (z.getY() <= -1.0f) {
            float v$iv = -1.5707964f;
            $i$f$degrees = false;
            float f = v$iv * 57.295776f;
            v$iv = (float)Math.atan2(x.getZ(), y.getZ());
            $i$f$degrees = false;
            Float3 float32 = new Float3(f, 0.0f, v$iv * 57.295776f);
            float3 = float32;
        } else if (z.getY() >= 1.0f) {
            float v$iv = 1.5707964f;
            $i$f$degrees = false;
            float f = v$iv * 57.295776f;
            v$iv = (float)Math.atan2(-x.getZ(), -y.getZ());
            $i$f$degrees = false;
            Float3 float33 = new Float3(f, 0.0f, v$iv * 57.295776f);
            float3 = float33;
        } else {
            float v$iv = -((float)Math.asin(z.getY()));
            $i$f$degrees = false;
            float f = v$iv * 57.295776f;
            v$iv = -((float)Math.atan2(z.getX(), z.getZ()));
            $i$f$degrees = false;
            float f2 = v$iv * 57.295776f;
            v$iv = (float)Math.atan2(x.getY(), y.getY());
            $i$f$degrees = false;
            Float3 float34 = new Float3(f, f2, v$iv * 57.295776f);
            float3 = float34;
        }
        return float3;
    }

    @NotNull
    public final Mat3 getUpperLeft() {
        boolean $i$f$getUpperLeft = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        Float3 float3 = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        this_$iv = this.getY();
        $i$f$getXyz = false;
        Float3 float32 = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        this_$iv = this.getZ();
        $i$f$getXyz = false;
        return new Mat3(float3, float32, new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ()));
    }

    @NotNull
    public final Float4 get(int column) {
        Float4 float4;
        switch (column) {
            case 0: {
                float4 = this.x;
                break;
            }
            case 1: {
                float4 = this.y;
                break;
            }
            case 2: {
                float4 = this.z;
                break;
            }
            case 3: {
                float4 = this.w;
                break;
            }
            default: {
                throw new IllegalArgumentException("column must be in 0..3");
            }
        }
        return float4;
    }

    public final float get(int column, int row) {
        return this.get(column).get(row);
    }

    @NotNull
    public final Float4 get(@NotNull MatrixColumn column) {
        Float4 float4;
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        switch (WhenMappings.$EnumSwitchMapping$0[column.ordinal()]) {
            case 1: {
                float4 = this.x;
                break;
            }
            case 2: {
                float4 = this.y;
                break;
            }
            case 3: {
                float4 = this.z;
                break;
            }
            case 4: {
                float4 = this.w;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return float4;
    }

    public final float get(@NotNull MatrixColumn column, int row) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return this.get(column).get(row);
    }

    public final float invoke(int row, int column) {
        return this.get(column - 1).get(row - 1);
    }

    public final void invoke(int row, int column, float v) {
        this.set(column - 1, row - 1, v);
    }

    public final void set(int column, @NotNull Float4 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Float4 this_$iv = this.get(column);
        boolean $i$f$setXyzw = false;
        this_$iv.setX(v.getX());
        this_$iv.setY(v.getY());
        this_$iv.setZ(v.getZ());
        this_$iv.setW(v.getW());
    }

    public final void set(int column, int row, float v) {
        this.get(column).set(row, v);
    }

    @NotNull
    public final Mat4 unaryMinus() {
        return new Mat4(this.x.unaryMinus(), this.y.unaryMinus(), this.z.unaryMinus(), this.w.unaryMinus());
    }

    @NotNull
    public final Mat4 inc() {
        Float4 float4 = this.x;
        this.x = float4.inc();
        Float4 float42 = float4;
        float4 = this.y;
        this.y = float4.inc();
        Float4 float43 = float4;
        float4 = this.z;
        this.z = float4.inc();
        Float4 float44 = float4;
        float4 = this.w;
        this.w = float4.inc();
        return new Mat4(float42, float43, float44, float4);
    }

    @NotNull
    public final Mat4 dec() {
        Float4 float4 = this.x;
        this.x = float4.dec();
        Float4 float42 = float4;
        float4 = this.y;
        this.y = float4.dec();
        Float4 float43 = float4;
        float4 = this.z;
        this.z = float4.dec();
        Float4 float44 = float4;
        float4 = this.w;
        this.w = float4.dec();
        return new Mat4(float42, float43, float44, float4);
    }

    @NotNull
    public final Mat4 plus(float v) {
        Float4 this_$iv = this.x;
        boolean $i$f$plus = false;
        Float4 float4 = new Float4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        this_$iv = this.y;
        $i$f$plus = false;
        Float4 float42 = new Float4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        this_$iv = this.z;
        $i$f$plus = false;
        Float4 float43 = new Float4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        this_$iv = this.w;
        $i$f$plus = false;
        return new Mat4(float4, float42, float43, new Float4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v));
    }

    @NotNull
    public final Mat4 minus(float v) {
        Float4 this_$iv = this.x;
        boolean $i$f$minus = false;
        Float4 float4 = new Float4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        this_$iv = this.y;
        $i$f$minus = false;
        Float4 float42 = new Float4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        this_$iv = this.z;
        $i$f$minus = false;
        Float4 float43 = new Float4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        this_$iv = this.w;
        $i$f$minus = false;
        return new Mat4(float4, float42, float43, new Float4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v));
    }

    @NotNull
    public final Mat4 times(float v) {
        Float4 this_$iv = this.x;
        boolean $i$f$times = false;
        Float4 float4 = new Float4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        this_$iv = this.y;
        $i$f$times = false;
        Float4 float42 = new Float4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        this_$iv = this.z;
        $i$f$times = false;
        Float4 float43 = new Float4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        this_$iv = this.w;
        $i$f$times = false;
        return new Mat4(float4, float42, float43, new Float4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v));
    }

    @NotNull
    public final Mat4 div(float v) {
        Float4 this_$iv = this.x;
        boolean $i$f$div = false;
        Float4 float4 = new Float4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        this_$iv = this.y;
        $i$f$div = false;
        Float4 float42 = new Float4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        this_$iv = this.z;
        $i$f$div = false;
        Float4 float43 = new Float4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        this_$iv = this.w;
        $i$f$div = false;
        return new Mat4(float4, float42, float43, new Float4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v));
    }

    @NotNull
    public final Mat4 times(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat4(new Float4(this.x.getX() * m.x.getX() + this.y.getX() * m.x.getY() + this.z.getX() * m.x.getZ() + this.w.getX() * m.x.getW(), this.x.getY() * m.x.getX() + this.y.getY() * m.x.getY() + this.z.getY() * m.x.getZ() + this.w.getY() * m.x.getW(), this.x.getZ() * m.x.getX() + this.y.getZ() * m.x.getY() + this.z.getZ() * m.x.getZ() + this.w.getZ() * m.x.getW(), this.x.getW() * m.x.getX() + this.y.getW() * m.x.getY() + this.z.getW() * m.x.getZ() + this.w.getW() * m.x.getW()), new Float4(this.x.getX() * m.y.getX() + this.y.getX() * m.y.getY() + this.z.getX() * m.y.getZ() + this.w.getX() * m.y.getW(), this.x.getY() * m.y.getX() + this.y.getY() * m.y.getY() + this.z.getY() * m.y.getZ() + this.w.getY() * m.y.getW(), this.x.getZ() * m.y.getX() + this.y.getZ() * m.y.getY() + this.z.getZ() * m.y.getZ() + this.w.getZ() * m.y.getW(), this.x.getW() * m.y.getX() + this.y.getW() * m.y.getY() + this.z.getW() * m.y.getZ() + this.w.getW() * m.y.getW()), new Float4(this.x.getX() * m.z.getX() + this.y.getX() * m.z.getY() + this.z.getX() * m.z.getZ() + this.w.getX() * m.z.getW(), this.x.getY() * m.z.getX() + this.y.getY() * m.z.getY() + this.z.getY() * m.z.getZ() + this.w.getY() * m.z.getW(), this.x.getZ() * m.z.getX() + this.y.getZ() * m.z.getY() + this.z.getZ() * m.z.getZ() + this.w.getZ() * m.z.getW(), this.x.getW() * m.z.getX() + this.y.getW() * m.z.getY() + this.z.getW() * m.z.getZ() + this.w.getW() * m.z.getW()), new Float4(this.x.getX() * m.w.getX() + this.y.getX() * m.w.getY() + this.z.getX() * m.w.getZ() + this.w.getX() * m.w.getW(), this.x.getY() * m.w.getX() + this.y.getY() * m.w.getY() + this.z.getY() * m.w.getZ() + this.w.getY() * m.w.getW(), this.x.getZ() * m.w.getX() + this.y.getZ() * m.w.getY() + this.z.getZ() * m.w.getZ() + this.w.getZ() * m.w.getW(), this.x.getW() * m.w.getX() + this.y.getW() * m.w.getY() + this.z.getW() * m.w.getZ() + this.w.getW() * m.w.getW()));
    }

    @NotNull
    public final Float4 times(@NotNull Float4 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Float4(this.x.getX() * v.getX() + this.y.getX() * v.getY() + this.z.getX() * v.getZ() + this.w.getX() * v.getW(), this.x.getY() * v.getX() + this.y.getY() * v.getY() + this.z.getY() * v.getZ() + this.w.getY() * v.getW(), this.x.getZ() * v.getX() + this.y.getZ() * v.getY() + this.z.getZ() * v.getZ() + this.w.getZ() * v.getW(), this.x.getW() * v.getX() + this.y.getW() * v.getY() + this.z.getW() * v.getZ() + this.w.getW() * v.getW());
    }

    @NotNull
    public final Float3 toEulerAngles(@NotNull RotationsOrder order) {
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        return MatrixKt.eulerAngles(this, order);
    }

    public static /* synthetic */ Float3 toEulerAngles$default(Mat4 mat4, RotationsOrder rotationsOrder, int n, Object object) {
        if ((n & 1) != 0) {
            rotationsOrder = RotationsOrder.ZYX;
        }
        return mat4.toEulerAngles(rotationsOrder);
    }

    @NotNull
    public final Quaternion toQuaternion() {
        return MatrixKt.quaternion(this);
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] fArray = new float[]{this.x.getX(), this.y.getX(), this.z.getX(), this.w.getX(), this.x.getY(), this.y.getY(), this.z.getY(), this.w.getY(), this.x.getZ(), this.y.getZ(), this.z.getZ(), this.w.getZ(), this.x.getW(), this.y.getW(), this.z.getW(), this.w.getW()};
        return fArray;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n            |").append(this.x.getX()).append(' ').append(this.y.getX()).append(' ').append(this.z.getX()).append(' ').append(this.w.getX()).append("|\n            |").append(this.x.getY()).append(' ').append(this.y.getY()).append(' ').append(this.z.getY()).append(' ').append(this.w.getY()).append("|\n            |").append(this.x.getZ()).append(' ').append(this.y.getZ()).append(' ').append(this.z.getZ()).append(' ');
        stringBuilder.append(this.w.getZ()).append("|\n            |").append(this.x.getW()).append(' ').append(this.y.getW()).append(' ').append(this.z.getW()).append(' ').append(this.w.getW()).append("|\n            ");
        return StringsKt.trimIndent((String)stringBuilder.toString());
    }

    @NotNull
    public final Float4 component1() {
        return this.x;
    }

    @NotNull
    public final Float4 component2() {
        return this.y;
    }

    @NotNull
    public final Float4 component3() {
        return this.z;
    }

    @NotNull
    public final Float4 component4() {
        return this.w;
    }

    @NotNull
    public final Mat4 copy(@NotNull Float4 x, @NotNull Float4 y, @NotNull Float4 z, @NotNull Float4 w) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return new Mat4(x, y, z, w);
    }

    public static /* synthetic */ Mat4 copy$default(Mat4 mat4, Float4 float4, Float4 float42, Float4 float43, Float4 float44, int n, Object object) {
        if ((n & 1) != 0) {
            float4 = mat4.x;
        }
        if ((n & 2) != 0) {
            float42 = mat4.y;
        }
        if ((n & 4) != 0) {
            float43 = mat4.z;
        }
        if ((n & 8) != 0) {
            float44 = mat4.w;
        }
        return mat4.copy(float4, float42, float43, float44);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = result * 31 + this.y.hashCode();
        result = result * 31 + this.z.hashCode();
        result = result * 31 + this.w.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mat4)) {
            return false;
        }
        Mat4 mat4 = (Mat4)other;
        if (!Intrinsics.areEqual((Object)this.x, (Object)mat4.x)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.y, (Object)mat4.y)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.z, (Object)mat4.z)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.w, (Object)mat4.w);
    }

    public Mat4() {
        this((Float4)null, (Float4)null, (Float4)null, (Float4)null, 15, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0005\u001a\u00020\u00042\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b\u00a8\u0006\t"}, d2={"Ldev/romainguy/kotlin/math/Mat4$Companion;", "", "()V", "identity", "Ldev/romainguy/kotlin/math/Mat4;", "of", "a", "", "", "kotlin-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Mat4 of(float ... a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (!(a.length >= 16)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Mat4(new Float4(a[0], a[4], a[8], a[12]), new Float4(a[1], a[5], a[9], a[13]), new Float4(a[2], a[6], a[10], a[14]), new Float4(a[3], a[7], a[11], a[15]));
        }

        @NotNull
        public final Mat4 identity() {
            return new Mat4(null, null, null, null, 15, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatrixColumn.values().length];
            try {
                nArray[MatrixColumn.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.W.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

