/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.npy;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.npy.BooleanArrayChunker;
import org.jetbrains.bio.npy.BooleanArrayMerger;
import org.jetbrains.bio.npy.ByteArrayMerger;
import org.jetbrains.bio.npy.DictParserKt;
import org.jetbrains.bio.npy.DoubleArrayChunker;
import org.jetbrains.bio.npy.DoubleArrayMerger;
import org.jetbrains.bio.npy.ExceptionsKt;
import org.jetbrains.bio.npy.FloatArrayChunker;
import org.jetbrains.bio.npy.FloatArrayMerger;
import org.jetbrains.bio.npy.IntArrayChunker;
import org.jetbrains.bio.npy.IntArrayMerger;
import org.jetbrains.bio.npy.LongArrayChunker;
import org.jetbrains.bio.npy.LongArrayMerger;
import org.jetbrains.bio.npy.NpyArray;
import org.jetbrains.bio.npy.NpyFile;
import org.jetbrains.bio.npy.NpyKt;
import org.jetbrains.bio.npy.PeekingIterator;
import org.jetbrains.bio.npy.ShortArrayChunker;
import org.jetbrains.bio.npy.ShortArrayMerger;
import org.jetbrains.bio.npy.StringArrayChunker;
import org.jetbrains.bio.npy.StringArrayMerger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\u0010\u0012\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0016\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u001b\u0010\u0015\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ-\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u001fJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u000e2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u000f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00122\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00132\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00142\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/bio/npy/NpyFile;", "", "()V", "allocate", "Lkotlin/sequences/Sequence;", "Ljava/nio/ByteBuffer;", "data", "", "", "shape", "", "allocate$npy", "([Ljava/lang/String;[I)Lkotlin/sequences/Sequence;", "", "", "", "order", "Ljava/nio/ByteOrder;", "", "", "", "read", "Lorg/jetbrains/bio/npy/NpyArray;", "path", "Ljava/nio/file/Path;", "step", "", "chunks", "read$npy", "write", "", "(Ljava/nio/file/Path;[Ljava/lang/String;[I)V", "Header", "npy"})
public final class NpyFile {
    @NotNull
    public static final NpyFile INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final NpyArray read(@NotNull Path path, int step) {
        NpyArray npyArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = FileChannel.open(path, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            void chunk;
            void remaining;
            FileChannel it = (FileChannel)closeable;
            boolean bl3 = false;
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = Files.size(path);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = ByteBuffer.allocate(0);
            npyArray = INSTANCE.read$npy((Sequence<? extends ByteBuffer>)SequencesKt.generateSequence((Function0)((Function0)new Function0<ByteBuffer>((Ref.LongRef)remaining, (Ref.ObjectRef)chunk, it, path, step){
                final /* synthetic */ Ref.LongRef $remaining;
                final /* synthetic */ Ref.ObjectRef $chunk;
                final /* synthetic */ FileChannel $it;
                final /* synthetic */ Path $path$inlined;
                final /* synthetic */ int $step$inlined;
                {
                    this.$remaining = longRef;
                    this.$chunk = objectRef;
                    this.$it = fileChannel;
                    this.$path$inlined = path;
                    this.$step$inlined = n;
                    super(0);
                }

                @Nullable
                public final ByteBuffer invoke() {
                    ByteBuffer byteBuffer;
                    this.$remaining.element += (long)((ByteBuffer)this.$chunk.element).remaining();
                    if (this.$remaining.element == 0L) {
                        byteBuffer = null;
                    } else {
                        long offset = Files.size(this.$path$inlined) - this.$remaining.element;
                        this.$chunk.element = this.$it.map(FileChannel.MapMode.READ_ONLY, offset, this.$remaining.element > (long)this.$step$inlined ? (long)this.$step$inlined : this.$remaining.element);
                        this.$remaining.element -= (long)((ByteBuffer)this.$chunk.element).capacity();
                        byteBuffer = (ByteBuffer)this.$chunk.element;
                    }
                    return byteBuffer;
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return npyArray;
    }

    public static /* synthetic */ NpyArray read$default(Path path, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return NpyFile.read(path, n);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final NpyArray read$npy(@NotNull Sequence<? extends ByteBuffer> chunks) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        iterator = new PeekingIterator<T>(chunks.iterator());
        header = Header.Companion.read((ByteBuffer)iterator.peek());
        $this$reduce$iv = header.getShape();
        $i$f$reduce = false;
        var7_7 = $this$reduce$iv;
        var8_10 = 0;
        if (var7_7.length == 0) {
            throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
        }
        accumulator$iv = $this$reduce$iv[0];
        var8_10 = 1;
        var9_12 = ArraysKt.getLastIndex((int[])$this$reduce$iv);
        if (var8_10 <= var9_12) {
            while (true) {
                var10_13 = $this$reduce$iv[index$iv];
                a = accumulator$iv;
                $i$a$-reduce-NpyFile$read$size$1 = false;
                accumulator$iv = a * b;
                if (index$iv == var9_12) break;
                ++index$iv;
            }
        }
        size = accumulator$iv;
        block0 : switch (header.getType()) {
            case 'b': {
                switch (header.getBytes()) {
                    case 1: {
                        ** break;
                    }
                    default: {
                        v0 = ExceptionsKt.unexpectedByteNumber(header.getType(), header.getBytes());
                        throw new KotlinNothingValueException();
                    }
lbl-1000:
                    // 1 sources

                    {
                        v1 = new BooleanArrayMerger(size);
                    }
                }
                break;
            }
            case 'i': 
            case 'u': {
                switch (header.getBytes()) {
                    case 1: {
                        v1 = new ByteArrayMerger(size);
                        break block0;
                    }
                    case 2: {
                        v1 = new ShortArrayMerger(size);
                        break block0;
                    }
                    case 4: {
                        v1 = new IntArrayMerger(size);
                        break block0;
                    }
                    case 8: {
                        v1 = new LongArrayMerger(size);
                        break block0;
                    }
                }
                v2 = ExceptionsKt.unexpectedByteNumber(header.getType(), header.getBytes());
                throw new KotlinNothingValueException();
            }
            case 'f': {
                switch (header.getBytes()) {
                    case 4: {
                        v1 = new FloatArrayMerger(size);
                        break block0;
                    }
                    case 8: {
                        v1 = new DoubleArrayMerger(size);
                        break block0;
                    }
                }
                v3 = ExceptionsKt.unexpectedByteNumber(header.getType(), header.getBytes());
                throw new KotlinNothingValueException();
            }
            case 'S': {
                v1 = new StringArrayMerger(size, header.getBytes());
                break;
            }
            default: {
                v4 = ExceptionsKt.unexpectedHeaderType(header.getType());
                throw new KotlinNothingValueException();
            }
        }
        merger = v1;
        var8_11 = iterator;
        var9_12 = 0;
        var7_9 = var8_11;
        while (var7_9.hasNext()) {
            chunk = (ByteBuffer)var7_9.next();
            if (header.getOrder() != null) {
                var9_12 = 0;
                var10_13 = 0;
                it = var8_11;
                $i$a$-let-NpyFile$read$2 = false;
                chunk.order((ByteOrder)it);
            }
            merger.invoke(chunk);
        }
        return new NpyArray(merger.result(), header.getShape());
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull boolean[] data, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape));
    }

    public static /* synthetic */ void write$default(Path path, boolean[] blArray, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{blArray.length};
        }
        NpyFile.write(path, blArray, nArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull boolean[] data) {
        NpyFile.write$default(path, data, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull byte[] data, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape));
    }

    public static /* synthetic */ void write$default(Path path, byte[] byArray, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{byArray.length};
        }
        NpyFile.write(path, byArray, nArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull byte[] data) {
        NpyFile.write$default(path, data, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull short[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape, order));
    }

    public static /* synthetic */ void write$default(Path path, short[] sArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{sArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, sArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull short[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull short[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull int[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape, order));
    }

    public static /* synthetic */ void write$default(Path path, int[] nArray, int[] nArray2, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray2 = new int[]{nArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, nArray, nArray2, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull int[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull int[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull long[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape, order));
    }

    public static /* synthetic */ void write$default(Path path, long[] lArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{lArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, lArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull long[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull long[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull float[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape, order));
    }

    public static /* synthetic */ void write$default(Path path, float[] fArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{fArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, fArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull float[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull float[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull double[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape, order));
    }

    public static /* synthetic */ void write$default(Path path, double[] dArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{dArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, dArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull double[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull double[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull String[] data, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        INSTANCE.write(path, INSTANCE.allocate$npy(data, shape));
    }

    public static /* synthetic */ void write$default(Path path, String[] stringArray, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{stringArray.length};
        }
        NpyFile.write(path, stringArray, nArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull String[] data) {
        NpyFile.write$default(path, data, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(Path path, Sequence<? extends ByteBuffer> chunks) {
        Closeable closeable = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)closeable;
            boolean bl3 = false;
            for (ByteBuffer chunk : chunks) {
                while (chunk.hasRemaining()) {
                    it.write(chunk);
                }
            }
            FileChannel fileChannel = it.truncate(it.position());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull boolean[] data, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Header header = new Header(null, 'b', 1, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new BooleanArrayChunker(data));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull byte[] data, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Header header = new Header(null, 'i', 1, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Object)ByteBuffer.wrap(data));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull short[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Header header = new Header(order, 'i', 2, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new ShortArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull int[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Header header = new Header(order, 'i', 4, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new IntArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull long[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Header header = new Header(order, 'i', 8, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new LongArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull float[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Header header = new Header(order, 'f', 4, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new FloatArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull double[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        Header header = new Header(order, 'f', 8, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new DoubleArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy(@NotNull String[] data, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])data), (Function1)allocate.bytes.1.INSTANCE));
        int bytes2 = n != null ? n : 0;
        Header header = new Header(null, 'S', bytes2, shape);
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])new ByteBuffer[]{header.allocate$npy()}), (Sequence)new StringArrayChunker(data));
    }

    private NpyFile() {
    }

    static {
        NpyFile npyFile;
        INSTANCE = npyFile = new NpyFile();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\b\u0018\u0000 '2\u00020\u0001:\u0001'B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aH\u0000\u00a2\u0006\u0002\b\u001cJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J3\u0010!\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020\u0007H\u0016J\t\u0010&\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/bio/npy/NpyFile$Header;", "", "order", "Ljava/nio/ByteOrder;", "type", "", "bytes", "", "shape", "", "(Ljava/nio/ByteOrder;CI[I)V", "getBytes", "()I", "major", "getMajor", "meta", "", "minor", "getOrder", "()Ljava/nio/ByteOrder;", "getShape", "()[I", "size", "getType", "()C", "allocate", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "allocate$npy", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "npy"})
    public static final class Header {
        private final int major;
        private final int minor;
        private final String meta;
        private final int size;
        @Nullable
        private final ByteOrder order;
        private final char type;
        private final int bytes;
        @NotNull
        private final int[] shape;
        @NotNull
        private static final byte[] MAGIC;
        private static int NPY_10_20_SIZE_BOUNDARY;
        @NotNull
        public static final Companion Companion;

        public final int getMajor() {
            return this.major;
        }

        public final ByteBuffer allocate$npy() {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.size);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer $this$apply = byteBuffer;
            boolean bl3 = false;
            $this$apply.order(ByteOrder.LITTLE_ENDIAN);
            $this$apply.put(MAGIC);
            $this$apply.put((byte)this.major);
            $this$apply.put((byte)this.minor);
            Object object = TuplesKt.to((Object)this.major, (Object)this.minor);
            if (Intrinsics.areEqual((Object)object, (Object)TuplesKt.to((Object)1, (Object)0))) {
                $this$apply.putShort((short)this.meta.length());
            } else if (Intrinsics.areEqual((Object)object, (Object)TuplesKt.to((Object)2, (Object)0))) {
                $this$apply.putInt(this.meta.length());
            }
            object = this.meta;
            Charset charset = Charsets.US_ASCII;
            boolean bl4 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object2).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            $this$apply.put(byArray);
            $this$apply.rewind();
            return byteBuffer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) return false;
            if (!(other instanceof Header)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.order, (Object)((Header)other).order)) return false;
            if (this.type != ((Header)other).type) return false;
            if (this.bytes != ((Header)other).bytes) return false;
            int[] nArray = this.shape;
            int[] nArray2 = ((Header)other).shape;
            boolean bl = false;
            if (!Arrays.equals(nArray, nArray2)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.order, Character.valueOf(this.type), this.bytes, Arrays.hashCode(this.shape));
        }

        @Nullable
        public final ByteOrder getOrder() {
            return this.order;
        }

        public final char getType() {
            return this.type;
        }

        public final int getBytes() {
            return this.bytes;
        }

        @NotNull
        public final int[] getShape() {
            return this.shape;
        }

        public Header(@Nullable ByteOrder order, char type, int bytes2, @NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            this.order = order;
            this.type = type;
            this.bytes = bytes2;
            this.shape = shape;
            String string = new StringJoiner(", ", "{", "}").add("'descr': '" + NpyKt.access$toChar(this.order) + this.type + this.bytes + '\'').add("'fortran_order': False").add("'shape': (" + ArraysKt.joinToString$default((int[])this.shape, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ", )").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringJoiner(\", \", \"{\", \u2026              .toString()");
            String metaUnpadded = string;
            int totalUnpadded = MAGIC.length + 2 + 2 + metaUnpadded.length() + 1;
            int padding = 16 - totalUnpadded % 16;
            int total = totalUnpadded + padding;
            if (total <= NPY_10_20_SIZE_BOUNDARY) {
                this.major = 1;
            } else {
                total += 2;
                this.major = 2;
            }
            this.meta = metaUnpadded + StringsKt.repeat((CharSequence)" ", (int)padding) + '\n';
            this.size = total;
        }

        public /* synthetic */ Header(ByteOrder byteOrder, char c, int n, int[] nArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                byteOrder = null;
            }
            this(byteOrder, c, n, nArray);
        }

        static {
            Companion = new Companion(null);
            byte[] byArray = new byte[]{(byte)147};
            String string = "NUMPY";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray2 = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            MAGIC = ArraysKt.plus((byte[])byArray, (byte[])byArray2);
            NPY_10_20_SIZE_BOUNDARY = 65535;
        }

        @Nullable
        public final ByteOrder component1() {
            return this.order;
        }

        public final char component2() {
            return this.type;
        }

        public final int component3() {
            return this.bytes;
        }

        @NotNull
        public final int[] component4() {
            return this.shape;
        }

        @NotNull
        public final Header copy(@Nullable ByteOrder order, char type, int bytes2, @NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return new Header(order, type, bytes2, shape);
        }

        public static /* synthetic */ Header copy$default(Header header, ByteOrder byteOrder, char c, int n, int[] nArray, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byteOrder = header.order;
            }
            if ((n2 & 2) != 0) {
                c = header.type;
            }
            if ((n2 & 4) != 0) {
                n = header.bytes;
            }
            if ((n2 & 8) != 0) {
                nArray = header.shape;
            }
            return header.copy(byteOrder, c, n, nArray);
        }

        @NotNull
        public String toString() {
            return "Header(order=" + this.order + ", type=" + this.type + ", bytes=" + this.bytes + ", shape=" + Arrays.toString(this.shape) + ")";
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bio/npy/NpyFile$Header$Companion;", "", "()V", "MAGIC", "", "getMAGIC$npy", "()[B", "NPY_10_20_SIZE_BOUNDARY", "", "getNPY_10_20_SIZE_BOUNDARY$npy", "()I", "setNPY_10_20_SIZE_BOUNDARY$npy", "(I)V", "read", "Lorg/jetbrains/bio/npy/NpyFile$Header;", "input", "Ljava/nio/ByteBuffer;", "npy"})
        public static final class Companion {
            @NotNull
            public final byte[] getMAGIC$npy() {
                return MAGIC;
            }

            public final int getNPY_10_20_SIZE_BOUNDARY$npy() {
                return NPY_10_20_SIZE_BOUNDARY;
            }

            public final void setNPY_10_20_SIZE_BOUNDARY$npy(int n) {
                NPY_10_20_SIZE_BOUNDARY = n;
            }

            @NotNull
            public final Header read(@NotNull ByteBuffer input) {
                int n;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                ByteBuffer byteBuffer = input.order(ByteOrder.LITTLE_ENDIAN);
                boolean bl = false;
                boolean bl2 = false;
                ByteBuffer $this$with = byteBuffer;
                boolean bl3 = false;
                byte[] buf = new byte[6];
                $this$with.get(buf);
                byte[] byArray = Companion.getMAGIC$npy();
                boolean bl4 = false;
                boolean bl5 = Arrays.equals(byArray, buf);
                bl4 = false;
                boolean bl6 = false;
                if (!bl5) {
                    boolean bl7 = false;
                    byte[] byArray2 = buf;
                    boolean bl8 = false;
                    String string = "bad magic: " + new String(byArray2, Charsets.UTF_8);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                byte major = $this$with.get();
                byte minor = $this$with.get();
                Pair bl7 = TuplesKt.to((Object)major, (Object)minor);
                if (Intrinsics.areEqual((Object)bl7, (Object)TuplesKt.to((Object)1, (Object)0))) {
                    n = $this$with.getShort();
                } else if (Intrinsics.areEqual((Object)bl7, (Object)TuplesKt.to((Object)2, (Object)0))) {
                    n = $this$with.getInt();
                } else {
                    String string = "unsupported version: " + major + '.' + minor;
                    boolean bl9 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int size = n;
                byte[] header = new byte[size];
                $this$with.get(header);
                boolean bl10 = false;
                String s = new String(header, Charsets.UTF_8);
                Map<String, Object> meta = DictParserKt.parseDict(s);
                Object object = meta.get("descr");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String type = (String)object;
                Object object2 = meta.get("fortran_order");
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                boolean bl11 = (Boolean)object2 == false;
                boolean bl12 = false;
                boolean bl13 = false;
                if (!bl11) {
                    boolean bl14 = false;
                    String string = "Fortran-contiguous arrays are not supported";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Object object3 = meta.get("shape");
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
                }
                int[] shape = CollectionsKt.toIntArray((Collection)((List)object3));
                ByteOrder order = NpyKt.access$toByteOrder(type.charAt(0));
                char c = type.charAt(1);
                String string = type;
                int n2 = 2;
                boolean bl15 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string = string3;
                n2 = 0;
                return new Header(order, c, Integer.parseInt(string), shape);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

