/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.client.database.application.converters;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.client.database.AnestheticRecordEntity;
import vet.inpulse.core.client.database.AnestheticRecordEntityView;
import vet.inpulse.core.client.database.EcgRecordEntity;
import vet.inpulse.core.client.database.EcgRecordEntityView;
import vet.inpulse.core.client.database.EcgReportEntity;
import vet.inpulse.core.client.database.EstablishmentEntity;
import vet.inpulse.core.client.database.NibpRecordEntity;
import vet.inpulse.core.client.database.NibpRecordEntityView;
import vet.inpulse.core.client.database.OwnerEntity;
import vet.inpulse.core.client.database.PatientEntity;
import vet.inpulse.core.client.database.RecordEntity;
import vet.inpulse.core.client.database.TelemedicineReportRequestEntity;
import vet.inpulse.core.client.database.VeterinarianEntity;
import vet.inpulse.core.models.model.ASA;
import vet.inpulse.core.models.model.AnestheticRecord;
import vet.inpulse.core.models.model.EcgAnalysis;
import vet.inpulse.core.models.model.EcgRecord;
import vet.inpulse.core.models.model.EcgReport;
import vet.inpulse.core.models.model.Establishment;
import vet.inpulse.core.models.model.Gender;
import vet.inpulse.core.models.model.Hydration;
import vet.inpulse.core.models.model.NibpRecord;
import vet.inpulse.core.models.model.Owner;
import vet.inpulse.core.models.model.Pain;
import vet.inpulse.core.models.model.Patient;
import vet.inpulse.core.models.model.PatientState;
import vet.inpulse.core.models.model.Record;
import vet.inpulse.core.models.model.RecordMetadata;
import vet.inpulse.core.models.model.RecordType;
import vet.inpulse.core.models.model.RegistrationId;
import vet.inpulse.core.models.model.TelemedicineReportRequest;
import vet.inpulse.core.models.model.TelemedicineReportRequestCancelReason;
import vet.inpulse.core.models.model.TelemedicineReportRequestState;
import vet.inpulse.core.models.model.Ventilation;
import vet.inpulse.core.models.model.Veterinarian;
import vet.inpulse.core.models.utils.ModelUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0002*\u00020\u00012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u001a\n\u0010\u0000\u001a\u00020\u0007*\u00020\b\u001a\u001a\u0010\u0003\u001a\u00020\b*\u00020\u00072\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u001a\n\u0010\u0000\u001a\u00020\t*\u00020\n\u001a\u001a\u0010\u0003\u001a\u00020\n*\u00020\t2\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u001a\n\u0010\u0000\u001a\u00020\u000b*\u00020\f\u001a\u001a\u0010\u0003\u001a\u00020\f*\u00020\u000b2\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u001a\n\u0010\u0003\u001a\u00020\u0010*\u00020\u0011\u001a\n\u0010\u0000\u001a\u00020\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0012\u001a\n\u0010\u0003\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\u0000\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\u0003\u001a\u00020\u0017*\u00020\u0018\u001a\n\u0010\u0000\u001a\u00020\u0018*\u00020\u0019\u001a \u0010\u0003\u001a\u00020\u001a*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u001b*\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u001a\n\u0010\u0000\u001a\u00020 *\u00020!\u001a\u0016\u0010\u0003\u001a\u00020!*\u00020 2\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a8\u0006\""}, d2={"toModel", "Lvet/inpulse/core/models/model/Establishment;", "Lvet/inpulse/core/client/database/EstablishmentEntity;", "toDbEntity", "orgId", "Lkotlin/uuid/Uuid;", "Lvet/inpulse/shared/models/UUID;", "Lvet/inpulse/core/models/model/Patient;", "Lvet/inpulse/core/client/database/PatientEntity;", "Lvet/inpulse/core/models/model/Owner;", "Lvet/inpulse/core/client/database/OwnerEntity;", "Lvet/inpulse/core/models/model/Veterinarian;", "Lvet/inpulse/core/client/database/VeterinarianEntity;", "toBaseRecordEntity", "Lvet/inpulse/core/client/database/RecordEntity;", "Lvet/inpulse/core/models/model/Record;", "Lvet/inpulse/core/client/database/AnestheticRecordEntity;", "Lvet/inpulse/core/models/model/AnestheticRecord;", "Lvet/inpulse/core/client/database/AnestheticRecordEntityView;", "toAnestheticRecordEntity", "Lvet/inpulse/core/client/database/NibpRecordEntity;", "Lvet/inpulse/core/models/model/NibpRecord;", "Lvet/inpulse/core/client/database/NibpRecordEntityView;", "Lvet/inpulse/core/client/database/EcgRecordEntity;", "Lvet/inpulse/core/models/model/EcgRecord;", "Lvet/inpulse/core/client/database/EcgRecordEntityView;", "Lvet/inpulse/core/client/database/EcgReportEntity;", "Lvet/inpulse/core/models/model/EcgReport;", "analysisUrl", "", "analysis", "Lvet/inpulse/core/models/model/EcgAnalysis;", "Lvet/inpulse/core/models/model/TelemedicineReportRequest;", "Lvet/inpulse/core/client/database/TelemedicineReportRequestEntity;", "core-client-database"})
@SourceDebugExtension(value={"SMAP\nSynchronizableConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynchronizableConverters.kt\nvet/inpulse/core/client/database/application/converters/SynchronizableConvertersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1#2:519\n*E\n"})
public final class SynchronizableConvertersKt {
    @NotNull
    public static final Establishment toModel(@NotNull EstablishmentEntity $this$toModel) {
        String[] stringArray;
        Object object;
        RegistrationId registrationId;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        String string = $this$toModel.getName();
        String string2 = $this$toModel.getAddress();
        String string3 = $this$toModel.getLegalName();
        String string4 = $this$toModel.getRegistrationValue();
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            String string5 = $this$toModel.getRegistrationType();
            if (string5 == null) {
                string5 = "CNPJ";
            }
            v2 = new RegistrationId(string5, it);
        } else {
            v2 = registrationId = null;
        }
        if ((object = $this$toModel.getPhoneNumbers()) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object object2 = object;
        boolean bl = $this$toModel.getDeleted();
        long l = $this$toModel.getLastModified();
        long l2 = $this$toModel.getServerLastSyncTime();
        String string6 = $this$toModel.getLogoUrl();
        String string7 = $this$toModel.getSyncError();
        String string8 = $this$toModel.getExtraData();
        return new Establishment(string, string2, registrationId, string3, (List)object2, string6, uuid, bl, l, l2, string7, string8);
    }

    @NotNull
    public static final EstablishmentEntity toDbEntity(@NotNull Establishment $this$toDbEntity, @Nullable Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Uuid uuid = $this$toDbEntity.getId();
        String string = $this$toDbEntity.getAddress();
        String string2 = $this$toDbEntity.getName();
        RegistrationId registrationId = $this$toDbEntity.getRegistration();
        String string3 = registrationId != null ? registrationId.getType() : null;
        RegistrationId registrationId2 = $this$toDbEntity.getRegistration();
        String string4 = registrationId2 != null ? registrationId2.getValue() : null;
        String string5 = $this$toDbEntity.getLegalName();
        String string6 = ModelUtilsKt.serializePhoneNumbers((List)$this$toDbEntity.getPhoneNumbers());
        long l = $this$toDbEntity.getLastModified();
        boolean bl = $this$toDbEntity.getDeleted();
        String string7 = $this$toDbEntity.getLogoUrl();
        String string8 = $this$toDbEntity.getExtraData();
        return new EstablishmentEntity(uuid, string2, string, string5, orgId, l, bl, string7, 0L, null, string3, string4, string6, string8);
    }

    @NotNull
    public static final Patient toModel(@NotNull PatientEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        String string = $this$toModel.getOwnerName();
        String string2 = $this$toModel.getName();
        Gender gender = Gender.Companion.parse($this$toModel.getGender());
        Long l = $this$toModel.getBirthDate();
        Integer n = $this$toModel.getSpeciesId();
        String string3 = $this$toModel.getCustomSpecies();
        Integer n2 = $this$toModel.getBreedId();
        String string4 = $this$toModel.getCustomBreed();
        Float f = $this$toModel.getWeight();
        Uuid uuid2 = $this$toModel.getOwnerId();
        long l2 = $this$toModel.getLastModified();
        long l3 = $this$toModel.getServerLastSyncTime();
        boolean bl = $this$toModel.getDeleted();
        String string5 = $this$toModel.getSyncError();
        String string6 = $this$toModel.getExtraData();
        return new Patient(string2, string, gender, n, string3, n2, string4, l, f, uuid, uuid2, bl, l2, l3, string5, string6);
    }

    @NotNull
    public static final PatientEntity toDbEntity(@NotNull Patient $this$toDbEntity, @Nullable Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Uuid uuid = $this$toDbEntity.getId();
        String string = $this$toDbEntity.getOwnerName();
        String string2 = $this$toDbEntity.getName();
        Gender gender = $this$toDbEntity.getGender();
        Integer n = gender != null ? Integer.valueOf(gender.getDbValue()) : null;
        Integer n2 = $this$toDbEntity.getSpeciesId();
        String string3 = $this$toDbEntity.getCustomSpecies();
        Integer n3 = $this$toDbEntity.getBreedId();
        String string4 = $this$toDbEntity.getCustomBreed();
        Long l = $this$toDbEntity.getBirthDate();
        Float f = $this$toDbEntity.getWeight();
        Uuid uuid2 = $this$toDbEntity.getOwnerId();
        long l2 = $this$toDbEntity.getLastModified();
        boolean bl = $this$toDbEntity.getDeleted();
        String string5 = $this$toDbEntity.getExtraData();
        return new PatientEntity(uuid, string2, string, n, n2, n3, l, f, orgId, l2, bl, string3, string4, uuid2, 0L, null, string5);
    }

    @NotNull
    public static final Owner toModel(@NotNull OwnerEntity $this$toModel) {
        String[] stringArray;
        Object object;
        RegistrationId registrationId;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        String string = $this$toModel.getName();
        Gender gender = Gender.Companion.parse($this$toModel.getGender());
        String string2 = $this$toModel.getRegistrationValue();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = $this$toModel.getRegistrationType();
            if (string3 == null) {
                string3 = "CPF";
            }
            v2 = new RegistrationId(string3, it);
        } else {
            v2 = registrationId = null;
        }
        if ((object = $this$toModel.getPhoneNumbers()) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object object2 = object;
        String string4 = $this$toModel.getEmail();
        String string5 = $this$toModel.getAddress();
        boolean bl = $this$toModel.getDeleted();
        long l = $this$toModel.getLastModified();
        long l2 = $this$toModel.getServerLastSyncTime();
        String string6 = $this$toModel.getSyncError();
        String string7 = $this$toModel.getExtraData();
        return new Owner(string, gender, registrationId, (List)object2, string4, string5, uuid, bl, l, l2, string6, string7);
    }

    @NotNull
    public static final OwnerEntity toDbEntity(@NotNull Owner $this$toDbEntity, @Nullable Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Uuid uuid = $this$toDbEntity.getId();
        String string = $this$toDbEntity.getName();
        Gender gender = $this$toDbEntity.getGender();
        Integer n = gender != null ? Integer.valueOf(gender.getDbValue()) : null;
        RegistrationId registrationId = $this$toDbEntity.getPersonalRegistration();
        String string2 = registrationId != null ? registrationId.getType() : null;
        RegistrationId registrationId2 = $this$toDbEntity.getPersonalRegistration();
        String string3 = registrationId2 != null ? registrationId2.getValue() : null;
        String string4 = ModelUtilsKt.serializePhoneNumbers((List)$this$toDbEntity.getPhoneNumbers());
        String string5 = $this$toDbEntity.getEmail();
        String string6 = $this$toDbEntity.getAddress();
        long l = $this$toDbEntity.getLastModified();
        boolean bl = $this$toDbEntity.getDeleted();
        String string7 = $this$toDbEntity.getExtraData();
        return new OwnerEntity(uuid, string, n, string5, string6, orgId, l, bl, 0L, null, string2, string3, string4, string7);
    }

    @NotNull
    public static final Veterinarian toModel(@NotNull VeterinarianEntity $this$toModel) {
        RegistrationId registrationId;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        String string = $this$toModel.getEmail();
        String string2 = $this$toModel.getName();
        Object object = $this$toModel.getPhoneNumbers();
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object object2 = object;
        String string3 = $this$toModel.getRegistrationValue();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            String string4 = $this$toModel.getRegistrationType();
            if (string4 == null) {
                string4 = "CRMV";
            }
            registrationId = new RegistrationId(string4, it);
        } else {
            registrationId = null;
        }
        RegistrationId registrationId2 = registrationId;
        boolean bl = $this$toModel.getDeleted();
        long l = $this$toModel.getLastModified();
        long l2 = $this$toModel.getServerLastSyncTime();
        String string5 = $this$toModel.getSignatureUrl();
        String string6 = $this$toModel.getSyncError();
        String string7 = $this$toModel.getExtraData();
        Uuid uuid2 = $this$toModel.getUserId();
        return new Veterinarian(string2, registrationId2, string, (List)object2, string5, uuid, bl, l, l2, string6, string7, uuid2);
    }

    @NotNull
    public static final VeterinarianEntity toDbEntity(@NotNull Veterinarian $this$toDbEntity, @Nullable Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Uuid uuid = $this$toDbEntity.getId();
        String string = $this$toDbEntity.getEmail();
        boolean bl = $this$toDbEntity.getDeleted();
        long l = $this$toDbEntity.getLastModified();
        String string2 = $this$toDbEntity.getName();
        String string3 = ModelUtilsKt.serializePhoneNumbers((List)$this$toDbEntity.getPhoneNumbers());
        RegistrationId registrationId = $this$toDbEntity.getProfessionalRegistration();
        String string4 = registrationId != null ? registrationId.getType() : null;
        RegistrationId registrationId2 = $this$toDbEntity.getProfessionalRegistration();
        String string5 = registrationId2 != null ? registrationId2.getValue() : null;
        String string6 = $this$toDbEntity.getSignatureUrl();
        String string7 = $this$toDbEntity.getExtraData();
        Uuid uuid2 = $this$toDbEntity.getUserId();
        return new VeterinarianEntity(uuid, string2, string, orgId, l, bl, string6, 0L, null, string4, string5, string3, string7, uuid2);
    }

    @NotNull
    public static final RecordEntity toBaseRecordEntity(@NotNull Record $this$toBaseRecordEntity, @Nullable Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toBaseRecordEntity, (String)"<this>");
        Uuid uuid = $this$toBaseRecordEntity.getId();
        RecordType recordType = $this$toBaseRecordEntity.recordType();
        long l = $this$toBaseRecordEntity.getRecordStart();
        Long l2 = $this$toBaseRecordEntity.getRecordEnd();
        boolean bl = $this$toBaseRecordEntity.getDeleted();
        Uuid uuid2 = $this$toBaseRecordEntity.getEstablishmentId();
        Uuid uuid3 = $this$toBaseRecordEntity.getPatientId();
        Uuid uuid4 = $this$toBaseRecordEntity.getResponsibleId();
        long l3 = $this$toBaseRecordEntity.getLastModified();
        String string = $this$toBaseRecordEntity.getRefCode();
        Long l4 = $this$toBaseRecordEntity.getDataUploadTimestamp();
        String string2 = $this$toBaseRecordEntity.getDataUrl();
        String string3 = $this$toBaseRecordEntity.getDataHash();
        String string4 = $this$toBaseRecordEntity.getRecordExtraData();
        RecordMetadata recordMetadata = $this$toBaseRecordEntity.getMetadata();
        String string5 = recordMetadata != null ? recordMetadata.serialize() : null;
        return new RecordEntity(uuid, recordType, uuid3, uuid2, uuid4, orgId, l, l2, string, l4, string2, string3, bl, l3, 0L, null, string5, string4);
    }

    @NotNull
    public static final AnestheticRecordEntity toDbEntity(@NotNull AnestheticRecord $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Uuid uuid = $this$toDbEntity.getId();
        String string = $this$toDbEntity.getAnestheticInductionMedication();
        int n = $this$toDbEntity.getAsaClassification().getDbValue();
        Uuid uuid2 = $this$toDbEntity.getAuxiliary1Id();
        Uuid uuid3 = $this$toDbEntity.getAuxiliary2Id();
        Integer n2 = $this$toDbEntity.getCardiacFrequency();
        Float f = $this$toDbEntity.getCrt();
        Integer n3 = $this$toDbEntity.getHoursInFasting();
        int n4 = $this$toDbEntity.getHydrationLevel().getDbValue();
        int n5 = $this$toDbEntity.getPainScale().getDbValue();
        String string2 = $this$toDbEntity.getPostAnestheticComments();
        String string3 = $this$toDbEntity.getPostAnestheticMedication();
        String string4 = $this$toDbEntity.getPreanestheticMedication();
        String string5 = $this$toDbEntity.getPreEvalDrugs();
        String string6 = $this$toDbEntity.getPreEvalExams();
        String string7 = $this$toDbEntity.getProcedureDescription();
        String string8 = $this$toDbEntity.getRegionalBlock();
        Integer n6 = $this$toDbEntity.getRespiratoryFrequency();
        int n7 = $this$toDbEntity.getState().getDbValue();
        Uuid uuid4 = $this$toDbEntity.getSurgeonId();
        Float f2 = $this$toDbEntity.getTemperature();
        int n8 = $this$toDbEntity.getVentilation().getDbValue();
        String string9 = $this$toDbEntity.getExtraData();
        return new AnestheticRecordEntity(uuid, string, n, uuid2, uuid3, n2, f, n3, n4, n5, string2, string3, string5, string6, string4, string7, string8, n6, n7, uuid4, f2, n8, string9);
    }

    @NotNull
    public static final AnestheticRecord toModel(@NotNull AnestheticRecordEntityView $this$toModel) {
        RecordMetadata recordMetadata;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        long l = $this$toModel.getRecordStart();
        Long l2 = $this$toModel.getRecordEnd();
        String string = $this$toModel.getRefCode();
        String string2 = $this$toModel.getAnestheticInductionMedication();
        ASA aSA = ASA.Companion.parse($this$toModel.getAsaClassification());
        Uuid uuid2 = $this$toModel.getAuxiliary1Id();
        Uuid uuid3 = $this$toModel.getAuxiliary2Id();
        Integer n = $this$toModel.getCardiacFrequency();
        Float f = $this$toModel.getCrt();
        Uuid uuid4 = $this$toModel.getEstablishmentId();
        Integer n2 = $this$toModel.getHoursInFasting();
        Hydration hydration = Hydration.Companion.parse($this$toModel.getHydrationLevel());
        Pain pain = Pain.Companion.parse($this$toModel.getPainScale());
        Uuid uuid5 = $this$toModel.getPatientId();
        String string3 = $this$toModel.getPostAnestheticComments();
        String string4 = $this$toModel.getPostAnestheticMedication();
        String string5 = $this$toModel.getPreanestheticMedication();
        String string6 = $this$toModel.getPreEvalDrugs();
        String string7 = $this$toModel.getPreEvalExams();
        String string8 = $this$toModel.getProcedureDescription();
        String string9 = $this$toModel.getRegionalBlock();
        Integer n3 = $this$toModel.getRespiratoryFrequency();
        Uuid uuid6 = $this$toModel.getResponsibleId();
        PatientState patientState = PatientState.Companion.parse($this$toModel.getState());
        Uuid uuid7 = $this$toModel.getSurgeonId();
        Float f2 = $this$toModel.getTemperature();
        Ventilation ventilation = Ventilation.Companion.parse($this$toModel.getVentilation());
        String string10 = $this$toModel.getDataUrl();
        Long l3 = $this$toModel.getDataUploadTimestamp();
        String string11 = $this$toModel.getDataHash();
        long l4 = $this$toModel.getLastModified();
        long l5 = $this$toModel.getServerLastSyncTime();
        boolean bl = $this$toModel.getDeleted();
        String string12 = $this$toModel.getSyncError();
        String string13 = $this$toModel.getRecordExtraData();
        String string14 = $this$toModel.getExtraData();
        String string15 = $this$toModel.getMetadata();
        if (string15 != null) {
            String it = string15;
            boolean bl2 = false;
            recordMetadata = RecordMetadata.Companion.fromJson(it);
        } else {
            recordMetadata = null;
        }
        RecordMetadata recordMetadata2 = recordMetadata;
        return new AnestheticRecord(l, l2, string2, aSA, uuid2, uuid3, n, f, uuid4, n2, hydration, pain, uuid5, string3, string4, string6, string7, string5, string8, string9, n3, uuid6, patientState, uuid7, f2, ventilation, string, string10, l3, string11, uuid, bl, l4, l5, string12, string13, recordMetadata2, string14);
    }

    @NotNull
    public static final AnestheticRecordEntity toAnestheticRecordEntity(@NotNull AnestheticRecordEntityView $this$toAnestheticRecordEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toAnestheticRecordEntity, (String)"<this>");
        Uuid uuid = $this$toAnestheticRecordEntity.getId();
        String string = $this$toAnestheticRecordEntity.getAnestheticInductionMedication();
        Integer n = $this$toAnestheticRecordEntity.getAsaClassification();
        Uuid uuid2 = $this$toAnestheticRecordEntity.getAuxiliary1Id();
        Uuid uuid3 = $this$toAnestheticRecordEntity.getAuxiliary2Id();
        Integer n2 = $this$toAnestheticRecordEntity.getCardiacFrequency();
        int n3 = n2 != null ? n2 : 0;
        Float f = $this$toAnestheticRecordEntity.getCrt();
        Integer n4 = $this$toAnestheticRecordEntity.getHoursInFasting();
        Integer n5 = $this$toAnestheticRecordEntity.getHydrationLevel();
        Integer n6 = $this$toAnestheticRecordEntity.getPainScale();
        String string2 = $this$toAnestheticRecordEntity.getPostAnestheticComments();
        String string3 = $this$toAnestheticRecordEntity.getPostAnestheticMedication();
        String string4 = $this$toAnestheticRecordEntity.getPreanestheticMedication();
        String string5 = $this$toAnestheticRecordEntity.getPreEvalDrugs();
        String string6 = $this$toAnestheticRecordEntity.getPreEvalExams();
        String string7 = $this$toAnestheticRecordEntity.getProcedureDescription();
        String string8 = $this$toAnestheticRecordEntity.getRegionalBlock();
        Integer n7 = $this$toAnestheticRecordEntity.getRespiratoryFrequency();
        Integer n8 = $this$toAnestheticRecordEntity.getState();
        Uuid uuid4 = $this$toAnestheticRecordEntity.getSurgeonId();
        Float f2 = $this$toAnestheticRecordEntity.getTemperature();
        Integer n9 = $this$toAnestheticRecordEntity.getVentilation();
        String string9 = $this$toAnestheticRecordEntity.getExtraData();
        return new AnestheticRecordEntity(uuid, string, n, uuid2, uuid3, n3, f, n4, n5, n6, string2, string3, string5, string6, string4, string7, string8, n7, n8, uuid4, f2, n9, string9);
    }

    @NotNull
    public static final NibpRecordEntity toDbEntity(@NotNull NibpRecord $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Uuid uuid = $this$toDbEntity.getId();
        Long l = $this$toDbEntity.getPresentedResult();
        String string = $this$toDbEntity.getDiastolicPressureResult();
        String string2 = $this$toDbEntity.getMeanPressureResult();
        String string3 = $this$toDbEntity.getSystolicPressureResult();
        String string4 = $this$toDbEntity.getConclusion();
        String string5 = $this$toDbEntity.getComments();
        String string6 = $this$toDbEntity.getDrugsInCourse();
        String string7 = $this$toDbEntity.getExtraData();
        return new NibpRecordEntity(uuid, string6, string5, string4, string3, string2, string, l, string7);
    }

    @NotNull
    public static final NibpRecord toModel(@NotNull NibpRecordEntityView $this$toModel) {
        RecordMetadata recordMetadata;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        Long l = $this$toModel.getPresentedResult();
        String string = $this$toModel.getDiastolicPressureResult();
        String string2 = $this$toModel.getMeanPressureResult();
        String string3 = $this$toModel.getSystolicPressureResult();
        String string4 = $this$toModel.getConclusion();
        String string5 = $this$toModel.getComments();
        String string6 = $this$toModel.getDrugsInCourse();
        String string7 = $this$toModel.getRefCode();
        long l2 = $this$toModel.getLastModified();
        long l3 = $this$toModel.getServerLastSyncTime();
        boolean bl = $this$toModel.getDeleted();
        long l4 = $this$toModel.getRecordStart();
        Long l5 = $this$toModel.getRecordEnd();
        Uuid uuid2 = $this$toModel.getResponsibleId();
        Uuid uuid3 = $this$toModel.getEstablishmentId();
        Uuid uuid4 = $this$toModel.getPatientId();
        String string8 = $this$toModel.getSyncError();
        String string9 = $this$toModel.getDataUrl();
        Long l6 = $this$toModel.getDataUploadTimestamp();
        String string10 = $this$toModel.getDataHash();
        String string11 = $this$toModel.getRecordExtraData();
        String string12 = $this$toModel.getExtraData();
        String string13 = $this$toModel.getMetadata();
        if (string13 != null) {
            String it = string13;
            boolean bl2 = false;
            recordMetadata = RecordMetadata.Companion.fromJson(it);
        } else {
            recordMetadata = null;
        }
        RecordMetadata recordMetadata2 = recordMetadata;
        return new NibpRecord(string7, string6, string5, string4, string3, string2, string, l, uuid, uuid4, uuid3, uuid2, l4, l5, string9, l6, string10, bl, l2, l3, string8, string11, recordMetadata2, string12);
    }

    @NotNull
    public static final EcgRecordEntity toDbEntity(@NotNull EcgRecord $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        return new EcgRecordEntity($this$toDbEntity.getId(), $this$toDbEntity.getDrugs(), $this$toDbEntity.getComments(), $this$toDbEntity.getRequestorId(), $this$toDbEntity.getExtraData());
    }

    @NotNull
    public static final EcgRecord toModel(@NotNull EcgRecordEntityView $this$toModel) {
        RecordMetadata recordMetadata;
        String string;
        String string2;
        String string3;
        String string4;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        long l = $this$toModel.getRecordStart();
        Long l2 = $this$toModel.getRecordEnd();
        String string5 = $this$toModel.getRefCode();
        if (string5 == null) {
            string5 = string4 = "";
        }
        if ((string3 = $this$toModel.getDrugs()) == null) {
            string3 = string2 = "";
        }
        if ((string = $this$toModel.getComments()) == null) {
            string = "";
        }
        String string6 = string;
        Uuid uuid2 = $this$toModel.getRequestorId();
        Uuid uuid3 = $this$toModel.getEstablishmentId();
        Uuid uuid4 = $this$toModel.getPatientId();
        Uuid uuid5 = $this$toModel.getResponsibleId();
        long l3 = $this$toModel.getLastModified();
        long l4 = $this$toModel.getServerLastSyncTime();
        boolean bl = $this$toModel.getDeleted();
        String string7 = $this$toModel.getSyncError();
        String string8 = $this$toModel.getDataUrl();
        Long l5 = $this$toModel.getDataUploadTimestamp();
        String string9 = $this$toModel.getDataHash();
        String string10 = $this$toModel.getRecordExtraData();
        String string11 = $this$toModel.getExtraData();
        String string12 = $this$toModel.getMetadata();
        if (string12 != null) {
            String it = string12;
            boolean bl2 = false;
            recordMetadata = RecordMetadata.Companion.fromJson(it);
        } else {
            recordMetadata = null;
        }
        RecordMetadata recordMetadata2 = recordMetadata;
        return new EcgRecord(string4, string2, string6, uuid2, uuid, uuid4, uuid3, uuid5, l, l2, string8, l5, string9, bl, l3, l4, string7, string10, recordMetadata2, string11);
    }

    @NotNull
    public static final EcgReportEntity toDbEntity(@NotNull EcgReport $this$toDbEntity, @Nullable String analysisUrl, @NotNull Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        Uuid uuid = $this$toDbEntity.getId();
        Uuid uuid2 = $this$toDbEntity.getExamId();
        long l = $this$toDbEntity.getReportDate();
        Uuid uuid3 = $this$toDbEntity.getCardiologistId();
        String string = $this$toDbEntity.getConclusion();
        String string2 = $this$toDbEntity.getComments();
        long l2 = $this$toDbEntity.getLastModified();
        boolean bl = $this$toDbEntity.getDeleted();
        String string3 = $this$toDbEntity.getExtraData();
        return new EcgReportEntity(uuid, uuid2, orgId, l, uuid3, string, string2, analysisUrl, l2, bl, 0L, null, string3);
    }

    @NotNull
    public static final EcgReport toModel(@NotNull EcgReportEntity $this$toModel, @Nullable EcgAnalysis analysis) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        Uuid uuid2 = $this$toModel.getExamId();
        long l = $this$toModel.getReportDate();
        Uuid uuid3 = $this$toModel.getCardiologistId();
        String string = $this$toModel.getConclusion();
        String string2 = $this$toModel.getComments();
        long l2 = $this$toModel.getLastModified();
        long l3 = $this$toModel.getServerLastSyncTime();
        boolean bl = $this$toModel.getDeleted();
        String string3 = $this$toModel.getSyncError();
        String string4 = $this$toModel.getExtraData();
        return new EcgReport(uuid2, l, uuid3, string, string2, analysis, uuid, bl, l2, l3, string3, string4);
    }

    @NotNull
    public static final TelemedicineReportRequest toModel(@NotNull TelemedicineReportRequestEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toModel.getRequestState().ordinal()]) {
            case 1 -> (TelemedicineReportRequest)new TelemedicineReportRequest.Requested($this$toModel.getId(), $this$toModel.getRecordType(), $this$toModel.getRecordId(), $this$toModel.getTelemedicineCenterId(), $this$toModel.getTelemedicineCenterName(), $this$toModel.getRequestDate(), $this$toModel.isUrgent(), $this$toModel.getServerSyncTime(), $this$toModel.getSyncError());
            case 2 -> {
                Uuid var1_1 = $this$toModel.getId();
                RecordType var2_3 = $this$toModel.getRecordType();
                Uuid var3_5 = $this$toModel.getRecordId();
                Uuid var4_7 = $this$toModel.getTelemedicineCenterId();
                String var5_9 = $this$toModel.getTelemedicineCenterName();
                long var6_11 = $this$toModel.getRequestDate();
                boolean var8_13 = $this$toModel.isUrgent();
                Uuid var9_15 = $this$toModel.getAnalystId();
                String var10_17 = $this$toModel.getAnalystName();
                TelemedicineReportRequestCancelReason var11_19 = TelemedicineReportRequestCancelReason.Companion.parse($this$toModel.getCancelReason());
                String v1 = $this$toModel.getCancelComment();
                if (v1 == null) {
                    v1 = "";
                }
                String var12_21 = v1;
                Long v2 = $this$toModel.getCancelDate();
                long var13_23 = v2 != null ? v2 : 0L;
                long var15_25 = $this$toModel.getServerSyncTime();
                String var17_26 = $this$toModel.getSyncError();
                yield (TelemedicineReportRequest)new TelemedicineReportRequest.Canceled(var1_1, var2_3, var3_5, var4_7, var5_9, var6_11, var8_13, var15_25, var9_15, var10_17, var11_19, var12_21, var13_23, var17_26);
            }
            case 3 -> {
                String v5;
                String var10_18;
                Uuid var1_2 = $this$toModel.getId();
                RecordType var2_4 = $this$toModel.getRecordType();
                Uuid var3_6 = $this$toModel.getRecordId();
                Uuid var4_8 = $this$toModel.getTelemedicineCenterId();
                String var5_10 = $this$toModel.getTelemedicineCenterName();
                long var6_12 = $this$toModel.getRequestDate();
                boolean var8_14 = $this$toModel.isUrgent();
                String v3 = $this$toModel.getReportUrl();
                if (v3 == null) {
                    throw new IllegalStateException(("Report URL should never be null (request " + $this$toModel.getId() + ")").toString());
                }
                String var9_16 = v3;
                String v4 = $this$toModel.getReportComment();
                if (v4 == null) {
                    v4 = var10_18 = "";
                }
                if ((v5 = $this$toModel.getReportConclusion()) == null) {
                    v5 = "";
                }
                String var11_20 = v5;
                Uuid v6 = $this$toModel.getAnalystId();
                if (v6 == null) {
                    throw new IllegalStateException(("Analyst id should never be null (request " + $this$toModel.getId() + ")").toString());
                }
                Uuid var12_22 = v6;
                String v7 = $this$toModel.getAnalystName();
                if (v7 == null) {
                    v7 = "";
                }
                String var13_24 = v7;
                Long v8 = $this$toModel.getReportDate();
                long var14_28 = v8 != null ? v8 : 0L;
                String v9 = $this$toModel.getReportChatRoomUrl();
                if (v9 == null) {
                    v9 = "";
                }
                String var16_29 = v9;
                long var17_27 = $this$toModel.getServerSyncTime();
                String var19_30 = $this$toModel.getSyncError();
                yield (TelemedicineReportRequest)new TelemedicineReportRequest.Reported(var1_2, var2_4, var3_6, var4_8, var5_10, var6_12, var8_14, var17_27, var9_16, var10_18, var11_20, var12_22, var13_24, var14_28, var16_29, var19_30);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final TelemedicineReportRequestEntity toDbEntity(@NotNull TelemedicineReportRequest $this$toDbEntity, @NotNull Uuid orgId) {
        Uuid uuid;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        TelemedicineReportRequest.Canceled canceled = $this$toDbEntity instanceof TelemedicineReportRequest.Canceled ? (TelemedicineReportRequest.Canceled)$this$toDbEntity : null;
        TelemedicineReportRequest.Reported reported = $this$toDbEntity instanceof TelemedicineReportRequest.Reported ? (TelemedicineReportRequest.Reported)$this$toDbEntity : null;
        TelemedicineReportRequest telemedicineReportRequest = $this$toDbEntity;
        if (telemedicineReportRequest instanceof TelemedicineReportRequest.Requested) {
            string = null;
        } else if (telemedicineReportRequest instanceof TelemedicineReportRequest.Canceled) {
            string = ((TelemedicineReportRequest.Canceled)$this$toDbEntity).getAnalystName();
        } else if (telemedicineReportRequest instanceof TelemedicineReportRequest.Reported) {
            string = ((TelemedicineReportRequest.Reported)$this$toDbEntity).getAnalystName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String analystName = string;
        TelemedicineReportRequest telemedicineReportRequest2 = $this$toDbEntity;
        if (telemedicineReportRequest2 instanceof TelemedicineReportRequest.Requested) {
            uuid = null;
        } else if (telemedicineReportRequest2 instanceof TelemedicineReportRequest.Canceled) {
            uuid = ((TelemedicineReportRequest.Canceled)$this$toDbEntity).getAnalystId();
        } else if (telemedicineReportRequest2 instanceof TelemedicineReportRequest.Reported) {
            uuid = ((TelemedicineReportRequest.Reported)$this$toDbEntity).getAnalystId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Uuid analystId = uuid;
        telemedicineReportRequest2 = $this$toDbEntity.getId();
        RecordType recordType = $this$toDbEntity.getRecordType();
        Uuid uuid2 = $this$toDbEntity.getRecordId();
        Uuid uuid3 = $this$toDbEntity.getTelemedicineCenterId();
        String string2 = $this$toDbEntity.getTelemedicineCenterName();
        TelemedicineReportRequestState telemedicineReportRequestState = $this$toDbEntity.getState();
        long l = $this$toDbEntity.getRequestDate();
        boolean bl = $this$toDbEntity.isUrgent();
        TelemedicineReportRequest.Canceled canceled2 = canceled;
        Integer n = canceled2 != null && (canceled2 = canceled2.getReason()) != null ? Integer.valueOf(canceled2.getDbValue()) : null;
        TelemedicineReportRequest.Canceled canceled3 = canceled;
        String string3 = canceled3 != null ? canceled3.getComment() : null;
        TelemedicineReportRequest.Canceled canceled4 = canceled;
        Long l2 = canceled4 != null ? Long.valueOf(canceled4.getCancelDate()) : null;
        TelemedicineReportRequest.Reported reported2 = reported;
        String string4 = reported2 != null ? reported2.getUrl() : null;
        TelemedicineReportRequest.Reported reported3 = reported;
        String string5 = reported3 != null ? reported3.getComment() : null;
        TelemedicineReportRequest.Reported reported4 = reported;
        String string6 = reported4 != null ? reported4.getConclusion() : null;
        TelemedicineReportRequest.Reported reported5 = reported;
        Long l3 = reported5 != null ? Long.valueOf(reported5.getReportDate()) : null;
        TelemedicineReportRequest.Reported reported6 = reported;
        String string7 = reported6 != null ? reported6.getChatRoomUrl() : null;
        long l4 = $this$toDbEntity.getServerSyncTime();
        String string8 = $this$toDbEntity.getSyncError();
        return new TelemedicineReportRequestEntity((Uuid)telemedicineReportRequest2, recordType, uuid2, orgId, uuid3, telemedicineReportRequestState, l, string2, bl, analystId, analystName, n, string3, l2, string4, string5, string6, l3, string7, l4, string8);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TelemedicineReportRequestState.values().length];
            try {
                nArray[TelemedicineReportRequestState.REQUESTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TelemedicineReportRequestState.CANCELED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TelemedicineReportRequestState.REPORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

