/*
 * Decompiled with CFR 0.152.
 */
package dev.datlag.kcef;

import dev.datlag.kcef.KCEFException;
import dev.datlag.kcef.common.ExtendSystemKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\n\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\bJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/datlag/kcef/Platform;", "", "<init>", "()V", "PROPERTY_OS_NAME", "", "PROPERTY_OS_ARCH", "osInfo", "Ldev/datlag/kcef/Platform$OSInfo;", "getCurrentPlatform", "equals", "", "other", "hashCode", "", "toString", "OS", "ARCH", "OSInfo", "kcef"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ndev/datlag/kcef/Platform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();
    @NotNull
    private static final String PROPERTY_OS_NAME = "os.name";
    @NotNull
    private static final String PROPERTY_OS_ARCH = "os.arch";
    @Nullable
    private static OSInfo osInfo;

    private Platform() {
    }

    @NotNull
    public final OSInfo getCurrentPlatform() throws KCEFException.UnsupportedPlatform {
        OSInfo oSInfo;
        ARCH arch;
        OS oS;
        OSInfo oSInfo2 = osInfo;
        if (oSInfo2 != null) {
            OSInfo it = oSInfo2;
            boolean bl = false;
            return it;
        }
        String osName = ExtendSystemKt.systemProperty(PROPERTY_OS_NAME);
        String osArch = ExtendSystemKt.systemProperty(PROPERTY_OS_ARCH);
        String string = osName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            oS = OS.Companion.matching$kcef(it);
        } else {
            oS = null;
        }
        OS os = oS;
        String string2 = osArch;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            v4 = ARCH.Companion.matching$kcef(it);
        } else {
            v4 = arch = null;
        }
        if (os == null || arch == null) {
            throw new KCEFException.UnsupportedPlatform(osName, osArch);
        }
        OSInfo it = oSInfo = new OSInfo(os, arch);
        boolean bl = false;
        osInfo = it;
        return oSInfo;
    }

    @NotNull
    public String toString() {
        return "Platform";
    }

    public int hashCode() {
        return -1994957554;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Platform)) {
            return false;
        }
        Platform cfr_ignored_0 = (Platform)other;
        return true;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b2\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB%\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\u0082\u0001\u0004\u001c\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Ldev/datlag/kcef/Platform$ARCH;", "", "arch", "", "values", "", "<init>", "(Ljava/lang/String;[Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "getValues$kcef", "()[Ljava/lang/String;", "[Ljava/lang/String;", "matches", "", "osArch", "matches$kcef", "isAMD64", "()Z", "isI386", "isARM64", "isARM", "toString", "AMD64", "I386", "ARM64", "ARM", "Companion", "Ldev/datlag/kcef/Platform$ARCH$AMD64;", "Ldev/datlag/kcef/Platform$ARCH$ARM;", "Ldev/datlag/kcef/Platform$ARCH$ARM64;", "Ldev/datlag/kcef/Platform$ARCH$I386;", "kcef"})
    public static abstract class ARCH {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String arch;
        @NotNull
        private final String[] values;

        private ARCH(String arch, String ... values) {
            this.arch = arch;
            this.values = values;
        }

        @NotNull
        public String getArch() {
            return this.arch;
        }

        @NotNull
        public final String[] getValues$kcef() {
            return this.values;
        }

        public final boolean matches$kcef(@NotNull String osArch) {
            Intrinsics.checkNotNullParameter((Object)osArch, (String)"osArch");
            String string = osArch;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return ArraysKt.contains((Object[])this.values, (Object)string2);
        }

        public final boolean isAMD64() {
            return this instanceof AMD64;
        }

        public final boolean isI386() {
            return this instanceof I386;
        }

        public final boolean isARM64() {
            return this instanceof ARM64;
        }

        public final boolean isARM() {
            return this instanceof ARM;
        }

        @NotNull
        public String toString() {
            return this.isAMD64() ? "x64" : (this.isI386() ? "x32" : (this.isARM64() ? "arm64" : (this.isARM() ? "arm" : "Unknown")));
        }

        public /* synthetic */ ARCH(String arch, String[] values, DefaultConstructorMarker $constructor_marker) {
            this(arch, values);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/datlag/kcef/Platform$ARCH$AMD64;", "Ldev/datlag/kcef/Platform$ARCH;", "arch", "", "<init>", "(Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class AMD64
        extends ARCH {
            @NotNull
            private final String arch;

            public AMD64(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                String[] stringArray = new String[]{"amd64", "x86_64", "x64"};
                super(arch, stringArray, (DefaultConstructorMarker)null);
                this.arch = arch;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @NotNull
            public final String component1() {
                return this.arch;
            }

            @NotNull
            public final AMD64 copy(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                return new AMD64(arch);
            }

            public static /* synthetic */ AMD64 copy$default(AMD64 aMD64, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = aMD64.arch;
                }
                return aMD64.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "AMD64(arch=" + this.arch + ")";
            }

            public int hashCode() {
                return this.arch.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AMD64)) {
                    return false;
                }
                AMD64 aMD64 = (AMD64)other;
                return Intrinsics.areEqual((Object)this.arch, (Object)aMD64.arch);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/datlag/kcef/Platform$ARCH$ARM;", "Ldev/datlag/kcef/Platform$ARCH;", "arch", "", "<init>", "(Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class ARM
        extends ARCH {
            @NotNull
            private final String arch;

            public ARM(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                String[] stringArray = new String[]{"arm"};
                super(arch, stringArray, (DefaultConstructorMarker)null);
                this.arch = arch;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @NotNull
            public final String component1() {
                return this.arch;
            }

            @NotNull
            public final ARM copy(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                return new ARM(arch);
            }

            public static /* synthetic */ ARM copy$default(ARM aRM, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = aRM.arch;
                }
                return aRM.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "ARM(arch=" + this.arch + ")";
            }

            public int hashCode() {
                return this.arch.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ARM)) {
                    return false;
                }
                ARM aRM = (ARM)other;
                return Intrinsics.areEqual((Object)this.arch, (Object)aRM.arch);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/datlag/kcef/Platform$ARCH$ARM64;", "Ldev/datlag/kcef/Platform$ARCH;", "arch", "", "<init>", "(Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class ARM64
        extends ARCH {
            @NotNull
            private final String arch;

            public ARM64(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                String[] stringArray = new String[]{"arm64", "aarch64"};
                super(arch, stringArray, (DefaultConstructorMarker)null);
                this.arch = arch;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @NotNull
            public final String component1() {
                return this.arch;
            }

            @NotNull
            public final ARM64 copy(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                return new ARM64(arch);
            }

            public static /* synthetic */ ARM64 copy$default(ARM64 aRM64, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = aRM64.arch;
                }
                return aRM64.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "ARM64(arch=" + this.arch + ")";
            }

            public int hashCode() {
                return this.arch.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ARM64)) {
                    return false;
                }
                ARM64 aRM64 = (ARM64)other;
                return Intrinsics.areEqual((Object)this.arch, (Object)aRM64.arch);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Ldev/datlag/kcef/Platform$ARCH$Companion;", "", "<init>", "()V", "matching", "Ldev/datlag/kcef/Platform$ARCH;", "osArch", "", "matching$kcef", "kcef"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ARCH matching$kcef(@NotNull String osArch) {
                Intrinsics.checkNotNullParameter((Object)osArch, (String)"osArch");
                return new AMD64(osArch).matches$kcef(osArch) ? (ARCH)new AMD64(osArch) : (new I386(osArch).matches$kcef(osArch) ? (ARCH)new I386(osArch) : (new ARM64(osArch).matches$kcef(osArch) ? (ARCH)new ARM64(osArch) : (new ARM(osArch).matches$kcef(osArch) ? (ARCH)new ARM(osArch) : null)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/datlag/kcef/Platform$ARCH$I386;", "Ldev/datlag/kcef/Platform$ARCH;", "arch", "", "<init>", "(Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class I386
        extends ARCH {
            @NotNull
            private final String arch;

            public I386(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                String[] stringArray = new String[]{"x86", "i386", "i486", "i586", "i686", "i786"};
                super(arch, stringArray, (DefaultConstructorMarker)null);
                this.arch = arch;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @NotNull
            public final String component1() {
                return this.arch;
            }

            @NotNull
            public final I386 copy(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                return new I386(arch);
            }

            public static /* synthetic */ I386 copy$default(I386 i386, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = i386.arch;
                }
                return i386.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "I386(arch=" + this.arch + ")";
            }

            public int hashCode() {
                return this.arch.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof I386)) {
                    return false;
                }
                I386 i386 = (I386)other;
                return Intrinsics.areEqual((Object)this.arch, (Object)i386.arch);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\u00020\u0001:\u0004\u001d\u001e\u001f B%\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0010J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u0082\u0001\u0003!\"#\u00a8\u0006$"}, d2={"Ldev/datlag/kcef/Platform$OS;", "", "name", "", "values", "", "<init>", "(Ljava/lang/String;[Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValues$kcef", "()[Ljava/lang/String;", "[Ljava/lang/String;", "matches", "", "osName", "matches$kcef", "isMacOSX", "()Z", "isLinux", "isWindows", "getFixedArgs", "", "installDir", "Ljava/io/File;", "args", "getResourcesPath", "getBrowserPath", "toString", "MACOSX", "LINUX", "WINDOWS", "Companion", "Ldev/datlag/kcef/Platform$OS$LINUX;", "Ldev/datlag/kcef/Platform$OS$MACOSX;", "Ldev/datlag/kcef/Platform$OS$WINDOWS;", "kcef"})
    @SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ndev/datlag/kcef/Platform$OS\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n12574#2,2:180\n*S KotlinDebug\n*F\n+ 1 Platform.kt\ndev/datlag/kcef/Platform$OS\n*L\n80#1:180,2\n*E\n"})
    public static abstract class OS {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String[] values;

        private OS(String name, String ... values) {
            this.name = name;
            this.values = values;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String[] getValues$kcef() {
            return this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean matches$kcef(@NotNull String osName) {
            Intrinsics.checkNotNullParameter((Object)osName, (String)"osName");
            String[] $this$any$iv = this.values;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl = false;
                if (!StringsKt.startsWith((String)osName, (String)it, (boolean)true)) continue;
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            String string = osName;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!ArraysKt.contains((Object[])this.values, (Object)string2)) return false;
            return true;
        }

        public final boolean isMacOSX() {
            return this instanceof MACOSX;
        }

        public final boolean isLinux() {
            return this instanceof LINUX;
        }

        public final boolean isWindows() {
            return this instanceof WINDOWS;
        }

        @NotNull
        public Collection<String> getFixedArgs(@NotNull File installDir, @NotNull Collection<String> args) {
            Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return args;
        }

        @NotNull
        public String getResourcesPath(@NotNull File installDir) {
            Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
            String string = installDir.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
            return string;
        }

        @NotNull
        public String getBrowserPath(@NotNull File installDir) {
            Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
            String string = new File(installDir, "jcef_helper").getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
            return string;
        }

        @NotNull
        public String toString() {
            return this.isMacOSX() ? "MacOS" : (this.isLinux() ? "Linux" : (this.isWindows() ? "Windows" : "Unknown"));
        }

        public /* synthetic */ OS(String name, String[] values, DefaultConstructorMarker $constructor_marker) {
            this(name, values);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Ldev/datlag/kcef/Platform$OS$Companion;", "", "<init>", "()V", "matching", "Ldev/datlag/kcef/Platform$OS;", "osName", "", "matching$kcef", "kcef"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final OS matching$kcef(@NotNull String osName) {
                Intrinsics.checkNotNullParameter((Object)osName, (String)"osName");
                return new MACOSX(osName).matches$kcef(osName) ? (OS)new MACOSX(osName) : (new LINUX(osName).matches$kcef(osName) ? (OS)new LINUX(osName) : (new WINDOWS(osName).matches$kcef(osName) ? (OS)new WINDOWS(osName) : null));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/datlag/kcef/Platform$OS$LINUX;", "Ldev/datlag/kcef/Platform$OS;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class LINUX
        extends OS {
            @NotNull
            private final String name;

            public LINUX(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String[] stringArray = new String[]{"linux"};
                super(name, stringArray, (DefaultConstructorMarker)null);
                this.name = name;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final LINUX copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new LINUX(name);
            }

            public static /* synthetic */ LINUX copy$default(LINUX lINUX, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = lINUX.name;
                }
                return lINUX.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "LINUX(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LINUX)) {
                    return false;
                }
                LINUX lINUX = (LINUX)other;
                return Intrinsics.areEqual((Object)this.name, (Object)lINUX.name);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ldev/datlag/kcef/Platform$OS$MACOSX;", "Ldev/datlag/kcef/Platform$OS;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getFrameworkPath", "installDir", "Ljava/io/File;", "inFrameworks", "", "getMainBundlePath", "getResourcesPath", "getBrowserPath", "getFixedArgs", "", "args", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class MACOSX
        extends OS {
            @NotNull
            private final String name;

            public MACOSX(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String[] stringArray = new String[]{"mac", "darwin", "osx"};
                super(name, stringArray, (DefaultConstructorMarker)null);
                this.name = name;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final String getFrameworkPath(@NotNull File installDir, boolean inFrameworks) {
                Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
                return installDir.getCanonicalPath() + "/" + (inFrameworks ? "Frameworks/" : "") + "Chromium Embedded Framework.framework";
            }

            public static /* synthetic */ String getFrameworkPath$default(MACOSX mACOSX, File file, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                return mACOSX.getFrameworkPath(file, bl);
            }

            @NotNull
            public final String getMainBundlePath(@NotNull File installDir) {
                Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
                return installDir.getCanonicalPath() + "/Frameworks/jcef Helper.app";
            }

            @Override
            @NotNull
            public String getResourcesPath(@NotNull File installDir) {
                Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
                return this.getFrameworkPath(installDir, true) + "/Resources";
            }

            @Override
            @NotNull
            public String getBrowserPath(@NotNull File installDir) {
                Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
                return installDir.getCanonicalPath() + "/Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper";
            }

            @Override
            @NotNull
            public Collection<String> getFixedArgs(@NotNull File installDir, @NotNull Collection<String> args) {
                Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                List newArgs = CollectionsKt.toMutableList(args);
                newArgs.add(0, "--framework-dir-path=" + this.getFrameworkPath(installDir, true));
                newArgs.add(0, "--main-bundle-path=" + this.getMainBundlePath(installDir));
                newArgs.add(0, "--browser-subprocess-path=" + this.getBrowserPath(installDir));
                return newArgs;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final MACOSX copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new MACOSX(name);
            }

            public static /* synthetic */ MACOSX copy$default(MACOSX mACOSX, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = mACOSX.name;
                }
                return mACOSX.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "MACOSX(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MACOSX)) {
                    return false;
                }
                MACOSX mACOSX = (MACOSX)other;
                return Intrinsics.areEqual((Object)this.name, (Object)mACOSX.name);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/datlag/kcef/Platform$OS$WINDOWS;", "Ldev/datlag/kcef/Platform$OS;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kcef"})
        public static final class WINDOWS
        extends OS {
            @NotNull
            private final String name;

            public WINDOWS(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String[] stringArray = new String[]{"win", "windows"};
                super(name, stringArray, (DefaultConstructorMarker)null);
                this.name = name;
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final WINDOWS copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new WINDOWS(name);
            }

            public static /* synthetic */ WINDOWS copy$default(WINDOWS wINDOWS, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = wINDOWS.name;
                }
                return wINDOWS.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "WINDOWS(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WINDOWS)) {
                    return false;
                }
                WINDOWS wINDOWS = (WINDOWS)other;
                return Intrinsics.areEqual((Object)this.name, (Object)wINDOWS.name);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ldev/datlag/kcef/Platform$OSInfo;", "", "os", "Ldev/datlag/kcef/Platform$OS;", "arch", "Ldev/datlag/kcef/Platform$ARCH;", "<init>", "(Ldev/datlag/kcef/Platform$OS;Ldev/datlag/kcef/Platform$ARCH;)V", "getOs", "()Ldev/datlag/kcef/Platform$OS;", "getArch", "()Ldev/datlag/kcef/Platform$ARCH;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kcef"})
    public static final class OSInfo {
        @NotNull
        private final OS os;
        @NotNull
        private final ARCH arch;

        public OSInfo(@NotNull OS os, @NotNull ARCH arch) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            this.os = os;
            this.arch = arch;
        }

        @NotNull
        public final OS getOs() {
            return this.os;
        }

        @NotNull
        public final ARCH getArch() {
            return this.arch;
        }

        @NotNull
        public final OS component1() {
            return this.os;
        }

        @NotNull
        public final ARCH component2() {
            return this.arch;
        }

        @NotNull
        public final OSInfo copy(@NotNull OS os, @NotNull ARCH arch) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            return new OSInfo(os, arch);
        }

        public static /* synthetic */ OSInfo copy$default(OSInfo oSInfo, OS oS, ARCH aRCH, int n, Object object) {
            if ((n & 1) != 0) {
                oS = oSInfo.os;
            }
            if ((n & 2) != 0) {
                aRCH = oSInfo.arch;
            }
            return oSInfo.copy(oS, aRCH);
        }

        @NotNull
        public String toString() {
            return "OSInfo(os=" + this.os + ", arch=" + this.arch + ")";
        }

        public int hashCode() {
            int result2 = this.os.hashCode();
            result2 = result2 * 31 + this.arch.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OSInfo)) {
                return false;
            }
            OSInfo oSInfo = (OSInfo)other;
            if (!Intrinsics.areEqual((Object)this.os, (Object)oSInfo.os)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.arch, (Object)oSInfo.arch);
        }
    }
}

