/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core;

import androidx.annotation.GuardedBy;
import androidx.datastore.core.FileStorageConnection;
import androidx.datastore.core.InterProcessCoordinator;
import androidx.datastore.core.InterProcessCoordinator_jvmKt;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.Storage;
import androidx.datastore.core.StorageConnection;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000fB9\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/datastore/core/FileStorage;", "T", "Landroidx/datastore/core/Storage;", "serializer", "Landroidx/datastore/core/Serializer;", "coordinatorProducer", "Lkotlin/Function1;", "Ljava/io/File;", "Landroidx/datastore/core/InterProcessCoordinator;", "produceFile", "Lkotlin/Function0;", "<init>", "(Landroidx/datastore/core/Serializer;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "createConnection", "Landroidx/datastore/core/StorageConnection;", "Companion", "datastore-core"})
@SourceDebugExtension(value={"SMAP\nFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStorage.kt\nandroidx/datastore/core/FileStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
public final class FileStorage<T>
implements Storage<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializer<T> serializer;
    @NotNull
    private final Function1<File, InterProcessCoordinator> coordinatorProducer;
    @NotNull
    private final Function0<File> produceFile;
    @GuardedBy(value="activeFilesLock")
    @NotNull
    private static final Set<String> activeFiles = new LinkedHashSet();
    @NotNull
    private static final Object activeFilesLock = new Object();

    public FileStorage(@NotNull Serializer<T> serializer, @NotNull Function1<? super File, ? extends InterProcessCoordinator> coordinatorProducer, @NotNull Function0<? extends File> produceFile) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(coordinatorProducer, (String)"coordinatorProducer");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        this.serializer = serializer;
        this.coordinatorProducer = coordinatorProducer;
        this.produceFile = produceFile;
    }

    public /* synthetic */ FileStorage(Serializer serializer, Function1 function1, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = FileStorage::_init_$lambda$0;
        }
        this(serializer, (Function1<? super File, ? extends InterProcessCoordinator>)function1, (Function0<? extends File>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StorageConnection<T> createConnection() {
        File file = ((File)this.produceFile.invoke()).getCanonicalFile();
        Object object = activeFilesLock;
        synchronized (object) {
            boolean bl = false;
            String path = file.getAbsolutePath();
            if (!(!activeFiles.contains(path))) {
                boolean bl2 = false;
                String string = "There are multiple DataStores active for the same file: " + path + ". You should either maintain your DataStore as a singleton or confirm that there is no two DataStore's active on the same file (by confirming that the scope is cancelled).";
                throw new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNull((Object)path);
            boolean bl3 = activeFiles.add(path);
        }
        Intrinsics.checkNotNull((Object)file);
        return new FileStorageConnection<T>(file, this.serializer, (InterProcessCoordinator)this.coordinatorProducer.invoke((Object)file), (Function0<Unit>)((Function0)() -> FileStorage.createConnection$lambda$1(file)));
    }

    private static final InterProcessCoordinator _init_$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InterProcessCoordinator_jvmKt.createSingleProcessCoordinator(it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit createConnection$lambda$1(File $file) {
        Object object = activeFilesLock;
        synchronized (object) {
            boolean bl = false;
            activeFiles.remove($file.getAbsolutePath());
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/datastore/core/FileStorage$Companion;", "", "<init>", "()V", "activeFiles", "", "", "getActiveFiles$datastore_core", "()Ljava/util/Set;", "activeFilesLock", "getActiveFilesLock$datastore_core", "()Ljava/lang/Object;", "datastore-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getActiveFiles$datastore_core() {
            return activeFiles;
        }

        @NotNull
        public final Object getActiveFilesLock$datastore_core() {
            return activeFilesLock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

