/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Landroidx/datastore/core/FileDiagnostics;", "", "<init>", "()V", "attachFileDebugInfo", "Ljava/io/IOException;", "file", "Ljava/io/File;", "cause", "attachParentStacktrace", "attachFileSystemMessage", "origException", "datastore-core"})
public final class FileDiagnostics {
    @NotNull
    public static final FileDiagnostics INSTANCE = new FileDiagnostics();

    private FileDiagnostics() {
    }

    @NotNull
    public final IOException attachFileDebugInfo(@NotNull File file, @NotNull IOException cause) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        return file.exists() ? (file.isFile() ? (file.canRead() ? (file.canWrite() ? this.attachParentStacktrace(file, cause) : this.attachParentStacktrace(file, cause)) : (file.canWrite() ? this.attachParentStacktrace(file, cause) : this.attachParentStacktrace(file, cause))) : (file.canRead() ? (file.canWrite() ? this.attachParentStacktrace(file, cause) : this.attachParentStacktrace(file, cause)) : (file.canWrite() ? this.attachParentStacktrace(file, cause) : this.attachParentStacktrace(file, cause)))) : this.attachParentStacktrace(file, cause);
    }

    private final IOException attachParentStacktrace(File file, IOException cause) {
        File parent = file.getParentFile();
        if (parent == null) {
            return this.attachFileSystemMessage(file, cause);
        }
        return parent.exists() ? (parent.isFile() ? (parent.canRead() ? (parent.canWrite() ? this.attachFileSystemMessage(file, cause) : this.attachFileSystemMessage(file, cause)) : (parent.canWrite() ? this.attachFileSystemMessage(file, cause) : this.attachFileSystemMessage(file, cause))) : (parent.canRead() ? (parent.canWrite() ? this.attachFileSystemMessage(file, cause) : this.attachFileSystemMessage(file, cause)) : (parent.canWrite() ? this.attachFileSystemMessage(file, cause) : this.attachFileSystemMessage(file, cause)))) : this.attachFileSystemMessage(file, cause);
    }

    private final IOException attachFileSystemMessage(File file, IOException origException) {
        StringBuilder stringBuilder;
        StringBuilder $this$attachFileSystemMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$attachFileSystemMessage_u24lambda_u240.append("Inoperable file:");
        try {
            $this$attachFileSystemMessage_u24lambda_u240.append(" canonical[" + file.getCanonicalPath() + "] freeSpace[" + file.getFreeSpace() + ']');
        }
        catch (IOException ignored) {
            $this$attachFileSystemMessage_u24lambda_u240.append(" failed to attach additional metadata");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String message = string;
        return new IOException(message, origException);
    }
}

