/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core;

import androidx.datastore.core.Actual_jvmKt;
import androidx.datastore.core.CorruptionHandler;
import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataMigrationInitializer;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreImpl;
import androidx.datastore.core.FileStorage;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.Storage;
import androidx.datastore.core.handlers.NoOpCorruptionHandler;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jb\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007JT\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00142\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0015"}, d2={"Landroidx/datastore/core/DataStoreFactory;", "", "<init>", "()V", "create", "Landroidx/datastore/core/DataStore;", "T", "serializer", "Landroidx/datastore/core/Serializer;", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "migrations", "", "Landroidx/datastore/core/DataMigration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "produceFile", "Lkotlin/Function0;", "Ljava/io/File;", "storage", "Landroidx/datastore/core/Storage;", "datastore-core"})
public final class DataStoreFactory {
    @NotNull
    public static final DataStoreFactory INSTANCE = new DataStoreFactory();

    private DataStoreFactory() {
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Serializer<T> serializer, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull List<? extends DataMigration<T>> migrations, @NotNull CoroutineScope scope, @NotNull Function0<? extends File> produceFile) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        return this.create(new FileStorage(serializer, null, produceFile, 2, null), corruptionHandler, migrations, scope);
    }

    public static /* synthetic */ DataStore create$default(DataStoreFactory dataStoreFactory, Serializer serializer, ReplaceFileCorruptionHandler replaceFileCorruptionHandler, List list, CoroutineScope coroutineScope, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            replaceFileCorruptionHandler = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        }
        return dataStoreFactory.create(serializer, replaceFileCorruptionHandler, list, coroutineScope, (Function0<? extends File>)function0);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Storage<T> storage, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull List<? extends DataMigration<T>> migrations, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ReplaceFileCorruptionHandler<T> replaceFileCorruptionHandler = corruptionHandler;
        CorruptionHandler corruptionHandler2 = replaceFileCorruptionHandler != null ? (CorruptionHandler)replaceFileCorruptionHandler : (CorruptionHandler)new NoOpCorruptionHandler();
        List list = CollectionsKt.listOf(DataMigrationInitializer.Companion.getInitializer(migrations));
        return new DataStoreImpl<T>(storage, list, corruptionHandler2, scope);
    }

    public static /* synthetic */ DataStore create$default(DataStoreFactory dataStoreFactory, Storage storage, ReplaceFileCorruptionHandler replaceFileCorruptionHandler, List list, CoroutineScope coroutineScope, int n, Object object) {
        if ((n & 2) != 0) {
            replaceFileCorruptionHandler = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Actual_jvmKt.ioDispatcher().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        }
        return dataStoreFactory.create(storage, replaceFileCorruptionHandler, list, coroutineScope);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Serializer<T> serializer, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull List<? extends DataMigration<T>> migrations, @NotNull Function0<? extends File> produceFile) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        return DataStoreFactory.create$default(this, serializer, corruptionHandler, migrations, null, produceFile, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Serializer<T> serializer, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull Function0<? extends File> produceFile) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        return DataStoreFactory.create$default(this, serializer, corruptionHandler, null, null, produceFile, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Serializer<T> serializer, @NotNull Function0<? extends File> produceFile) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        return DataStoreFactory.create$default(this, serializer, null, null, null, produceFile, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Storage<T> storage, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull List<? extends DataMigration<T>> migrations) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        return DataStoreFactory.create$default(this, storage, corruptionHandler, migrations, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Storage<T> storage, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        return DataStoreFactory.create$default(this, storage, corruptionHandler, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> DataStore<T> create(@NotNull Storage<T> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        return DataStoreFactory.create$default(this, storage, null, null, null, 14, null);
    }
}

