/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.linalg;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0002\b\u0005\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a0\u0010\u0000\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a8\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0000\u001a8\u0010\f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0000\u001a0\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a0\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a0\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u001a0\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a8\u0006\u0010"}, d2={"norm1", "", "mat", "", "offset", "", "strides", "", "n", "m", "", "", "normFro", "power", "normInf", "normMax", "multik-kotlin"})
public final class NormKt {
    public static final float normFro(@NotNull float[] mat, int offset, @NotNull int[] strides, int n, int m, int power) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        float result = 0.0f;
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int i = 0; i < n; ++i) {
            int matInd = i * stride0 + offset;
            for (int k = 0; k < m; ++k) {
                float absValue = Math.abs(mat[matInd + k * stride1]);
                result += (float)Math.pow(absValue, power);
            }
        }
        return (float)Math.pow(result, 1.0f / (float)power);
    }

    public static final double normFro(@NotNull double[] mat, int offset, @NotNull int[] strides, int n, int m, int power) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        double result = 0.0;
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int i = 0; i < n; ++i) {
            int matInd = i * stride0 + offset;
            for (int k = 0; k < m; ++k) {
                double absValue = Math.abs(mat[matInd + k * stride1]);
                result += Math.pow(absValue, power);
            }
        }
        return Math.pow(result, 1.0 / (double)power);
    }

    public static final float norm1(@NotNull float[] mat, int offset, @NotNull int[] strides, int n, int m) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        float result = 0.0f;
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int j = 0; j < m; ++j) {
            int matIdx = j * stride1;
            float sum = 0.0f;
            for (int i = 0; i < n; ++i) {
                sum += Math.abs(mat[matIdx + (i * stride0 + offset)]);
            }
            if (!(result < sum)) continue;
            result = sum;
        }
        return result;
    }

    public static final double norm1(@NotNull double[] mat, int offset, @NotNull int[] strides, int n, int m) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        double result = 0.0;
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int j = 0; j < m; ++j) {
            int matIdx = j * stride1;
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                sum += Math.abs(mat[matIdx + (i * stride0 + offset)]);
            }
            if (!(result < sum)) continue;
            result = sum;
        }
        return result;
    }

    public static final float normMax(@NotNull float[] mat, int offset, @NotNull int[] strides, int n, int m) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        float result = mat[offset];
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int i = 0; i < n; ++i) {
            int matIdx = i * stride0 + offset;
            for (int j = 0; j < m; ++j) {
                float element = Math.abs(mat[matIdx + j * stride1]);
                if (!(result < element)) continue;
                result = element;
            }
        }
        return result;
    }

    public static final double normMax(@NotNull double[] mat, int offset, @NotNull int[] strides, int n, int m) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        double result = mat[offset];
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int i = 0; i < n; ++i) {
            int matIdx = i * stride0 + offset;
            for (int j = 0; j < m; ++j) {
                double element = Math.abs(mat[matIdx + j * stride1]);
                if (!(result < element)) continue;
                result = element;
            }
        }
        return result;
    }

    public static final float normInf(@NotNull float[] mat, int offset, @NotNull int[] strides, int n, int m) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        float result = 0.0f;
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int i = 0; i < n; ++i) {
            int matIdx = i * stride0 + offset;
            float sum = 0.0f;
            for (int j = 0; j < m; ++j) {
                sum += Math.abs(mat[matIdx + j * stride1]);
            }
            if (!(result < sum)) continue;
            result = sum;
        }
        return result;
    }

    public static final double normInf(@NotNull double[] mat, int offset, @NotNull int[] strides, int n, int m) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        double result = 0.0;
        int stride0 = strides[0];
        int stride1 = strides[1];
        for (int i = 0; i < n; ++i) {
            int matIdx = i * stride0 + offset;
            double sum = 0.0;
            for (int j = 0; j < m; ++j) {
                sum += Math.abs(mat[matIdx + j * stride1]);
            }
            if (!(result < sum)) continue;
            result = sum;
        }
        return result;
    }
}

