/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.linalg;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.api.ConstructorsKt;
import org.jetbrains.kotlinx.multik.api.ExperimentalMultikApi;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.api.linalg.LinAlgEx;
import org.jetbrains.kotlinx.multik.api.linalg.Norm;
import org.jetbrains.kotlinx.multik.kotlin.linalg.DotKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.EigenKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.NormKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.PluDecompositionKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.QrFactorizationKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.SolveKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.UtilsKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.Complex;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dim2;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;
import org.jetbrains.kotlinx.multik.ndarray.data.ScalarsGettersAndSettersKt;
import org.jetbrains.kotlinx.multik.ndarray.operations.CopyStrategy;
import org.jetbrains.kotlinx.multik.ndarray.operations.IteratingNDArrayKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016JF\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016JF\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\tH\u0016JF\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\u0004\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\tH\u0016J?\u0010\u0010\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\tH\u0016\u00a2\u0006\u0002\u0010\u0011J?\u0010\u0012\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\tH\u0016\u00a2\u0006\u0002\u0010\u0013J^\u0010\u0014\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\u0016`\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u0016`\u00180\u0015\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J^\u0010\u001a\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u00180\u0015\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016JT\u0010\u001b\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\u001c`\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001c`\u00180\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\tH\u0016J<\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\u0016`\u0017\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J<\u0010\u001f\u001a\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0017\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J2\u0010 \u001a\u0018\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\u001c`\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\tH\u0016J2\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J2\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J(\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\tH\u0016J$\u0010%\u001a\u00020\"2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010%\u001a\u00020&H\u0016J$\u0010'\u001a\u00020\u001d2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010%\u001a\u00020&H\u0016Jz\u0010(\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u00180)\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016Jz\u0010*\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u00180)\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J\u0088\u0001\u0010+\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H,`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H,`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H,`\u00180)\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010,*\u00020-2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010.\u001a\u00020/H\u0002Jp\u00100\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u00180)2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\tH\u0016J^\u00101\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u00180\u0015\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016J^\u00102\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u00180\u0015\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0016JT\u00103\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u00180\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\tH\u0016JP\u00104\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H50\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0007\"\b\b\u0001\u00105*\u0002062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H50\tH\u0016JP\u00107\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H50\u0004\"\b\b\u0000\u0010\u0005*\u00020\f\"\b\b\u0001\u00105*\u0002062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H50\tH\u0016J^\u00108\u001a\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u0002H50\u0004\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010,*\u00020-\"\b\b\u0002\u00105*\u0002062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H50\t2\u0006\u0010.\u001a\u00020/H\u0002JF\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H50\u0004\"\b\b\u0000\u00105*\u0002062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H50\tH\u0016Jz\u0010:\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\"`\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\"`\u00180)\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0017Jz\u0010;\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u0002H\u0005`\u00180)\"\b\b\u0000\u0010\u0005*\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\tH\u0017Jp\u0010<\u001aV\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u0018\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u0017\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u001d`\u00180)2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060\tH\u0017\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlinx/multik/kotlin/linalg/KELinAlgEx;", "Lorg/jetbrains/kotlinx/multik/api/linalg/LinAlgEx;", "()V", "dotMM", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "T", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "b", "dotMMComplex", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/Complex;", "dotMV", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1;", "dotMVComplex", "dotVV", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)Ljava/lang/Number;", "dotVVComplex", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)Lorg/jetbrains/kotlinx/multik/ndarray/complex/Complex;", "eig", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1Array;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2Array;", "mat", "eigC", "eigF", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloat;", "", "eigVals", "eigValsC", "eigValsF", "inv", "", "invC", "invF", "norm", "Lorg/jetbrains/kotlinx/multik/api/linalg/Norm;", "normF", "plu", "Lkotlin/Triple;", "pluC", "pluCommon", "O", "", "dtype", "Lorg/jetbrains/kotlinx/multik/ndarray/data/DataType;", "pluF", "qr", "qrC", "qrF", "solve", "D", "Lorg/jetbrains/kotlinx/multik/ndarray/data/Dim2;", "solveC", "solveCommon", "solveF", "svd", "svdC", "svdF", "multik-kotlin"})
@SourceDebugExtension(value={"SMAP\nLinAlgEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinAlgEx.kt\norg/jetbrains/kotlinx/multik/kotlin/linalg/KELinAlgEx\n+ 2 IteratingNDArray.kt\norg/jetbrains/kotlinx/multik/ndarray/operations/IteratingNDArrayKt\n+ 3 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 4 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1609#2,2:165\n1611#2:179\n79#3:167\n13#4,11:168\n1#5:180\n*S KotlinDebug\n*F\n+ 1 LinAlgEx.kt\norg/jetbrains/kotlinx/multik/kotlin/linalg/KELinAlgEx\n*L\n75#1:165,2\n75#1:179\n75#1:167\n75#1:168,11\n*E\n"})
public final class KELinAlgEx
implements LinAlgEx {
    @NotNull
    public static final KELinAlgEx INSTANCE = new KELinAlgEx();

    private KELinAlgEx() {
    }

    @NotNull
    public <T extends Number> NDArray<Double, D2> inv(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return this.solveCommon(mat, (MultiArray)ConstructorsKt.identity((Multik)Multik.INSTANCE, (int)mat.getShape()[0], (DataType)mat.getDtype()), mat.getDtype());
    }

    @NotNull
    public NDArray<Float, D2> invF(@NotNull MultiArray<Float, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return this.solveCommon(mat, (MultiArray)ConstructorsKt.identity((Multik)Multik.INSTANCE, (int)mat.getShape()[0], (DataType)mat.getDtype()), mat.getDtype());
    }

    @NotNull
    public <T extends Complex> NDArray<T, D2> invC(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return this.solveCommon(mat, (MultiArray)ConstructorsKt.identity((Multik)Multik.INSTANCE, (int)mat.getShape()[0], (DataType)mat.getDtype()), mat.getDtype());
    }

    @NotNull
    public <T extends Number, D extends Dim2> NDArray<Double, D> solve(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return this.solveCommon(a, b, DataType.DoubleDataType);
    }

    @NotNull
    public <D extends Dim2> NDArray<Float, D> solveF(@NotNull MultiArray<Float, D2> a, @NotNull MultiArray<Float, D> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return this.solveCommon(a, b, DataType.FloatDataType);
    }

    @NotNull
    public <T extends Complex, D extends Dim2> NDArray<T, D> solveC(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return this.solveCommon(a, b, a.getDtype());
    }

    private final <T, O, D extends Dim2> NDArray<O, D> solveCommon(MultiArray<T, D2> a, MultiArray<T, D> b, DataType dtype) {
        NDArray nDArray;
        UtilsKt.requireSquare(a.getShape());
        UtilsKt.requireDotShape(a.getShape(), b.getShape());
        NDArray _a = IteratingNDArrayKt.toType(a, (DataType)dtype, (CopyStrategy)CopyStrategy.MEANINGFUL);
        MultiArray bTyped = dtype == DataType.DoubleDataType ? (MultiArray)IteratingNDArrayKt.toType(b, (DataType)dtype, (CopyStrategy)CopyStrategy.MEANINGFUL) : b;
        MultiArray multiArray = ((Dim2)bTyped.getDim()).getD() == 2 ? bTyped : bTyped.reshape(bTyped.getShape()[0], 1);
        Intrinsics.checkNotNull((Object)multiArray, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.MultiArray<T of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.solveCommon, org.jetbrains.kotlinx.multik.ndarray.data.D2>");
        MultiArray _b = multiArray;
        switch (WhenMappings.$EnumSwitchMapping$0[dtype.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)_a, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<kotlin.Double, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<kotlin.Double> }");
                nDArray = SolveKt.solveDouble$default((MultiArray)_a, (MultiArray)((NDArray)_b), 0.0, 4, null);
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)_a, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<kotlin.Float, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<kotlin.Float> }");
                nDArray = SolveKt.solveFloat$default((MultiArray)_a, (MultiArray)((NDArray)_b), 0.0f, 4, null);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)_a, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble> }");
                nDArray = SolveKt.solveComplexDouble$default((MultiArray)_a, (MultiArray)((NDArray)_b), 0.0, 4, null);
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)_a, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat> }");
                nDArray = SolveKt.solveComplexFloat$default((MultiArray)_a, (MultiArray)((NDArray)_b), 0.0f, 4, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        NDArray ans2 = nDArray;
        NDArray nDArray2 = ((Dim2)b.getDim()).getD() == 2 ? ans2 : ans2.reshape(ans2.getShape()[0]);
        Intrinsics.checkNotNull((Object)nDArray2, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.multik.ndarray.data.NDArray<O of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.solveCommon, D of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.solveCommon>");
        return nDArray2;
    }

    public float normF(@NotNull MultiArray<Float, D2> mat, @NotNull Norm norm) {
        float f;
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)norm, (String)"norm");
        switch (WhenMappings.$EnumSwitchMapping$1[norm.ordinal()]) {
            case 1: {
                f = NormKt.normFro(mat.getData().getFloatArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1], 2);
                break;
            }
            case 2: {
                f = NormKt.norm1(mat.getData().getFloatArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1]);
                break;
            }
            case 3: {
                f = NormKt.normMax(mat.getData().getFloatArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1]);
                break;
            }
            case 4: {
                f = NormKt.normInf(mat.getData().getFloatArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1]);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    public double norm(@NotNull MultiArray<Double, D2> mat, @NotNull Norm norm) {
        double d;
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)norm, (String)"norm");
        switch (WhenMappings.$EnumSwitchMapping$1[norm.ordinal()]) {
            case 1: {
                d = NormKt.normFro(mat.getData().getDoubleArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1], 2);
                break;
            }
            case 2: {
                d = NormKt.norm1(mat.getData().getDoubleArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1]);
                break;
            }
            case 3: {
                d = NormKt.normMax(mat.getData().getDoubleArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1]);
                break;
            }
            case 4: {
                d = NormKt.normInf(mat.getData().getDoubleArray(), mat.getOffset(), mat.getStrides(), mat.getShape()[0], mat.getShape()[1]);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @NotNull
    public <T extends Number> Pair<NDArray<Double, D2>, NDArray<Double, D2>> qr(@NotNull MultiArray<T, D2> mat) {
        DataType dataType;
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        MultiArray<T, D2> $this$toType_u24default$iv = mat;
        CopyStrategy copy$iv = CopyStrategy.FULL;
        boolean $i$f$toType = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Double.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        DataType dtype$iv = dataType;
        return QrFactorizationKt.qrDouble((MultiArray<Double, D2>)((MultiArray)IteratingNDArrayKt.toType($this$toType_u24default$iv, (DataType)dtype$iv, (CopyStrategy)copy$iv)));
    }

    @NotNull
    public Pair<NDArray<Float, D2>, NDArray<Float, D2>> qrF(@NotNull MultiArray<Float, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return QrFactorizationKt.qrFloat(mat);
    }

    @NotNull
    public <T extends Complex> Pair<NDArray<T, D2>, NDArray<T, D2>> qrC(@NotNull MultiArray<T, D2> mat) {
        Pair<NDArray<ComplexFloat, D2>, NDArray<ComplexFloat, D2>> pair;
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        switch (WhenMappings.$EnumSwitchMapping$0[mat.getDtype().ordinal()]) {
            case 4: {
                pair = QrFactorizationKt.qrComplexFloat(mat);
                break;
            }
            case 3: {
                pair = QrFactorizationKt.qrComplexDouble(mat);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Matrix should be complex");
            }
        }
        Pair<NDArray<ComplexFloat, D2>, NDArray<ComplexFloat, D2>> pair2 = pair;
        Intrinsics.checkNotNull(pair2, (String)"null cannot be cast to non-null type kotlin.Pair<org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.qrC, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<T of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.qrC> }, org.jetbrains.kotlinx.multik.ndarray.data.NDArray<T of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.qrC, org.jetbrains.kotlinx.multik.ndarray.data.D2>{ org.jetbrains.kotlinx.multik.ndarray.data.NDArrayKt.D2Array<T of org.jetbrains.kotlinx.multik.kotlin.linalg.KELinAlgEx.qrC> }>");
        return pair2;
    }

    @NotNull
    public <T extends Number> Triple<NDArray<Double, D2>, NDArray<Double, D2>, NDArray<Double, D2>> plu(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return this.pluCommon(mat, DataType.DoubleDataType);
    }

    @NotNull
    public Triple<NDArray<Float, D2>, NDArray<Float, D2>, NDArray<Float, D2>> pluF(@NotNull MultiArray<Float, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return this.pluCommon(mat, DataType.FloatDataType);
    }

    @NotNull
    public <T extends Complex> Triple<NDArray<T, D2>, NDArray<T, D2>, NDArray<T, D2>> pluC(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return this.pluCommon(mat, mat.getDtype());
    }

    @ExperimentalMultikApi
    @NotNull
    public Triple<NDArray<Float, D2>, NDArray<Float, D1>, NDArray<Float, D2>> svdF(@NotNull MultiArray<Float, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @ExperimentalMultikApi
    @NotNull
    public <T extends Number> Triple<NDArray<Double, D2>, NDArray<Double, D1>, NDArray<Double, D2>> svd(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @ExperimentalMultikApi
    @NotNull
    public <T extends Complex> Triple<NDArray<T, D2>, NDArray<T, D1>, NDArray<T, D2>> svdC(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public <T extends Number> Pair<NDArray<ComplexDouble, D1>, NDArray<ComplexDouble, D2>> eig(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public Pair<NDArray<ComplexFloat, D1>, NDArray<ComplexFloat, D2>> eigF(@NotNull MultiArray<Float, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public <T extends Complex> Pair<NDArray<T, D1>, NDArray<T, D2>> eigC(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public <T extends Number> NDArray<ComplexDouble, D1> eigVals(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return EigenKt.eigenValuesCommon(mat, DataType.ComplexDoubleDataType);
    }

    @NotNull
    public NDArray<ComplexFloat, D1> eigValsF(@NotNull MultiArray<Float, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return EigenKt.eigenValuesCommon(mat, DataType.ComplexFloatDataType);
    }

    @NotNull
    public <T extends Complex> NDArray<T, D1> eigValsC(@NotNull MultiArray<T, D2> mat) {
        Intrinsics.checkNotNullParameter(mat, (String)"mat");
        return EigenKt.eigenValuesCommon(mat, mat.getDtype());
    }

    private final <T, O> Triple<NDArray<O, D2>, NDArray<O, D2>, NDArray<O, D2>> pluCommon(MultiArray<T, D2> mat, DataType dtype) {
        int i;
        NDArray a = IteratingNDArrayKt.toType(mat, (DataType)dtype, (CopyStrategy)CopyStrategy.MEANINGFUL);
        Triple triple = PluDecompositionKt.pluCompressed((MultiArray)a);
        NDArray perm = (NDArray)triple.component1();
        NDArray L = (NDArray)triple.component2();
        NDArray U = (NDArray)triple.component3();
        NDArray P = ConstructorsKt.identity((Multik)Multik.INSTANCE, (int)a.getShape()[0], (DataType)dtype);
        IntRange intRange = perm.getIndices();
        int n = intRange.getFirst();
        if (n <= (i = intRange.getLast())) {
            while (true) {
                if (ScalarsGettersAndSettersKt.intGet1((MultiArray)((MultiArray)perm), (int)i) != 0) {
                    int n2 = P.getShape()[1];
                    for (int k = 0; k < n2; ++k) {
                        Object object;
                        Object object2 = object = ScalarsGettersAndSettersKt.genGet2((MultiArray)((MultiArray)P), (int)(i + ScalarsGettersAndSettersKt.intGet1((MultiArray)((MultiArray)perm), (int)i)), (int)k);
                        int n3 = k;
                        int n4 = i;
                        MutableMultiArray mutableMultiArray = (MutableMultiArray)P;
                        boolean bl = false;
                        ScalarsGettersAndSettersKt.genSet2((MutableMultiArray)((MutableMultiArray)P), (int)(i + ScalarsGettersAndSettersKt.intGet1((MultiArray)((MultiArray)perm), (int)i)), (int)k, (Object)ScalarsGettersAndSettersKt.genGet2((MultiArray)((MultiArray)P), (int)i, (int)k));
                        Unit unit = Unit.INSTANCE;
                        ScalarsGettersAndSettersKt.genSet2((MutableMultiArray)mutableMultiArray, (int)n4, (int)n3, (Object)object);
                    }
                }
                if (i == n) break;
                --i;
            }
        }
        return new Triple((Object)P, (Object)L, (Object)U);
    }

    @NotNull
    public <T extends Number> NDArray<T, D2> dotMM(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D2> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrix(a, b);
    }

    @NotNull
    public <T extends Complex> NDArray<T, D2> dotMMComplex(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D2> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixComplex(a, b);
    }

    @NotNull
    public <T extends Number> NDArray<T, D1> dotMV(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D1> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixToVector(a, b);
    }

    @NotNull
    public <T extends Complex> NDArray<T, D1> dotMVComplex(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D1> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixToVectorComplex(a, b);
    }

    @NotNull
    public <T extends Number> T dotVV(@NotNull MultiArray<T, D1> a, @NotNull MultiArray<T, D1> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotVecToVec(a, b);
    }

    @NotNull
    public <T extends Complex> T dotVVComplex(@NotNull MultiArray<T, D1> a, @NotNull MultiArray<T, D1> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotVecToVecComplex(a, b);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.DoubleDataType.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.FloatDataType.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ComplexDoubleDataType.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.ComplexFloatDataType.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Norm.values().length];
            try {
                nArray[Norm.Fro.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Norm.N1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Norm.Max.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Norm.Inf.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

