/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.BluetoothStackWIDCOMMSDPInputStream;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackToshiba
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    private boolean initialized = false;
    private Vector deviceDiscoveryListeners = new Vector();
    private Hashtable deviceDiscoveryListenerFoundDevices = new Hashtable();
    private Hashtable deviceDiscoveryListenerReportedDevices = new Hashtable();
    private static final int ATTR_RETRIEVABLE_MAX = 65535;
    private static final int RECEIVE_MTU_MAX = 1024;

    private String getBTWVersionInfo() {
        return "";
    }

    private int getDeviceVersion() {
        return 0;
    }

    private int getDeviceManufacturer() {
        return 0;
    }

    BluetoothStackToshiba() {
    }

    @Override
    public String getStackID() {
        return "toshiba";
    }

    public String toString() {
        return this.getStackID();
    }

    @Override
    public int getFeatureSet() {
        return 0;
    }

    @Override
    public native boolean isNativeCodeLoaded();

    @Override
    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return BluetoothStack.LibraryInformation.library("bluecove");
    }

    @Override
    public native int getLibraryVersion();

    @Override
    public native int detectBluetoothStack();

    @Override
    public native void enableNativeDebug(Class var1, boolean var2);

    private native boolean initializeImpl() throws BluetoothStateException;

    private native void destroyImpl();

    @Override
    public void initialize() throws BluetoothStateException {
        if (!this.initializeImpl()) {
            throw new BluetoothStateException("TOSHIBA BluetoothStack not found");
        }
        this.initialized = true;
    }

    @Override
    public void destroy() {
        if (this.initialized) {
            this.destroyImpl();
            this.initialized = false;
            DebugLog.debug("TOSHIBA destroyed");
        }
    }

    @Override
    public boolean isCurrentThreadInterruptedCallback() {
        return UtilsJavaSE.isCurrentThreadInterrupted();
    }

    @Override
    public RemoteDevice[] retrieveDevices(int option) {
        return null;
    }

    @Override
    public Boolean isRemoteDeviceTrusted(long address) {
        return null;
    }

    @Override
    public Boolean isRemoteDeviceAuthenticated(long address) {
        return null;
    }

    @Override
    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
    }

    @Override
    public native String getLocalDeviceBluetoothAddress() throws BluetoothStateException;

    @Override
    public DeviceClass getLocalDeviceClass() {
        return null;
    }

    @Override
    public void setLocalDeviceServiceClasses(int classOfDevice) {
    }

    @Override
    public String getLocalDeviceName() {
        return null;
    }

    @Override
    public boolean isLocalDevicePowerOn() {
        return true;
    }

    @Override
    public String getLocalDeviceProperty(String property) {
        if ("bluetooth.connected.devices.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.sd.trans.max".equals(property)) {
            return "1";
        }
        if ("bluetooth.connected.inquiry.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.inquiry".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page".equals(property)) {
            return "true";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(property)) {
            return String.valueOf(65535);
        }
        if ("bluetooth.master.switch".equals(property)) {
            return "false";
        }
        if ("bluetooth.l2cap.receiveMTU.max".equals(property)) {
            return String.valueOf(1024);
        }
        if ("bluecove.radio.version".equals(property)) {
            return String.valueOf(this.getDeviceVersion());
        }
        if ("bluecove.radio.manufacturer".equals(property)) {
            return String.valueOf(this.getDeviceManufacturer());
        }
        if ("bluecove.stack.version".equals(property)) {
            return this.getBTWVersionInfo();
        }
        if (property.startsWith("bluecove.nativeFunction:")) {
            String functionDescr = property.substring(property.indexOf(58) + 1, property.length());
            int paramIdx = functionDescr.indexOf(58);
            if (paramIdx == -1) {
                throw new RuntimeException("Invalid native function " + functionDescr + "; arguments expected");
            }
            String function = functionDescr.substring(0, paramIdx);
            long address = RemoteDeviceHelper.getAddress(functionDescr.substring(function.length() + 1, functionDescr.length()));
            if ("getRemoteDeviceVersionInfo".equals(function)) {
                return this.getRemoteDeviceVersionInfo(address);
            }
            if ("cancelSniffMode".equals(function)) {
                return String.valueOf(this.cancelSniffMode(address));
            }
            if ("setSniffMode".equals(function)) {
                return String.valueOf(this.setSniffMode(address));
            }
            if ("getRemoteDeviceRSSI".equals(function)) {
                return String.valueOf(this.getRemoteDeviceRSSI(address));
            }
            if ("getRemoteDeviceLinkMode".equals(function)) {
                if (this.isRemoteDeviceConnected(address)) {
                    return this.getRemoteDeviceLinkMode(address);
                }
                return "disconnected";
            }
        }
        return null;
    }

    @Override
    public int getLocalDeviceDiscoverable() {
        return 0;
    }

    @Override
    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        return false;
    }

    @Override
    public boolean authenticateRemoteDevice(long address) throws IOException {
        return false;
    }

    @Override
    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        return false;
    }

    public boolean isRemoteDeviceConnected(long address) {
        return true;
    }

    public String getRemoteDeviceLinkMode(long address) {
        return "";
    }

    public String getRemoteDeviceVersionInfo(long address) {
        return "";
    }

    public boolean setSniffMode(long address) {
        return false;
    }

    public boolean cancelSniffMode(long address) {
        return false;
    }

    public int getRemoteDeviceRSSI(long address) {
        return 0;
    }

    private native int runDeviceInquiryImpl(DeviceInquiryThread var1, int var2, DiscoveryListener var3) throws BluetoothStateException;

    @Override
    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        this.deviceDiscoveryListeners.addElement(listener);
        if (BlueCoveImpl.getConfigProperty("bluecove.inquiry.report_asap", false)) {
            this.deviceDiscoveryListenerFoundDevices.put(listener, new Hashtable());
        }
        this.deviceDiscoveryListenerReportedDevices.put(listener, new Vector());
        return DeviceInquiryThread.startInquiry(this, this, accessCode, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        try {
            Hashtable previouslyFound;
            int discType = this.runDeviceInquiryImpl(startedNotify, accessCode, listener);
            if (discType == 0 && (previouslyFound = (Hashtable)this.deviceDiscoveryListenerFoundDevices.get(listener)) != null) {
                Vector reported = (Vector)this.deviceDiscoveryListenerReportedDevices.get(listener);
                Enumeration en = previouslyFound.keys();
                while (en.hasMoreElements()) {
                    RemoteDevice remoteDevice = (RemoteDevice)en.nextElement();
                    if (reported.contains(remoteDevice)) continue;
                    reported.addElement(remoteDevice);
                    Integer deviceClassInt = (Integer)previouslyFound.get(remoteDevice);
                    DeviceClass deviceClass = new DeviceClass(deviceClassInt);
                    listener.deviceDiscovered(remoteDevice, deviceClass);
                    if (this.deviceDiscoveryListeners.contains(listener)) continue;
                    int n = 5;
                    return n;
                }
            }
            int n = discType;
            return n;
        }
        finally {
            this.deviceDiscoveryListeners.removeElement(listener);
            this.deviceDiscoveryListenerFoundDevices.remove(listener);
            this.deviceDiscoveryListenerReportedDevices.remove(listener);
        }
    }

    @Override
    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
        DebugLog.debug("deviceDiscoveredCallback deviceName", deviceName);
        if (!this.deviceDiscoveryListeners.contains(listener)) {
            return;
        }
        RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(this, deviceAddr, deviceName, paired);
        Vector reported = (Vector)this.deviceDiscoveryListenerReportedDevices.get(listener);
        if (reported == null || reported.contains(remoteDevice)) {
            return;
        }
        Hashtable previouslyFound = (Hashtable)this.deviceDiscoveryListenerFoundDevices.get(listener);
        if (previouslyFound != null) {
            Integer deviceClassInt = (Integer)previouslyFound.get(remoteDevice);
            if (deviceClassInt == null) {
                previouslyFound.put(remoteDevice, new Integer(deviceClass));
            } else if (deviceClass != 0) {
                previouslyFound.put(remoteDevice, new Integer(deviceClass));
            }
        } else {
            DeviceClass cod = new DeviceClass(deviceClass);
            reported.addElement(remoteDevice);
            DebugLog.debug("deviceDiscoveredCallback address", remoteDevice.getBluetoothAddress());
            DebugLog.debug("deviceDiscoveredCallback deviceClass", cod);
            listener.deviceDiscovered(remoteDevice, cod);
        }
    }

    private native boolean deviceInquiryCancelImpl();

    @Override
    public boolean cancelInquiry(DiscoveryListener listener) {
        if (!this.deviceDiscoveryListeners.removeElement(listener)) {
            return false;
        }
        return this.deviceInquiryCancelImpl();
    }

    private native String getRemoteDeviceFriendlyNameImpl(long var1);

    @Override
    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return this.getRemoteDeviceFriendlyNameImpl(address);
    }

    private native short connectSDPImpl(long var1);

    private native void disconnectSDPImpl(short var1);

    private native long[] searchServicesImpl(SearchServicesThread var1, short var2, byte[][] var3);

    private native byte[] populateWorkerImpl(short var1, long var2, int[] var4);

    private boolean setAttributes(ServiceRecordImpl serviceRecord, int[] attrIDs, byte[] bytes) {
        boolean anyRetrived = false;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BluetoothStackWIDCOMMSDPInputStream btis = null;
        try {
            btis = new BluetoothStackWIDCOMMSDPInputStream(bais);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < attrIDs.length; ++i) {
            int id = attrIDs[i];
            try {
                DataElement protocolElement;
                Enumeration protocolsSeqEnum;
                DataElement element = btis.readElement();
                if (id == 4 && (protocolsSeqEnum = (Enumeration)element.getValue()).hasMoreElements() && (protocolElement = (DataElement)protocolsSeqEnum.nextElement()).getDataType() != 48) {
                    DataElement newMainSeq = new DataElement(48);
                    newMainSeq.addElement(element);
                    element = newMainSeq;
                }
                serviceRecord.populateAttributeValue(id, element);
                anyRetrived = true;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return anyRetrived;
    }

    @Override
    public int runSearchServices(SearchServicesThread startedNotify, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        long[] handles;
        short cid;
        try {
            cid = this.connectSDPImpl(RemoteDeviceHelper.getAddress(device.getBluetoothAddress()));
        }
        catch (Exception e) {
            return 6;
        }
        byte[][] uuidBytes = new byte[uuidSet.length][16];
        for (int i = 0; i < uuidSet.length; ++i) {
            uuidBytes[i] = new byte[16];
            String full = uuidSet[i].toString();
            for (int j = 0; j < 16; ++j) {
                String sub = full.substring(j * 2, j * 2 + 2).toUpperCase();
                uuidBytes[i][j] = (byte)Integer.parseInt(sub, 16);
            }
        }
        try {
            handles = this.searchServicesImpl(startedNotify, cid, uuidBytes);
        }
        catch (Exception e) {
            this.disconnectSDPImpl(cid);
            return 3;
        }
        if (handles.length <= 0) {
            this.disconnectSDPImpl(cid);
            return 4;
        }
        ServiceRecord[] records = new ServiceRecordImpl[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            byte[] bytes;
            records[i] = new ServiceRecordImpl(this, device, handles[i]);
            try {
                bytes = this.populateWorkerImpl(cid, handles[i], attrSet);
            }
            catch (Exception e) {
                this.disconnectSDPImpl(cid);
                return 3;
            }
            if (bytes == null) continue;
            this.setAttributes((ServiceRecordImpl)records[i], attrSet, bytes);
        }
        listener.servicesDiscovered(startedNotify.getTransID(), records);
        this.disconnectSDPImpl(cid);
        return 1;
    }

    @Override
    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return SearchServicesThread.startSearchServices(this, this, attrSet, uuidSet, device, listener);
    }

    @Override
    public boolean cancelServiceSearch(int transID) {
        return false;
    }

    @Override
    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        byte[] bytes;
        short cid;
        if (attrIDs.length > 65535) {
            throw new IllegalArgumentException();
        }
        try {
            cid = this.connectSDPImpl(RemoteDeviceHelper.getAddress(serviceRecord.getHostDevice().getBluetoothAddress()));
        }
        catch (Exception e) {
            return false;
        }
        try {
            bytes = this.populateWorkerImpl(cid, serviceRecord.getHandle(), attrIDs);
        }
        catch (Exception e) {
            this.disconnectSDPImpl(cid);
            return false;
        }
        if (bytes == null) {
            return false;
        }
        boolean ret = this.setAttributes(serviceRecord, attrIDs, bytes);
        this.disconnectSDPImpl(cid);
        return ret;
    }

    @Override
    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        return 0L;
    }

    @Override
    public void connectionRfCloseClientConnection(long handle) throws IOException {
    }

    @Override
    public int rfGetSecurityOpt(long handle, int expected) throws IOException {
        return expected;
    }

    @Override
    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    @Override
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        return 0L;
    }

    @Override
    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
    }

    @Override
    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
    }

    @Override
    public long rfServerAcceptAndOpenRfServerConnection(long handle) throws IOException {
        return 0L;
    }

    @Override
    public void connectionRfCloseServerConnection(long handle) throws IOException {
    }

    @Override
    public void connectionRfFlush(long handle) throws IOException {
    }

    @Override
    public int connectionRfRead(long handle) throws IOException {
        return 0;
    }

    @Override
    public int connectionRfRead(long handle, byte[] b, int off, int len) throws IOException {
        return 0;
    }

    @Override
    public int connectionRfReadAvailable(long handle) throws IOException {
        return 0;
    }

    @Override
    public void connectionRfWrite(long handle, int b) throws IOException {
    }

    @Override
    public void connectionRfWrite(long handle, byte[] b, int off, int len) throws IOException {
    }

    @Override
    public long getConnectionRfRemoteAddress(long handle) throws IOException {
        return 0L;
    }

    @Override
    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        return 0L;
    }

    @Override
    public void l2CloseClientConnection(long handle) throws IOException {
    }

    @Override
    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        return 0L;
    }

    @Override
    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
    }

    @Override
    public long l2ServerAcceptAndOpenServerConnection(long handle) throws IOException {
        return 0L;
    }

    @Override
    public void l2CloseServerConnection(long handle) throws IOException {
    }

    @Override
    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
    }

    @Override
    public int l2GetSecurityOpt(long handle, int expected) throws IOException {
        return expected;
    }

    @Override
    public boolean l2Ready(long handle) throws IOException {
        return false;
    }

    @Override
    public int l2Receive(long handle, byte[] inBuf) throws IOException {
        return 0;
    }

    @Override
    public void l2Send(long handle, byte[] data, int transmitMTU) throws IOException {
    }

    @Override
    public int l2GetReceiveMTU(long handle) throws IOException {
        return 0;
    }

    @Override
    public int l2GetTransmitMTU(long handle) throws IOException {
        return 0;
    }

    @Override
    public long l2RemoteAddress(long handle) throws IOException {
        return 0L;
    }

    @Override
    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }
}

