/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NotSupportedIOException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.RetrieveDevicesCallback;
import com.intel.bluetooth.SDPInputStream;
import com.intel.bluetooth.SearchServicesDeviceNotReachableException;
import com.intel.bluetooth.SearchServicesException;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesTerminatedException;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackMicrosoft
implements BluetoothStack {
    private static final int BTH_MODE_POWER_OFF = 1;
    private static final int BTH_MODE_CONNECTABLE = 2;
    private static final int BTH_MODE_DISCOVERABLE = 3;
    private static BluetoothStackMicrosoft singleInstance = null;
    private boolean peerInitialized = false;
    private boolean windowsCE;
    private long localBluetoothAddress = 0L;
    private DiscoveryListener currentDeviceDiscoveryListener;
    private Thread limitedDiscoverableTimer;
    private static final int ATTR_RETRIEVABLE_MAX = 256;
    private Hashtable deviceDiscoveryDevices;
    private static int connectThreadNumber;

    private static synchronized int nextConnectThreadNum() {
        return connectThreadNumber++;
    }

    BluetoothStackMicrosoft() {
    }

    @Override
    public String getStackID() {
        return "winsock";
    }

    @Override
    public native boolean isNativeCodeLoaded();

    @Override
    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return BluetoothStack.LibraryInformation.library("intelbth");
    }

    public String toString() {
        return this.getStackID();
    }

    @Override
    public native int getLibraryVersion();

    @Override
    public native int detectBluetoothStack();

    @Override
    public native void enableNativeDebug(Class var1, boolean var2);

    private static native int initializationStatus() throws IOException;

    private native void uninitialize();

    private native boolean isWindowsCE();

    @Override
    public void initialize() throws BluetoothStateException {
        if (singleInstance != null) {
            throw new BluetoothStateException("Only one instance of " + this.getStackID() + " stack supported");
        }
        try {
            int status = BluetoothStackMicrosoft.initializationStatus();
            DebugLog.debug("initializationStatus", status);
            if (status == 1) {
                this.peerInitialized = true;
            }
            this.windowsCE = this.isWindowsCE();
            singleInstance = this;
        }
        catch (BluetoothStateException e) {
            throw e;
        }
        catch (IOException e) {
            DebugLog.fatal("initialization", e);
            throw new BluetoothStateException(e.getMessage());
        }
    }

    @Override
    public void destroy() {
        if (singleInstance != this) {
            throw new RuntimeException("Destroy invalid instance");
        }
        if (this.peerInitialized) {
            this.peerInitialized = false;
            this.uninitialize();
        }
        this.cancelLimitedDiscoverableTimer();
        singleInstance = null;
    }

    private void initialized() throws BluetoothStateException {
        if (!this.peerInitialized) {
            throw new BluetoothStateException("Bluetooth system is unavailable");
        }
    }

    @Override
    public int getFeatureSet() {
        return 2 | (this.windowsCE ? 0 : 4);
    }

    private native int getDeviceClass(long var1);

    private native void setDiscoverable(boolean var1) throws BluetoothStateException;

    private native int getBluetoothRadioMode();

    private native String getradioname(long var1);

    private native int getDeviceVersion(long var1);

    private native int getDeviceManufacturer(long var1);

    @Override
    public String getLocalDeviceBluetoothAddress() {
        try {
            long socket = this.socket(false, false);
            this.bind(socket);
            this.localBluetoothAddress = this.getsockaddress(socket);
            String address = RemoteDeviceHelper.getBluetoothAddress(this.localBluetoothAddress);
            this.storesockopt(socket);
            this.close(socket);
            return address;
        }
        catch (IOException e) {
            DebugLog.error("get local bluetoothAddress", e);
            return "000000000000";
        }
    }

    @Override
    public String getLocalDeviceName() {
        if (this.localBluetoothAddress == 0L) {
            this.getLocalDeviceBluetoothAddress();
        }
        return this.getradioname(this.localBluetoothAddress);
    }

    @Override
    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return this.getpeername(address);
    }

    @Override
    public DeviceClass getLocalDeviceClass() {
        return new DeviceClass(this.getDeviceClass(this.localBluetoothAddress));
    }

    @Override
    public void setLocalDeviceServiceClasses(int classOfDevice) {
    }

    private void cancelLimitedDiscoverableTimer() {
        if (this.limitedDiscoverableTimer != null) {
            this.limitedDiscoverableTimer.interrupt();
            this.limitedDiscoverableTimer = null;
        }
    }

    @Override
    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        switch (mode) {
            case 0: {
                this.cancelLimitedDiscoverableTimer();
                DebugLog.debug("setDiscoverable(false)");
                this.setDiscoverable(false);
                return 0 == this.getLocalDeviceDiscoverable();
            }
            case 10390323: {
                this.cancelLimitedDiscoverableTimer();
                DebugLog.debug("setDiscoverable(true)");
                this.setDiscoverable(true);
                return 10390323 == this.getLocalDeviceDiscoverable();
            }
            case 10390272: {
                this.cancelLimitedDiscoverableTimer();
                DebugLog.debug("setDiscoverable(LIAC)");
                this.setDiscoverable(true);
                if (10390323 != this.getLocalDeviceDiscoverable()) {
                    return false;
                }
                this.limitedDiscoverableTimer = Utils.schedule(60000L, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BluetoothStackMicrosoft.this.setDiscoverable(false);
                        }
                        catch (BluetoothStateException e) {
                            DebugLog.debug("error setDiscoverable", e);
                        }
                        finally {
                            BluetoothStackMicrosoft.this.limitedDiscoverableTimer = null;
                        }
                    }
                });
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLocalDevicePowerOn() {
        int mode = this.getBluetoothRadioMode();
        if (mode == 1) {
            return false;
        }
        return mode == 2 || mode == 3;
    }

    @Override
    public int getLocalDeviceDiscoverable() {
        int mode = this.getBluetoothRadioMode();
        if (mode == 3) {
            if (this.limitedDiscoverableTimer != null) {
                DebugLog.debug("Discoverable = LIAC");
                return 10390272;
            }
            DebugLog.debug("Discoverable = GIAC");
            return 10390323;
        }
        DebugLog.debug("Discoverable = NOT_DISCOVERABLE");
        return 0;
    }

    @Override
    public String getLocalDeviceProperty(String property) {
        if ("bluetooth.connected.devices.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.sd.trans.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.connected.inquiry.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.inquiry".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page".equals(property)) {
            return "true";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(property)) {
            return String.valueOf(256);
        }
        if ("bluetooth.master.switch".equals(property)) {
            return "false";
        }
        if ("bluetooth.l2cap.receiveMTU.max".equals(property)) {
            return "0";
        }
        if ("bluecove.radio.version".equals(property)) {
            return String.valueOf(this.getDeviceVersion(this.localBluetoothAddress));
        }
        if ("bluecove.radio.manufacturer".equals(property)) {
            return String.valueOf(this.getDeviceManufacturer(this.localBluetoothAddress));
        }
        return null;
    }

    @Override
    public boolean isCurrentThreadInterruptedCallback() {
        return UtilsJavaSE.isCurrentThreadInterrupted();
    }

    private native boolean retrieveDevicesImpl(int var1, RetrieveDevicesCallback var2);

    @Override
    public RemoteDevice[] retrieveDevices(int option) {
        if (this.windowsCE) {
            return null;
        }
        final Vector devices = new Vector();
        RetrieveDevicesCallback retrieveDevicesCallback = new RetrieveDevicesCallback(){

            @Override
            public void deviceFoundCallback(long deviceAddr, int deviceClass, String deviceName, boolean paired) {
                DebugLog.debug("device found", deviceAddr);
                RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(BluetoothStackMicrosoft.this, deviceAddr, deviceName, paired);
                devices.add(remoteDevice);
            }
        };
        if (this.retrieveDevicesImpl(option, retrieveDevicesCallback)) {
            return RemoteDeviceHelper.remoteDeviceListToArray(devices);
        }
        return null;
    }

    private native boolean isRemoteDeviceTrustedImpl(long var1);

    @Override
    public Boolean isRemoteDeviceTrusted(long address) {
        if (this.windowsCE) {
            return null;
        }
        return new Boolean(this.isRemoteDeviceTrustedImpl(address));
    }

    private native boolean isRemoteDeviceAuthenticatedImpl(long var1);

    @Override
    public Boolean isRemoteDeviceAuthenticated(long address) {
        if (this.windowsCE) {
            return null;
        }
        return new Boolean(this.isRemoteDeviceAuthenticatedImpl(address));
    }

    private native boolean authenticateRemoteDeviceImpl(long var1, String var3) throws IOException;

    @Override
    public boolean authenticateRemoteDevice(long address) throws IOException {
        return this.authenticateRemoteDeviceImpl(address, null);
    }

    @Override
    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        return this.authenticateRemoteDeviceImpl(address, passkey);
    }

    private native void removeAuthenticationWithRemoteDeviceImpl(long var1) throws IOException;

    @Override
    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
        this.removeAuthenticationWithRemoteDeviceImpl(address);
    }

    private native int runDeviceInquiryImpl(DeviceInquiryRunnable var1, DeviceInquiryThread var2, int var3, int var4, DiscoveryListener var5) throws BluetoothStateException;

    @Override
    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        this.initialized();
        if (this.currentDeviceDiscoveryListener != null) {
            throw new BluetoothStateException("Another inquiry already running");
        }
        this.currentDeviceDiscoveryListener = listener;
        DeviceInquiryRunnable inquiryRunnable = new DeviceInquiryRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int runDeviceInquiry(DeviceInquiryThread inquiryThread, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
                try {
                    BluetoothStackMicrosoft.this.deviceDiscoveryDevices = new Hashtable();
                    int discType = BluetoothStackMicrosoft.this.runDeviceInquiryImpl(this, inquiryThread, accessCode, DeviceInquiryThread.getConfigDeviceInquiryDuration(), listener);
                    if (discType == 0) {
                        Enumeration en = BluetoothStackMicrosoft.this.deviceDiscoveryDevices.keys();
                        while (en.hasMoreElements()) {
                            RemoteDevice remoteDevice = (RemoteDevice)en.nextElement();
                            DeviceClass deviceClass = (DeviceClass)BluetoothStackMicrosoft.this.deviceDiscoveryDevices.get(remoteDevice);
                            listener.deviceDiscovered(remoteDevice, deviceClass);
                            if (BluetoothStackMicrosoft.this.currentDeviceDiscoveryListener != null) continue;
                            int n = 5;
                            return n;
                        }
                    }
                    int n = discType;
                    return n;
                }
                finally {
                    BluetoothStackMicrosoft.this.deviceDiscoveryDevices = null;
                    BluetoothStackMicrosoft.this.currentDeviceDiscoveryListener = null;
                }
            }

            @Override
            public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
                RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(BluetoothStackMicrosoft.this, deviceAddr, deviceName, paired);
                if (BluetoothStackMicrosoft.this.currentDeviceDiscoveryListener == null || BluetoothStackMicrosoft.this.deviceDiscoveryDevices == null || BluetoothStackMicrosoft.this.currentDeviceDiscoveryListener != listener) {
                    return;
                }
                DeviceClass cod = new DeviceClass(deviceClass);
                DebugLog.debug("deviceDiscoveredCallback address", remoteDevice.getBluetoothAddress());
                DebugLog.debug("deviceDiscoveredCallback deviceClass", cod);
                BluetoothStackMicrosoft.this.deviceDiscoveryDevices.put(remoteDevice, cod);
            }
        };
        return DeviceInquiryThread.startInquiry(this, inquiryRunnable, accessCode, listener);
    }

    private native boolean cancelInquiry();

    @Override
    public boolean cancelInquiry(DiscoveryListener listener) {
        if (this.currentDeviceDiscoveryListener != listener) {
            return false;
        }
        this.currentDeviceDiscoveryListener = null;
        return this.cancelInquiry();
    }

    private native int[] runSearchServicesImpl(UUID[] var1, long var2) throws SearchServicesException;

    public native byte[] getServiceAttributes(int[] var1, long var2, int var4) throws IOException;

    @Override
    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        SearchServicesRunnable searchRunnable = new SearchServicesRunnable(){

            @Override
            public int runSearchServices(SearchServicesThread sst, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
                int[] handles;
                sst.searchServicesStartedCallback();
                try {
                    handles = BluetoothStackMicrosoft.this.runSearchServicesImpl(uuidSet, RemoteDeviceHelper.getAddress(device));
                }
                catch (SearchServicesDeviceNotReachableException e) {
                    return 6;
                }
                catch (SearchServicesTerminatedException e) {
                    return 2;
                }
                catch (SearchServicesException e) {
                    return 3;
                }
                if (handles == null) {
                    return 3;
                }
                if (handles.length > 0) {
                    ServiceRecord[] records = new ServiceRecordImpl[handles.length];
                    int[] requiredAttrIDs = new int[]{0, 1, 2, 3, 4};
                    boolean hasError = false;
                    for (int i = 0; i < handles.length; ++i) {
                        records[i] = new ServiceRecordImpl(BluetoothStackMicrosoft.this, device, handles[i]);
                        try {
                            records[i].populateRecord(requiredAttrIDs);
                            if (attrSet != null) {
                                records[i].populateRecord(attrSet);
                            }
                        }
                        catch (Exception e) {
                            DebugLog.debug("populateRecord error", e);
                            hasError = true;
                        }
                        if (!sst.isTerminated()) continue;
                        return 2;
                    }
                    listener.servicesDiscovered(sst.getTransID(), records);
                    if (hasError) {
                        return 3;
                    }
                    return 1;
                }
                return 4;
            }
        };
        return SearchServicesThread.startSearchServices(this, searchRunnable, attrSet, uuidSet, device, listener);
    }

    @Override
    public boolean cancelServiceSearch(int transID) {
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread(transID);
        if (sst != null) {
            return sst.setTerminated();
        }
        return false;
    }

    @Override
    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        if (attrIDs.length > 256) {
            throw new IllegalArgumentException();
        }
        byte[] blob = this.getServiceAttributes(attrIDs, RemoteDeviceHelper.getAddress(serviceRecord.getHostDevice()), (int)serviceRecord.getHandle());
        if (blob.length > 0) {
            try {
                boolean anyRetrived = false;
                DataElement element = new SDPInputStream(new ByteArrayInputStream(blob)).readElement();
                Enumeration e = (Enumeration)element.getValue();
                block3: while (e.hasMoreElements()) {
                    int attrID = (int)((DataElement)e.nextElement()).getLong();
                    serviceRecord.populateAttributeValue(attrID, (DataElement)e.nextElement());
                    if (anyRetrived) continue;
                    for (int i = 0; i < attrIDs.length; ++i) {
                        if (attrIDs[i] != attrID) continue;
                        anyRetrived = true;
                        continue block3;
                    }
                }
                return anyRetrived;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException();
            }
        }
        return false;
    }

    private native long socket(boolean var1, boolean var2) throws IOException;

    private native long getsockaddress(long var1) throws IOException;

    private native void storesockopt(long var1);

    private native int getsockchannel(long var1) throws IOException;

    private native void connect(long var1, long var3, int var5, int var6) throws IOException;

    private native void bind(long var1) throws IOException;

    private native void listen(long var1) throws IOException;

    private native long accept(long var1) throws IOException;

    private native int recvAvailable(long var1) throws IOException;

    private native int recv(long var1) throws IOException;

    private native int recv(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void send(long var1, int var3) throws IOException;

    private native void send(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void close(long var1) throws IOException;

    private native String getpeername(long var1) throws IOException;

    private native long getpeeraddress(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        long socket = this.socket(params.authenticate, params.encrypt);
        Object event = new Object();
        ConnectThread connectThread = new ConnectThread(event, socket, params);
        UtilsJavaSE.threadSetDaemon(connectThread);
        boolean timeoutHappend = false;
        Object object = event;
        synchronized (object) {
            connectThread.start();
            while (connectThread.connecting) {
                try {
                    if (params.timeouts) {
                        event.wait(params.timeout);
                        timeoutHappend = connectThread.connecting;
                        connectThread.interrupt();
                        break;
                    }
                    event.wait();
                }
                catch (InterruptedException e) {
                    try {
                        this.close(socket);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new InterruptedIOException();
                }
            }
        }
        if (!connectThread.success) {
            try {
                this.close(socket);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connectThread.error != null) {
            throw connectThread.error;
        }
        if (!connectThread.success) {
            if (timeoutHappend) {
                throw new BluetoothConnectionException(5);
            }
            throw new BluetoothConnectionException(4);
        }
        return socket;
    }

    @Override
    public void connectionRfCloseClientConnection(long handle) throws IOException {
        this.close(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        long socket = this.socket(params.authenticate, params.encrypt);
        boolean success = false;
        try {
            BluetoothStackMicrosoft bluetoothStackMicrosoft = this;
            synchronized (bluetoothStackMicrosoft) {
                this.bind(socket);
            }
            this.listen(socket);
            int channel = this.getsockchannel(socket);
            DebugLog.debug("service channel ", channel);
            long serviceRecordHandle = socket;
            serviceRecord.populateRFCOMMAttributes(serviceRecordHandle, channel, params.uuid, params.name, params.obex);
            serviceRecord.setHandle(this.registerService(serviceRecord.toByteArray(), serviceRecord.deviceServiceClasses));
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close(socket);
                }
                catch (IOException e) {
                    DebugLog.debug("close on failure", e);
                }
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        try {
            this.close(handle);
        }
        finally {
            this.unregisterService(serviceRecord.getHandle());
        }
    }

    private native long registerService(byte[] var1, int var2) throws ServiceRegistrationException;

    private native void unregisterService(long var1) throws ServiceRegistrationException;

    @Override
    public long rfServerAcceptAndOpenRfServerConnection(long handle) throws IOException {
        return this.accept(handle);
    }

    @Override
    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        byte[] blob;
        this.unregisterService(serviceRecord.getHandle());
        try {
            blob = serviceRecord.toByteArray();
        }
        catch (IOException e) {
            throw new ServiceRegistrationException(e.toString());
        }
        serviceRecord.setHandle(this.registerService(blob, serviceRecord.deviceServiceClasses));
        DebugLog.debug("new serviceRecord", serviceRecord);
    }

    @Override
    public void connectionRfCloseServerConnection(long handle) throws IOException {
        this.connectionRfCloseClientConnection(handle);
    }

    @Override
    public long getConnectionRfRemoteAddress(long handle) throws IOException {
        return this.getpeeraddress(handle);
    }

    @Override
    public int connectionRfRead(long handle) throws IOException {
        return this.recv(handle);
    }

    @Override
    public int connectionRfRead(long handle, byte[] b, int off, int len) throws IOException {
        return this.recv(handle, b, off, len);
    }

    @Override
    public int connectionRfReadAvailable(long handle) throws IOException {
        return this.recvAvailable(handle);
    }

    @Override
    public void connectionRfWrite(long handle, int b) throws IOException {
        this.send(handle, b);
    }

    @Override
    public void connectionRfWrite(long handle, byte[] b, int off, int len) throws IOException {
        this.send(handle, b, off, len);
    }

    @Override
    public void connectionRfFlush(long handle) throws IOException {
    }

    @Override
    public int rfGetSecurityOpt(long handle, int expected) throws IOException {
        return expected;
    }

    @Override
    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    @Override
    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public void l2CloseClientConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        throw new ServiceRegistrationException("Not Supported on" + this.getStackID());
    }

    @Override
    public long l2ServerAcceptAndOpenServerConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public void l2CloseServerConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public int l2GetSecurityOpt(long handle, int expected) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public boolean l2Ready(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public int l2Receive(long handle, byte[] inBuf) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public void l2Send(long handle, byte[] data, int transmitMTU) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public int l2GetReceiveMTU(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public int l2GetTransmitMTU(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public long l2RemoteAddress(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    @Override
    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    private class ConnectThread
    extends Thread {
        final Object event;
        final long socket;
        final BluetoothConnectionParams params;
        final int retryUnreachable;
        volatile IOException error;
        volatile boolean success;
        volatile boolean connecting;

        ConnectThread(Object event, long socket, BluetoothConnectionParams params) {
            super("ConnectThread-" + BluetoothStackMicrosoft.nextConnectThreadNum());
            this.success = false;
            this.connecting = true;
            this.event = event;
            this.socket = socket;
            this.params = params;
            this.retryUnreachable = BlueCoveImpl.getConfigProperty("bluecove.connect.unreachable_retry", 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BluetoothStackMicrosoft.this.connect(this.socket, this.params.address, this.params.channel, this.retryUnreachable);
                this.success = true;
            }
            catch (IOException e) {
                this.error = e;
            }
            finally {
                this.connecting = false;
                Object object = this.event;
                synchronized (object) {
                    this.event.notifyAll();
                }
            }
        }
    }
}

