/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothRFCommConnection;
import java.io.IOException;
import java.io.InputStream;

class BluetoothRFCommInputStream
extends InputStream {
    private volatile BluetoothRFCommConnection conn;

    public BluetoothRFCommInputStream(BluetoothRFCommConnection conn) {
        this.conn = conn;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.conn == null) {
            throw new IOException("Stream closed");
        }
        return this.conn.bluetoothStack.connectionRfReadAvailable(this.conn.handle);
    }

    @Override
    public int read() throws IOException {
        if (this.conn == null) {
            throw new IOException("Stream closed");
        }
        try {
            return this.conn.bluetoothStack.connectionRfRead(this.conn.handle);
        }
        catch (IOException e) {
            if (this.isClosed()) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.conn == null) {
            throw new IOException("Stream closed");
        }
        if (len == 0) {
            return 0;
        }
        try {
            return this.conn.bluetoothStack.connectionRfRead(this.conn.handle, b, off, len);
        }
        catch (IOException e) {
            if (this.isClosed()) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        BluetoothRFCommConnection c = this.conn;
        if (c != null) {
            this.conn = null;
            c.streamClosed();
        }
    }

    boolean isClosed() {
        return this.conn == null;
    }
}

