/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import com.jetbrains.cef.remote.network.RemoteCookieManager;
import java.util.concurrent.atomic.AtomicReference;
import org.cef.CefApp;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.callback.CefNativeAdapter;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager_N;

public abstract class CefCookieManager
extends CefNativeAdapter {
    protected CefCookieManager() {
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static final CefCookieManager getGlobalManager() {
        if (CefApp.isRemoteEnabled()) {
            return RemoteCookieManager.createGlobal();
        }
        CookieManagerWrapper instance = new CookieManagerWrapper();
        CefApp.getInstance().onInitialization(state2 -> {
            if (state2 == CefApp.CefAppState.INITIALIZED) {
                instance.setInstance(CefCookieManager_N.getGlobalManagerNative());
            }
        });
        return instance;
    }

    public abstract void dispose();

    public abstract boolean visitAllCookies(CefCookieVisitor var1);

    public abstract boolean visitUrlCookies(String var1, boolean var2, CefCookieVisitor var3);

    public abstract boolean setCookie(String var1, CefCookie var2);

    public abstract boolean deleteCookies(String var1, String var2);

    public abstract boolean flushStore(CefCompletionCallback var1);

    private static class CookieManagerWrapper
    extends CefCookieManager {
        private final AtomicReference<CefCookieManager> myInstance = new AtomicReference();

        private CookieManagerWrapper() {
        }

        public void setInstance(CefCookieManager manager) {
            this.myInstance.set(manager);
        }

        @Override
        public void dispose() {
            CefCookieManager impl = this.myInstance.get();
            if (impl != null) {
                impl.dispose();
            }
        }

        @Override
        public boolean visitAllCookies(CefCookieVisitor visitor) {
            CefCookieManager impl = this.myInstance.get();
            if (impl != null) {
                return impl.visitAllCookies(visitor);
            }
            throw new RuntimeException("JCEF is not initialed yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
        }

        @Override
        public boolean visitUrlCookies(String url, boolean includeHttpOnly, CefCookieVisitor visitor) {
            CefCookieManager impl = this.myInstance.get();
            if (impl != null) {
                return impl.visitUrlCookies(url, includeHttpOnly, visitor);
            }
            throw new RuntimeException("JCEF is not initialed yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
        }

        @Override
        public boolean setCookie(String url, CefCookie cookie) {
            CefCookieManager impl = this.myInstance.get();
            if (impl != null) {
                return impl.setCookie(url, cookie);
            }
            throw new RuntimeException("JCEF is not initialed yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
        }

        @Override
        public boolean deleteCookies(String url, String cookieName) {
            CefCookieManager impl = this.myInstance.get();
            if (impl != null) {
                return impl.deleteCookies(url, cookieName);
            }
            throw new RuntimeException("JCEF is not initialed yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
        }

        @Override
        public boolean flushStore(CefCompletionCallback handler) {
            CefCookieManager impl = this.myInstance.get();
            if (impl != null) {
                return impl.flushStore(handler);
            }
            throw new RuntimeException("JCEF is not initialed yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
        }
    }
}

